/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.tuple;

import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.TotalOrder;
import edu.rice.cs.plt.object.ObjectUtil;
import edu.rice.cs.plt.tuple.Null;
import edu.rice.cs.plt.tuple.OptionUnwrapException;
import edu.rice.cs.plt.tuple.OptionVisitor;
import edu.rice.cs.plt.tuple.Tuple;
import edu.rice.cs.plt.tuple.Wrapper;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<T>
extends Tuple {
    protected Option() {
    }

    public abstract <Ret> Ret apply(OptionVisitor<? super T, ? extends Ret> var1);

    public abstract boolean isSome();

    public final boolean isNone() {
        return !this.isSome();
    }

    public abstract T unwrap() throws OptionUnwrapException;

    public abstract T unwrap(T var1);

    public static <T> Option<T> some(T val) {
        return new Wrapper<T>(val);
    }

    public static <T> Option<T> none() {
        return Null.INSTANCE;
    }

    public static <T> Option<T> wrap(T val) {
        if (val == null) {
            return Null.INSTANCE;
        }
        return new Wrapper<T>(val);
    }

    public static <T> T unwrap(Option<? extends T> opt, T forNone) {
        if (opt.isSome()) {
            return opt.unwrap();
        }
        return forNone;
    }

    public static <T extends Comparable<? super T>> TotalOrder<Option<? extends T>> comparator() {
        return new OptionComparator(CollectUtil.naturalOrder());
    }

    public static <T> TotalOrder<Option<? extends T>> comparator(Comparator<? super T> comp) {
        return new OptionComparator<T>(comp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OptionComparator<T>
    extends TotalOrder<Option<? extends T>> {
        private final Comparator<? super T> _comp;

        public OptionComparator(Comparator<? super T> comp) {
            this._comp = comp;
        }

        @Override
        public int compare(Option<? extends T> o1, Option<? extends T> o2) {
            if (o1.isSome()) {
                return o2.isSome() ? this._comp.compare(o1.unwrap(), o2.unwrap()) : 1;
            }
            return o2.isSome() ? -1 : 0;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OptionComparator)) {
                return false;
            }
            OptionComparator cast = (OptionComparator)o;
            return ((Object)this._comp).equals(cast._comp);
        }

        public int hashCode() {
            return ObjectUtil.hash(OptionComparator.class, this._comp);
        }
    }
}

