/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.debug;

import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.debug.LogSink;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.lambda.WrappedException;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMILogSink
implements LogSink,
Closeable {
    private final Thunk<RemoteLogSink> _delegate;
    private volatile boolean _active;

    public RMILogSink(Thunk<? extends LogSink> factory) {
        this(factory, JVMBuilder.DEFAULT, true);
    }

    public RMILogSink(Thunk<? extends LogSink> factory, boolean closeOnExit) {
        this(factory, JVMBuilder.DEFAULT, closeOnExit);
    }

    public RMILogSink(Thunk<? extends LogSink> factory, JVMBuilder jvm) {
        this(factory, jvm, true);
    }

    public RMILogSink(final Thunk<? extends LogSink> factory, final JVMBuilder jvm, boolean closeOnExit) {
        this._delegate = LazyThunk.make(new Thunk<RemoteLogSink>(){

            @Override
            public RemoteLogSink value() {
                try {
                    RemoteLogSink result = (RemoteLogSink)ConcurrentUtil.exportInProcess(new ServerFactory(factory), jvm);
                    RMILogSink.this._active = true;
                    return result;
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            }
        });
        this._active = false;
        if (closeOnExit) {
            IOUtil.closeOnExit(this);
        }
    }

    @Override
    public void close() throws IOException {
        if (this._active) {
            this._delegate.value().close();
            this._active = false;
        }
    }

    @Override
    public void log(LogSink.StandardMessage m) {
        try {
            this._delegate.value().log(m.serializable());
        }
        catch (RemoteException e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public void logStart(LogSink.StartMessage m) {
        try {
            this._delegate.value().logStart(m.serializable());
        }
        catch (RemoteException e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public void logEnd(LogSink.EndMessage m) {
        try {
            this._delegate.value().logEnd(m.serializable());
        }
        catch (RemoteException e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public void logError(LogSink.ErrorMessage m) {
        try {
            this._delegate.value().logError(m.serializable());
        }
        catch (RemoteException e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public void logStack(LogSink.StackMessage m) {
        try {
            this._delegate.value().logStack(m.serializable());
        }
        catch (RemoteException e) {
            throw new WrappedException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServerFactory
    implements Thunk<RemoteLogSink>,
    Serializable {
        private final Thunk<? extends LogSink> _sinkFactory;

        public ServerFactory(Thunk<? extends LogSink> sinkFactory) {
            this._sinkFactory = sinkFactory;
        }

        @Override
        public RemoteLogSink value() {
            final LogSink sink = this._sinkFactory.value();
            return new RemoteLogSink(){

                public void close() throws IOException {
                    System.exit(0);
                }

                public void log(LogSink.StandardMessage m) {
                    sink.log(m);
                }

                public void logStart(LogSink.StartMessage m) {
                    sink.logStart(m);
                }

                public void logEnd(LogSink.EndMessage m) {
                    sink.logEnd(m);
                }

                public void logError(LogSink.ErrorMessage m) {
                    sink.logError(m);
                }

                public void logStack(LogSink.StackMessage m) {
                    sink.logStack(m);
                }
            };
        }
    }

    private static interface RemoteLogSink
    extends Remote {
        public void log(LogSink.StandardMessage var1) throws RemoteException;

        public void logStart(LogSink.StartMessage var1) throws RemoteException;

        public void logEnd(LogSink.EndMessage var1) throws RemoteException;

        public void logError(LogSink.ErrorMessage var1) throws RemoteException;

        public void logStack(LogSink.StackMessage var1) throws RemoteException;

        public void close() throws IOException;
    }
}

