/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.DelegatingSet;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.CachedThunk;
import edu.rice.cs.plt.lambda.Thunk;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotSynchronizedSet<E>
extends DelegatingSet<E> {
    private final CachedThunk<Iterable<E>> _copy = CachedThunk.make(new Thunk<Iterable<E>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterable<E> value() {
            Collection collection = SnapshotSynchronizedSet.this._delegate;
            synchronized (collection) {
                return IterUtil.snapshot(SnapshotSynchronizedSet.this._delegate.iterator());
            }
        }
    });

    public SnapshotSynchronizedSet(Set<E> delegate) {
        super(Collections.synchronizedSet(delegate));
    }

    public void discardSnapshot() {
        this._copy.reset();
    }

    private boolean reset(boolean changed) {
        if (changed) {
            this._copy.reset();
        }
        return changed;
    }

    @Override
    public Iterator<E> iterator() {
        return this._copy.value().iterator();
    }

    @Override
    public boolean add(E o) {
        return this.reset(this._delegate.add(o));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.reset(this._delegate.addAll(c));
    }

    @Override
    public void clear() {
        this._delegate.clear();
        this.reset(true);
    }

    @Override
    public boolean remove(Object o) {
        return this.reset(this._delegate.remove(o));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.reset(this._delegate.removeAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.reset(this._delegate.retainAll(c));
    }

    public static <T> Thunk<Set<T>> factory(Thunk<? extends Set<T>> delegateFactory) {
        return new Factory(delegateFactory);
    }

    public static <T> SnapshotSynchronizedSet<T> make(Set<T> delegate) {
        return new SnapshotSynchronizedSet<T>(delegate);
    }

    public static <T> SnapshotSynchronizedSet<T> makeHash() {
        return new SnapshotSynchronizedSet(new HashSet());
    }

    public static <T> SnapshotSynchronizedSet<T> makeLinkedHash() {
        return new SnapshotSynchronizedSet(new LinkedHashSet());
    }

    public static <T> SnapshotSynchronizedSet<T> makeTree() {
        return new SnapshotSynchronizedSet(new TreeSet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory<T>
    implements Thunk<Set<T>>,
    Serializable {
        private final Thunk<? extends Set<T>> _delegateFactory;

        private Factory(Thunk<? extends Set<T>> delegateFactory) {
            this._delegateFactory = delegateFactory;
        }

        @Override
        public Set<T> value() {
            return new SnapshotSynchronizedSet<T>(this._delegateFactory.value());
        }
    }
}

