/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.AbstractPredicateSet;
import edu.rice.cs.plt.iter.SingletonIterator;
import edu.rice.cs.plt.lambda.Lambda;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonSet<E>
extends AbstractPredicateSet<E>
implements Serializable {
    private final E _elt;

    public SingletonSet(E elt) {
        this._elt = elt;
    }

    @Override
    public boolean contains(Object o) {
        return this._elt == null ? o == null : this._elt.equals(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new SingletonIterator<E>(this._elt);
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public int size(int bound) {
        return bound < 1 ? bound : 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this._elt};
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static <E> SingletonSet<E> make(E element) {
        return new SingletonSet<E>(element);
    }

    public static <T> Lambda<T, SingletonSet<T>> factory() {
        return Factory.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory<T>
    implements Lambda<T, SingletonSet<T>>,
    Serializable {
        public static final Factory<Object> INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public SingletonSet<T> value(T arg) {
            return new SingletonSet<T>(arg);
        }
    }
}

