/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.collect;

import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.collect.ConcreteRelationIndex;
import edu.rice.cs.plt.collect.DelegatingSet;
import edu.rice.cs.plt.collect.ImmutableSet;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.RelationIndex;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SnapshotIterable;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcreteRelationIndex<K, V>
implements RelationIndex<K, V>,
Serializable {
    private final Map<K, WeakReference<ValueSet>> _valueSets = new HashMap<K, WeakReference<ValueSet>>();
    private final Map<K, PredicateSet<V>> _nonEmptyValueSets;
    private final Thunk<? extends Set<V>> _setFactory;
    private int _size;

    public ConcreteRelationIndex(Thunk<? extends Map<K, PredicateSet<V>>> mapFactory, Thunk<? extends Set<V>> setFactory) {
        this._nonEmptyValueSets = mapFactory.value();
        this._setFactory = setFactory;
        this._size = 0;
    }

    protected void validateAdd(K key, V value) {
    }

    protected void addToRelation(K key, V value) {
    }

    protected void validateRemove(K key, V value) {
    }

    protected void validateRemoveKey(K key, PredicateSet<V> vals) {
    }

    protected void removeFromRelation(K key, V value) {
    }

    protected void validateClear() {
    }

    protected void clearRelation() {
    }

    @Override
    public boolean contains(Object key, Object value) {
        PredicateSet<V> vals = this._nonEmptyValueSets.get(key);
        return vals != null && vals.contains(value);
    }

    @Override
    public PredicateSet<K> keys() {
        return new KeySet();
    }

    @Override
    public PredicateSet<V> match(K key) {
        return this.findMatch(key);
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return new EntryIterator();
    }

    @Override
    public boolean isEmpty() {
        return this._nonEmptyValueSets.isEmpty();
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int size(int bound) {
        return this._size < bound ? this._size : bound;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean hasFixedSize() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public void added(K key, V value) {
        this.findMatch(key).doAdd(value);
    }

    @Override
    public void removed(K key, V value) {
        this.findMatch(key).doRemove(value);
    }

    @Override
    public void cleared() {
        for (K key : this._nonEmptyValueSets.keySet()) {
            ((ValueSet)this._valueSets.get(key).get()).doClear(false);
        }
        this._nonEmptyValueSets.clear();
    }

    private ValueSet findMatch(K key) {
        ValueSet result;
        WeakReference<ValueSet> ref = this._valueSets.get(key);
        if (ref != null && (result = (ValueSet)ref.get()) != null) {
            return result;
        }
        return new ValueSet(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Pair<K, V>> {
        private final Iterator<Map.Entry<K, PredicateSet<V>>> _entries;
        private K _currentKey;
        private PredicateSet<V> _currentValues;
        private Iterator<V> _valuesIter;

        public EntryIterator() {
            this._entries = ConcreteRelationIndex.this._nonEmptyValueSets.entrySet().iterator();
            this._currentKey = null;
            this._currentValues = null;
            this._valuesIter = null;
        }

        @Override
        public boolean hasNext() {
            return this._valuesIter != null && this._valuesIter.hasNext() || this._entries.hasNext();
        }

        @Override
        public Pair<K, V> next() {
            if (this._valuesIter == null || !this._valuesIter.hasNext()) {
                Map.Entry entry = this._entries.next();
                this._currentKey = entry.getKey();
                this._currentValues = entry.getValue();
                this._valuesIter = this._currentValues.iterator();
            }
            return new Pair(this._currentKey, this._valuesIter.next());
        }

        @Override
        public void remove() {
            if (!(this._valuesIter instanceof ValueSet.ValueSetIterator)) {
                throw new UnsupportedOperationException();
            }
            ((ValueSet.ValueSetIterator)this._valuesIter).remove(this._entries);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueSet
    extends DelegatingSet<V>
    implements Serializable {
        private final K _key;
        private int _size;

        public ValueSet(K key) {
            super((Set)ConcreteRelationIndex.this._setFactory.value());
            this._key = key;
            this._size = this._delegate.size();
            ConcreteRelationIndex.this._valueSets.put(key, new WeakReference<ValueSet>(this));
            if (!this._delegate.isEmpty()) {
                ConcreteRelationIndex.this._nonEmptyValueSets.put(this._key, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                ConcreteRelationIndex.this._valueSets.remove(this._key);
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public boolean isEmpty() {
            return this._size == 0;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public int size(int bound) {
            return this._size < bound ? this._size : bound;
        }

        public edu.rice.cs.plt.collect.ConcreteRelationIndex$ValueSet.ValueSetIterator iterator() {
            return new ValueSetIterator();
        }

        @Override
        public boolean add(V val) {
            boolean result;
            boolean bl = result = !this._delegate.contains(val);
            if (result) {
                ConcreteRelationIndex.this.validateAdd(this._key, val);
                this._delegate.add(val);
                this.finishAdd();
                ConcreteRelationIndex.this.addToRelation(this._key, val);
            }
            return result;
        }

        @Override
        public boolean remove(Object o) {
            Option cast = CollectUtil.castIfContains(this._delegate, o);
            if (cast.isSome()) {
                Object val = cast.unwrap();
                ConcreteRelationIndex.this.validateRemove(this._key, val);
                this._delegate.remove(val);
                this.finishRemove();
                ConcreteRelationIndex.this.removeFromRelation(this._key, val);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            if (this._size != 0) {
                ConcreteRelationIndex.this.validateRemoveKey(this._key, new ImmutableSet(this));
                SnapshotIterable vals = IterUtil.snapshot(this);
                this._delegate.clear();
                this.finishClear(true);
                for (Object val : vals) {
                    ConcreteRelationIndex.this.removeFromRelation(this._key, val);
                }
            }
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            return this.abstractCollectionAddAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.abstractCollectionRetainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.abstractCollectionRemoveAll(c);
        }

        public void clearAndNotifyAfterMapRemoval() {
            if (this._size != 0) {
                SnapshotIterable vals = IterUtil.snapshot(this);
                try {
                    this._delegate.clear();
                }
                catch (RuntimeException e) {
                    ConcreteRelationIndex.this._nonEmptyValueSets.put(this._key, this);
                    throw e;
                }
                this.finishClear(false);
                for (Object val : vals) {
                    ConcreteRelationIndex.this.removeFromRelation(this._key, val);
                }
            }
        }

        public void clearAfterMapRemoval() {
            if (this._size != 0) {
                try {
                    this._delegate.clear();
                }
                catch (RuntimeException e) {
                    ConcreteRelationIndex.this._nonEmptyValueSets.put(this._key, this);
                    throw e;
                }
                this.finishClear(false);
            }
        }

        public void doAdd(V val) {
            boolean changed = this._delegate.add(val);
            if (changed) {
                this.finishAdd();
            }
        }

        public void doRemove(V val) {
            boolean changed = this._delegate.remove(val);
            if (changed) {
                this.finishRemove();
            }
        }

        public void doClear(boolean removeFromMap) {
            if (this._size != 0) {
                this._delegate.clear();
                this.finishClear(removeFromMap);
            }
        }

        private void finishAdd() {
            if (this._size == 0) {
                ConcreteRelationIndex.this._nonEmptyValueSets.put(this._key, this);
            }
            ++this._size;
            ConcreteRelationIndex.this._size++;
        }

        private void finishRemove() {
            --this._size;
            ConcreteRelationIndex.this._size--;
            if (this._size == 0) {
                ConcreteRelationIndex.this._nonEmptyValueSets.remove(this._key);
            }
        }

        private void finishRemove(Iterator<Map.Entry<K, PredicateSet<V>>> nonEmptyMapIterator) {
            --this._size;
            ConcreteRelationIndex.this._size--;
            if (this._size == 0) {
                nonEmptyMapIterator.remove();
            }
        }

        private void finishClear(boolean removeFromMap) {
            ConcreteRelationIndex.this._size -= this._size;
            this._size = 0;
            if (removeFromMap) {
                ConcreteRelationIndex.this._nonEmptyValueSets.remove(this._key);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public final class ValueSetIterator
        implements Iterator<V> {
            private final Iterator<? extends V> _i;
            private V _last;

            public ValueSetIterator() {
                this._i = ValueSet.this._delegate.iterator();
                this._last = null;
            }

            @Override
            public boolean hasNext() {
                return this._i.hasNext();
            }

            @Override
            public V next() {
                this._last = this._i.next();
                return this._last;
            }

            @Override
            public void remove() {
                if (this._last == null) {
                    throw new IllegalStateException();
                }
                ConcreteRelationIndex.this.validateRemove(ValueSet.this._key, this._last);
                this._i.remove();
                ValueSet.this.finishRemove();
                ConcreteRelationIndex.this.removeFromRelation(ValueSet.this._key, this._last);
            }

            public void remove(Iterator<Map.Entry<K, PredicateSet<V>>> nonEmptyMapIterator) {
                if (this._last == null) {
                    throw new IllegalStateException();
                }
                ConcreteRelationIndex.this.validateRemove(ValueSet.this._key, this._last);
                this._i.remove();
                ValueSet.this.finishRemove(nonEmptyMapIterator);
                ConcreteRelationIndex.this.removeFromRelation(ValueSet.this._key, this._last);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends DelegatingSet<K> {
        public KeySet() {
            super(ConcreteRelationIndex.this._nonEmptyValueSets.keySet());
        }

        @Override
        public boolean add(K obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                final Iterator<K> _i;
                K _last;
                {
                    this._i = KeySet.this._delegate.iterator();
                    this._last = null;
                }

                @Override
                public boolean hasNext() {
                    return this._i.hasNext();
                }

                @Override
                public K next() {
                    this._last = this._i.next();
                    return this._last;
                }

                @Override
                public void remove() {
                    if (this._last == null) {
                        throw new IllegalStateException();
                    }
                    ValueSet vals = (ValueSet)((WeakReference)ConcreteRelationIndex.this._valueSets.get(this._last)).get();
                    ConcreteRelationIndex.this.validateRemoveKey(this._last, new ImmutableSet(vals));
                    this._i.remove();
                    vals.clearAndNotifyAfterMapRemoval();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            Option cast = CollectUtil.castIfContains(this, o);
            if (cast.isSome()) {
                Object key = cast.unwrap();
                ValueSet vals = (ValueSet)((WeakReference)ConcreteRelationIndex.this._valueSets.get(key)).get();
                ConcreteRelationIndex.this.validateRemoveKey(key, new ImmutableSet(vals));
                this._delegate.remove(key);
                vals.clearAndNotifyAfterMapRemoval();
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ConcreteRelationIndex.this.validateClear();
            ArrayList toClear = new ArrayList(this._delegate.size());
            for (Object key : this._delegate) {
                toClear.add(((WeakReference)ConcreteRelationIndex.this._valueSets.get(key)).get());
            }
            this._delegate.clear();
            for (ValueSet v : toClear) {
                v.clearAfterMapRemoval();
            }
            ConcreteRelationIndex.this.clearRelation();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.abstractCollectionRemoveAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.abstractCollectionRetainAll(c);
        }
    }
}

