/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.javalanglevels;

import edu.rice.cs.javalanglevels.BodyData;
import edu.rice.cs.javalanglevels.LanguageLevelVisitor;
import edu.rice.cs.javalanglevels.SourceInfo;
import edu.rice.cs.javalanglevels.SymbolData;
import edu.rice.cs.javalanglevels.VariableData;
import edu.rice.cs.javalanglevels.tree.JExpression;
import edu.rice.cs.javalanglevels.tree.ModifiersAndVisibility;
import edu.rice.cs.javalanglevels.tree.NullLiteral;
import edu.rice.cs.javalanglevels.tree.TypeParameter;

public class MethodData
extends BodyData {
    private TypeParameter[] _typeParameters;
    private SymbolData _returnType;
    private VariableData[] _params;
    private String[] _thrown;
    private JExpression _jexpr;
    private boolean _generated;

    public MethodData(String name, ModifiersAndVisibility modifiersAndVisibility, TypeParameter[] typeParameters, SymbolData returnType, VariableData[] params, String[] thrown, SymbolData enclosingClass, JExpression jexpr) {
        super(enclosingClass);
        this._name = name;
        this._modifiersAndVisibility = modifiersAndVisibility;
        this._typeParameters = typeParameters;
        this._returnType = returnType;
        this._params = params;
        this._thrown = thrown;
        this._jexpr = jexpr;
        this._generated = false;
    }

    public MethodData(String name, VariableData[] params) {
        this(name, new ModifiersAndVisibility(SourceInfo.NO_INFO, new String[0]), new TypeParameter[0], null, params, new String[0], null, new NullLiteral(SourceInfo.NO_INFO));
    }

    public static MethodData make(String name, ModifiersAndVisibility modifiersAndVisibility, TypeParameter[] typeParameters, SymbolData returnType, VariableData[] params, String[] thrown, SymbolData enclosingClass, JExpression jexpr) {
        MethodData md = new MethodData(name, modifiersAndVisibility, typeParameters, returnType, params, thrown, enclosingClass, jexpr);
        return md;
    }

    public static MethodData make(String name, VariableData[] params) {
        return new MethodData(name, params);
    }

    public boolean isGenerated() {
        return this._generated;
    }

    public boolean isStatic() {
        return this.hasModifier("static");
    }

    public void setGenerated(boolean generated) {
        this._generated = generated;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MethodData md = (MethodData)obj;
        return this._name.equals(md.getName()) && this._modifiersAndVisibility.equals(md.getMav()) && LanguageLevelVisitor.arrayEquals(this._typeParameters, md.getTypeParameters()) && LanguageLevelVisitor.arrayEquals(this._params, md.getParams()) && LanguageLevelVisitor.arrayEquals(this._thrown, md.getThrown()) && this._enclosingData.get(0) == md.getEnclosingData().get(0) && this._vars.equals(md.getVars());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getEnclosingData().hashCode();
    }

    public boolean isMethodData() {
        return true;
    }

    public MethodData getMethodData() {
        return this;
    }

    public TypeParameter[] getTypeParameters() {
        return this._typeParameters;
    }

    public SymbolData getReturnType() {
        return this._returnType;
    }

    public void setReturnType(SymbolData rt) {
        this._returnType = rt;
    }

    public VariableData[] getParams() {
        return this._params;
    }

    public void setParams(VariableData[] p) {
        this._params = p;
    }

    public String[] getThrown() {
        return this._thrown;
    }

    public void setThrown(String[] thrown) {
        this._thrown = thrown;
    }

    public ModifiersAndVisibility getMav() {
        return this._modifiersAndVisibility;
    }

    public void addPublicMav() {
        String[] oldMav = this._modifiersAndVisibility.getModifiers();
        String[] modifiers = new String[oldMav.length + 1];
        modifiers[0] = "public";
        for (int i = 0; i < oldMav.length; ++i) {
            modifiers[i + 1] = oldMav[i];
        }
        this._modifiersAndVisibility = new ModifiersAndVisibility(this._modifiersAndVisibility.getSourceInfo(), modifiers);
    }

    public JExpression getJExpression() {
        return this._jexpr;
    }

    public String toString() {
        return "MethodData<" + this._name + ">";
    }
}

