/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.AmbiguousNameException;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.LibraryContext;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.Access;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.LocalFunction;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.TopLevelAccessModule;
import edu.rice.cs.dynamicjava.symbol.TypeSystem;
import edu.rice.cs.dynamicjava.symbol.type.ClassType;
import edu.rice.cs.dynamicjava.symbol.type.IntersectionType;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.collect.IndexedRelation;
import edu.rice.cs.plt.collect.PredicateSet;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SequenceIterator;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.text.TextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportContext
extends DelegatingContext {
    private final TypeContext _next;
    private final Options _opt;
    private final String _currentPackage;
    private final Iterator<Integer> _anonymousCounter;
    private final HashSet<String> _onDemandPackages;
    private final HashSet<DJClass> _onDemandClasses;
    private final HashSet<DJClass> _staticOnDemandClasses;
    private final HashMap<String, DJClass> _importedTopLevelClasses;
    private final HashMap<String, DJClass> _importedMemberClasses;
    private final HashMap<String, DJClass> _importedFields;
    private final Relation<String, DJClass> _importedMethods;

    public ImportContext(ClassLoader loader, Options opt) {
        this(new LibraryContext(SymbolUtil.classLibrary(loader)), opt);
    }

    public ImportContext(TypeContext next, Options opt) {
        super(next);
        this._next = next;
        this._opt = opt;
        this._currentPackage = "";
        this._anonymousCounter = new SequenceIterator<Integer>(1, LambdaUtil.INCREMENT_INT);
        this._onDemandPackages = new HashSet();
        this._onDemandClasses = new HashSet();
        this._staticOnDemandClasses = new HashSet();
        this._importedTopLevelClasses = new HashMap();
        this._importedMemberClasses = new HashMap();
        this._importedFields = new HashMap();
        this._importedMethods = new IndexedRelation<String, DJClass>(false);
        this._onDemandPackages.add("java.lang");
    }

    private ImportContext(ImportContext copy) {
        this(copy._next, copy._currentPackage, copy);
    }

    private ImportContext(TypeContext next, String currentPackage, ImportContext bindings) {
        super(next);
        this._next = next;
        this._opt = bindings._opt;
        this._currentPackage = currentPackage;
        this._anonymousCounter = bindings._anonymousCounter;
        this._onDemandPackages = (HashSet)bindings._onDemandPackages.clone();
        this._onDemandClasses = (HashSet)bindings._onDemandClasses.clone();
        this._staticOnDemandClasses = (HashSet)bindings._staticOnDemandClasses.clone();
        this._importedTopLevelClasses = (HashMap)bindings._importedTopLevelClasses.clone();
        this._importedMemberClasses = (HashMap)bindings._importedMemberClasses.clone();
        this._importedFields = (HashMap)bindings._importedFields.clone();
        this._importedMethods = new IndexedRelation<String, DJClass>(false);
        this._importedMethods.addAll(bindings._importedMethods);
    }

    @Override
    protected TypeContext duplicate(TypeContext next) {
        return new ImportContext(next, this._currentPackage, this);
    }

    @Override
    public TypeContext setPackage(String name) {
        return new ImportContext(this._next, name, this);
    }

    @Override
    public TypeContext importTopLevelClasses(String pkg) {
        ImportContext result = new ImportContext(this);
        result._onDemandPackages.add(pkg);
        return result;
    }

    @Override
    public TypeContext importMemberClasses(DJClass outer) {
        ImportContext result = new ImportContext(this);
        result._onDemandClasses.add(outer);
        return result;
    }

    @Override
    public TypeContext importStaticMembers(DJClass c) {
        ImportContext result = new ImportContext(this);
        result._staticOnDemandClasses.add(c);
        return result;
    }

    @Override
    public TypeContext importTopLevelClass(DJClass c) {
        ImportContext result = new ImportContext(this);
        String name = c.declaredName();
        result._importedMemberClasses.remove(name);
        result._importedTopLevelClasses.put(name, c);
        return result;
    }

    @Override
    public TypeContext importMemberClass(DJClass outer, String name) {
        ImportContext result = new ImportContext(this);
        result._importedTopLevelClasses.remove(name);
        result._importedMemberClasses.put(name, outer);
        return result;
    }

    @Override
    public TypeContext importField(DJClass c, String name) {
        ImportContext result = new ImportContext(this);
        result._importedFields.put(name, c);
        return result;
    }

    @Override
    public TypeContext importMethod(DJClass c, String name) {
        ImportContext result = new ImportContext(this);
        result._importedMethods.add(name, c);
        return result;
    }

    @Override
    public boolean typeExists(String name, TypeSystem ts) {
        return this.importsTopLevelClass(name, ts) || this.importsMemberClass(name, ts) || super.typeExists(name, ts);
    }

    @Override
    public boolean topLevelClassExists(String name, TypeSystem ts) {
        return this.importsTopLevelClass(name, ts) || !this.importsMemberClass(name, ts) && super.topLevelClassExists(name, ts);
    }

    @Override
    public DJClass getTopLevelClass(String name, TypeSystem ts) throws AmbiguousNameException {
        DJClass result = this.importedTopLevelClass(name, ts);
        return result == null && !this.importsMemberClass(name, ts) ? super.getTopLevelClass(name, ts) : result;
    }

    private boolean importsTopLevelClass(String name, TypeSystem ts) {
        try {
            return this.importedTopLevelClass(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    private DJClass importedTopLevelClass(String name, TypeSystem ts) throws AmbiguousNameException {
        DJClass result = null;
        if (!TextUtil.contains(name, 46)) {
            result = this._importedTopLevelClasses.get(name);
            if (result == null && (result = super.getTopLevelClass(this.makeClassName(name), ts)) == null) {
                LinkedList<String> onDemandNames = new LinkedList<String>();
                for (String p : this._onDemandPackages) {
                    String fullName = p + "." + name;
                    if (!super.topLevelClassExists(fullName, ts)) continue;
                    onDemandNames.add(fullName);
                }
                if (onDemandNames.size() > 1) {
                    throw new AmbiguousNameException();
                }
                if (onDemandNames.size() == 1) {
                    result = super.getTopLevelClass((String)onDemandNames.get(0), ts);
                }
            }
            if (result != null && (this._opt.enforcePrivateAccess() || this._opt.enforceAllAccess()) && !result.accessibility().equals((Object)Access.PUBLIC) && !this._currentPackage.equals(result.accessModule().packageName())) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public boolean memberClassExists(String name, TypeSystem ts) {
        return this.importsMemberClass(name, ts) || !this.importsTopLevelClass(name, ts) && super.memberClassExists(name, ts);
    }

    @Override
    public ClassType typeContainingMemberClass(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result = this.importedMemberClassType(name, ts);
        return result == null && !this.importsTopLevelClass(name, ts) ? super.typeContainingMemberClass(name, ts) : result;
    }

    private boolean importsMemberClass(String name, TypeSystem ts) {
        try {
            return this.importedMemberClassType(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    private ClassType importedMemberClassType(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result;
        DJClass explicitImport = this._importedMemberClasses.get(name);
        ClassType classType = result = explicitImport == null ? null : ts.makeClassType(explicitImport);
        if (result == null) {
            ClassType t;
            LinkedList<ClassType> onDemandMatches = new LinkedList<ClassType>();
            for (DJClass c : this._onDemandClasses) {
                t = ts.makeClassType(c);
                if (!ts.containsClass(t, name, this.accessModule())) continue;
                onDemandMatches.add(t);
            }
            for (DJClass c : this._staticOnDemandClasses) {
                t = ts.makeClassType(c);
                if (!ts.containsStaticClass(t, name, this.accessModule())) continue;
                onDemandMatches.add(t);
            }
            if (onDemandMatches.size() > 1) {
                throw new AmbiguousNameException();
            }
            if (onDemandMatches.size() == 1) {
                result = (ClassType)onDemandMatches.getFirst();
            }
            if (result == null) {
                result = super.typeContainingMemberClass(name, ts);
            }
        }
        return result;
    }

    @Override
    public boolean variableExists(String name, TypeSystem ts) {
        return this.importsField(name, ts) || super.variableExists(name, ts);
    }

    @Override
    public boolean fieldExists(String name, TypeSystem ts) {
        return this.importsField(name, ts) || super.fieldExists(name, ts);
    }

    @Override
    public ClassType typeContainingField(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result = this.importedFieldType(name, ts);
        return result == null ? super.typeContainingField(name, ts) : result;
    }

    @Override
    public boolean localVariableExists(String name, TypeSystem ts) {
        return !this.importsField(name, ts) && super.localVariableExists(name, ts);
    }

    @Override
    public LocalVariable getLocalVariable(String name, TypeSystem ts) {
        return this.importsField(name, ts) ? null : super.getLocalVariable(name, ts);
    }

    private boolean importsField(String name, TypeSystem ts) {
        try {
            return this.importedFieldType(name, ts) != null;
        }
        catch (AmbiguousNameException e) {
            return true;
        }
    }

    private ClassType importedFieldType(String name, TypeSystem ts) throws AmbiguousNameException {
        ClassType result;
        DJClass explicitImport = this._importedFields.get(name);
        ClassType classType = result = explicitImport == null ? null : ts.makeClassType(explicitImport);
        if (result == null) {
            LinkedList<ClassType> onDemandMatches = new LinkedList<ClassType>();
            for (DJClass c : this._staticOnDemandClasses) {
                ClassType t = ts.makeClassType(c);
                if (!ts.containsStaticField(t, name, this.accessModule())) continue;
                onDemandMatches.add(t);
            }
            if (onDemandMatches.size() > 1) {
                throw new AmbiguousNameException();
            }
            if (onDemandMatches.size() == 1) {
                result = (ClassType)onDemandMatches.getFirst();
            }
            if (result == null) {
                result = super.typeContainingField(name, ts);
            }
        }
        return result;
    }

    @Override
    public boolean functionExists(String name, TypeSystem ts) {
        return this.importsMethod(name, ts) || super.functionExists(name, ts);
    }

    @Override
    public boolean methodExists(String name, TypeSystem ts) {
        return this.importsMethod(name, ts) || super.methodExists(name, ts);
    }

    @Override
    public Type typeContainingMethod(String name, TypeSystem ts) {
        Type result = this.importedMethodType(name, ts);
        return result == null ? super.typeContainingMethod(name, ts) : result;
    }

    @Override
    public boolean localFunctionExists(String name, TypeSystem ts) {
        return !this.importsMethod(name, ts) && super.localFunctionExists(name, ts);
    }

    @Override
    public Iterable<LocalFunction> getLocalFunctions(String name, TypeSystem ts, Iterable<LocalFunction> partial) {
        boolean keepLooking = IterUtil.isEmpty(partial) && !this.importsMethod(name, ts);
        return keepLooking ? super.getLocalFunctions(name, ts, partial) : partial;
    }

    private boolean importsMethod(String name, TypeSystem ts) {
        return this.importedMethodType(name, ts) != null;
    }

    private Type importedMethodType(String name, final TypeSystem ts) {
        Iterable<ClassType> matches;
        PredicateSet<DJClass> explicitImports = this._importedMethods.matchFirst(name);
        if (!IterUtil.isEmpty(explicitImports)) {
            matches = IterUtil.mapSnapshot(explicitImports, new Lambda<DJClass, ClassType>(){

                @Override
                public ClassType value(DJClass c) {
                    return ts.makeClassType(c);
                }
            });
        } else {
            LinkedList<ClassType> onDemandMatches = new LinkedList<ClassType>();
            for (DJClass c : this._staticOnDemandClasses) {
                ClassType t = ts.makeClassType(c);
                if (!ts.containsStaticMethod(t, name, this.accessModule())) continue;
                onDemandMatches.add(t);
            }
            matches = onDemandMatches;
        }
        switch (IterUtil.sizeOf(matches, 2)) {
            case 0: {
                return null;
            }
            case 1: {
                return IterUtil.first(matches);
            }
        }
        return new IntersectionType(matches);
    }

    @Override
    public Access.Module accessModule() {
        return new TopLevelAccessModule(this._currentPackage);
    }

    @Override
    public String makeClassName(String n) {
        return this._currentPackage.equals("") ? n : this._currentPackage + "." + n;
    }

    @Override
    public String makeAnonymousClassName() {
        return this.makeClassName("$" + this._anonymousCounter.next().toString());
    }

    @Override
    public DJClass getThis() {
        return null;
    }

    @Override
    public DJClass getThis(String className) {
        return null;
    }

    @Override
    public DJClass getThis(Type expected, TypeSystem ts) {
        return null;
    }

    @Override
    public DJClass initializingClass() {
        return null;
    }

    @Override
    public Type getReturnType() {
        return null;
    }

    @Override
    public Iterable<Type> getDeclaredThrownTypes() {
        return IterUtil.singleton(TypeSystem.THROWABLE);
    }
}

