/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.drjava.ui.MainFrame;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBindingManager {
    public static final KeyBindingManager ONLY = new KeyBindingManager();
    private HashMap<KeyStroke, KeyStrokeData> _keyToDataMap = new HashMap();
    private HashMap<Action, KeyStrokeData> _actionToDataMap = new HashMap();
    private MainFrame _mainFrame = null;
    private ActionMap _actionMap;
    private boolean _shouldCheckConflict = true;

    private KeyBindingManager() {
    }

    public void setMainFrame(MainFrame mainFrame) {
        this._mainFrame = mainFrame;
    }

    public void setActionMap(ActionMap actionMap) {
        this._actionMap = actionMap;
    }

    public void setShouldCheckConflict(boolean bool) {
        this._shouldCheckConflict = bool;
    }

    public Collection<KeyStrokeData> getKeyStrokeData() {
        return this._actionToDataMap.values();
    }

    public void put(VectorOption<KeyStroke> vkso, Action a, JMenuItem jmi, String name) {
        Vector keys = (Vector)((Object)DrJava.getConfig().getSetting(vkso));
        Vector<KeyStroke> retained = new Vector<KeyStroke>();
        KeyStrokeData ksd = new KeyStrokeData(keys, a, jmi, name, vkso);
        this._actionToDataMap.put(a, ksd);
        for (KeyStroke ks : keys) {
            if (!this.shouldUpdate(ks, a)) continue;
            retained.add(ks);
            this._keyToDataMap.put(ks, ksd);
        }
        DrJava.getConfig().addOptionListener(vkso, new VectorKeyStrokeOptionListener(jmi, a, retained));
        if (retained.size() != keys.size()) {
            DrJava.getConfig().setSetting(vkso, retained);
        }
    }

    public Action get(KeyStroke ks) {
        KeyStrokeData ksd = this._keyToDataMap.get(ks);
        if (ksd == null) {
            return null;
        }
        return ksd.getAction();
    }

    public String getName(KeyStroke ks) {
        KeyStrokeData ksd = this._keyToDataMap.get(ks);
        if (ksd == null) {
            return null;
        }
        return ksd.getName();
    }

    public String getName(Action a) {
        KeyStrokeData ksd = this._actionToDataMap.get(a);
        if (ksd == null) {
            return null;
        }
        return ksd.getName();
    }

    private boolean shouldUpdate(KeyStroke ks, Action a) {
        if (ks == KeyStrokeOption.NULL_KEYSTROKE) {
            return false;
        }
        if (!this._keyToDataMap.containsKey(ks)) {
            return true;
        }
        if (this._keyToDataMap.get(ks).getAction().equals(a)) {
            return false;
        }
        if (this._shouldCheckConflict) {
            KeyStrokeOption opt = new KeyStrokeOption(null, null);
            KeyStrokeData conflictKSD = this._keyToDataMap.get(ks);
            String key = opt.format(ks);
            KeyStrokeData newKSD = this._actionToDataMap.get(a);
            String text = "\"" + key + "\"" + " is already assigned to \"" + conflictKSD.getName() + "\".\nWould you like to assign \"" + key + "\" to \"" + newKSD.getName() + "\"?";
            int rc = JOptionPane.showConfirmDialog(this._mainFrame, text, "DrJava", 0);
            switch (rc) {
                case 0: {
                    this.removeExistingKeyStroke(ks);
                    return true;
                }
                case -1: 
                case 1: 
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid rc: " + rc);
        }
        return true;
    }

    private void removeExistingKeyStroke(KeyStroke ks) {
        if (this._keyToDataMap.containsKey(ks) && this._shouldCheckConflict) {
            KeyStrokeData conflictKSD = this._keyToDataMap.get(ks);
            LinkedHashSet<KeyStroke> conflictKeys = new LinkedHashSet<KeyStroke>(conflictKSD.getKeyStrokes());
            conflictKeys.remove(ks);
            conflictKSD.setKeyStrokes(new Vector<KeyStroke>(conflictKeys));
            this.updateMenuItem(conflictKSD);
            this._keyToDataMap.remove(ks);
            DrJava.getConfig().setSetting(conflictKSD.getOption(), conflictKSD.getKeyStrokes());
        }
    }

    private void updateMenuItem(KeyStrokeData data) {
        JMenuItem jmi = data.getJMenuItem();
        if (jmi != null) {
            Vector<KeyStroke> keys = data.getKeyStrokes();
            if (keys.size() > 0) {
                jmi.setAccelerator(keys.get(0));
            } else {
                jmi.setAccelerator(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyStrokeData {
        private Vector<KeyStroke> _ks;
        private Action _a;
        private JMenuItem _jmi;
        private String _name;
        private VectorOption<KeyStroke> _vkso;

        public KeyStrokeData(Vector<KeyStroke> ks, Action a, JMenuItem jmi, String name, VectorOption<KeyStroke> vkso) {
            this._ks = new Vector<KeyStroke>(ks);
            this._a = a;
            this._jmi = jmi;
            this._name = name;
            this._vkso = vkso;
        }

        public Vector<KeyStroke> getKeyStrokes() {
            return this._ks;
        }

        public Action getAction() {
            return this._a;
        }

        public JMenuItem getJMenuItem() {
            return this._jmi;
        }

        public String getName() {
            return this._name;
        }

        public VectorOption<KeyStroke> getOption() {
            return this._vkso;
        }

        public void setKeyStrokes(Vector<KeyStroke> ks) {
            this._ks = new Vector<KeyStroke>(ks);
        }

        public void setAction(Action a) {
            this._a = a;
        }

        public void setJMenuItem(JMenuItem jmi) {
            this._jmi = jmi;
        }

        public void setName(String name) {
            this._name = name;
        }

        public void setOption(VectorOption<KeyStroke> vkso) {
            this._vkso = vkso;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VectorKeyStrokeOptionListener
    implements OptionListener<Vector<KeyStroke>> {
        protected JMenuItem _jmi;
        protected Action _a;
        protected Set<KeyStroke> _oldKeys;

        public VectorKeyStrokeOptionListener(JMenuItem jmi, Action a, Vector<KeyStroke> keys) {
            this._jmi = jmi;
            this._a = a;
            this._oldKeys = new LinkedHashSet<KeyStroke>(keys);
        }

        public VectorKeyStrokeOptionListener(Action a, Vector<KeyStroke> keys) {
            this(null, a, keys);
        }

        @Override
        public void optionChanged(OptionEvent<Vector<KeyStroke>> oce) {
            LinkedHashSet newKeys = new LinkedHashSet((Collection)oce.value);
            LinkedHashSet<KeyStroke> removed = new LinkedHashSet<KeyStroke>(this._oldKeys);
            removed.removeAll(newKeys);
            LinkedHashSet added = new LinkedHashSet(newKeys);
            added.removeAll(this._oldKeys);
            LinkedHashSet<KeyStroke> retained = new LinkedHashSet<KeyStroke>(this._oldKeys);
            retained.retainAll(newKeys);
            boolean update = false;
            KeyStrokeData data = (KeyStrokeData)KeyBindingManager.this._actionToDataMap.get(this._a);
            if (data == null) {
                return;
            }
            for (KeyStroke ks : removed) {
                if (!data.equals(KeyBindingManager.this._keyToDataMap.get(ks))) continue;
                KeyBindingManager.this._keyToDataMap.remove(ks);
                update = true;
            }
            for (KeyStroke ks : added) {
                if (!KeyBindingManager.this.shouldUpdate(ks, this._a)) continue;
                KeyBindingManager.this._keyToDataMap.put(ks, data);
                retained.add(ks);
                update = true;
            }
            if (update) {
                Vector<KeyStroke> v = new Vector<KeyStroke>(retained);
                data.setKeyStrokes(v);
                KeyBindingManager.this.updateMenuItem(data);
                this._oldKeys = retained;
            }
        }
    }
}

