/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.KeyStrokeOption;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.DJDocument;
import edu.rice.cs.drjava.model.definitions.CompoundUndoManager;
import edu.rice.cs.drjava.model.definitions.indent.Indenter;
import edu.rice.cs.drjava.model.repl.InteractionsDJDocument;
import edu.rice.cs.drjava.model.repl.InteractionsEditorKit;
import edu.rice.cs.drjava.ui.AbstractDJPane;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.ReverseHighlighter;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.EditorKit;
import javax.swing.text.Keymap;
import javax.swing.text.StyledEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractionsPane
extends AbstractDJPane
implements OptionConstants,
ClipboardOwner {
    static Log LOG = new Log("InteractionsPane.txt", false);
    private volatile UndoAction _undoAction;
    private volatile RedoAction _redoAction;
    public volatile boolean _inCompoundEdit = false;
    private volatile int _compoundEditKey;
    private volatile boolean deleteCEBool = true;
    protected final Keymap _keymap;
    private boolean _antiAliasText = false;
    static StyledEditorKit EDITOR_KIT = new InteractionsEditorKit();
    protected Runnable _beep = new Runnable(){

        public void run() {
            Toolkit.getDefaultToolkit().beep();
        }
    };
    private final InteractionsDJDocument _doc;
    private final UndoableEditListener _undoListener = new UndoableEditListener(){

        public void undoableEditHappened(UndoableEditEvent e) {
            assert (EventQueue.isDispatchThread() || Utilities.TEST_MODE);
            UndoableEdit undo = e.getEdit();
            LOG.log("In undoableEditHappened - _inCompoundEdit is " + InteractionsPane.this._inCompoundEdit);
            if (!InteractionsPane.this._inCompoundEdit) {
                CompoundUndoManager undoMan = InteractionsPane.this._doc.getUndoManager();
                InteractionsPane.this._inCompoundEdit = true;
                InteractionsPane.this._compoundEditKey = undoMan.startCompoundEdit();
                InteractionsPane.this.getUndoAction().updateUndoState();
                InteractionsPane.this.getRedoAction().updateRedoState();
            }
            InteractionsPane.this._doc.getUndoManager().addEdit(undo);
            InteractionsPane.this.getRedoAction().setEnabled(false);
        }
    };

    public Runnable getBeep() {
        return this._beep;
    }

    public InteractionsPane(InteractionsDJDocument doc) {
        this("INTERACTIONS_KEYMAP", doc);
    }

    public InteractionsPane(String keymapName, InteractionsDJDocument doc) {
        super(doc);
        this._doc = doc;
        this._keymap = InteractionsPane.addKeymap(keymapName, this.getKeymap());
        this.setCaretPosition(doc.getLength());
        this.setHighlighter(new ReverseHighlighter());
        this._highlightManager = new HighlightManager(this);
        this._antiAliasText = DrJava.getConfig().getSetting(TEXT_ANTIALIAS);
        new ForegroundColorListener(this);
        new BackgroundColorListener(this);
        AntiAliasOptionListener aaTemp = new AntiAliasOptionListener();
        DrJava.getConfig().addOptionListener(OptionConstants.TEXT_ANTIALIAS, aaTemp);
        this._resetUndo();
        this.addMouseListener(new leftUndoBreak());
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 8 && this.deleteCEBool) {
            this.endCompoundEdit();
            this.deleteCEBool = false;
        } else if (e.getID() == 401 && e.getKeyCode() != 8) {
            this.deleteCEBool = true;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
        Action a = KeyBindingManager.ONLY.get(ks);
        if (ks != KeyStrokeOption.NULL_KEYSTROKE && a != null) {
            this.endCompoundEdit();
        }
        if ((e.getModifiers() & 1) != 0 && e.getKeyCode() == 10) {
            this.endCompoundEdit();
        }
        super.processKeyEvent(e);
    }

    public void addActionForKeyStroke(KeyStroke stroke, Action action) {
        KeyStroke[] keys = this._keymap.getKeyStrokesForAction(action);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this._keymap.removeKeyStrokeBinding(keys[i]);
            }
        }
        this._keymap.addActionForKeyStroke(stroke, action);
        this.setKeymap(this._keymap);
    }

    public void addActionForKeyStroke(Vector<KeyStroke> stroke, Action action) {
        KeyStroke[] keys = this._keymap.getKeyStrokesForAction(action);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                this._keymap.removeKeyStrokeBinding(keys[i]);
            }
        }
        for (KeyStroke ks : stroke) {
            this._keymap.addActionForKeyStroke(ks, action);
        }
        this.setKeymap(this._keymap);
    }

    public void setBeep(Runnable beep) {
        this._beep = beep;
    }

    public void highlightError(int offset, int length) {
        this._highlightManager.addHighlight(offset, offset + length, ERROR_PAINTER);
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return EDITOR_KIT;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        if (this._antiAliasText && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        super.paintComponent(g);
    }

    @Override
    public DJDocument getDJDocument() {
        return this._doc;
    }

    @Override
    protected void matchUpdate(int offset, boolean opening) {
        if (!this._doc.hasPrompt()) {
            return;
        }
        this._doc.setCurrentLocation(offset);
        this._removePreviousHighlight();
        int caretPos = this.getCaretPosition();
        if (opening) {
            int to2 = this._doc.balanceForward();
            if (to2 > -1) {
                int end = caretPos + to2;
                this._addHighlight(caretPos - 1, end);
            }
        } else {
            int from = this._doc.balanceBackward();
            if (from > -1) {
                int start = caretPos - from;
                this._addHighlight(start, caretPos);
            }
        }
    }

    @Override
    protected void updateStatusField() {
    }

    @Override
    protected void indentLines(int selStart, int selEnd, Indenter.IndentReason reason, ProgressMonitor pm) {
        assert (EventQueue.isDispatchThread());
        try {
            this._doc.indentLines(selStart, selEnd, reason, pm);
            this.setCaretPos(this._doc.getCurrentLocation());
        }
        catch (OperationCanceledException oce) {
            throw new UnexpectedException(oce);
        }
    }

    @Override
    protected boolean shouldIndent(int selStart, int selEnd) {
        return true;
    }

    public abstract int getPromptPos();

    public void endCompoundEdit() {
        if (this._inCompoundEdit) {
            CompoundUndoManager undoMan = this._doc.getUndoManager();
            this._inCompoundEdit = false;
            undoMan.endCompoundEdit(this._compoundEditKey);
        }
    }

    public UndoAction getUndoAction() {
        return this._undoAction;
    }

    public RedoAction getRedoAction() {
        return this._redoAction;
    }

    private void resetUndo() {
        this._doc.getUndoManager().discardAllEdits();
        this._undoAction.updateUndoState();
        this._redoAction.updateRedoState();
    }

    public void discardUndoEdits() {
        this.endCompoundEdit();
        this.resetUndo();
    }

    public void _resetUndo() {
        if (this._undoAction == null) {
            this._undoAction = new UndoAction();
        }
        if (this._redoAction == null) {
            this._redoAction = new RedoAction();
        }
        this._doc.resetUndoManager();
        this._doc.addUndoableEditListener(this._undoListener);
        this._undoAction.updateUndoState();
        this._redoAction.updateRedoState();
    }

    public class RedoAction
    extends AbstractAction {
        private RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                InteractionsPane.this._doc.getUndoManager().redo();
                InteractionsPane.this._doc.updateModifiedSinceSave();
            }
            catch (CannotRedoException ex) {
                throw new UnexpectedException(ex);
            }
            this.updateRedoState();
            InteractionsPane.this._undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (InteractionsPane.this._doc.undoManagerCanRedo() && InteractionsPane.this.isEditable()) {
                this.setEnabled(true);
                this.putValue("Name", InteractionsPane.this._doc.getUndoManager().getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                InteractionsPane.this._doc.getUndoManager().undo();
                InteractionsPane.this._doc.updateModifiedSinceSave();
            }
            catch (CannotUndoException ex) {
                throw new UnexpectedException(ex);
            }
            this.updateUndoState();
            InteractionsPane.this._redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (InteractionsPane.this._doc.undoManagerCanUndo() && InteractionsPane.this.isEditable()) {
                this.setEnabled(true);
                this.putValue("Name", InteractionsPane.this._doc.getUndoManager().getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    private class leftUndoBreak
    extends MouseAdapter {
        private leftUndoBreak() {
        }

        public void mouseClicked(MouseEvent e) {
            InteractionsPane.this.endCompoundEdit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AntiAliasOptionListener
    implements OptionListener<Boolean> {
        private AntiAliasOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            InteractionsPane.this._antiAliasText = (Boolean)oce.value;
            InteractionsPane.this.repaint();
        }
    }
}

