/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.platform;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.platform.DefaultPlatform;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

class MacPlatform
extends DefaultPlatform {
    public static MacPlatform ONLY = new MacPlatform();

    protected MacPlatform() {
    }

    public boolean openURL(URL address) {
        if (super.openURL(address)) {
            return true;
        }
        try {
            String addressString = address.toString();
            if (addressString.startsWith("file:/")) {
                String suffix = addressString.substring("file:/".length(), addressString.length());
                addressString = "file:///" + suffix;
            }
            Runtime.getRuntime().exec(new String[]{"open", addressString});
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public void beforeUISetup() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        ApplicationAdapter appListener = new ApplicationAdapter(){

            public void handleOpenFile(ApplicationEvent event) {
                if (event.getFilename() != null) {
                    DrJavaRoot.handleRemoteOpenFile(new File(event.getFilename()), -1);
                    event.setHandled(true);
                }
            }
        };
        Application appl = new Application();
        appl.addApplicationListener((ApplicationListener)appListener);
    }

    public void afterUISetup(final Action about, final Action prefs, final Action quit) {
        ApplicationAdapter appListener = new ApplicationAdapter(){

            public void handleAbout(ApplicationEvent e) {
                about.actionPerformed(new ActionEvent((Object)this, 0, "About DrJava"));
                e.setHandled(true);
            }

            public void handlePreferences(ApplicationEvent e) {
                prefs.actionPerformed(new ActionEvent((Object)this, 0, "Preferences..."));
                e.setHandled(true);
            }

            public void handleQuit(ApplicationEvent e) {
                final ApplicationEvent ae = e;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        quit.actionPerformed(new ActionEvent(this, 0, "Quit DrJava"));
                        ae.setHandled(true);
                    }
                });
            }
        };
        Application appl = new Application();
        appl.setEnabledPreferencesMenu(true);
        appl.addApplicationListener((ApplicationListener)appListener);
    }

    public boolean isMacPlatform() {
        return true;
    }

    public void setMnemonic(AbstractButton obj, int mnemonic) {
    }

    public void setMnemonic(AbstractButton obj, char mnemonic) {
    }

    public void setMnemonic(ButtonModel obj, int mnemonic) {
    }

    public void setMnemonic(JTabbedPane obj, int tabIndex, int mnemonic) {
    }

    public void setMnemonic(JTabbedPane obj, int mnemonic) {
    }
}

