/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl.newjvm;

import edu.rice.cs.drjava.model.junit.JUnitError;
import edu.rice.cs.drjava.model.junit.JUnitModelCallback;
import edu.rice.cs.drjava.model.junit.JUnitTestManager;
import edu.rice.cs.drjava.model.repl.InteractionsPaneOptions;
import edu.rice.cs.drjava.model.repl.newjvm.ClassPathManager;
import edu.rice.cs.drjava.model.repl.newjvm.InterpretResult;
import edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVMRemoteI;
import edu.rice.cs.drjava.model.repl.newjvm.MainJVMRemoteI;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.ClassContext;
import edu.rice.cs.dynamicjava.interpreter.ClassSignatureContext;
import edu.rice.cs.dynamicjava.interpreter.DelegatingContext;
import edu.rice.cs.dynamicjava.interpreter.EvaluatorException;
import edu.rice.cs.dynamicjava.interpreter.ImportContext;
import edu.rice.cs.dynamicjava.interpreter.Interpreter;
import edu.rice.cs.dynamicjava.interpreter.InterpreterException;
import edu.rice.cs.dynamicjava.interpreter.LocalContext;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.dynamicjava.symbol.DJClass;
import edu.rice.cs.dynamicjava.symbol.LocalVariable;
import edu.rice.cs.dynamicjava.symbol.SymbolUtil;
import edu.rice.cs.dynamicjava.symbol.type.Type;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.OptionVisitor;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.InputStreamRedirector;
import edu.rice.cs.util.OutputStreamRedirector;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.newjvm.AbstractSlaveJVM;
import edu.rice.cs.util.newjvm.MasterRemote;
import java.io.File;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterJVM
extends AbstractSlaveJVM
implements InterpreterJVMRemoteI,
JUnitModelCallback {
    public static final InterpreterJVM ONLY = new InterpreterJVM();
    private final InteractionsPaneOptions _interpreterOptions;
    private volatile Pair<String, Interpreter> _activeInterpreter;
    private final Interpreter _defaultInterpreter;
    private final Map<String, Interpreter> _interpreters;
    private final Set<Interpreter> _busyInterpreters;
    private final Map<String, Pair<TypeContext, RuntimeBindings>> _environments;
    private final ClassPathManager _classPathManager = new ClassPathManager(ReflectUtil.SYSTEM_CLASS_PATH);
    private final ClassLoader _interpreterLoader = this._classPathManager.makeClassLoader(null);
    private final JUnitTestManager _junitTestManager = new JUnitTestManager(this, this._classPathManager);
    private volatile MainJVMRemoteI _mainJVM;

    private InterpreterJVM() {
        super("Reset Interactions Thread", "Poll DrJava Thread");
        this._interpreterOptions = new InteractionsPaneOptions();
        this._defaultInterpreter = new Interpreter(this._interpreterOptions, this._interpreterLoader);
        this._interpreters = new HashMap<String, Interpreter>();
        this._busyInterpreters = new HashSet<Interpreter>();
        this._environments = new HashMap<String, Pair<TypeContext, RuntimeBindings>>();
        this._activeInterpreter = Pair.make("", this._defaultInterpreter);
    }

    @Override
    protected void handleStart(MasterRemote mainJVM) {
        this._mainJVM = (MainJVMRemoteI)mainJVM;
        System.setIn(new InputStreamRedirector(){

            protected String _getInput() {
                try {
                    return InterpreterJVM.this._mainJVM.getConsoleInput();
                }
                catch (RemoteException re) {
                    DebugUtil.error.log(re);
                    throw new UnexpectedException("Main JVM can't be reached for input.\n" + re);
                }
            }
        });
        System.setOut(new PrintStream(new OutputStreamRedirector(){

            public void print(String s) {
                try {
                    InterpreterJVM.this._mainJVM.systemOutPrint(s);
                }
                catch (RemoteException re) {
                    DebugUtil.error.log(re);
                    throw new UnexpectedException("Main JVM can't be reached for output.\n" + re);
                }
            }
        }));
        System.setErr(new PrintStream(new OutputStreamRedirector(){

            public void print(String s) {
                try {
                    InterpreterJVM.this._mainJVM.systemErrPrint(s);
                }
                catch (RemoteException re) {
                    DebugUtil.error.log(re);
                    throw new UnexpectedException("Main JVM can't be reached for output.\n" + re);
                }
            }
        }));
        if (PlatformFactory.ONLY.isWindowsPlatform()) {
            JDialog d = new JDialog();
            d.setSize(0, 0);
            d.setVisible(true);
            d.setVisible(false);
        }
    }

    @Override
    public InterpretResult interpret(String s) {
        return this.interpret(s, this._activeInterpreter.second());
    }

    public InterpretResult interpret(String s, String interpreterName) {
        Interpreter i = this._interpreters.get(interpreterName);
        if (i == null) {
            throw new IllegalArgumentException("Interpreter '" + interpreterName + "' does not exist.");
        }
        return this.interpret(s, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpretResult interpret(String input, Interpreter interpreter) {
        DebugUtil.debug.logStart("Interpret " + input);
        boolean available = this._busyInterpreters.add(interpreter);
        if (!available) {
            DebugUtil.debug.logEnd();
            return InterpretResult.busy();
        }
        Option<Object> result = null;
        try {
            result = interpreter.interpret(input);
        }
        catch (InterpreterException e) {
            DebugUtil.debug.logEnd();
            InterpretResult interpretResult = InterpretResult.exception(e);
            Object var8_6 = null;
            this._busyInterpreters.remove(interpreter);
            return interpretResult;
        }
        catch (Throwable e) {
            InterpretResult interpretResult;
            try {
                DebugUtil.debug.logEnd();
                interpretResult = InterpretResult.unexpectedException(e);
                Object var8_7 = null;
                this._busyInterpreters.remove(interpreter);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this._busyInterpreters.remove(interpreter);
                throw throwable;
            }
            return interpretResult;
        }
        Object var8_5 = null;
        this._busyInterpreters.remove(interpreter);
        return result.apply(new OptionVisitor<Object, InterpretResult>(){

            @Override
            public InterpretResult forNone() {
                return InterpretResult.noValue();
            }

            @Override
            public InterpretResult forSome(Object obj) {
                if (obj instanceof String) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.stringValue((String)obj);
                }
                if (obj instanceof Character) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.charValue((Character)obj);
                }
                if (obj instanceof Number) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.numberValue((Number)obj);
                }
                if (obj instanceof Boolean) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.booleanValue((Boolean)obj);
                }
                try {
                    String resultString = TextUtil.toString(obj);
                    String resultTypeStr = null;
                    if (obj != null) {
                        Class<?> c = obj.getClass();
                        resultTypeStr = InterpreterJVM.getClassName(c);
                    }
                    DebugUtil.debug.logEnd();
                    return InterpretResult.objectValue(resultString, resultTypeStr);
                }
                catch (Throwable t) {
                    DebugUtil.debug.logEnd();
                    return InterpretResult.exception(new EvaluatorException(t));
                }
            }
        });
    }

    public Object[] getVariableValue(String var) {
        Pair<Object, String>[] arr = this.getVariable(var);
        if (arr.length == 0) {
            return new Object[0];
        }
        return new Object[]{arr[0].first()};
    }

    public Pair<Object, String>[] getVariable(String var) {
        InterpretResult ir = this.interpret(var);
        return ir.apply(new InterpretResult.Visitor<Pair<Object, String>[]>(){

            public Pair<Object, String>[] fail() {
                return new Pair[0];
            }

            public Pair<Object, String>[] value(Object val) {
                return new Pair[]{new Pair<Object, String>(val, InterpreterJVM.getClassName(val.getClass()))};
            }

            @Override
            public Pair<Object, String>[] forNoValue() {
                return this.fail();
            }

            @Override
            public Pair<Object, String>[] forStringValue(String val) {
                return this.value(val);
            }

            @Override
            public Pair<Object, String>[] forCharValue(Character val) {
                return this.value(val);
            }

            @Override
            public Pair<Object, String>[] forNumberValue(Number val) {
                return this.value(val);
            }

            @Override
            public Pair<Object, String>[] forBooleanValue(Boolean val) {
                return this.value(val);
            }

            @Override
            public Pair<Object, String>[] forObjectValue(String valString, String objTypeString) {
                return new Pair[]{new Pair<String, String>(valString, objTypeString)};
            }

            @Override
            public Pair<Object, String>[] forException(String message) {
                return this.fail();
            }

            @Override
            public Pair<Object, String>[] forEvalException(String message, StackTraceElement[] stackTrace) {
                return this.fail();
            }

            @Override
            public Pair<Object, String>[] forUnexpectedException(Throwable t) {
                return this.fail();
            }

            @Override
            public Pair<Object, String>[] forBusy() {
                return this.fail();
            }
        });
    }

    @Override
    public Pair<String, String> getVariableToString(String var) {
        Pair<Object, String>[] val = this.getVariable(var);
        if (val.length == 0) {
            return new Pair<Object, Object>(null, null);
        }
        Object o = val[0].first();
        try {
            return new Pair<String, String>(TextUtil.toString(o), val[0].second());
        }
        catch (Throwable t) {
            return new Pair<String, String>("<error in toString()>", "");
        }
    }

    public static String getClassName(Class<?> c) {
        StringBuilder sb = new StringBuilder();
        boolean isArray = c.isArray();
        while (c.isArray()) {
            sb.append("[]");
            c = c.getComponentType();
        }
        if (!isArray) {
            if (c.equals(Byte.class)) {
                return "byte" + sb.toString() + " or " + c.getSimpleName() + sb.toString();
            }
            if (c.equals(Short.class)) {
                return "short" + sb.toString() + " or " + c.getSimpleName() + sb.toString();
            }
            if (c.equals(Integer.class)) {
                return "int" + sb.toString() + " or " + c.getSimpleName() + sb.toString();
            }
            if (c.equals(Long.class)) {
                return "long" + sb.toString() + " or " + c.getSimpleName() + sb.toString();
            }
            if (c.equals(Float.class)) {
                return "float" + sb.toString() + " or " + c.getSimpleName() + sb.toString();
            }
            if (c.equals(Double.class)) {
                return "double" + sb.toString() + " or " + c.getSimpleName() + sb.toString();
            }
            if (c.equals(Boolean.class)) {
                return "boolean" + sb.toString() + " or " + c.getSimpleName() + sb.toString();
            }
            if (c.equals(Character.class)) {
                return "char" + sb.toString() + " or " + c.getSimpleName() + sb.toString();
            }
            return c.getName() + sb.toString();
        }
        return c.getName() + sb.toString();
    }

    @Override
    public void addInterpreter(String name) {
        if (this._interpreters.containsKey(name)) {
            throw new IllegalArgumentException("'" + name + "' is not a unique interpreter name");
        }
        Interpreter i = new Interpreter(this._interpreterOptions, this._interpreterLoader);
        this._interpreters.put(name, i);
    }

    public void addInterpreter(String name, Object thisVal, Class<?> thisClass, Object[] localVars, String[] localVarNames, Class<?>[] localVarClasses) {
        DebugUtil.debug.logValues(new String[]{"name", "thisVal", "thisClass", "localVars", "localVarNames", "localVarClasses"}, name, thisVal, thisClass, localVars, localVarNames, localVarClasses);
        if (this._interpreters.containsKey(name)) {
            throw new IllegalArgumentException("'" + name + "' is not a unique interpreter name");
        }
        if (localVars.length != localVarNames.length || localVars.length != localVarClasses.length) {
            throw new IllegalArgumentException("Local variable arrays are inconsistent");
        }
        Package pkg = thisClass.getPackage();
        DJClass c = SymbolUtil.wrapClass(thisClass);
        LinkedList<LocalVariable> vars = new LinkedList<LocalVariable>();
        for (int i = 0; i < localVars.length; ++i) {
            if (localVarClasses[i] == null) {
                try {
                    localVarClasses[i] = (Class)localVars[i].getClass().getField("TYPE").get(null);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Type varT = SymbolUtil.typeOfGeneralClass(localVarClasses[i], this._interpreterOptions.typeSystem());
            vars.add(new LocalVariable(localVarNames[i], varT, false));
        }
        TypeContext ctx = new ImportContext(this._interpreterLoader, (Options)this._interpreterOptions);
        if (pkg != null) {
            ctx = ctx.setPackage(pkg.getName());
        }
        ctx = new ClassSignatureContext(ctx, c, this._interpreterLoader);
        ctx = new ClassContext(ctx, c);
        ctx = new DebugMethodContext(ctx, thisVal == null);
        ctx = new LocalContext(ctx, vars);
        RuntimeBindings bindings = RuntimeBindings.EMPTY;
        if (thisVal != null) {
            bindings = new RuntimeBindings(bindings, c, thisVal);
        }
        bindings = new RuntimeBindings(bindings, vars, IterUtil.asIterable(localVars));
        Interpreter i = new Interpreter(this._interpreterOptions, ctx, bindings);
        this._environments.put(name, Pair.make(ctx, bindings));
        this._interpreters.put(name, i);
    }

    @Override
    public void removeInterpreter(String name) {
        this._interpreters.remove(name);
        this._environments.remove(name);
    }

    @Override
    public synchronized Pair<Boolean, Boolean> setActiveInterpreter(String name) {
        Interpreter i = this._interpreters.get(name);
        if (i == null) {
            throw new IllegalArgumentException("Interpreter '" + name + "' does not exist.");
        }
        boolean changed = i != this._activeInterpreter.second();
        this._activeInterpreter = Pair.make(name, i);
        return Pair.make(changed, this._busyInterpreters.contains(i));
    }

    @Override
    public synchronized Pair<Boolean, Boolean> setToDefaultInterpreter() {
        boolean changed = this._defaultInterpreter != this._activeInterpreter.second();
        this._activeInterpreter = Pair.make("", this._defaultInterpreter);
        return Pair.make(changed, this._busyInterpreters.contains(this._defaultInterpreter));
    }

    @Override
    public synchronized void setEnforceAllAccess(boolean enforce) {
        this._interpreterOptions.setEnforceAllAccess(enforce);
    }

    @Override
    public synchronized void setEnforcePrivateAccess(boolean enforce) {
        this._interpreterOptions.setEnforcePrivateAccess(enforce);
    }

    @Override
    public synchronized void setRequireSemicolon(boolean require) {
        this._interpreterOptions.setRequireSemicolon(require);
    }

    @Override
    public synchronized void setRequireVariableType(boolean require) {
        this._interpreterOptions.setRequireVariableType(require);
    }

    @Override
    public List<String> findTestClasses(List<String> classNames, List<File> files) throws RemoteException {
        return this._junitTestManager.findTestClasses(classNames, files);
    }

    @Override
    public boolean runTestSuite() throws RemoteException {
        return this._junitTestManager.runTestSuite();
    }

    @Override
    public void nonTestCase(boolean isTestAll, boolean didCompileFail) {
        try {
            this._mainJVM.nonTestCase(isTestAll, didCompileFail);
        }
        catch (RemoteException re) {
            DebugUtil.error.log(re);
        }
    }

    @Override
    public void classFileError(ClassFileError e) {
        try {
            this._mainJVM.classFileError(e);
        }
        catch (RemoteException re) {
            DebugUtil.error.log(re);
        }
    }

    @Override
    public void testSuiteStarted(int numTests) {
        try {
            this._mainJVM.testSuiteStarted(numTests);
        }
        catch (RemoteException re) {
            DebugUtil.error.log(re);
        }
    }

    @Override
    public void testStarted(String testName) {
        try {
            this._mainJVM.testStarted(testName);
        }
        catch (RemoteException re) {
            DebugUtil.error.log(re);
        }
    }

    @Override
    public void testEnded(String testName, boolean wasSuccessful, boolean causedError) {
        try {
            this._mainJVM.testEnded(testName, wasSuccessful, causedError);
        }
        catch (RemoteException re) {
            DebugUtil.error.log(re);
        }
    }

    @Override
    public void testSuiteEnded(JUnitError[] errors) {
        try {
            this._mainJVM.testSuiteEnded(errors);
        }
        catch (RemoteException re) {
            DebugUtil.error.log(re);
        }
    }

    @Override
    public File getFileForClassName(String className) {
        try {
            return this._mainJVM.getFileForClassName(className);
        }
        catch (RemoteException re) {
            DebugUtil.error.log(re);
            return null;
        }
    }

    @Override
    public void junitJVMReady() {
    }

    @Override
    public void addExtraClassPath(File f) {
        this._classPathManager.addExtraCP(f);
    }

    @Override
    public void addProjectClassPath(File f) {
        this._classPathManager.addProjectCP(f);
    }

    @Override
    public void addBuildDirectoryClassPath(File f) {
        this._classPathManager.addBuildDirectoryCP(f);
    }

    @Override
    public void addProjectFilesClassPath(File f) {
        this._classPathManager.addProjectFilesCP(f);
    }

    @Override
    public void addExternalFilesClassPath(File f) {
        this._classPathManager.addExternalFilesCP(f);
    }

    @Override
    public Iterable<File> getClassPath() {
        return IterUtil.snapshot(this._classPathManager.getClassPath());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DebugMethodContext
    extends DelegatingContext {
        private final boolean _isStatic;

        public DebugMethodContext(TypeContext next, boolean isStatic) {
            super(next);
            this._isStatic = isStatic;
        }

        @Override
        protected TypeContext duplicate(TypeContext next) {
            return new DebugMethodContext(next, this._isStatic);
        }

        @Override
        public DJClass getThis() {
            return this._isStatic ? null : super.getThis();
        }

        @Override
        public DJClass getThis(String className) {
            return this._isStatic ? null : super.getThis(className);
        }

        @Override
        public Type getReturnType() {
            return null;
        }

        @Override
        public Iterable<Type> getDeclaredThrownTypes() {
            return IterUtil.empty();
        }
    }
}

