/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.junit;

import edu.rice.cs.drjava.model.DJError;
import java.io.File;
import java.io.Serializable;

public class JUnitError
extends DJError
implements Serializable {
    private String _test;
    private String _className;
    private String _exception;
    private StackTraceElement[] _stackTrace;

    public JUnitError(File file, int lineNumber, int startColumn, String message, boolean isWarning, String test, String className, String exception, StackTraceElement[] stackTrace) {
        super(file, lineNumber, startColumn, message, isWarning);
        this._test = test;
        this._className = className;
        this._exception = exception;
        this._stackTrace = stackTrace;
    }

    public JUnitError(String message, boolean isWarning, String test) {
        this(null, -1, -1, message, isWarning, test, "", "No associated stack trace", new StackTraceElement[0]);
    }

    public String testName() {
        return this._test;
    }

    public String className() {
        return this._className;
    }

    public String exception() {
        return this._exception;
    }

    public StackTraceElement[] stackTrace() {
        return this._stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stes) {
        this._stackTrace = stes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._exception);
        for (StackTraceElement s : this._stackTrace) {
            sb.append('\n');
            sb.append("\tat ");
            sb.append(s);
        }
        return sb.toString();
    }
}

