/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.Brace;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;

public abstract class ReducedToken
implements ReducedModelStates {
    private volatile ReducedModelState _state;

    public ReducedToken(ReducedModelState state) {
        this._state = state;
    }

    public abstract int getSize();

    public abstract String getType();

    public abstract void setType(String var1);

    public abstract void flip();

    public abstract boolean isMatch(Brace var1);

    public abstract boolean isMatchable();

    public ReducedModelState getState() {
        return this._state;
    }

    public int getHighlightState() {
        String type = this.getType();
        if (type.equals("//") || this._state == INSIDE_LINE_COMMENT || type.equals("/*") || type.equals("*/") || this._state == INSIDE_BLOCK_COMMENT) {
            return 1;
        }
        if (type.equals("'") && this._state == FREE || this._state == INSIDE_SINGLE_QUOTE) {
            return 2;
        }
        if (type.equals("\"") && this._state == FREE || this._state == INSIDE_DOUBLE_QUOTE) {
            return 3;
        }
        return 0;
    }

    public void setState(ReducedModelState state) {
        this._state = state;
    }

    public abstract void grow(int var1);

    public abstract void shrink(int var1);

    public boolean isShadowed() {
        return this._state != FREE;
    }

    public boolean isQuoted() {
        return this._state == INSIDE_DOUBLE_QUOTE;
    }

    boolean isCommented() {
        return this.inBlockComment() || this.inLineComment();
    }

    private boolean inBlockComment() {
        return this._state == INSIDE_BLOCK_COMMENT;
    }

    private boolean inLineComment() {
        return this._state == INSIDE_LINE_COMMENT;
    }

    public abstract boolean isMultipleCharBrace();

    public abstract boolean isGap();

    public abstract boolean isLineComment();

    public abstract boolean isBlockCommentStart();

    public abstract boolean isBlockCommentEnd();

    public abstract boolean isNewline();

    public abstract boolean isSlash();

    public abstract boolean isStar();

    public abstract boolean isDoubleQuote();

    public abstract boolean isSingleQuote();

    public abstract boolean isDoubleEscapeSequence();

    public abstract boolean isDoubleEscape();

    public abstract boolean isEscapedSingleQuote();

    public abstract boolean isEscapedDoubleQuote();

    public abstract boolean isOpen();

    public abstract boolean isClosed();

    public abstract boolean isOpenBrace();

    public abstract boolean isClosedBrace();

    public boolean isCommentStart() {
        return this.isBlockCommentStart() || this.isLineComment();
    }
}

