/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions;

import edu.rice.cs.drjava.model.GlobalEventNotifier;
import edu.rice.cs.drjava.model.definitions.ColoringView;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.drjava.ui.AbstractDJPane;
import edu.rice.cs.util.UnexpectedException;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class DefinitionsEditorKit
extends StyledEditorKit {
    private GlobalEventNotifier _notifier;
    private Action[] _actions;
    private static ViewFactory _factory = new ViewFactory(){

        public View create(Element elem) {
            return new ColoringView(elem);
        }
    };

    public DefinitionsEditorKit(GlobalEventNotifier notifier) {
        this._notifier = notifier;
        Action[] supActions = super.getActions();
        this._actions = new Action[supActions.length];
        for (int i = 0; i < this._actions.length; ++i) {
            Action a = supActions[i];
            Object name = a.getValue("Name");
            this._actions[i] = name.equals("caret-begin-word") ? new BeginWordAction("caret-begin-word", false) : (name.equals("caret-end-word") ? new EndWordAction("caret-end-word", false) : (name.equals("caret-next-word") ? new NextWordAction("caret-next-word", false) : (name.equals("caret-previous-word") ? new PreviousWordAction("caret-previous-word", false) : (name.equals("selection-next-word") ? new NextWordAction("selection-next-word", true) : (name.equals("selection-previous-word") ? new PreviousWordAction("selection-previous-word", true) : (name.equals("select-word") ? new SelectWordAction() : a))))));
        }
    }

    public Action[] getActions() {
        return this._actions;
    }

    public DefinitionsDocument createNewDocument() {
        return this._createDefaultTypedDocument();
    }

    private DefinitionsDocument _createDefaultTypedDocument() {
        return new DefinitionsDocument(this._notifier);
    }

    public String getContentType() {
        return "text/java";
    }

    public final ViewFactory getViewFactory() {
        return _factory;
    }

    static class SelectWordAction
    extends TextAction {
        private Action start = new BeginWordAction("pigdog", false);
        private Action end = new EndWordAction("pigdog", true);

        public SelectWordAction() {
            super("select-word");
        }

        public void actionPerformed(ActionEvent e) {
            this.start.actionPerformed(e);
            this.end.actionPerformed(e);
        }
    }

    static class NextWordAction
    extends TextAction {
        private boolean _select;

        NextWordAction(String nm, boolean b) {
            super(nm);
            this._select = b;
        }

        public void actionPerformed(ActionEvent e) {
            AbstractDJPane target = (AbstractDJPane)this.getTextComponent(e);
            if (target != null) {
                try {
                    int offs;
                    int iOffs = offs = target.getCaretPosition();
                    String text = target.getDocument().getText(iOffs, target.getDocument().getLength() - iOffs);
                    int len = text.length();
                    while (offs - iOffs < len && ++offs - iOffs != len) {
                        char ch = text.charAt(offs - iOffs);
                        char chPrev = text.charAt(offs - iOffs - 1);
                        if ("!@%^&*()-=+[]{};:'\",.<>/?".indexOf(ch) >= 0 || "!@%^&*()-=+[]{};:'\",.<>/?".indexOf(chPrev) >= 0 || Character.isWhitespace(chPrev) || ch == '\n') {
                            while (offs - iOffs < len && Character.isWhitespace(ch) && ch != '\n' && "!@%^&*()-=+[]{};:'\",.<>/?".indexOf(chPrev) < 0) {
                                ch = text.charAt(++offs - iOffs);
                            }
                            if (ch != '\n' || !Character.isWhitespace(text.charAt(offs - iOffs - 1))) break;
                            continue;
                        }
                        if (Character.isWhitespace(chPrev) || !Character.isWhitespace(ch)) continue;
                        int offs0 = offs;
                        while (offs - iOffs < len - 1 && ch != '\n' && Character.isWhitespace(ch)) {
                            ch = text.charAt(++offs - iOffs);
                            chPrev = text.charAt(offs - iOffs - 1);
                        }
                        offs = offs0;
                        if (ch != '\n') continue;
                        break;
                    }
                    if (this._select) {
                        target.moveCaretPosition(offs);
                    } else {
                        target.setCaretPosition(offs);
                    }
                }
                catch (BadLocationException ble) {
                    throw new UnexpectedException(ble);
                }
            }
        }
    }

    static class PreviousWordAction
    extends TextAction {
        private boolean _select;

        PreviousWordAction(String nm, boolean b) {
            super(nm);
            this._select = b;
        }

        public void actionPerformed(ActionEvent e) {
            AbstractDJPane target = (AbstractDJPane)this.getTextComponent(e);
            if (target != null) {
                try {
                    int offs = target.getCaretPosition();
                    String text = target.getDocument().getText(0, offs);
                    while (offs > 0 && --offs != 0) {
                        char ch = text.charAt(offs);
                        char chPrev = text.charAt(offs - 1);
                        if (Character.isWhitespace(ch) && Character.isWhitespace(chPrev) && ch != '\n') continue;
                        if ("!@%^&*()-=+[]{};:'\",.<>/?".indexOf(ch) >= 0 || "!@%^&*()-=+[]{};:'\",.<>/?".indexOf(chPrev) >= 0 || offs >= 2 && Character.isWhitespace(chPrev) && !Character.isWhitespace(text.charAt(offs - 2)) && ch != '\n' || Character.isWhitespace(chPrev) && !Character.isWhitespace(ch) || !Character.isWhitespace(chPrev) && ch == '\n') break;
                        if (!Character.isWhitespace(chPrev) || ch != '\n') continue;
                        while (Character.isWhitespace(chPrev) && offs > 0) {
                            ch = text.charAt(--offs);
                            chPrev = text.charAt(offs - 1);
                        }
                        break block2;
                    }
                    if (this._select) {
                        target.moveCaretPosition(offs);
                    } else {
                        target.setCaretPosition(offs);
                    }
                }
                catch (BadLocationException ble) {
                    throw new UnexpectedException(ble);
                }
            }
        }
    }

    static class EndWordAction
    extends TextAction {
        private boolean _select;

        EndWordAction(String nm, boolean b) {
            super(nm);
            this._select = b;
        }

        public void actionPerformed(ActionEvent e) {
            AbstractDJPane target = (AbstractDJPane)this.getTextComponent(e);
            if (target != null) {
                try {
                    char ch;
                    int offs;
                    int iOffs = offs = target.getCaretPosition();
                    String text = target.getDocument().getText(iOffs, target.getDocument().getLength() - iOffs);
                    while (offs - iOffs < text.length() - 1 && "!@%^&*()-=+[]{};:'\",.<>/?".indexOf(ch = text.charAt(++offs - iOffs)) < 0 && !Character.isWhitespace(ch)) {
                    }
                    if (this._select) {
                        target.moveCaretPosition(offs);
                    } else {
                        target.setCaretPosition(offs);
                    }
                }
                catch (BadLocationException ble) {
                    throw new UnexpectedException(ble);
                }
            }
        }
    }

    static class BeginWordAction
    extends TextAction {
        private boolean _select;

        BeginWordAction(String nm, boolean b) {
            super(nm);
            this._select = b;
        }

        public void actionPerformed(ActionEvent e) {
            AbstractDJPane target = (AbstractDJPane)this.getTextComponent(e);
            if (target != null) {
                try {
                    char chPrev;
                    int offs = target.getCaretPosition();
                    String text = target.getDocument().getText(0, offs);
                    while (offs > 0 && "!@%^&*()-=+[]{};:'\",.<>/?".indexOf(chPrev = text.charAt(offs - 1)) < 0 && !Character.isWhitespace(chPrev) && --offs != 0) {
                        char ch = text.charAt(offs);
                        chPrev = text.charAt(offs - 1);
                        if ("!@%^&*()-=+[]{};:'\",.<>/?".indexOf(ch) < 0 && "!@%^&*()-=+[]{};:'\",.<>/?".indexOf(chPrev) < 0 && !Character.isWhitespace(ch) && !Character.isWhitespace(chPrev)) continue;
                        break;
                    }
                    if (this._select) {
                        target.moveCaretPosition(offs);
                    } else {
                        target.setCaretPosition(offs);
                    }
                }
                catch (BadLocationException ble) {
                    throw new UnexpectedException(ble);
                }
            }
        }
    }
}

