/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.compiler.CompilerOptions;
import edu.rice.cs.drjava.model.compiler.JavacCompiler;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.io.FilePredicate;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.ArgumentTokenizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class MintCompiler
extends JavacCompiler {
    private final boolean _filterExe;
    private File _tempJUnit = null;
    private final String PREFIX = "drjava-junit";
    private final String SUFFIX = ".jar";
    String ownName = "mint";
    PrintWriter out = new PrintWriter(System.err, true);
    boolean fatalErrors;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private Options options = null;
    public ListBuffer<File> filenames = null;
    public ListBuffer<String> classnames = null;
    private JavaFileManager fileManager;
    private static final String javacBundleName = "com.sun.tools.javac.resources.javac";
    private static JavacMessages messages;

    public MintCompiler(JavaVersion.FullVersion version, String location, java.util.List<? extends File> defaultBootClassPath) {
        super(version, location, defaultBootClassPath);
        boolean bl = this._filterExe = version.compareTo(JavaVersion.parseFullVersion("1.6.0_04")) >= 0;
        if (this._filterExe) {
            block6: {
                try {
                    InputStream is = MintCompiler.class.getResourceAsStream("/junit.jar");
                    if (is != null) {
                        this._tempJUnit = IOUtil.createAndMarkTempFile("drjava-junit", ".jar");
                        FileOutputStream fos = new FileOutputStream(this._tempJUnit);
                        int size = IOUtil.copyInputStream(is, fos);
                    } else if (this._tempJUnit != null) {
                        this._tempJUnit.delete();
                        this._tempJUnit = null;
                    }
                }
                catch (IOException ioe) {
                    if (this._tempJUnit == null) break block6;
                    this._tempJUnit.delete();
                    this._tempJUnit = null;
                }
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File[] toDelete;
                        File temp = File.createTempFile("drjava-junit", ".jar");
                        IOUtil.attemptDelete(temp);
                        for (File f : toDelete = temp.getParentFile().listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                if (!name.startsWith("drjava-junit") || !name.endsWith(".jar")) {
                                    return false;
                                }
                                String rest = name.substring("drjava-junit".length(), name.length() - ".jar".length());
                                try {
                                    Integer i = new Integer(rest);
                                    return true;
                                }
                                catch (NumberFormatException e) {
                                    return false;
                                }
                            }
                        })) {
                            f.delete();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }));
        }
    }

    @Override
    public String getName() {
        return "Mint " + this._version.versionString();
    }

    @Override
    public java.util.List<File> additionalBootClassPathForInteractions() {
        return Arrays.asList(new File(this._location));
    }

    @Override
    public String transformCommands(String interactionsString) {
        if (interactionsString.startsWith("mint ") || interactionsString.startsWith("java ")) {
            interactionsString = MintCompiler._transformMintCommand(interactionsString);
        }
        return interactionsString;
    }

    protected static String _transformMintCommand(String s) {
        String command = "edu.rice.cs.mint.runtime.Mint.execute(\"edu.rice.cs.drjava.interactions.class.path\", \"{0}\"{1});";
        if (s.endsWith(";")) {
            s = MintCompiler._deleteSemiColon(s);
        }
        java.util.List<String> args = ArgumentTokenizer.tokenize(s, true);
        String classNameWithQuotes = args.get(1);
        String className = classNameWithQuotes.substring(1, classNameWithQuotes.length() - 1);
        StringBuilder argsString = new StringBuilder();
        for (int i = 2; i < args.size(); ++i) {
            argsString.append(",");
            argsString.append(args.get(i));
        }
        return MessageFormat.format("edu.rice.cs.mint.runtime.Mint.execute(\"edu.rice.cs.drjava.interactions.class.path\", \"{0}\"{1});", className, argsString.toString());
    }

    @Override
    public boolean isAvailable() {
        try {
            Class<?> diagnostic = Class.forName("javax.tools.Diagnostic");
            diagnostic.getMethod("getKind", new Class[0]);
            Class.forName("com.sun.tools.javac.main.JavaCompiler");
            Class.forName("edu.rice.cs.mint.comp.TransStaging");
            Class.forName("com.sun.source.tree.BracketExprTree");
            Class.forName("com.sun.source.tree.BracketStatTree");
            Class.forName("com.sun.source.tree.EscapeExprTree");
            Class.forName("com.sun.source.tree.EscapeStatTree");
            return true;
        }
        catch (Exception e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    @Override
    public java.util.List<? extends DJError> compile(java.util.List<? extends File> files, java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        DebugUtil.debug.logStart("compile()");
        DebugUtil.debug.logValues(new String[]{"this", "files", "classPath", "sourcePath", "destination", "bootClassPath", "sourceVersion", "showWarnings"}, this, files, classPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        LinkedList<? extends File> filteredClassPath = null;
        if (classPath != null) {
            filteredClassPath = new LinkedList<File>(classPath);
            if (this._filterExe) {
                FilePredicate filter = IOUtil.extensionFilePredicate("exe");
                Iterator i = filteredClassPath.iterator();
                while (i.hasNext()) {
                    if (!filter.accept((File)i.next())) continue;
                    i.remove();
                }
                if (this._tempJUnit != null) {
                    filteredClassPath.add(this._tempJUnit);
                }
            }
        }
        LinkedList errors = new LinkedList();
        Context context = this._createContext(filteredClassPath, sourcePath, destination, bootClassPath, sourceVersion, showWarnings);
        new CompilerErrorListener(context, errors);
        int result = this.compile(new String[0], ListBuffer.lb().appendArray(files.toArray(new File[0])).toList(), context);
        DebugUtil.debug.logEnd("compile()");
        return errors;
    }

    private Context _createContext(java.util.List<? extends File> classPath, java.util.List<? extends File> sourcePath, File destination, java.util.List<? extends File> bootClassPath, String sourceVersion, boolean showWarnings) {
        if (bootClassPath == null) {
            bootClassPath = this._defaultBootClassPath;
        }
        Context context = new Context();
        Options options = Options.instance(context);
        for (Map.Entry<String, String> e : CompilerOptions.getOptions(showWarnings).entrySet()) {
            options.put(e.getKey(), e.getValue());
        }
        options.put("-g", "");
        if (classPath != null) {
            options.put("-classpath", IOUtil.pathToString(classPath));
        }
        if (sourcePath != null) {
            options.put("-sourcepath", IOUtil.pathToString(sourcePath));
        }
        if (destination != null) {
            options.put("-d", destination.getPath());
        }
        if (bootClassPath != null) {
            options.put("-bootclasspath", IOUtil.pathToString(bootClassPath));
        }
        if (sourceVersion != null) {
            options.put("-source", sourceVersion);
        }
        if (!showWarnings) {
            options.put("-nowarn", "");
        }
        return context;
    }

    void error(String key, Object ... args) {
        if (this.fatalErrors) {
            String msg = MintCompiler.getLocalizedString(key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.usage", this.ownName));
    }

    void warning(String key, Object ... args) {
        Log.printLines((PrintWriter)this.out, (String)(this.ownName + ": " + MintCompiler.getLocalizedString(key, args)));
    }

    public void setFatalErrors(boolean fatalErrors) {
        this.fatalErrors = fatalErrors;
    }

    public int compile(String[] args, List<File> files, Context context) {
        JavacFileManager.preRegister(context);
        int result = this.compile(args, files, context, List.<JavaFileObject>nil(), null);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(String[] args, List<File> files, Context context, List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        int n;
        if (this.options == null) {
            this.options = Options.instance(context);
        }
        this.filenames = new ListBuffer();
        this.classnames = new ListBuffer();
        JavaCompiler comp = null;
        try {
            boolean batchMode;
            boolean forceStdOut;
            if (args.length == 0 && files.isEmpty() && fileObjects.isEmpty()) {
                int n2 = 2;
                return n2;
            }
            if (files == null) {
                int n3 = 2;
                return n3;
            }
            if (files.isEmpty() && fileObjects.isEmpty() && this.classnames.isEmpty()) {
                this.error("err.no.source.files", new Object[0]);
                int n4 = 2;
                return n4;
            }
            boolean bl = forceStdOut = this.options.get("stdout") != null;
            if (forceStdOut) {
                this.out.flush();
                this.out = new PrintWriter(System.out, true);
            }
            context.put(Log.outKey, this.out);
            boolean bl2 = batchMode = this.options.get("nonBatchMode") == null && System.getProperty("nonBatchMode") == null;
            if (batchMode) {
                CacheFSInfo.preRegister(context);
            }
            this.fileManager = context.get(JavaFileManager.class);
            comp = JavaCompiler.instance(context);
            if (comp == null) {
                int n5 = 3;
                return n5;
            }
            Log log = Log.instance(context);
            if (!files.isEmpty()) {
                comp = JavaCompiler.instance(context);
                List<JavaFileObject> otherFiles = List.nil();
                JavacFileManager dfm = (JavacFileManager)this.fileManager;
                for (JavaFileObject javaFileObject : dfm.getJavaFileObjectsFromFiles(files)) {
                    otherFiles = otherFiles.prepend(javaFileObject);
                }
                for (JavaFileObject javaFileObject : otherFiles) {
                    fileObjects = fileObjects.prepend(javaFileObject);
                }
            }
            comp.compile(fileObjects, this.classnames.toList(), processors);
            if (log.expectDiagKeys != null) {
                if (log.expectDiagKeys.size() == 0) {
                    Log.printLines((PrintWriter)log.noticeWriter, (String)"all expected diagnostics found");
                    int n6 = 0;
                    return n6;
                }
                Log.printLines((PrintWriter)log.noticeWriter, (String)("expected diagnostic keys not found: " + log.expectDiagKeys));
                int n7 = 1;
                return n7;
            }
            if (comp.errorCount() != 0 || this.options.get("-Werror") != null && comp.warningCount() != 0) {
                int n8 = 1;
                return n8;
            }
        }
        catch (IOException ex) {
            this.ioMessage(ex);
            n = 3;
            return n;
        }
        catch (OutOfMemoryError ex) {
            this.resourceMessage(ex);
            n = 3;
            return n;
        }
        catch (StackOverflowError ex) {
            this.resourceMessage(ex);
            n = 3;
            return n;
        }
        catch (FatalError ex) {
            this.feMessage(ex);
            n = 3;
            return n;
        }
        catch (AnnotationProcessingError ex) {
            this.apMessage(ex);
            n = 3;
            return n;
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.get("dev") != null) {
                this.bugMessage(ex);
            }
            n = 4;
            return n;
        }
        finally {
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
        }
        return 0;
    }

    void bugMessage(Throwable ex) {
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.bug", JavaCompiler.version()));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        Log.printLines((PrintWriter)this.out, (String)ex.getMessage());
    }

    void ioMessage(Throwable ex) {
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void apMessage(AnnotationProcessingError ex) {
        Log.printLines((PrintWriter)this.out, (String)MintCompiler.getLocalizedString("msg.proc.annotation.uncaught.exception", new Object[0]));
        ex.getCause().printStackTrace();
    }

    public static String getLocalizedString(String key, Object ... args) {
        try {
            if (messages == null) {
                messages = new JavacMessages(javacBundleName);
            }
            return messages.getLocalizedString("javac." + key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static void useRawMessages(boolean enable) {
        messages = enable ? new JavacMessages(javacBundleName){

            @Override
            public String getLocalizedString(String key, Object ... args) {
                return key;
            }
        } : new JavacMessages(javacBundleName);
    }

    private static class CompilerErrorListener
    implements DiagnosticListener<JavaFileObject> {
        private java.util.List<? super DJError> _errors;

        public CompilerErrorListener(Context context, java.util.List<? super DJError> errors) {
            this._errors = errors;
            context.put(DiagnosticListener.class, this);
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> d) {
            Diagnostic.Kind dt = d.getKind();
            boolean isWarning = false;
            switch (dt) {
                case OTHER: {
                    return;
                }
                case NOTE: {
                    return;
                }
                case MANDATORY_WARNING: {
                    isWarning = true;
                    break;
                }
                case WARNING: {
                    isWarning = true;
                    break;
                }
                case ERROR: {
                    isWarning = false;
                }
            }
            if (d.getSource() != null) {
                this._errors.add(new DJError(new File(d.getSource().toUri().getPath()), (int)d.getLineNumber() - 1, (int)d.getColumnNumber() - 1, d.getMessage(null), isWarning));
            } else {
                this._errors.add(new DJError(d.getMessage(null), isWarning));
            }
        }
    }
}

