/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.JDKToolsLibrary;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.javadoc.DefaultJavadocModel;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.javadoc.NoJavadocAvailable;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SingletonIterable;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.reflect.PathClassLoader;
import edu.rice.cs.plt.reflect.PreemptingClassLoader;
import edu.rice.cs.plt.reflect.ReflectException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.reflect.ShadowingClassLoader;
import edu.rice.cs.util.FileOps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarJDKToolsLibrary
extends JDKToolsLibrary {
    private static final Iterable<String> TOOLS_PACKAGES = IterUtil.asIterable("com.sun.javadoc", "com.sun.jdi", "com.sun.tools", "sun.applet", "sun.rmi.rmic", "sun.tools", "com.sun.jarsigner", "com.sun.mirror", "sun.jvmstat", "com.sun.codemodel", "com.sun.istack.internal.tools", "com.sun.istack.internal.ws", "com.sun.source", "com.sun.xml.internal.dtdparser", "com.sun.xml.internal.rngom", "com.sun.xml.internal.xsom", "org.relaxng", "com.sun.tools.javac", "com.sun.tools.javac.tree", "com.sun.tools.javac.comp", "com.sun.tools.javac.main", "edu.rice.cs.mint", "edu.rice.cs.mint.comp", "edu.rice.cs.mint.runtime", "edu.rice.cs.mint.runtime.mspTree");
    private final File _location;
    private final List<File> _bootClassPath;

    private JarJDKToolsLibrary(File location, JavaVersion.FullVersion version, CompilerInterface compiler, Debugger debugger, JavadocModel javadoc, List<File> bootClassPath) {
        super(version, compiler, debugger, javadoc);
        this._location = location;
        this._bootClassPath = bootClassPath;
    }

    public File location() {
        return this._location;
    }

    public List<File> bootClassPath() {
        if (this._bootClassPath != null) {
            return new ArrayList<File>(this._bootClassPath);
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " at " + this._location + ", boot classpath: " + this.bootClassPath();
    }

    public static JarJDKToolsLibrary makeFromFile(File f, GlobalModel model) {
        return JarJDKToolsLibrary.makeFromFile(f, model, new ArrayList<File>());
    }

    public static JarJDKToolsLibrary makeFromFile(File f, GlobalModel model, List<File> additionalBootClassPath) {
        JavaVersion.FullVersion version = JarJDKToolsLibrary.guessVersion(f);
        CompilerInterface compiler = NoCompilerAvailable.ONLY;
        Debugger debugger = NoDebuggerAvailable.ONLY;
        JavadocModel javadoc = new NoJavadocAvailable(model);
        ArrayList<File> bootClassPath = null;
        if (JavaVersion.CURRENT.supports(version.majorVersion())) {
            ShadowingClassLoader loader = new ShadowingClassLoader(JarJDKToolsLibrary.class.getClassLoader(), true, TOOLS_PACKAGES, true);
            SingletonIterable<File> path = IterUtil.singleton(IOUtil.attemptAbsoluteFile(f));
            String compilerAdapter = JarJDKToolsLibrary.adapterForCompiler(version);
            if (compilerAdapter != null) {
                File[] jars;
                File jdkLibDir;
                File libDir = null;
                if (f.getName().equals("classes.jar")) {
                    libDir = f.getParentFile();
                } else if (f.getName().equals("tools.jar") && (jdkLibDir = f.getParentFile()) != null) {
                    File jreLibDir;
                    File jdkRoot = jdkLibDir.getParentFile();
                    if (jdkRoot != null && IOUtil.attemptExists(new File(jreLibDir = new File(jdkRoot, "jre/lib"), "rt.jar"))) {
                        libDir = jreLibDir;
                    }
                    if (libDir == null && IOUtil.attemptExists(new File(jdkLibDir, "rt.jar"))) {
                        libDir = jdkLibDir;
                    }
                }
                bootClassPath = new ArrayList<File>();
                if (libDir != null && (jars = IOUtil.attemptListFiles(libDir, IOUtil.extensionFilePredicate("jar"))) != null) {
                    bootClassPath.addAll(Arrays.asList(jars));
                }
                bootClassPath.addAll(additionalBootClassPath);
                if (bootClassPath.isEmpty()) {
                    bootClassPath = null;
                }
                try {
                    Class[] sig = new Class[]{JavaVersion.FullVersion.class, String.class, List.class};
                    Object[] args = new Object[]{version, f.toString(), bootClassPath};
                    CompilerInterface attempt = (CompilerInterface)ReflectUtil.loadLibraryAdapter((ClassLoader)loader, path, compilerAdapter, sig, args);
                    if (attempt.isAvailable()) {
                        compiler = attempt;
                    }
                }
                catch (ReflectException e) {
                }
                catch (LinkageError e) {
                    // empty catch block
                }
            }
            String debuggerAdapter = JarJDKToolsLibrary.adapterForDebugger(version);
            String debuggerPackage = "edu.rice.cs.drjava.model.debug.jpda";
            if (debuggerAdapter != null) {
                try {
                    Class[] sig = new Class[]{GlobalModel.class};
                    PreemptingClassLoader debugLoader = new PreemptingClassLoader((ClassLoader)new PathClassLoader((ClassLoader)loader, path), debuggerPackage);
                    Debugger attempt = (Debugger)ReflectUtil.loadObject((ClassLoader)debugLoader, debuggerAdapter, sig, new Object[]{model});
                    if (attempt.isAvailable()) {
                        debugger = attempt;
                    }
                }
                catch (ReflectException e) {
                }
                catch (LinkageError e) {
                    // empty catch block
                }
            }
            try {
                new PathClassLoader((ClassLoader)loader, path).loadClass("com.sun.tools.javadoc.Main");
                File bin = new File(f.getParentFile(), "../bin");
                if (!IOUtil.attemptIsDirectory(bin)) {
                    bin = new File(f.getParentFile(), "../Home/bin");
                }
                if (!IOUtil.attemptIsDirectory(bin)) {
                    bin = new File(System.getProperty("java.home", f.getParent()));
                }
                javadoc = new DefaultJavadocModel(model, bin, path);
            }
            catch (ClassNotFoundException e) {
            }
            catch (LinkageError e) {
                // empty catch block
            }
        }
        return new JarJDKToolsLibrary(f, version, compiler, debugger, javadoc, bootClassPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static JavaVersion.FullVersion guessVersion(File f) {
        JavaVersion.FullVersion result;
        block33: {
            JarFile jf;
            String vendor;
            String parsedVersion;
            block34: {
                block32: {
                    block31: {
                        String v;
                        result = null;
                        File current = IOUtil.attemptCanonicalFile(f);
                        parsedVersion = "";
                        vendor = "";
                        do {
                            String name = current.getName();
                            String path = current.getAbsolutePath();
                            if (path.startsWith("/System/Library/Frameworks/JavaVM.framework")) {
                                vendor = "apple";
                            } else if (path.toLowerCase().contains("openjdk")) {
                                vendor = "openjdk";
                            }
                            if (name.startsWith("jdk")) {
                                parsedVersion = name.substring(3);
                                result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor);
                                continue;
                            }
                            if (name.startsWith("j2sdk")) {
                                parsedVersion = name.substring(5);
                                result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor);
                                continue;
                            }
                            if (!name.matches("\\d+\\.\\d+\\.\\d+")) continue;
                            parsedVersion = name;
                            result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor);
                        } while ((current = current.getParentFile()) != null && result == null);
                        if (result != null && !result.majorVersion().equals((Object)JavaVersion.UNRECOGNIZED)) break block34;
                        jf = null;
                        jf = new JarFile(f);
                        Manifest mf = jf.getManifest();
                        if (mf == null || (v = mf.getMainAttributes().getValue("Created-By")) == null) break block31;
                        int space = v.indexOf(32);
                        if (space >= 0) {
                            v = v.substring(0, space);
                        }
                        parsedVersion = v;
                        result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor);
                    }
                    Object var10_11 = null;
                    try {
                        if (jf != null) {
                            jf.close();
                        }
                        break block32;
                    }
                    catch (IOException ioe2) {}
                    break block32;
                    {
                        catch (IOException ioe) {
                            result = null;
                            Object var10_12 = null;
                            try {
                                if (jf != null) {
                                    jf.close();
                                }
                                break block32;
                            }
                            catch (IOException ioe2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        try {
                            if (jf != null) {
                                jf.close();
                            }
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                if (result == null || result.majorVersion().equals((Object)JavaVersion.UNRECOGNIZED)) {
                    result = JavaVersion.CURRENT_FULL;
                    parsedVersion = result.versionString();
                }
            }
            if (result == null || result.vendor() == JavaVersion.VendorType.UNKNOWN && result.majorVersion().compareTo(JavaVersion.JAVA_6) >= 0 || f.getAbsolutePath().toLowerCase().contains("mint")) {
                jf = null;
                jf = new JarFile(f);
                vendor = jf.getJarEntry("edu/rice/cs/mint/comp/TransStaging.class") != null && jf.getJarEntry("com/sun/source/tree/BracketExprTree.class") != null && jf.getJarEntry("com/sun/source/tree/BracketStatTree.class") != null && jf.getJarEntry("com/sun/source/tree/EscapeExprTree.class") != null && jf.getJarEntry("com/sun/source/tree/EscapeStatTree.class") != null && jf.getJarEntry("com/sun/tools/javac/util/DefaultFileManager.class") == null ? "mint" : (jf.getJarEntry("com/sun/tools/javac/util/DefaultFileManager.class") == null ? "openjdk" : "sun");
                result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor);
                Object var13_18 = null;
                try {
                    if (jf != null) {
                        jf.close();
                    }
                    break block33;
                }
                catch (IOException ioe3) {}
                break block33;
                {
                    catch (IOException ioe) {
                        Object var13_19 = null;
                        try {
                            if (jf != null) {
                                jf.close();
                            }
                            break block33;
                        }
                        catch (IOException ioe3) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var13_20 = null;
                    try {
                        if (jf != null) {
                            jf.close();
                        }
                    }
                    catch (IOException ioe3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return result;
    }

    public static Iterable<JarJDKToolsLibrary> search(GlobalModel model) {
        String javaHome = System.getProperty("java.home");
        String envJavaHome = null;
        String programFiles = null;
        String systemDrive = null;
        if (JavaVersion.CURRENT.supports(JavaVersion.JAVA_5)) {
            envJavaHome = System.getenv("JAVA_HOME");
            programFiles = System.getenv("ProgramFiles");
            systemDrive = System.getenv("SystemDrive");
        }
        LinkedHashSet roots = new LinkedHashSet();
        if (javaHome != null) {
            JarJDKToolsLibrary.addIfDir(new File(javaHome), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, ".."), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, "../.."), roots);
        }
        if (envJavaHome != null) {
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome), roots);
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome, ".."), roots);
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome, "../.."), roots);
        }
        if (programFiles != null) {
            JarJDKToolsLibrary.addIfDir(new File(programFiles, "Java"), roots);
            JarJDKToolsLibrary.addIfDir(new File(programFiles), roots);
        }
        JarJDKToolsLibrary.addIfDir(new File("/C:/Program Files/Java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/C:/Program Files"), roots);
        if (systemDrive != null) {
            JarJDKToolsLibrary.addIfDir(new File(systemDrive, "Java"), roots);
            JarJDKToolsLibrary.addIfDir(new File(systemDrive), roots);
        }
        JarJDKToolsLibrary.addIfDir(new File("/C:/Java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/C:"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/System/Library/Frameworks/JavaVM.framework/Versions"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/j2se"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local/java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local/j2se"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm/java-6-sun"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm/java-1.5.0-sun"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm/java-6-openjdk"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/home/javaplt/java/Linux-i686"), roots);
        LinkedHashSet jars = new LinkedHashSet();
        Predicate<File> subdirFilter = LambdaUtil.or(IOUtil.regexCanonicalCaseFilePredicate("j2sdk.*"), IOUtil.regexCanonicalCaseFilePredicate("jdk.*"), LambdaUtil.or(IOUtil.regexCanonicalCaseFilePredicate("\\d+\\.\\d+\\.\\d+"), IOUtil.regexCanonicalCaseFilePredicate("java.*")));
        for (File root : roots) {
            for (File subdir : IOUtil.attemptListFilesAsIterable(root, subdirFilter)) {
                JarJDKToolsLibrary.addIfFile(new File(subdir, "lib/tools.jar"), jars);
                JarJDKToolsLibrary.addIfFile(new File(subdir, "Classes/classes.jar"), jars);
            }
        }
        JarJDKToolsLibrary.addIfFile(new File("/C:/Program Files/JavaMint/langtools/dist/lib/classes.jar"), jars);
        JarJDKToolsLibrary.addIfFile(new File("/C:/Program Files/JavaMint/langtools/dist/lib/tools.jar"), jars);
        JarJDKToolsLibrary.addIfFile(new File("/usr/local/soylatte/lib/classes.jar"), jars);
        JarJDKToolsLibrary.addIfFile(new File("/usr/local/soylatte/lib/tools.jar"), jars);
        JarJDKToolsLibrary.addIfFile(new File("/usr/local/JavaMint/langtools/dist/lib/classes.jar"), jars);
        JarJDKToolsLibrary.addIfFile(new File("/usr/local/JavaMint/langtools/dist/lib/tools.jar"), jars);
        try {
            String mint_home = System.getenv("MINT_HOME");
            if (mint_home != null) {
                JDKToolsLibrary.msg("MINT_HOME environment variable set to: " + mint_home);
                JarJDKToolsLibrary.addIfFile(new File(new File(mint_home), "langtools/dist/lib/classes.jar"), jars);
                JarJDKToolsLibrary.addIfFile(new File(new File(mint_home), "langtools/dist/lib/tools.jar"), jars);
            } else {
                JDKToolsLibrary.msg("MINT_HOME not set");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        JarJDKToolsLibrary.addIfFile(FileOps.getDrJavaFile(), jars);
        TreeMap<JavaVersion.FullVersion, AbstractIterable> results = new TreeMap<JavaVersion.FullVersion, AbstractIterable>();
        TreeMap mintResults = new TreeMap();
        for (File jar : jars) {
            JarJDKToolsLibrary lib = JarJDKToolsLibrary.makeFromFile(jar, model);
            if (!lib.isValid()) continue;
            JavaVersion.FullVersion v = lib.version();
            TreeMap<JavaVersion.FullVersion, AbstractIterable> mapToAddTo = results;
            if (v.vendor().equals((Object)JavaVersion.VendorType.MINT)) {
                mapToAddTo = mintResults;
            }
            if (mapToAddTo.containsKey(v)) {
                mapToAddTo.put(v, IterUtil.compose(lib, (Iterable)mapToAddTo.get(v)));
                continue;
            }
            mapToAddTo.put(v, IterUtil.singleton(lib));
        }
        SizedIterable<JarJDKToolsLibrary> collapsed = IterUtil.reverse(IterUtil.collapse(results.values()));
        SizedIterable<JarJDKToolsLibrary> mintCollapsed = IterUtil.reverse(IterUtil.collapse(mintResults.values()));
        TreeMap<JavaVersion.FullVersion, AbstractIterable> javaMintResults = new TreeMap<JavaVersion.FullVersion, AbstractIterable>();
        for (JarJDKToolsLibrary mintLib : mintCollapsed) {
            JarJDKToolsLibrary lib;
            JavaVersion.FullVersion javaVersion;
            JDKToolsLibrary.msg("mintLib: " + mintLib.version());
            JDKToolsLibrary.msg("\t" + mintLib.location());
            JavaVersion.FullVersion mintVersion = mintLib.version();
            JarJDKToolsLibrary found = null;
            for (JarJDKToolsLibrary javaLib : collapsed) {
                JDKToolsLibrary.msg("\texact? " + javaLib.version());
                javaVersion = javaLib.version();
                if (!javaVersion.majorVersion().equals((Object)mintVersion.majorVersion()) || javaVersion.maintenance() != mintVersion.maintenance() || javaVersion.update() != mintVersion.update() || javaVersion.release() != mintVersion.release()) continue;
                JDKToolsLibrary.msg("\t\tfound");
                found = javaLib;
                break;
            }
            if (found == null) {
                for (JarJDKToolsLibrary javaLib : collapsed) {
                    JDKToolsLibrary.msg("\tmajor? " + javaLib.version());
                    javaVersion = javaLib.version();
                    if (!javaVersion.majorVersion().equals((Object)mintVersion.majorVersion())) continue;
                    JDKToolsLibrary.msg("\t\tfound");
                    found = javaLib;
                    break;
                }
            }
            if (found == null || !(lib = JarJDKToolsLibrary.makeFromFile(mintLib.location(), model, found.bootClassPath())).isValid()) continue;
            JDKToolsLibrary.msg("\t==> " + lib.version());
            JavaVersion.FullVersion v = lib.version();
            if (javaMintResults.containsKey(v)) {
                javaMintResults.put(v, IterUtil.compose(lib, (Iterable)javaMintResults.get(v)));
                continue;
            }
            javaMintResults.put(v, IterUtil.singleton(lib));
        }
        JDKToolsLibrary.msg("Result:");
        ComposedIterable<JarJDKToolsLibrary> result = IterUtil.compose(collapsed, IterUtil.reverse(IterUtil.collapse(javaMintResults.values())));
        for (JarJDKToolsLibrary lib : result) {
            JDKToolsLibrary.msg("Found library: " + lib);
        }
        return result;
    }

    private static void addIfDir(File f, Set<? super File> set) {
        if (IOUtil.attemptIsDirectory(f = IOUtil.attemptCanonicalFile(f))) {
            set.add(f);
            JDKToolsLibrary.msg("Dir added:     " + f);
        } else {
            JDKToolsLibrary.msg("Dir not added: " + f);
        }
    }

    private static void addIfFile(File f, Set<? super File> set) {
        if (IOUtil.attemptIsFile(f = IOUtil.attemptCanonicalFile(f))) {
            set.add(f);
            JDKToolsLibrary.msg("File added:     " + f);
        } else {
            JDKToolsLibrary.msg("File not added: " + f);
        }
    }
}

