/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.FindResult;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.DocumentIterator;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindReplaceMachine {
    private static Log _log = new Log("FindReplace.txt", false);
    private OpenDefinitionsDocument _doc;
    private OpenDefinitionsDocument _firstDoc;
    private int _current;
    private MovingDocumentRegion _selectionRegion;
    private String _findWord;
    private String _replaceWord;
    private boolean _matchCase;
    private boolean _matchWholeWord;
    private boolean _searchAllDocuments;
    private boolean _searchSelectionOnly;
    private boolean _isForward;
    private boolean _ignoreCommentsAndStrings;
    private boolean _ignoreTestCases;
    private String _lastFindWord;
    private boolean _skipText = false;
    private DocumentIterator _docIterator;
    private SingleDisplayModel _model;
    private Component _frame;

    public FindReplaceMachine(SingleDisplayModel model, DocumentIterator docIterator, Component frame) {
        this._model = model;
        this._frame = frame;
        this._docIterator = docIterator;
        this._current = -1;
        this.setFindAnyOccurrence();
        this.setFindWord("");
        this.setReplaceWord("");
        this.setSearchBackwards(false);
        this.setMatchCase(true);
        this.setSearchAllDocuments(false);
        this.setSearchSelectionOnly(false);
        this.setIgnoreCommentsAndStrings(false);
        this.setIgnoreTestCases(false);
    }

    public void cleanUp() {
        this._docIterator = null;
        this.setFindWord("");
        this._doc = null;
    }

    public void positionChanged() {
        this._lastFindWord = null;
        this._skipText = false;
    }

    public void setLastFindWord() {
        this._lastFindWord = this._findWord;
    }

    public boolean isSearchBackwards() {
        return !this._isForward;
    }

    public void setSearchBackwards(boolean searchBackwards) {
        if (this._isForward == searchBackwards) {
            this._skipText = this.onMatch() && this._findWord.equals(this._lastFindWord);
        }
        this._isForward = !searchBackwards;
    }

    public void setMatchCase(boolean matchCase) {
        this._matchCase = matchCase;
    }

    public boolean getMatchCase() {
        return this._matchCase;
    }

    public void setMatchWholeWord() {
        this._matchWholeWord = true;
    }

    public boolean getMatchWholeWord() {
        return this._matchWholeWord;
    }

    public void setFindAnyOccurrence() {
        this._matchWholeWord = false;
    }

    public void setSearchAllDocuments(boolean searchAllDocuments) {
        this._searchAllDocuments = searchAllDocuments;
    }

    public void setSearchSelectionOnly(boolean searchSelectionOnly) {
        this._searchSelectionOnly = searchSelectionOnly;
    }

    public void setIgnoreCommentsAndStrings(boolean ignoreCommentsAndStrings) {
        this._ignoreCommentsAndStrings = ignoreCommentsAndStrings;
    }

    public boolean getIgnoreCommentsAndStrings() {
        return this._ignoreCommentsAndStrings;
    }

    public void setIgnoreTestCases(boolean ignoreTestCases) {
        this._ignoreTestCases = ignoreTestCases;
    }

    public boolean getIgnoreTestCases() {
        return this._ignoreTestCases;
    }

    public void setDocument(OpenDefinitionsDocument doc) {
        this._doc = doc;
    }

    public void setFirstDoc(OpenDefinitionsDocument firstDoc) {
        this._firstDoc = firstDoc;
    }

    public void setPosition(int pos) {
        this._current = pos;
    }

    public int getCurrentOffset() {
        return this._current;
    }

    public String getFindWord() {
        return this._findWord;
    }

    public String getReplaceWord() {
        return this._replaceWord;
    }

    public boolean getSearchAllDocuments() {
        return this._searchAllDocuments;
    }

    public boolean getSearchSelectionOnly() {
        return this._searchSelectionOnly;
    }

    public OpenDefinitionsDocument getDocument() {
        return this._doc;
    }

    public OpenDefinitionsDocument getFirstDoc() {
        return this._firstDoc;
    }

    public void setFindWord(String word) {
        this._findWord = StringOps.replace(word, StringOps.EOL, "\n");
    }

    public void setReplaceWord(String word) {
        this._replaceWord = StringOps.replace(word, StringOps.EOL, "\n");
    }

    public boolean onMatch() {
        String matchSpace;
        String findWord = this._findWord;
        if (this._current == -1) {
            return false;
        }
        int wordLen = findWord.length();
        int off = this._isForward ? this.getCurrentOffset() - wordLen : this.getCurrentOffset();
        if (off < 0) {
            return false;
        }
        try {
            if (off + wordLen > this._doc.getLength()) {
                return false;
            }
            matchSpace = this._doc.getText(off, wordLen);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        if (!this._matchCase) {
            matchSpace = matchSpace.toLowerCase();
            findWord = findWord.toLowerCase();
        }
        return matchSpace.equals(findWord);
    }

    public boolean replaceCurrent() {
        assert (EventQueue.isDispatchThread());
        if (!this.onMatch()) {
            return false;
        }
        try {
            int offset = this.getCurrentOffset();
            if (this._isForward) {
                offset -= this._findWord.length();
            }
            this._doc.remove(offset, this._findWord.length());
            this._doc.insertString(offset, this._replaceWord, null);
            if (this._isForward) {
                this.setPosition(offset + this._replaceWord.length());
            } else {
                this.setPosition(offset);
            }
            return true;
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    public void setSelection(MovingDocumentRegion s) {
        this._selectionRegion = s;
    }

    public int replaceAll() {
        return this.replaceAll(this._searchAllDocuments, this._searchSelectionOnly);
    }

    private int replaceAll(boolean searchAll, boolean searchSelectionOnly) {
        if (searchAll) {
            int count = 0;
            int n = this._docIterator.getDocumentCount();
            for (int i = 0; i < n; ++i) {
                count += this._replaceAllInCurrentDoc(false);
                this._doc = this._docIterator.getNextDocument(this._doc, this._frame);
                if (this._doc != null) continue;
                i = n;
            }
            this._model.getDocumentNavigator().repaint();
            return count;
        }
        if (searchSelectionOnly) {
            int count = 0;
            return count += this._replaceAllInCurrentDoc(searchSelectionOnly);
        }
        return this._replaceAllInCurrentDoc(false);
    }

    private int _replaceAllInCurrentDoc(boolean searchSelectionOnly) {
        assert (EventQueue.isDispatchThread());
        if (!searchSelectionOnly) {
            this._selectionRegion = new MovingDocumentRegion(this._doc, 0, this._doc.getLength(), this._doc._getLineStartPos(0), this._doc._getLineEndPos(this._doc.getLength()));
        }
        if (this._isForward) {
            this.setPosition(this._selectionRegion.getStartOffset());
        } else {
            this.setPosition(this._selectionRegion.getEndOffset());
        }
        int count = 0;
        FindResult fr = this.findNext(false);
        while (!fr.getWrapped() && fr.getFoundOffset() <= this._selectionRegion.getEndOffset()) {
            this.replaceCurrent();
            ++count;
            fr = this.findNext(false);
        }
        return count;
    }

    public int processAll(Runnable1<FindResult> findAction, MovingDocumentRegion region) {
        this._selectionRegion = region;
        return this.processAll(findAction, this._searchAllDocuments, this._searchSelectionOnly);
    }

    private int processAll(Runnable1<FindResult> findAction, boolean searchAll, boolean searchSelectionOnly) {
        assert (EventQueue.isDispatchThread());
        if (searchAll) {
            int count = 0;
            int n = this._docIterator.getDocumentCount();
            for (int i = 0; i < n; ++i) {
                count += this._processAllInCurrentDoc(findAction, false);
                this._doc = this._docIterator.getNextDocument(this._doc, this._frame);
                if (this._doc != null) continue;
                i = n;
            }
            this._model.getDocumentNavigator().repaint();
            return count;
        }
        if (searchSelectionOnly) {
            int count = 0;
            return count += this._processAllInCurrentDoc(findAction, searchSelectionOnly);
        }
        return this._processAllInCurrentDoc(findAction, false);
    }

    private int _processAllInCurrentDoc(Runnable1<FindResult> findAction, boolean searchSelectionOnly) {
        if (!searchSelectionOnly) {
            this._selectionRegion = new MovingDocumentRegion(this._doc, 0, this._doc.getLength(), this._doc._getLineStartPos(0), this._doc._getLineEndPos(this._doc.getLength()));
        }
        if (this._isForward) {
            this.setPosition(this._selectionRegion.getStartOffset());
        } else {
            this.setPosition(this._selectionRegion.getEndOffset());
        }
        int count = 0;
        FindResult fr = this.findNext(false);
        while (!fr.getWrapped() && fr.getFoundOffset() <= this._selectionRegion.getEndOffset()) {
            findAction.run(fr);
            ++count;
            fr = this.findNext(false);
        }
        return count;
    }

    public FindResult findNext() {
        return this.findNext(this._searchAllDocuments);
    }

    private FindResult findNext(boolean searchAll) {
        int len;
        int start;
        assert (EventQueue.isDispatchThread());
        if (this._skipText) {
            int wordLen = this._lastFindWord.length();
            if (this._isForward) {
                this.setPosition(this.getCurrentOffset() + wordLen);
            } else {
                this.setPosition(this.getCurrentOffset() - wordLen);
            }
            this.positionChanged();
        }
        int offset = this.getCurrentOffset();
        if (this._isForward) {
            start = offset;
            len = this._doc.getLength() - offset;
        } else {
            start = 0;
            len = offset;
        }
        FindResult fr = this._findNextInDoc(this._doc, start, len, searchAll);
        if (fr.getFoundOffset() >= 0 || !searchAll) {
            return fr;
        }
        return this._findNextInOtherDocs(this._doc, start, len);
    }

    private FindResult _findNextInDoc(OpenDefinitionsDocument doc, int start, int len, boolean searchAll) {
        FindResult fr = this._findNextInDocSegment(doc, start, len);
        if (fr.getFoundOffset() >= 0 || searchAll) {
            return fr;
        }
        return this._findWrapped(doc, start, len, false);
    }

    private FindResult _findWrapped(OpenDefinitionsDocument doc, int start, int len, boolean allWrapped) {
        int newLen;
        int newStart;
        int docLen = doc.getLength();
        if (docLen == 0) {
            return new FindResult(doc, -1, true, allWrapped);
        }
        int wordLen = this._findWord.length();
        assert (start >= 0 && start <= docLen && len >= 0 && len <= docLen && wordLen > 0);
        assert (this._isForward && start + len == docLen || !this._isForward && start == 0);
        int adjustment = wordLen - 1;
        if (this._isForward) {
            newStart = 0;
            newLen = start + adjustment;
            if (newLen > docLen) {
                newLen = docLen;
            }
        } else {
            newStart = len - adjustment;
            if (newStart < 0) {
                newStart = 0;
            }
            newLen = docLen - newStart;
        }
        return this._findNextInDocSegment(doc, newStart, newLen, true, allWrapped);
    }

    private FindResult _findNextInDocSegment(OpenDefinitionsDocument doc, int start, int len) {
        return this._findNextInDocSegment(doc, start, len, false, false);
    }

    private FindResult _findNextInDocSegment(OpenDefinitionsDocument doc, int start, int len, boolean wrapped, boolean allWrapped) {
        boolean inTestCase = false;
        for (String ext : OptionConstants.LANGUAGE_LEVEL_EXTENSIONS) {
            inTestCase |= doc.getFileName().endsWith("Test" + ext);
        }
        if (!this._ignoreTestCases || !inTestCase) {
            int docLen = doc.getLength();
            int wordLen = this._findWord.length();
            assert (start >= 0 && start <= docLen && len >= 0 && len <= docLen);
            if (len == 0 || docLen == 0) {
                return new FindResult(doc, -1, wrapped, allWrapped);
            }
            if (start + len > docLen) {
                len = docLen - start;
            }
            try {
                String findWord;
                String text = doc.getText(start, len);
                if (!this._matchCase) {
                    text = text.toLowerCase();
                    findWord = this._findWord.toLowerCase();
                } else {
                    findWord = this._findWord;
                }
                int foundOffset = this._isForward ? 0 : len;
                int rem = len;
                while (rem >= wordLen) {
                    int matchLocation;
                    int n = foundOffset = this._isForward ? text.indexOf(findWord, foundOffset) : text.lastIndexOf(findWord, foundOffset);
                    if (foundOffset < 0) break;
                    int foundLocation = start + foundOffset;
                    if (this._isForward) {
                        rem = len - (foundOffset += wordLen);
                        matchLocation = foundLocation + wordLen;
                    } else {
                        rem = foundOffset -= wordLen;
                        matchLocation = foundLocation;
                    }
                    assert (foundLocation > -1);
                    if (this._shouldIgnore(foundLocation, doc)) continue;
                    this.setPosition(matchLocation);
                    return new FindResult(doc, matchLocation, wrapped, allWrapped);
                }
            }
            catch (BadLocationException e) {
                throw new UnexpectedException(e);
            }
        }
        return new FindResult(doc, -1, wrapped, allWrapped);
    }

    private FindResult _findNextInOtherDocs(OpenDefinitionsDocument startDoc, int start, int len) {
        boolean allWrapped = false;
        OpenDefinitionsDocument openDefinitionsDocument = this._doc = this._isForward ? this._docIterator.getNextDocument(startDoc) : this._docIterator.getPrevDocument(startDoc);
        while (this._doc != startDoc) {
            FindResult fr;
            if (this._doc == this._firstDoc) {
                allWrapped = true;
            }
            boolean inTestCase = this._doc.getFileName().endsWith("Test.java");
            if (!(this._ignoreTestCases && inTestCase || (fr = this._findNextInDocSegment(this._doc, 0, this._doc.getLength(), false, allWrapped)).getFoundOffset() < 0)) {
                return fr;
            }
            this._doc = this._isForward ? this._docIterator.getNextDocument(this._doc) : this._docIterator.getPrevDocument(this._doc);
        }
        return this._findWrapped(startDoc, start, len, true);
    }

    private boolean wholeWordFoundAtCurrent(OpenDefinitionsDocument doc, int foundOffset) {
        char leftOfMatch = '\u0000';
        char rightOfMatch = '\u0000';
        int leftLoc = foundOffset - 1;
        int rightLoc = foundOffset + this._findWord.length();
        boolean leftOutOfBounds = false;
        boolean rightOutOfBounds = false;
        try {
            leftOfMatch = doc.getText(leftLoc, 1).charAt(0);
        }
        catch (BadLocationException e) {
            leftOutOfBounds = true;
        }
        catch (IndexOutOfBoundsException e) {
            leftOutOfBounds = true;
        }
        try {
            rightOfMatch = doc.getText(rightLoc, 1).charAt(0);
        }
        catch (BadLocationException e) {
            rightOutOfBounds = true;
        }
        catch (IndexOutOfBoundsException e) {
            rightOutOfBounds = true;
        }
        if (!leftOutOfBounds && !rightOutOfBounds) {
            return this.isDelimiter(rightOfMatch) && this.isDelimiter(leftOfMatch);
        }
        if (!leftOutOfBounds) {
            return this.isDelimiter(leftOfMatch);
        }
        if (!rightOutOfBounds) {
            return this.isDelimiter(rightOfMatch);
        }
        return true;
    }

    private boolean isDelimiter(char ch) {
        return !Character.isLetterOrDigit(ch) && ch != '_';
    }

    private boolean _shouldIgnore(int foundOffset, OpenDefinitionsDocument odd) {
        assert (EventQueue.isDispatchThread());
        return this._matchWholeWord && !this.wholeWordFoundAtCurrent(odd, foundOffset) || this._ignoreCommentsAndStrings && odd.isShadowed(foundOffset);
    }
}

