/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.threadCheck;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.instrumentors.threadCheck.AAddThreadCheckStrategy;
import edu.rice.cs.cunit.instrumentors.threadCheck.AThreadCheckStrategy;
import edu.rice.cs.cunit.instrumentors.threadCheck.PredicateAnnotationRecord;
import edu.rice.cs.cunit.instrumentors.threadCheck.ThreadCheckAnnotationRecord;
import edu.rice.cs.cunit.instrumentors.threadCheck.ThreadCheckDefinitionRecord;
import edu.rice.cs.cunit.threadCheck.OnlyRunBy;
import edu.rice.cs.cunit.threadCheck.ThreadCheckException;
import edu.rice.cs.cunit.util.Debug;
import edu.rice.cs.cunit.util.ILambda;
import edu.rice.cs.cunit.util.IPredicate;
import edu.rice.cs.cunit.util.XMLConfig;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLAnnotUtils {
    private static final String CD_PREFIX_NOSLASH = "concutest/threadcheck:def/".substring(0, "concutest/threadcheck:def/".length() - 1);

    public static ConcurrentyDefinitions convertXMLToConcDefs(XMLConfig xc) {
        return XMLAnnotUtils.joinXMLConcDefs(xc, new ConcurrentyDefinitions());
    }

    public static XMLConfig joinXMLConcDefs(XMLConfig concDef1, XMLConfig concDef2) {
        ConcurrentyDefinitions defsAccum = XMLAnnotUtils.convertXMLToConcDefs(concDef1);
        defsAccum = XMLAnnotUtils.joinXMLConcDefs(concDef2, defsAccum);
        return XMLAnnotUtils.convertConcDefsToConcDefBasedXML(defsAccum);
    }

    public static XMLConfig convertConcDefsToConcDefBasedXML(ConcurrentyDefinitions defsAccum) {
        XMLConfig xc = XMLAnnotUtils.createEmptyXMLConcDefs();
        for (ThreadCheckDefinitionRecord cd : defsAccum.values()) {
            Node defNode = xc.createNode(CD_PREFIX_NOSLASH, null, false);
            Node invNode = xc.createNode("invariant", defNode);
            AnnotationToXML.processAnnotations(xc, invNode, cd.getInvariant());
            if (cd.classNames.size() > 0) {
                for (String s : cd.classNames) {
                    Node classNode = xc.createNode("class", defNode, false);
                    xc.set(".name", s, classNode, true);
                }
            }
            if (cd.methodClassAndSigs.size() <= 0) continue;
            for (String s : cd.methodClassAndSigs.keySet()) {
                int sepPos = s.indexOf("::");
                if (sepPos < 0) {
                    throw new ThreadCheckException("Method description of <class>::<signature> was incorrect");
                }
                String className = s.substring(0, sepPos);
                String sig = s.substring(sepPos + "::".length());
                Node methodNode = xc.createNode("method", defNode, false);
                xc.set(".name", className, methodNode, true);
                xc.set(".sig", sig, methodNode, true);
                if (!cd.methodClassAndSigs.get(s).booleanValue()) continue;
                xc.set(".suppress", "true", methodNode, true);
            }
        }
        return xc;
    }

    public static XMLConfig convertConcDefsToClassBasedXML(ConcurrentyDefinitions defsAccum) {
        XMLConfig xc = new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<concutest>\n  <threadcheck>  </threadcheck></concutest>\n"));
        List<Node> roots = xc.getNodes("concutest/threadcheck/");
        if (roots.size() != 1) {
            throw new ThreadCheckException("The output XML file must contain exactly one node with the path concutest/threadcheck/, found " + roots.size());
        }
        Node tcRoot = roots.get(0);
        for (ThreadCheckDefinitionRecord cd : defsAccum.values()) {
            if (cd.classNames.size() > 0) {
                for (String s : cd.classNames) {
                    String classPath = s.replace('.', '/').replace('$', '-') + "/class";
                    List<Node> cNodes = xc.getNodes(classPath, tcRoot);
                    if (cNodes.size() > 1) {
                        throw new ThreadCheckException("The output XML file must contain exactly one node with the path concutest/threadcheck/" + classPath + ", found " + cNodes.size());
                    }
                    Node classNode = cNodes.size() == 1 ? cNodes.get(0) : xc.createNode(classPath, tcRoot);
                    AnnotationToXML.processAnnotations(xc, classNode, cd.getInvariant());
                }
            }
            if (cd.methodClassAndSigs.size() <= 0) continue;
            for (String s : cd.methodClassAndSigs.keySet()) {
                int sepPos = s.indexOf("::");
                if (sepPos < 0) {
                    throw new ThreadCheckException("Method description of <class>::<signature> was incorrect");
                }
                String classPath = s.substring(0, sepPos).replace('.', '/').replace('$', '-') + "/class";
                String sig = s.substring(sepPos + "::".length());
                List<Node> cNodes = xc.getNodes(classPath, tcRoot);
                if (cNodes.size() > 1) {
                    throw new ThreadCheckException("The output XML file must contain exactly one node with the path concutest/threadcheck/" + classPath + ", found " + cNodes.size());
                }
                Node classNode = cNodes.size() == 1 ? cNodes.get(0) : xc.createNode(classPath, tcRoot);
                List<Node> mNodes = xc.getNodes("method", classNode);
                Node methodNode = null;
                for (Node mn : mNodes) {
                    try {
                        List<String> sigAttrs = xc.getMultiple(".sig", mn);
                        if (sigAttrs.size() != 1) {
                            throw new ThreadCheckException("The output XML file must contain a sig attribute for the path concutest/threadcheck/" + classPath + "/method");
                        }
                        if (!sig.equals(sigAttrs.get(0))) continue;
                        methodNode = mn;
                        break;
                    }
                    catch (XMLConfig.XMLConfigException e) {
                        if (e.equals(new XMLConfig.XMLConfigException("Node method has no attribute with name sig"))) continue;
                        throw new ThreadCheckException("The output XML file must contain a sig attribute for the path concutest/threadcheck/" + classPath + "/method");
                    }
                }
                if (methodNode == null) {
                    methodNode = xc.createNode("method", classNode, false);
                    xc.set(".sig", sig, methodNode, true);
                    if (cd.methodClassAndSigs.get(s).booleanValue()) {
                        xc.set(".suppress", "true", methodNode, true);
                    }
                }
                AnnotationToXML.processAnnotations(xc, methodNode, cd.getInvariant());
            }
        }
        return xc;
    }

    public static ConcurrentyDefinitions joinXMLConcDefs(XMLConfig xc, ConcurrentyDefinitions defsAccum) {
        AAddThreadCheckStrategy dummy = XMLAnnotUtils.createDummy();
        List<ThreadCheckDefinitionRecord> cds = dummy.extractXMLConcDef(xc);
        for (ThreadCheckDefinitionRecord cd : cds) {
            ThreadCheckDefinitionRecord old = (ThreadCheckDefinitionRecord)defsAccum.get(cd.getInvariant());
            if (old != null) {
                for (String s : old.classNames) {
                    cd.addClass(s);
                }
                for (String s : old.methodClassAndSigs.keySet()) {
                    int sepPos = s.indexOf("::");
                    if (sepPos < 0) {
                        throw new ThreadCheckException("Method description of <class>::<signature> was incorrect");
                    }
                    cd.addMethod(s.substring(0, sepPos), s.substring(sepPos + "::".length()), old.methodClassAndSigs.get(s));
                }
            }
            defsAccum.put(cd.getInvariant(), cd);
        }
        return defsAccum;
    }

    public static XMLConfig convertXMLToClassBasedXML(XMLConfig xc) {
        ConcurrentyDefinitions defsAccum = XMLAnnotUtils.convertXMLToConcDefs(xc);
        return XMLAnnotUtils.convertConcDefsToClassBasedXML(defsAccum);
    }

    public static XMLConfig convertXMLToConcDefXML(XMLConfig xc) {
        ConcurrentyDefinitions defsAccum = XMLAnnotUtils.convertXMLToConcDefs(xc);
        return XMLAnnotUtils.convertConcDefsToConcDefBasedXML(defsAccum);
    }

    public static AAddThreadCheckStrategy createDummy() {
        boolean debug = Debug.out.isDebug();
        Debug.out.setDebug(false);
        ArrayList<String> parameters = new ArrayList<String>();
        AThreadCheckStrategy.SharedData sharedData = new AThreadCheckStrategy.SharedData(parameters);
        Debug.out.setDebug(debug);
        return new AAddThreadCheckStrategy(sharedData, new AAddThreadCheckStrategy.SharedAddData(parameters, sharedData)){

            public void instrument(ClassFile cf) {
            }

            public void done() {
            }
        };
    }

    public static XMLConfig createEmptyXMLConcDefs() {
        return new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<concutest>\n</concutest>\n"));
    }

    public static XMLConfig createEmptyXMLAnnotaations() {
        return new XMLConfig(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<concutest>\n  <threadcheck>  </threadcheck></concutest>\n"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassBased {
        private static final String PATH_PREFIX = "concutest/threadcheck/".substring(0, "concutest/threadcheck/".length() - 1);

        public static void processNode(XMLConfig xc, ILambda.Ternary<Object, String, ThreadCheckAnnotationRecord, HashMap<String, ThreadCheckAnnotationRecord>> classLambda, IPredicate<String> processClassPred, List<ThreadCheckException> exList) {
            List<Node> nodes = xc.getNodes(PATH_PREFIX + "/*");
            if (nodes != null) {
                for (Node n : nodes) {
                    ClassBased.processNode(xc, classLambda, n, "", processClassPred, exList);
                }
            }
        }

        private static void processNode(XMLConfig xc, ILambda.Ternary<Object, String, ThreadCheckAnnotationRecord, HashMap<String, ThreadCheckAnnotationRecord>> classLambda, Node n, String path, IPredicate<String> processClassPred, List<ThreadCheckException> exList) {
            AAddThreadCheckStrategy dummy = XMLAnnotUtils.createDummy();
            String className = (path + "/" + n.getNodeName()).replace('/', '.').replace('-', '$').substring(1);
            List<Node> allNodes = xc.getNodes(PATH_PREFIX + path + "/" + n.getNodeName() + "/*");
            for (Node an : allNodes) {
                if (!an.getNodeName().equals("class")) {
                    ClassBased.processNode(xc, classLambda, an, path + "/" + n.getNodeName(), processClassPred, exList);
                    continue;
                }
                List<Node> classNodes = xc.getNodes(PATH_PREFIX + path + "/" + n.getNodeName() + "/class");
                if (classNodes.size() > 1) {
                    exList.add(new ThreadCheckException("Improper format, " + path + "/" + n.getNodeName() + " has multiple <class> tags"));
                    continue;
                }
                for (Node cn : classNodes) {
                    ClassBased.processClassNode(xc, classLambda, cn, path + "/" + n.getNodeName(), className, processClassPred, exList, dummy);
                }
            }
        }

        private static void processClassNode(XMLConfig xc, ILambda.Ternary<Object, String, ThreadCheckAnnotationRecord, HashMap<String, ThreadCheckAnnotationRecord>> classLambda, Node n, String path, String className, IPredicate<String> processClassPred, List<ThreadCheckException> exList, AAddThreadCheckStrategy dummy) {
            if (!((Boolean)processClassPred.apply(className)).booleanValue()) {
                return;
            }
            ThreadCheckAnnotationRecord classAnnots = dummy.extractXMLAnnotations(n);
            HashMap<String, ThreadCheckAnnotationRecord> methodAnnots = new HashMap<String, ThreadCheckAnnotationRecord>();
            List<Node> methodNodes = xc.getNodes(PATH_PREFIX + path + "/" + n.getNodeName() + "/method");
            for (Node mn : methodNodes) {
                Node sigAttr = mn.getAttributes().getNamedItem("sig");
                if (sigAttr == null) {
                    exList.add(new ThreadCheckException("Improper format, " + path + "/" + n.getNodeName() + "/class has a <method> tag without sig attribute"));
                    continue;
                }
                String sig = sigAttr.getNodeValue();
                ThreadCheckAnnotationRecord tcar = dummy.extractXMLAnnotations(mn);
                Node suppressAttr = mn.getAttributes().getNamedItem("suppress");
                if (suppressAttr != null && suppressAttr.getNodeValue().equalsIgnoreCase("true")) {
                    tcar.suppressSubtypingWarning = true;
                }
                methodAnnots.put(sig, tcar);
            }
            if (!classAnnots.empty() || methodAnnots.size() > 0) {
                classLambda.apply(className, classAnnots, methodAnnots);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConcurrentyDefinitions
    extends HashMap<ThreadCheckAnnotationRecord, ThreadCheckDefinitionRecord> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationToXML {
        public static void processAnnotations(XMLConfig xc, Node root, ThreadCheckAnnotationRecord tcAR) {
            Node node;
            for (String s : tcAR.denyThreadNames) {
                node = xc.set("name.type", "not", root, false);
                xc.set(".value", s, node, false);
            }
            for (String s : tcAR.denyThreadGroups) {
                node = xc.set("group.type", "not", root, false);
                xc.set(".value", s, node, false);
            }
            for (Long id : tcAR.denyThreadIds) {
                node = xc.set("id.type", "not", root, false);
                xc.set(".value", String.valueOf(id), node, false);
            }
            for (String s : tcAR.allowThreadNames) {
                node = xc.set("name.type", "only", root, false);
                xc.set(".value", s, node, false);
            }
            for (String s : tcAR.allowThreadGroups) {
                node = xc.set("group.type", "only", root, false);
                xc.set(".value", s, node, false);
            }
            for (Long id : tcAR.allowThreadIds) {
                node = xc.set("id.type", "only", root, false);
                xc.set(".value", String.valueOf(id), node, false);
            }
            if (tcAR.allowEventThread != OnlyRunBy.EVENT_THREAD.NO) {
                xc.set("eventThread.type", tcAR.allowEventThread.toString().toLowerCase(), root, false);
            }
            HashMap<String, ArrayList<PredicateAnnotationRecord>> rootSets = new HashMap<String, ArrayList<PredicateAnnotationRecord>>();
            rootSets.put("", tcAR.predicateAnnotations);
            AnnotationToXML.processPredicateAnnotations(xc, root, rootSets);
        }

        private static void processPredicateAnnotations(XMLConfig xc, Node node, HashMap<String, ArrayList<PredicateAnnotationRecord>> pars) {
            for (String key : pars.keySet()) {
                for (PredicateAnnotationRecord par : pars.get(key)) {
                    Node predNode;
                    if (par.predicateClass != null) {
                        predNode = xc.set("predicate.type", par.annotation.getType(), node, false);
                        Element membersNode = predNode.getOwnerDocument().createElement("values");
                        predNode.appendChild(membersNode);
                        AnnotationToXML.processPredicateMembers(xc, membersNode, par.paramNames, par.paramTypes, par.valueList);
                    } else {
                        predNode = xc.set("combine.type", par.annotation.getType(), node, false);
                        Node predicatesNode = xc.set("values.mode", par.combineMode.toString(), predNode, false);
                        AnnotationToXML.processPredicateAnnotations(xc, predicatesNode, par.combinedPredicates);
                    }
                    if (par.passArguments) {
                        xc.set(".arguments", "true", predNode, true);
                    }
                    AnnotationToXML.processAnnotation(xc, predNode, par.annotation.getPairs(), par.paramTypes);
                }
            }
        }

        private static void processAnnotation(final XMLConfig xc, Node node, List<AAnnotationsAttributeInfo.Annotation.NameValuePair> nvpList, final HashMap<String, String> paramTypes) {
            for (final AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : nvpList) {
                Node argNode = xc.set("arg.name", nvp.getName().toString(), node, false);
                nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<Object, Node>(){

                    @Override
                    public Object defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Node argNode) {
                        xc.set(".type", String.valueOf(host.getTag()), argNode, false);
                        xc.set(".value", host.toString(), argNode, false);
                        return null;
                    }

                    @Override
                    public Object arrayMemberCase(AAnnotationsAttributeInfo.Annotation.ArrayMemberValue host, Node argNode) {
                        xc.set(".type", String.valueOf(host.getTag()), argNode, false);
                        if (paramTypes != null && paramTypes.size() > 0) {
                            String type = (String)paramTypes.get(nvp.getName().toString());
                            xc.set(".desc", type, argNode, false);
                        }
                        xc.set(".value", String.valueOf(host.getEntries().length), argNode, false);
                        for (AAnnotationsAttributeInfo.Annotation.AMemberValue mv : host.getEntries()) {
                            Element elNode = argNode.getOwnerDocument().createElement("element");
                            argNode.appendChild(elNode);
                            mv.execute(this, elNode);
                        }
                        return null;
                    }

                    @Override
                    public Object annotationMemberCase(AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue host, Node argNode) {
                        xc.set(".type", String.valueOf(host.getTag()), argNode, false);
                        xc.set(".value", String.valueOf(host.getAnnotation().getType()), argNode, false);
                        AnnotationToXML.processAnnotation(xc, argNode, host.getAnnotation().getPairs(), null);
                        return null;
                    }
                }, argNode);
            }
        }

        private static void processPredicateMembers(final XMLConfig xc, Node node, List<String> paramNames, final HashMap<String, String> paramTypes, List<AAnnotationsAttributeInfo.Annotation.AMemberValue> valueList) {
            for (int i = 0; i < paramNames.size(); ++i) {
                final String name = paramNames.get(i);
                AAnnotationsAttributeInfo.Annotation.AMemberValue value = valueList.get(i);
                Node argNode = xc.set("arg.name", name, node, false);
                value.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<Object, Node>(){

                    @Override
                    public Object defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Node argNode) {
                        xc.set(".type", String.valueOf(host.getTag()), argNode, false);
                        xc.set(".value", host.toString(), argNode, false);
                        return null;
                    }

                    @Override
                    public Object arrayMemberCase(AAnnotationsAttributeInfo.Annotation.ArrayMemberValue host, Node argNode) {
                        xc.set(".type", String.valueOf(host.getTag()), argNode, false);
                        if (paramTypes != null && paramTypes.size() > 0) {
                            String type = (String)paramTypes.get(name);
                            xc.set(".desc", type, argNode, false);
                        }
                        xc.set(".value", String.valueOf(host.getEntries().length), argNode, false);
                        for (AAnnotationsAttributeInfo.Annotation.AMemberValue mv : host.getEntries()) {
                            Element elNode = argNode.getOwnerDocument().createElement("element");
                            argNode.appendChild(elNode);
                            mv.execute(this, elNode);
                        }
                        return null;
                    }

                    @Override
                    public Object annotationMemberCase(AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue host, Node argNode) {
                        xc.set(".type", String.valueOf(host.getTag()), argNode, false);
                        xc.set(".value", String.valueOf(host.getAnnotation().getType()), argNode, false);
                        AnnotationToXML.processAnnotation(xc, argNode, host.getAnnotation().getPairs(), null);
                        return null;
                    }
                }, argNode);
            }
        }
    }
}

