/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.record.graph;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import edu.rice.cs.cunit.record.IThreadInfo;
import edu.rice.cs.cunit.record.graph.LockInfo;
import edu.rice.cs.cunit.record.graph.StackFrameInfo;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadInfo
implements IThreadInfo {
    long _threadID;
    int _status;
    String _name;
    Long _contendedLockId;
    Set<Long> _ownedLockIds;
    LinkedList<StackFrameInfo> _stackFrame;

    public ThreadInfo(long uniqueId, int status, String name, Long contendedLockId, Set<Long> ownedLockIds, List<StackFrameInfo> stackFrame) {
        this._threadID = uniqueId;
        this._status = status;
        this._name = name;
        this._contendedLockId = contendedLockId;
        this._ownedLockIds = new HashSet<Long>(ownedLockIds);
        this._stackFrame = new LinkedList<StackFrameInfo>(stackFrame);
    }

    public ThreadInfo(ThreadReference tRef) {
        if (null == tRef) {
            this._threadID = 0L;
            this._status = -1;
            this._name = "null";
            this._contendedLockId = null;
            this._ownedLockIds = new HashSet<Long>();
            this._stackFrame = new LinkedList();
        } else {
            this._threadID = tRef.uniqueID();
            try {
                this._status = tRef.status();
            }
            catch (Exception e) {
                this._status = -1;
            }
            try {
                this._name = tRef.name();
            }
            catch (Exception e) {
                this._name = "???";
            }
            try {
                ObjectReference objRef = tRef.currentContendedMonitor();
                this._contendedLockId = objRef != null ? Long.valueOf(objRef.uniqueID()) : null;
            }
            catch (Exception e) {
                this._contendedLockId = null;
            }
            try {
                this._ownedLockIds = new HashSet<Long>(tRef.ownedMonitors().size());
                for (ObjectReference or : tRef.ownedMonitors()) {
                    this._ownedLockIds.add(or.uniqueID());
                }
            }
            catch (Exception e) {
                this._ownedLockIds = new HashSet<Long>();
            }
            try {
                this._stackFrame = new LinkedList();
                for (StackFrame sf : tRef.frames()) {
                    this._stackFrame.addFirst(new StackFrameInfo(sf));
                }
            }
            catch (Exception e) {
                this._stackFrame = new LinkedList();
            }
        }
    }

    @Override
    public long getThreadID() {
        return this._threadID;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public String getName() {
        return this._name;
    }

    public Long getContendedLockID() {
        return this._contendedLockId;
    }

    public void setContendedLockId(Long contendedLockId) {
        this._contendedLockId = contendedLockId;
    }

    public Set<Long> getOwnedLockIDs() {
        return this._ownedLockIds;
    }

    public List<StackFrameInfo> getStackFrame() {
        return this._stackFrame;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._threadID);
        sb.append(": ");
        sb.append(this._name);
        sb.append(", ");
        switch (this._status) {
            case 3: {
                sb.append("MONITOR WAITING");
                break;
            }
            case 5: {
                sb.append("NOT STARTED");
                break;
            }
            case 1: {
                sb.append("RUNNING");
                break;
            }
            case 2: {
                sb.append("SLEEPING");
                break;
            }
            case 4: {
                sb.append("WAITING");
                break;
            }
            case 0: {
                sb.append("ZOMBIE");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        return sb.toString();
    }

    public String toStringExtended(Map<Long, LockInfo> lockInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._threadID);
        sb.append(": ");
        sb.append(this._name);
        sb.append(", ");
        switch (this._status) {
            case 3: {
                sb.append("MONITOR WAITING");
                break;
            }
            case 5: {
                sb.append("NOT STARTED");
                break;
            }
            case 1: {
                sb.append("RUNNING");
                break;
            }
            case 2: {
                sb.append("SLEEPING");
                break;
            }
            case 4: {
                sb.append("WAITING");
                break;
            }
            case 0: {
                sb.append("ZOMBIE");
                break;
            }
            default: {
                sb.append("unknown");
            }
        }
        if (null != this._stackFrame) {
            if (this._stackFrame.size() > 0) {
                sb.append(", at ");
                sb.append(this._stackFrame.get(0).getSourcePath());
                sb.append(":");
                sb.append(this._stackFrame.get(0).getLineNumber());
            }
            sb.append(")\nStack:\n");
            for (StackFrameInfo sfi : this._stackFrame) {
                sb.append(sfi.toString());
                sb.append("\n");
            }
        }
        sb.append("\n");
        sb.append("Owned locks:\n");
        if (this._ownedLockIds.size() == 0) {
            sb.append("none\n");
        } else {
            for (Long id : this._ownedLockIds) {
                LockInfo li = lockInfo.get(id);
                if (li != null) {
                    sb.append(li);
                } else {
                    sb.append("null (id=");
                    sb.append(id);
                }
                sb.append("\n");
            }
        }
        sb.append("Contended lock:\n");
        if (this._contendedLockId == null) {
            sb.append("none");
        } else {
            LockInfo li = lockInfo.get(this._contendedLockId);
            if (li != null) {
                sb.append(lockInfo.get(li));
            } else {
                sb.append("null (id=");
                sb.append(this._contendedLockId);
            }
        }
        return sb.toString();
    }

    @Override
    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append("\n");
        sb.append("Contended: ");
        sb.append(this.getContendedLockID());
        sb.append("\n");
        sb.append("Owned:");
        for (Long id : this.getOwnedLockIDs()) {
            sb.append("\t");
            sb.append(id);
        }
        return sb.toString();
    }
}

