/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;
import edu.rice.cs.cunit.util.Types;
import java.util.ArrayList;

public class SynchronizedMethodToBlockStrategy
implements IInstrumentationStrategy {
    protected ArrayList<MethodInfo> _newMethods = new ArrayList();

    public void instrument(ClassFile cf) {
        this.instrumentSynchronizedMethods(cf);
    }

    protected void instrumentSynchronizedMethods(ClassFile cf) {
        byte[] loadCode = new byte[]{42};
        byte[] loadClassCode = new byte[]{19, 0, 0};
        for (MethodInfo mi : cf.getMethods()) {
            if (0 == (mi.getAccessFlags() & 0x20) || 0 != (mi.getAccessFlags() & 0x100)) continue;
            if (0 != (mi.getAccessFlags() & 8)) {
                Types.bytesFromShort(cf.getConstantPool().indexOf(cf.getThisClass()), loadClassCode, 1);
                this.instrumentSynchronizedMethod(cf, mi, loadClassCode, 2);
            } else {
                this.instrumentSynchronizedMethod(cf, mi, loadCode, 2);
            }
            short newFlags = (short)(mi.getAccessFlags() & 0xFFFFFFDF);
            mi.setAccessFlags(newFlags);
        }
    }

    protected void instrumentSynchronizedMethod(ClassFile cf, MethodInfo mi, byte[] loadLockCode, int reqdStackSize) {
        boolean result;
        CodeAttributeInfo codeAttr = mi.getCodeAttributeInfo();
        InstructionList il = new InstructionList(codeAttr.getCode());
        GenericInstruction monitorExitInstr = new GenericInstruction(-61);
        if (0 < loadLockCode.length) {
            InstructionList loadil = new InstructionList(loadLockCode);
            do {
                il.insertBeforeInstr(loadil.getInstr(), codeAttr);
                result = il.advanceIndex();
                assert (result);
            } while (loadil.advanceIndex());
        }
        il.insertBeforeInstr(new GenericInstruction(-62), codeAttr);
        result = il.advanceIndex();
        assert (result);
        int exceptionEndPC = il.getPCFromIndex(il.getIndex());
        do {
            if (Opcode.isReturn(il.getOpcode())) {
                if (0 < loadLockCode.length) {
                    InstructionList loadil = new InstructionList(loadLockCode);
                    do {
                        il.insertInstr(loadil.getInstr(), codeAttr);
                        result = il.advanceIndex();
                        assert (result);
                    } while (loadil.advanceIndex());
                }
                il.insertInstr(monitorExitInstr, codeAttr);
                result = il.advanceIndex();
                assert (result);
            }
            exceptionEndPC = il.getPCFromIndex(il.getIndex());
        } while (il.advanceIndex());
        int exceptionHandlerPC = il.getPCFromIndex(il.getIndex());
        if (0 < loadLockCode.length) {
            InstructionList loadil = new InstructionList(loadLockCode);
            do {
                il.insertInstr(loadil.getInstr(), codeAttr);
                result = il.advanceIndex();
                assert (result);
            } while (loadil.advanceIndex());
        }
        il.insertInstr(monitorExitInstr, codeAttr);
        result = il.advanceIndex();
        assert (result);
        il.insertInstr(new GenericInstruction(-65), codeAttr);
        result = il.advanceIndex();
        assert (result);
        CodeAttributeInfo.ExceptionTableEntry[] excTable = new CodeAttributeInfo.ExceptionTableEntry[codeAttr.getExceptionTableEntries().length + 1];
        System.arraycopy(codeAttr.getExceptionTableEntries(), 0, excTable, 0, codeAttr.getExceptionTableEntries().length);
        excTable[excTable.length - 1] = new CodeAttributeInfo.ExceptionTableEntry(0, exceptionEndPC, exceptionHandlerPC, 0);
        codeAttr.setExceptionTableEntries(excTable);
        codeAttr.setCode(il.getCode());
        CodeAttributeInfo.CodeProperties cp = mi.getCodeAttributeInfo().getProperties();
        cp.maxStack = (short)Math.max(reqdStackSize, cp.maxStack);
        mi.getCodeAttributeInfo().setProperties(cp.maxStack, cp.maxLocals);
    }

    public void done() {
    }
}

