/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.constantPool;

import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.IPoolInfoVisitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameAndTypePoolInfo
extends APoolInfo {
    protected AUTFPoolInfo _name;
    protected AUTFPoolInfo _descriptor;
    protected short _nameIndex;
    protected short _descriptorIndex;

    public NameAndTypePoolInfo(AUTFPoolInfo name, AUTFPoolInfo descriptor, ConstantPool cp) {
        super(12, cp);
        this._name = name;
        this._descriptor = descriptor;
        this.reindex();
    }

    public NameAndTypePoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(12, cp);
        this._nameIndex = dis.readShort();
        this._descriptorIndex = dis.readShort();
    }

    public AUTFPoolInfo getName() {
        return this._name;
    }

    public void setName(AUTFPoolInfo name) {
        this._name = name;
    }

    public AUTFPoolInfo getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(AUTFPoolInfo descriptor) {
        this._descriptor = descriptor;
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        this.reindex();
        dos.writeByte(this._type);
        dos.writeShort(this._nameIndex);
        dos.writeShort(this._descriptorIndex);
    }

    @Override
    public void resolve() {
        this._name = ((APoolInfo)this._constantPool.get(this._nameIndex)).execute(CheckUTFVisitor.singleton(), null);
        this._descriptor = ((APoolInfo)this._constantPool.get(this._descriptorIndex)).execute(CheckUTFVisitor.singleton(), null);
    }

    @Override
    public void reindex() {
        this._nameIndex = this._constantPool.indexOf(this._name);
        this._descriptorIndex = this._constantPool.indexOf(this._descriptor);
    }

    @Override
    public String toStringVerbose() {
        StringBuilder s = new StringBuilder();
        s.append("NAME-AND-TYPE: Name = #");
        s.append(this._nameIndex);
        s.append(", Descriptor = #");
        s.append(this._descriptorIndex);
        s.append(' ');
        s.append(this.toString());
        return s.toString();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this._name.toString());
        s.append(this._descriptor.toString());
        return s.toString();
    }

    @Override
    public int hashCode() {
        return this._nameIndex + 6101 * this._descriptorIndex;
    }

    @Override
    public boolean equals(Object obj) {
        return !(!(obj instanceof NameAndTypePoolInfo) || ((NameAndTypePoolInfo)obj)._nameIndex != this._nameIndex && ((NameAndTypePoolInfo)obj)._name != this._name || ((NameAndTypePoolInfo)obj)._descriptorIndex != this._descriptorIndex && ((NameAndTypePoolInfo)obj)._descriptor != this._descriptor);
    }

    @Override
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.nameAndTypeCase(this, data);
    }
}

