/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code.instructions;

import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.util.Types;

public class ReferenceInstruction
extends GenericInstruction {
    int _refSize;

    public ReferenceInstruction(byte opcode, int constantPoolId) {
        super(0);
        assert (constantPoolId <= 65535);
        this.checkOpcode(opcode);
        this._code = new byte[1 + this._refSize];
        this._code[0] = opcode;
        this.setReference(constantPoolId);
    }

    public ReferenceInstruction(byte[] bytecode, int pc, int paddingPC, LineNumberTable lnt) {
        super(bytecode, pc, paddingPC, lnt);
        this.checkOpcode(bytecode[pc]);
    }

    private void checkOpcode(byte opcode) {
        switch (opcode) {
            case -78: 
            case -77: 
            case -76: 
            case -75: 
            case -74: 
            case -73: 
            case -72: 
            case -69: 
            case -67: 
            case -64: 
            case -63: 
            case 19: 
            case 20: {
                this._refSize = 2;
                break;
            }
            case 18: {
                this._refSize = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal reference instruction: " + Opcode.getOpcodeName(opcode));
            }
        }
    }

    public void setReference(int constantPoolId) {
        assert (constantPoolId <= 65535);
        if (this._refSize == 1) {
            this._code[1] = (byte)(0xFF & constantPoolId);
        } else {
            Types.bytesFromShort((short)(0xFFFF & constantPoolId), this._code, 1);
        }
    }

    public int getReference() {
        if (this._refSize == 1) {
            return this._code[1] & 0xFF;
        }
        return Types.ushortFromBytes(this._code, 1);
    }

    public String toStringVerbose(ConstantPool cp) {
        StringBuilder x = new StringBuilder();
        x.append(Opcode.getOpcodeName(this._code[0]));
        x.append(' ');
        int ref = this.getReference();
        assert (ref <= 65535);
        x.append(((APoolInfo)cp.get(ref)).toString());
        x.append(' ');
        x.append("(CP=");
        x.append(ref);
        x.append(") ");
        for (int i = 1; i < this._code.length; ++i) {
            x.append(String.format("%02x ", new Byte(this._code[i])));
        }
        return x.toString();
    }
}

