/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code;

import edu.rice.cs.cunit.classFile.code.instructions.AInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.WideInstruction;
import edu.rice.cs.cunit.util.Types;

public abstract class Opcode {
    public static final byte NOP = 0;
    public static final byte ACONST_NULL = 1;
    public static final byte ICONST_M1 = 2;
    public static final byte ICONST_0 = 3;
    public static final byte ICONST_1 = 4;
    public static final byte ICONST_2 = 5;
    public static final byte ICONST_3 = 6;
    public static final byte ICONST_4 = 7;
    public static final byte ICONST_5 = 8;
    public static final byte LCONST_0 = 9;
    public static final byte LCONST_1 = 10;
    public static final byte FCONST_0 = 11;
    public static final byte FCONST_1 = 12;
    public static final byte FCONST_2 = 13;
    public static final byte DCONST_0 = 14;
    public static final byte DCONST_1 = 15;
    public static final byte BIPUSH = 16;
    public static final byte SIPUSH = 17;
    public static final byte LDC = 18;
    public static final byte LDC_W = 19;
    public static final byte LDC2_W = 20;
    public static final byte ILOAD = 21;
    public static final byte LLOAD = 22;
    public static final byte FLOAD = 23;
    public static final byte DLOAD = 24;
    public static final byte ALOAD = 25;
    public static final byte ILOAD_0 = 26;
    public static final byte ILOAD_1 = 27;
    public static final byte ILOAD_2 = 28;
    public static final byte ILOAD_3 = 29;
    public static final byte LLOAD_0 = 30;
    public static final byte LLOAD_1 = 31;
    public static final byte LLOAD_2 = 32;
    public static final byte LLOAD_3 = 33;
    public static final byte FLOAD_0 = 34;
    public static final byte FLOAD_1 = 35;
    public static final byte FLOAD_2 = 36;
    public static final byte FLOAD_3 = 37;
    public static final byte DLOAD_0 = 38;
    public static final byte DLOAD_1 = 39;
    public static final byte DLOAD_2 = 40;
    public static final byte DLOAD_3 = 41;
    public static final byte ALOAD_0 = 42;
    public static final byte ALOAD_1 = 43;
    public static final byte ALOAD_2 = 44;
    public static final byte ALOAD_3 = 45;
    public static final byte IALOAD = 46;
    public static final byte LALOAD = 47;
    public static final byte FALOAD = 48;
    public static final byte DALOAD = 49;
    public static final byte AALOAD = 50;
    public static final byte BALOAD = 51;
    public static final byte CALOAD = 52;
    public static final byte SALOAD = 53;
    public static final byte ISTORE = 54;
    public static final byte LSTORE = 55;
    public static final byte FSTORE = 56;
    public static final byte DSTORE = 57;
    public static final byte ASTORE = 58;
    public static final byte ISTORE_0 = 59;
    public static final byte ISTORE_1 = 60;
    public static final byte ISTORE_2 = 61;
    public static final byte ISTORE_3 = 62;
    public static final byte LSTORE_0 = 63;
    public static final byte LSTORE_1 = 64;
    public static final byte LSTORE_2 = 65;
    public static final byte LSTORE_3 = 66;
    public static final byte FSTORE_0 = 67;
    public static final byte FSTORE_1 = 68;
    public static final byte FSTORE_2 = 69;
    public static final byte FSTORE_3 = 70;
    public static final byte DSTORE_0 = 71;
    public static final byte DSTORE_1 = 72;
    public static final byte DSTORE_2 = 73;
    public static final byte DSTORE_3 = 74;
    public static final byte ASTORE_0 = 75;
    public static final byte ASTORE_1 = 76;
    public static final byte ASTORE_2 = 77;
    public static final byte ASTORE_3 = 78;
    public static final byte IASTORE = 79;
    public static final byte LASTORE = 80;
    public static final byte FASTORE = 81;
    public static final byte DASTORE = 82;
    public static final byte AASTORE = 83;
    public static final byte BASTORE = 84;
    public static final byte CASTORE = 85;
    public static final byte SASTORE = 86;
    public static final byte POP = 87;
    public static final byte POP2 = 88;
    public static final byte DUP = 89;
    public static final byte DUP_X1 = 90;
    public static final byte DUP_X2 = 91;
    public static final byte DUP2 = 92;
    public static final byte DUP2_X1 = 93;
    public static final byte DUP2_X2 = 94;
    public static final byte SWAP = 95;
    public static final byte IADD = 96;
    public static final byte LADD = 97;
    public static final byte FADD = 98;
    public static final byte DADD = 99;
    public static final byte ISUB = 100;
    public static final byte LSUB = 101;
    public static final byte FSUB = 102;
    public static final byte DSUB = 103;
    public static final byte IMUL = 104;
    public static final byte LMUL = 105;
    public static final byte FMUL = 106;
    public static final byte DMUL = 107;
    public static final byte IDIV = 108;
    public static final byte LDIV = 109;
    public static final byte FDIV = 110;
    public static final byte DDIV = 111;
    public static final byte IREM = 112;
    public static final byte LREM = 113;
    public static final byte FREM = 114;
    public static final byte DREM = 115;
    public static final byte INEG = 116;
    public static final byte LNEG = 117;
    public static final byte FNEG = 118;
    public static final byte DNEG = 119;
    public static final byte ISHL = 120;
    public static final byte LSHL = 121;
    public static final byte ISHR = 122;
    public static final byte LSHR = 123;
    public static final byte IUSHR = 124;
    public static final byte LUSHR = 125;
    public static final byte IAND = 126;
    public static final byte LAND = 127;
    public static final byte IOR = -128;
    public static final byte LOR = -127;
    public static final byte IXOR = -126;
    public static final byte LXOR = -125;
    public static final byte IINC = -124;
    public static final byte I2L = -123;
    public static final byte I2F = -122;
    public static final byte I2D = -121;
    public static final byte L2I = -120;
    public static final byte L2F = -119;
    public static final byte L2D = -118;
    public static final byte F2I = -117;
    public static final byte F2L = -116;
    public static final byte F2D = -115;
    public static final byte D2I = -114;
    public static final byte D2L = -113;
    public static final byte D2F = -112;
    public static final byte I2B = -111;
    public static final byte I2C = -110;
    public static final byte I2S = -109;
    public static final byte LCMP = -108;
    public static final byte FCMPL = -107;
    public static final byte FCMPG = -106;
    public static final byte DCMPL = -105;
    public static final byte DCMPG = -104;
    public static final byte IFEQ = -103;
    public static final byte IFNE = -102;
    public static final byte IFLT = -101;
    public static final byte IFGE = -100;
    public static final byte IFGT = -99;
    public static final byte IFLE = -98;
    public static final byte IF_ICMPEQ = -97;
    public static final byte IF_ICMPNE = -96;
    public static final byte IF_ICMPLT = -95;
    public static final byte IF_ICMPGE = -94;
    public static final byte IF_ICMPGT = -93;
    public static final byte IF_ICMPLE = -92;
    public static final byte IF_ACMPEQ = -91;
    public static final byte IF_ACMPNE = -90;
    public static final byte GOTO = -89;
    public static final byte JSR = -88;
    public static final byte RET = -87;
    public static final byte TABLESWITCH = -86;
    public static final byte LOOKUPSWITCH = -85;
    public static final byte IRETURN = -84;
    public static final byte LRETURN = -83;
    public static final byte FRETURN = -82;
    public static final byte DRETURN = -81;
    public static final byte ARETURN = -80;
    public static final byte RETURN = -79;
    public static final byte GETSTATIC = -78;
    public static final byte PUTSTATIC = -77;
    public static final byte GETFIELD = -76;
    public static final byte PUTFIELD = -75;
    public static final byte INVOKEVIRTUAL = -74;
    public static final byte INVOKESPECIAL = -73;
    public static final byte INVOKESTATIC = -72;
    public static final byte INVOKEINTERFACE = -71;
    public static final byte XXXUNUSEDXXX = -70;
    public static final byte NEW = -69;
    public static final byte NEWARRAY = -68;
    public static final byte ANEWARRAY = -67;
    public static final byte ARRAYLENGTH = -66;
    public static final byte ATHROW = -65;
    public static final byte CHECKCAST = -64;
    public static final byte INSTANCEOF = -63;
    public static final byte MONITORENTER = -62;
    public static final byte MONITOREXIT = -61;
    public static final byte WIDE = -60;
    public static final byte MULTIANEWARRAY = -59;
    public static final byte IFNULL = -58;
    public static final byte IFNONNULL = -57;
    public static final byte GOTO_W = -56;
    public static final byte JSR_W = -55;
    public static final byte BREAKPOINT = -54;
    public static final byte LDC_QUICK = -53;
    public static final byte LDC_W_QUICK = -52;
    public static final byte LDC2_W_QUICK = -51;
    public static final byte GETFIELD_QUICK = -50;
    public static final byte PUTFIELD_QUICK = -49;
    public static final byte GETFIELD2_QUICK = -48;
    public static final byte PUTFIELD2_QUICK = -47;
    public static final byte GETSTATIC_QUICK = -46;
    public static final byte PUTSTATIC_QUICK = -45;
    public static final byte GETSTATIC2_QUICK = -44;
    public static final byte PUTSTATIC2_QUICK = -43;
    public static final byte INVOKEVIRTUAL_QUICK = -42;
    public static final byte INVOKENONVIRTUAL_QUICK = -41;
    public static final byte INVOKESUPER_QUICK = -40;
    public static final byte INVOKESTATIC_QUICK = -39;
    public static final byte INVOKEINTERFACE_QUICK = -38;
    public static final byte INVOKEVIRTUALOBJECT_QUICK = -37;
    public static final byte UNKNOWN_DC = -36;
    public static final byte NEW_QUICK = -35;
    public static final byte ANEWARRAY_QUICK = -34;
    public static final byte MULTIANEWARRAY_QUICK = -33;
    public static final byte CHECKCAST_QUICK = -32;
    public static final byte INSTANCEOF_QUICK = -31;
    public static final byte INVOKEVIRTUAL_QUICK_W = -30;
    public static final byte GETFIELD_QUICK_W = -29;
    public static final byte PUTFIELD_QUICK_W = -28;
    public static final byte UNKNOWN_E5 = -27;
    public static final byte UNKNOWN_E6 = -26;
    public static final byte UNKNOWN_E7 = -25;
    public static final byte UNKNOWN_E8 = -24;
    public static final byte UNKNOWN_E9 = -23;
    public static final byte UNKNOWN_EA = -22;
    public static final byte UNKNOWN_EB = -21;
    public static final byte UNKNOWN_EC = -20;
    public static final byte UNKNOWN_ED = -19;
    public static final byte UNKNOWN_EE = -18;
    public static final byte UNKNOWN_EF = -17;
    public static final byte UNKNOWN_F0 = -16;
    public static final byte UNKNOWN_F1 = -15;
    public static final byte UNKNOWN_F2 = -14;
    public static final byte UNKNOWN_F3 = -13;
    public static final byte UNKNOWN_F4 = -12;
    public static final byte UNKNOWN_F5 = -11;
    public static final byte UNKNOWN_F6 = -10;
    public static final byte UNKNOWN_F7 = -9;
    public static final byte UNKNOWN_F8 = -8;
    public static final byte UNKNOWN_F9 = -7;
    public static final byte UNKNOWN_FA = -6;
    public static final byte UNKNOWN_FB = -5;
    public static final byte UNKNOWN_FC = -4;
    public static final byte UNKNOWN_FD = -3;
    public static final byte IMPDEP1 = -2;
    public static final byte IMPDEP2 = -1;
    private static final String[] NAMES;
    private static final byte[] OFFSET;
    private static final boolean[] isBranch;

    public static final String getOpcodeName(byte opcode) {
        return NAMES[opcode & 0xFF];
    }

    public static final int getInstrSize(byte[] code, int pc) {
        return Opcode.getInstrSize(code, pc, pc);
    }

    public static final int getInstrSize(byte[] code, int pc, int paddingPC) {
        byte opcode = code[pc];
        switch (opcode) {
            case -85: {
                int pad = 3 - paddingPC % 4;
                long npairs = Types.intFromBytes(code, pc + pad + 5);
                assert (npairs >= 0L);
                return (int)(npairs * 8L) + pad + 9;
            }
            case -86: {
                int pad = 3 - paddingPC % 4;
                long low = Types.intFromBytes(code, pc + pad + 5);
                long high = Types.intFromBytes(code, pc + pad + 9);
                long npairs = high - low + 1L;
                assert (low <= high);
                return (int)(npairs * 4L) + pad + 13;
            }
            case -60: {
                if (code[pc + 1] == -124) {
                    return 6;
                }
                return 4;
            }
        }
        return 1 + OFFSET[Types.unsigned(opcode)];
    }

    public static final byte[] repadInstr(byte[] code, int pc, int paddingPC, int newPC) {
        byte opcode = code[pc];
        switch (opcode) {
            case -85: {
                int pad = 3 - paddingPC % 4;
                int newPad = 3 - newPC % 4;
                byte[] newCode = new byte[code.length - pad + newPad];
                System.arraycopy(code, 0, newCode, 0, pc + 1);
                System.arraycopy(code, pc + pad + 1, newCode, pc + newPad + 1, code.length - pc - pad - 1);
                return newCode;
            }
            case -86: {
                int pad = 3 - paddingPC % 4;
                int newPad = 3 - newPC % 4;
                byte[] newCode = new byte[code.length - pad + newPad];
                System.arraycopy(code, 0, newCode, 0, pc + 1);
                System.arraycopy(code, pc + pad + 1, newCode, pc + newPad + 1, code.length - pc - pad - 1);
                return newCode;
            }
        }
        byte[] newCode = new byte[code.length];
        System.arraycopy(code, 0, newCode, 0, code.length);
        return newCode;
    }

    public static final boolean isReturn(byte opcode) {
        switch (opcode) {
            case -84: 
            case -83: 
            case -82: 
            case -81: 
            case -80: 
            case -79: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isBranch(byte opcode) {
        return isBranch[Types.unsigned(opcode)];
    }

    public static final boolean isUnconditionalBranch(byte opcode) {
        switch (opcode) {
            case -89: 
            case -88: 
            case -87: 
            case -86: 
            case -85: 
            case -84: 
            case -83: 
            case -82: 
            case -81: 
            case -80: 
            case -79: 
            case -65: 
            case -56: 
            case -55: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isJSR(byte opcode) {
        return opcode == -88 || opcode == -55;
    }

    public static final int[] getBranchTargets(byte[] code, int pc, int paddingPC) {
        if (!Opcode.isBranch(code[pc])) {
            return new int[0];
        }
        switch (code[pc]) {
            case -85: {
                int pad = 3 - paddingPC % 4;
                long deflt = Types.intFromBytes(code, pc + pad + 1);
                long npairs = Types.intFromBytes(code, pc + pad + 5);
                assert (npairs >= 0L);
                int[] result = new int[(int)npairs + 1];
                result[0] = pc + (int)deflt;
                int i = 0;
                while ((long)i < npairs) {
                    long offset = Types.intFromBytes(code, pc + pad + 9 + 4 + 8 * i);
                    result[i + 1] = pc + (int)offset;
                    ++i;
                }
                return result;
            }
            case -86: {
                int pad = 3 - paddingPC % 4;
                long deflt = Types.intFromBytes(code, pc + pad + 1);
                long low = Types.intFromBytes(code, pc + pad + 5);
                long high = Types.intFromBytes(code, pc + pad + 9);
                long npairs = high - low + 1L;
                assert (low <= high);
                int[] result = new int[(int)npairs + 1];
                result[0] = pc + (int)deflt;
                int i = 0;
                while ((long)i < npairs) {
                    long offset = Types.intFromBytes(code, pc + pad + 13 + 4 * i);
                    result[i + 1] = pc + (int)offset;
                    ++i;
                }
                return result;
            }
            case -56: 
            case -55: {
                long offset = Types.intFromBytes(code, pc + 1);
                int[] result = new int[]{pc + (int)offset};
                return result;
            }
            case -87: 
            case -84: 
            case -83: 
            case -82: 
            case -81: 
            case -80: 
            case -79: 
            case -65: {
                return new int[0];
            }
        }
        int offset = Types.ushortFromBytes(code, pc + 1);
        int[] result = new int[]{pc + offset};
        return result;
    }

    public static final void setBranchTargets(byte[] code, int pc, int[] branchTargets) {
        if (!Opcode.isBranch(code[pc])) {
            throw new IllegalArgumentException("Cannot set branch targets for non-branch instruction");
        }
        switch (code[pc]) {
            case -85: {
                int pad = 3 - pc % 4;
                long npairs = Types.intFromBytes(code, pc + pad + 5);
                assert (npairs >= 0L);
                if ((long)branchTargets.length != npairs + 1L) {
                    throw new IllegalArgumentException("Not allowed to change number of branch targets");
                }
                int delta = branchTargets[0] - pc;
                Types.bytesFromInt(delta, code, pc + pad + 1);
                int i = 0;
                while ((long)i < npairs) {
                    delta = branchTargets[1 + i] - pc;
                    Types.bytesFromInt(delta, code, pc + pad + 9 + 4 + 8 * i);
                    ++i;
                }
                return;
            }
            case -86: {
                int pad = 3 - pc % 4;
                long low = Types.intFromBytes(code, pc + pad + 5);
                long high = Types.intFromBytes(code, pc + pad + 9);
                long npairs = high - low + 1L;
                assert (low <= high);
                if ((long)branchTargets.length != npairs + 1L) {
                    throw new IllegalArgumentException("Not allowed to change number of branch targets");
                }
                int delta = branchTargets[0] - pc;
                Types.bytesFromInt(delta, code, pc + pad + 1);
                int i = 0;
                while ((long)i < npairs) {
                    delta = branchTargets[1 + i] - pc;
                    Types.bytesFromInt(delta, code, pc + pad + 13 + 4 * i);
                    ++i;
                }
                return;
            }
            case -56: 
            case -55: {
                if (branchTargets.length != 1) {
                    throw new IllegalArgumentException("Not allowed to change number of branch targets");
                }
                int delta = branchTargets[0] - pc;
                Types.bytesFromInt(delta, code, pc + 1);
                return;
            }
            case -87: 
            case -84: 
            case -83: 
            case -82: 
            case -81: 
            case -80: 
            case -79: 
            case -65: {
                if (branchTargets.length != 0) {
                    throw new IllegalArgumentException("Not allowed to change number of branch targets");
                }
                return;
            }
        }
        if (branchTargets.length != 1) {
            throw new IllegalArgumentException("Not allowed to change number of branch targets");
        }
        int delta = branchTargets[0] - pc;
        Types.bytesFromShort((short)(0xFFFF & delta), code, pc + 1);
    }

    public static AInstruction getShortestLoadStoreInstruction(byte baseOpcode, short index) {
        switch (baseOpcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(26);
                    }
                    case 1: {
                        return new GenericInstruction(27);
                    }
                    case 2: {
                        return new GenericInstruction(28);
                    }
                    case 3: {
                        return new GenericInstruction(29);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(21, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{21, b[0], b[1]});
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(30);
                    }
                    case 1: {
                        return new GenericInstruction(31);
                    }
                    case 2: {
                        return new GenericInstruction(32);
                    }
                    case 3: {
                        return new GenericInstruction(33);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(22, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{22, b[0], b[1]});
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(34);
                    }
                    case 1: {
                        return new GenericInstruction(35);
                    }
                    case 2: {
                        return new GenericInstruction(36);
                    }
                    case 3: {
                        return new GenericInstruction(37);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(23, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{23, b[0], b[1]});
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(38);
                    }
                    case 1: {
                        return new GenericInstruction(39);
                    }
                    case 2: {
                        return new GenericInstruction(40);
                    }
                    case 3: {
                        return new GenericInstruction(41);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(24, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{24, b[0], b[1]});
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(42);
                    }
                    case 1: {
                        return new GenericInstruction(43);
                    }
                    case 2: {
                        return new GenericInstruction(44);
                    }
                    case 3: {
                        return new GenericInstruction(45);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(25, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{25, b[0], b[1]});
            }
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(59);
                    }
                    case 1: {
                        return new GenericInstruction(60);
                    }
                    case 2: {
                        return new GenericInstruction(61);
                    }
                    case 3: {
                        return new GenericInstruction(62);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(54, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{54, b[0], b[1]});
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(63);
                    }
                    case 1: {
                        return new GenericInstruction(64);
                    }
                    case 2: {
                        return new GenericInstruction(65);
                    }
                    case 3: {
                        return new GenericInstruction(66);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(55, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{55, b[0], b[1]});
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(67);
                    }
                    case 1: {
                        return new GenericInstruction(68);
                    }
                    case 2: {
                        return new GenericInstruction(69);
                    }
                    case 3: {
                        return new GenericInstruction(70);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(56, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{56, b[0], b[1]});
            }
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(71);
                    }
                    case 1: {
                        return new GenericInstruction(72);
                    }
                    case 2: {
                        return new GenericInstruction(73);
                    }
                    case 3: {
                        return new GenericInstruction(74);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(57, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{57, b[0], b[1]});
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                switch (index) {
                    case 0: {
                        return new GenericInstruction(75);
                    }
                    case 1: {
                        return new GenericInstruction(76);
                    }
                    case 2: {
                        return new GenericInstruction(77);
                    }
                    case 3: {
                        return new GenericInstruction(78);
                    }
                }
                if (index <= 256) {
                    return new GenericInstruction(58, (byte)index);
                }
                byte[] b = Types.bytesFromInt(index);
                return new WideInstruction(new byte[]{58, b[0], b[1]});
            }
        }
        throw new IllegalArgumentException("Only ILOAD, LLOAD, FLOAD, DLOAD, ALOAD, ISTORE, LSTORE, FSTORE, DSTORE and ASTORE allowed");
    }

    static {
        int i;
        NAMES = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc2_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "xxxunusedxxx", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w", "breakpoint", "ldc_quick", "ldc_w_quick", "ldc2_w_quick", "getfield_quick", "putfield_quick", "getfield2_quick", "putfield2_quick", "getstatic_quick", "putstatic_quick", "getstatic2_quick", "putstatic2_quick", "invokevirtual_quick", "invokenonvirtual_quick", "invokesuper_quick", "invokestatic_quick", "invokeinterface_quick", "invokevirtualobject_quick", "unknown_dc", "new_quick", "anewarray_quick", "multianewarray_quick", "checkcast_quick", "instanceof_quick", "invokevirtual_quick_w", "getfield_quick_w", "putfield_quick_w", "unknown_e5", "unknown_e6", "unknown_e7", "unknown_e8", "unknown_e9", "unknown_ea", "unknown_eb", "unknown_ec", "unknown_ed", "unknown_ee", "unknown_ef", "unknown_f0", "unknown_f1", "unknown_f2", "unknown_f3", "unknown_f4", "unknown_f5", "unknown_f6", "unknown_f7", "unknown_f8", "unknown_f9", "unknown_fa", "unknown_fb", "unknown_fc", "unknown_fd", "impdep1", "impdep2"};
        OFFSET = new byte[256];
        for (i = 0; i < OFFSET.length; ++i) {
            Opcode.OFFSET[i] = 0;
        }
        Opcode.OFFSET[Types.unsigned((byte)16)] = 1;
        Opcode.OFFSET[Types.unsigned((byte)17)] = 2;
        Opcode.OFFSET[Types.unsigned((byte)18)] = 1;
        Opcode.OFFSET[Types.unsigned((byte)19)] = 2;
        Opcode.OFFSET[Types.unsigned((byte)20)] = 2;
        for (i = Types.unsigned(21); i <= Types.unsigned((byte)25); ++i) {
            Opcode.OFFSET[i] = 1;
        }
        for (i = Types.unsigned(54); i <= Types.unsigned((byte)58); ++i) {
            Opcode.OFFSET[i] = 1;
        }
        Opcode.OFFSET[Types.unsigned((byte)-124)] = 2;
        for (i = Types.unsigned(-103); i <= Types.unsigned((byte)-88); ++i) {
            Opcode.OFFSET[i] = 2;
        }
        Opcode.OFFSET[Types.unsigned((byte)-87)] = 1;
        for (i = Types.unsigned(-78); i <= Types.unsigned((byte)-72); ++i) {
            Opcode.OFFSET[i] = 2;
        }
        Opcode.OFFSET[Types.unsigned((byte)-71)] = 4;
        Opcode.OFFSET[Types.unsigned((byte)-69)] = 2;
        Opcode.OFFSET[Types.unsigned((byte)-68)] = 1;
        Opcode.OFFSET[Types.unsigned((byte)-67)] = 2;
        Opcode.OFFSET[Types.unsigned((byte)-64)] = 2;
        Opcode.OFFSET[Types.unsigned((byte)-63)] = 2;
        Opcode.OFFSET[Types.unsigned((byte)-59)] = 3;
        Opcode.OFFSET[Types.unsigned((byte)-58)] = 2;
        Opcode.OFFSET[Types.unsigned((byte)-57)] = 2;
        Opcode.OFFSET[Types.unsigned((byte)-56)] = 4;
        Opcode.OFFSET[Types.unsigned((byte)-55)] = 4;
        isBranch = new boolean[256];
        for (i = 0; i < isBranch.length; ++i) {
            Opcode.isBranch[i] = false;
        }
        for (i = Types.unsigned(-103); i <= Types.unsigned((byte)-79); ++i) {
            Opcode.isBranch[i] = true;
        }
        for (i = Types.unsigned(-58); i <= Types.unsigned((byte)-55); ++i) {
            Opcode.isBranch[i] = true;
        }
        Opcode.isBranch[Types.unsigned((byte)-65)] = true;
    }
}

