/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.util.Types;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AAnnotationsAttributeInfo
extends AAttributeInfo {
    public AAnnotationsAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) {
        super(name, data, cp);
    }

    public void adjustPC(int startPC, int deltaPC) {
    }

    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Annotation {
        private AUTFPoolInfo _type;
        private int _pairCount;
        private NameValuePair[] _pairs;

        public Annotation(AUTFPoolInfo type, short pairCount, NameValuePair[] pairs) {
            this._type = type;
            this._pairCount = pairCount;
            this._pairs = pairs;
        }

        public Annotation(ConstantPool cp, byte[] data, int start) {
            this._type = ((APoolInfo)cp.get(Types.ushortFromBytes(data, start + 0))).execute(CheckUTFVisitor.singleton(), null);
            this._pairCount = Types.ushortFromBytes(data, start + 2);
            this._pairs = new NameValuePair[this._pairCount];
            int index = start + 4;
            for (int i = 0; i < this._pairCount; ++i) {
                this._pairs[i] = new NameValuePair(cp, data, index);
                index += this._pairs[i].getSize();
            }
        }

        public int getSize() {
            int accum = 4;
            for (NameValuePair pair : this._pairs) {
                accum += pair.getSize();
            }
            return accum;
        }

        public void writeToByteArrayOutputStream(ConstantPool cp, ByteArrayOutputStream baos) throws IOException {
            baos.write(Types.bytesFromShort(cp.indexOf(this._type)));
            baos.write(Types.bytesFromShort((short)(this._pairCount & 0xFFFF)));
            for (NameValuePair nvp : this._pairs) {
                nvp.writeToByteArrayOutputStream(cp, baos);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("@");
            sb.append(this._type.toString());
            if (this._pairCount > 0) {
                sb.append("(");
                boolean first = true;
                for (NameValuePair nvp : this._pairs) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(nvp.toString());
                }
                sb.append(")");
            }
            return sb.toString();
        }

        public String toStringJava() {
            StringBuilder sb = new StringBuilder();
            sb.append("@");
            String typeName = ClassFileTools.getTypeString(this._type.toString(), "").replace('$', '.');
            typeName = typeName.substring(0, typeName.length() - 1);
            sb.append(typeName);
            if (this._pairCount > 0) {
                sb.append("(");
                boolean first = true;
                for (NameValuePair nvp : this._pairs) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(nvp.toString());
                }
                sb.append(")");
            }
            return sb.toString();
        }

        public String getType() {
            return this._type.toString();
        }

        public List<NameValuePair> getPairs() {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            for (NameValuePair nvp : this._pairs) {
                list.add(nvp);
            }
            return list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Annotation that = (Annotation)o;
            if (this._pairCount != that._pairCount) {
                return false;
            }
            if (!Arrays.equals(this._pairs, that._pairs)) {
                return false;
            }
            return !(this._type != null ? !this._type.equals(that._type) : that._type != null);
        }

        public int hashCode() {
            int result = this._type != null ? this._type.hashCode() : 0;
            result = 31 * result + this._pairCount;
            result = 31 * result + (this._pairs != null ? Arrays.hashCode(this._pairs) : 0);
            return result;
        }

        public static class NameValuePair {
            private AUTFPoolInfo name;
            private AMemberValue value;

            public NameValuePair(AUTFPoolInfo name, AMemberValue value) {
                this.name = name;
                this.value = value;
            }

            public NameValuePair(ConstantPool cp, byte[] data, int start) {
                this.name = ((APoolInfo)cp.get(Types.ushortFromBytes(data, start + 0))).execute(CheckUTFVisitor.singleton(), null);
                this.value = AMemberValue.read(cp, data, start + 2);
            }

            public int getSize() {
                return 2 + this.value.getSize();
            }

            public void writeToByteArrayOutputStream(ConstantPool cp, ByteArrayOutputStream baos) throws IOException {
                baos.write(Types.bytesFromShort(cp.indexOf(this.name)));
                this.value.writeToByteArrayOutputStream(cp, baos);
            }

            public String toString() {
                return this.name.toString() + " = " + this.value.toString();
            }

            public AUTFPoolInfo getName() {
                return this.name;
            }

            public AMemberValue getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                NameValuePair that = (NameValuePair)o;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                    return false;
                }
                return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
            }

            public int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ArrayMemberValue
        extends AMemberValue {
            int numEntries;
            AMemberValue[] entries;

            public ArrayMemberValue(char tag, int numEntries, AMemberValue[] entries) {
                super(tag);
                assert (numEntries <= 65535);
                this.numEntries = numEntries;
                this.entries = entries;
            }

            public ArrayMemberValue(ConstantPool cp, byte[] data, int start) {
                super((char)data[start]);
                this.numEntries = Types.ushortFromBytes(data, start + 1);
                this.entries = new AMemberValue[this.numEntries];
                int index = start + 3;
                for (int i = 0; i < this.numEntries; ++i) {
                    this.entries[i] = AMemberValue.read(cp, data, index);
                    index += this.entries[i].getSize();
                }
            }

            @Override
            public int getSize() {
                int accum = 3;
                for (AMemberValue mv : this.entries) {
                    accum += mv.getSize();
                }
                return accum;
            }

            @Override
            public void writeToByteArrayOutputStream(ConstantPool cp, ByteArrayOutputStream baos) throws IOException {
                baos.write(this.tag);
                baos.write(Types.bytesFromShort((short)(this.numEntries & 0xFFFF)));
                for (AMemberValue mv : this.entries) {
                    mv.writeToByteArrayOutputStream(cp, baos);
                }
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                boolean first = true;
                for (AMemberValue mv : this.entries) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(mv.toString());
                }
                sb.append("}");
                return sb.toString();
            }

            @Override
            public String toStringJava() {
                return this.toString();
            }

            @Override
            public <R, P> R execute(IMemberValueVisitor<R, P> v, P param) {
                return v.arrayMemberCase(this, param);
            }

            public AMemberValue[] getEntries() {
                return this.entries;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ArrayMemberValue that = (ArrayMemberValue)o;
                if (this.numEntries != that.numEntries) {
                    return false;
                }
                return Arrays.equals(this.entries, that.entries);
            }

            @Override
            public int hashCode() {
                int result = this.numEntries;
                result = 31 * result + (this.entries != null ? Arrays.hashCode(this.entries) : 0);
                return result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class AnnotationMemberValue
        extends AMemberValue {
            Annotation annotation;

            public AnnotationMemberValue(char tag, Annotation annotation) {
                super(tag);
                this.annotation = annotation;
            }

            @Override
            public int getSize() {
                return 1 + this.annotation.getSize();
            }

            @Override
            public void writeToByteArrayOutputStream(ConstantPool cp, ByteArrayOutputStream baos) throws IOException {
                baos.write(this.tag);
                this.annotation.writeToByteArrayOutputStream(cp, baos);
            }

            public String toString() {
                return this.annotation.toString();
            }

            @Override
            public String toStringJava() {
                return this.annotation.toStringJava();
            }

            @Override
            public <R, P> R execute(IMemberValueVisitor<R, P> v, P param) {
                return v.annotationMemberCase(this, param);
            }

            public Annotation getAnnotation() {
                return this.annotation;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                AnnotationMemberValue that = (AnnotationMemberValue)o;
                return !(this.annotation != null ? !this.annotation.equals(that.annotation) : that.annotation != null);
            }

            @Override
            public int hashCode() {
                return this.annotation != null ? this.annotation.hashCode() : 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ClassMemberValue
        extends AMemberValue {
            AUTFPoolInfo classNameInfo;

            public ClassMemberValue(char tag, AUTFPoolInfo classNameInfo) {
                super(tag);
                this.classNameInfo = classNameInfo;
            }

            @Override
            public int getSize() {
                return 3;
            }

            @Override
            public void writeToByteArrayOutputStream(ConstantPool cp, ByteArrayOutputStream baos) throws IOException {
                baos.write(this.tag);
                baos.write(Types.bytesFromShort(cp.indexOf(this.classNameInfo)));
            }

            public String toString() {
                return this.classNameInfo.toString();
            }

            @Override
            public String toStringJava() {
                String s = ClassFileTools.getTypeString(this.classNameInfo.toString(), "").replace('$', '.');
                return s.substring(0, s.length() - 1) + ".class";
            }

            @Override
            public <R, P> R execute(IMemberValueVisitor<R, P> v, P param) {
                return v.classMemberCase(this, param);
            }

            public AUTFPoolInfo getClassName() {
                return this.classNameInfo;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ClassMemberValue that = (ClassMemberValue)o;
                return !(this.classNameInfo != null ? !this.classNameInfo.equals(that.classNameInfo) : that.classNameInfo != null);
            }

            @Override
            public int hashCode() {
                return this.classNameInfo != null ? this.classNameInfo.hashCode() : 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class EnumMemberValue
        extends AMemberValue {
            AUTFPoolInfo typeName;
            AUTFPoolInfo constValue;

            public EnumMemberValue(char tag, AUTFPoolInfo typeName, AUTFPoolInfo constValue) {
                super(tag);
                this.typeName = typeName;
                this.constValue = constValue;
            }

            @Override
            public int getSize() {
                return 5;
            }

            @Override
            public void writeToByteArrayOutputStream(ConstantPool cp, ByteArrayOutputStream baos) throws IOException {
                baos.write(this.tag);
                baos.write(Types.bytesFromShort(cp.indexOf(this.typeName)));
                baos.write(Types.bytesFromShort(cp.indexOf(this.constValue)));
            }

            public String toString() {
                return this.typeName.toString() + "." + this.constValue.toString();
            }

            @Override
            public String toStringJava() {
                String s = ClassFileTools.getTypeString(this.typeName.toString(), "").replace('$', '.');
                return s.substring(0, s.length() - 1) + "." + this.constValue.toString();
            }

            @Override
            public <R, P> R execute(IMemberValueVisitor<R, P> v, P param) {
                return v.enumMemberCase(this, param);
            }

            public AUTFPoolInfo getTypeName() {
                return this.typeName;
            }

            public AUTFPoolInfo getConstValue() {
                return this.constValue;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EnumMemberValue that = (EnumMemberValue)o;
                if (this.constValue != null ? !this.constValue.equals(that.constValue) : that.constValue != null) {
                    return false;
                }
                return !(this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null);
            }

            @Override
            public int hashCode() {
                int result = this.typeName != null ? this.typeName.hashCode() : 0;
                result = 31 * result + (this.constValue != null ? this.constValue.hashCode() : 0);
                return result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ConstantMemberValue
        extends AMemberValue {
            APoolInfo constValue;

            public ConstantMemberValue(char tag, APoolInfo constValue) {
                super(tag);
                this.constValue = constValue;
            }

            @Override
            public int getSize() {
                return 3;
            }

            @Override
            public void writeToByteArrayOutputStream(ConstantPool cp, ByteArrayOutputStream baos) throws IOException {
                baos.write(this.tag);
                baos.write(Types.bytesFromShort(cp.indexOf(this.constValue)));
            }

            public String toString() {
                return this.constValue.toString();
            }

            @Override
            public String toStringJava() {
                switch (this.tag) {
                    case 's': {
                        return "\"" + this.constValue.toString() + "\"";
                    }
                    case 'F': {
                        return this.constValue.toString() + "f";
                    }
                }
                return this.constValue.toString();
            }

            @Override
            public <R, P> R execute(IMemberValueVisitor<R, P> v, P param) {
                return v.constantMemberCase(this, param);
            }

            public APoolInfo getConstValue() {
                return this.constValue;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ConstantMemberValue that = (ConstantMemberValue)o;
                return !(this.constValue != null ? !this.constValue.equals(that.constValue) : that.constValue != null);
            }

            @Override
            public int hashCode() {
                return this.constValue != null ? this.constValue.hashCode() : 0;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class CheckConstantMemberVisitor
        extends ADefaultMemberValueVisitor<ConstantMemberValue, Object> {
            private static CheckConstantMemberVisitor _instance = new CheckConstantMemberVisitor();

            @Override
            public ConstantMemberValue defaultCase(AMemberValue host, Object param) {
                throw new RuntimeException("Constant annotation member value expected.");
            }

            @Override
            public ConstantMemberValue constantMemberCase(ConstantMemberValue host, Object param) {
                return host;
            }

            private CheckConstantMemberVisitor() {
            }

            public static CheckConstantMemberVisitor singleton() {
                return _instance;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class ADefaultMemberValueVisitor<R, P>
        implements IMemberValueVisitor<R, P> {
            public abstract R defaultCase(AMemberValue var1, P var2);

            @Override
            public R constantMemberCase(ConstantMemberValue host, P param) {
                return this.defaultCase(host, param);
            }

            @Override
            public R enumMemberCase(EnumMemberValue host, P param) {
                return this.defaultCase(host, param);
            }

            @Override
            public R classMemberCase(ClassMemberValue host, P param) {
                return this.defaultCase(host, param);
            }

            @Override
            public R annotationMemberCase(AnnotationMemberValue host, P param) {
                return this.defaultCase(host, param);
            }

            @Override
            public R arrayMemberCase(ArrayMemberValue host, P param) {
                return this.defaultCase(host, param);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IMemberValueVisitor<R, P> {
            public R constantMemberCase(ConstantMemberValue var1, P var2);

            public R enumMemberCase(EnumMemberValue var1, P var2);

            public R classMemberCase(ClassMemberValue var1, P var2);

            public R annotationMemberCase(AnnotationMemberValue var1, P var2);

            public R arrayMemberCase(ArrayMemberValue var1, P var2);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class AMemberValue {
            public char tag;

            protected AMemberValue(char tag) {
                this.tag = tag;
            }

            public abstract int getSize();

            public char getTag() {
                return this.tag;
            }

            public abstract void writeToByteArrayOutputStream(ConstantPool var1, ByteArrayOutputStream var2) throws IOException;

            public static AMemberValue read(ConstantPool cp, byte[] data, int start) {
                char tag = (char)data[start];
                if ("BCDFIJSZs".indexOf(tag) != -1) {
                    return new ConstantMemberValue(tag, (APoolInfo)cp.get(Types.ushortFromBytes(data, start + 1)));
                }
                if (tag == 'e') {
                    return new EnumMemberValue(tag, ((APoolInfo)cp.get(Types.ushortFromBytes(data, start + 1))).execute(CheckUTFVisitor.singleton(), null), ((APoolInfo)cp.get(Types.ushortFromBytes(data, start + 3))).execute(CheckUTFVisitor.singleton(), null));
                }
                if (tag == 'c') {
                    return new ClassMemberValue(tag, ((APoolInfo)cp.get(Types.ushortFromBytes(data, start + 1))).execute(CheckUTFVisitor.singleton(), null));
                }
                if (tag == '@') {
                    return new AnnotationMemberValue(tag, new Annotation(cp, data, start + 1));
                }
                if (tag == '[') {
                    return new ArrayMemberValue(cp, data, start);
                }
                throw new ClassFormatError("Unknown member value tag: " + tag);
            }

            public abstract String toStringJava();

            public abstract <R, P> R execute(IMemberValueVisitor<R, P> var1, P var2);

            public abstract int hashCode();

            public abstract boolean equals(Object var1);
        }
    }
}

