/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import java.applet.AudioClip;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class SunAudioClip
implements AudioClip {
    private static boolean initialized;
    private static Class audioPlayerClass;
    private static Class audioStreamClass;
    private static Class audioDataClass;
    private static Class audioDataStreamClass;
    private static Class continuousAudioDataStreamClass;
    private static Constructor audioDataConstructor;
    private static Constructor audioDataStreamConstructor;
    private static Constructor continuousAudioDataStreamConstructor;
    private static Method getData;
    private Object player;
    private Object audioData;
    private Object audioDataStream;
    private Object continuousAudioDataStream;
    private Method audioPlayerStart;
    private Method audioPlayerStop;

    public SunAudioClip(InputStream inputStream) {
        if (!initialized) {
            SunAudioClip.initStaticData();
            initialized = true;
        }
        try {
            Object[] objectArray = new Object[]{inputStream};
            Object t = audioDataConstructor.newInstance(objectArray);
            this.audioData = getData.invoke(t, new Object[0]);
            this.player = audioPlayerClass.getField("player").get(null);
            Class[] classArray = new Class[]{Class.forName("java.io.InputStream")};
            this.audioPlayerStart = this.player.getClass().getMethod("start", classArray);
            this.audioPlayerStop = this.player.getClass().getMethod("stop", classArray);
        }
        catch (Exception exception) {}
    }

    public void play() {
        try {
            Object[] objectArray = new Object[]{this.audioData};
            objectArray[0] = this.audioDataStream = audioDataStreamConstructor.newInstance(objectArray);
            this.audioPlayerStart.invoke(this.player, objectArray);
        }
        catch (Exception exception) {}
    }

    public void loop() {
        try {
            Object[] objectArray = new Object[]{this.audioData};
            objectArray[0] = this.continuousAudioDataStream = continuousAudioDataStreamConstructor.newInstance(objectArray);
            this.audioPlayerStart.invoke(this.player, objectArray);
        }
        catch (Exception exception) {}
    }

    public void stop() {
        try {
            Object[] objectArray = new Object[1];
            if (this.continuousAudioDataStream != null) {
                objectArray[0] = this.audioDataStream;
                this.audioPlayerStop.invoke(this.player, objectArray);
            }
            if (this.audioDataStream != null) {
                objectArray[0] = this.continuousAudioDataStream;
                this.audioPlayerStop.invoke(this.player, objectArray);
            }
        }
        catch (Exception exception) {}
    }

    private static void initStaticData() {
        try {
            audioPlayerClass = Class.forName("sun.audio.AudioPlayer");
            audioStreamClass = Class.forName("sun.audio.AudioStream");
            audioDataClass = Class.forName("sun.audio.AudioData");
            audioDataStreamClass = Class.forName("sun.audio.AudioDataStream");
            continuousAudioDataStreamClass = Class.forName("sun.audio.ContinuousAudioDataStream");
            Class[] classArray = new Class[]{Class.forName("java.io.InputStream")};
            audioDataConstructor = audioStreamClass.getConstructor(classArray);
            getData = audioStreamClass.getMethod("getData", new Class[0]);
            Class[] classArray2 = new Class[]{audioDataClass};
            audioDataStreamConstructor = audioDataStreamClass.getConstructor(classArray2);
            continuousAudioDataStreamConstructor = continuousAudioDataStreamClass.getConstructor(classArray2);
        }
        catch (Exception exception) {}
    }
}

