/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.Animator;
import acm.util.ErrorException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SpeedBarListener
implements AdjustmentListener,
ChangeListener {
    private Animator animator;
    private Object speedBar;
    private Method getValue;
    private Method getMinimum;
    private Method getMaximum;

    public static void register(Animator animator, Object object) {
        SpeedBarListener speedBarListener = new SpeedBarListener();
        speedBarListener.animator = animator;
        speedBarListener.speedBar = object;
        Class<?> clazz = object.getClass();
        boolean bl = false;
        Method method = SpeedBarListener.lookForListener(clazz, "addAdjustmentListener", "java.awt.event.AdjustmentListener");
        if (method == null) {
            method = SpeedBarListener.lookForListener(clazz, "addChangeListener", "javax.swing.event.ChangeListener");
        }
        if (method == null) {
            method = SpeedBarListener.lookForListener(clazz, "addChangeListener", "ChangeListener");
            bl = true;
        }
        try {
            speedBarListener.getValue = clazz.getMethod("getValue", new Class[0]);
            speedBarListener.getMinimum = clazz.getMethod("getMinimum", new Class[0]);
            speedBarListener.getMaximum = clazz.getMethod("getMaximum", new Class[0]);
            Object[] objectArray = new Object[]{speedBarListener};
            if (bl) {
                Class<?> clazz2 = Class.forName("FakeChangeListener");
                Class[] classArray = new Class[]{Class.forName("java.awt.event.AdjustmentListener")};
                Constructor<?> constructor = clazz2.getConstructor(classArray);
                objectArray[0] = constructor.newInstance(objectArray);
            }
            method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException("Illegal speed bar object");
        }
        speedBarListener.setSpeed();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setSpeed();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setSpeed();
    }

    public void setSpeed() {
        try {
            int n = (Integer)this.getMinimum.invoke(this.speedBar, new Object[0]);
            int n2 = (Integer)this.getMaximum.invoke(this.speedBar, new Object[0]);
            int n3 = (Integer)this.getValue.invoke(this.speedBar, new Object[0]);
            double d = (double)(n3 - n) / (double)(n2 - n);
            this.animator.setSpeed(d);
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    private static Method lookForListener(Class clazz, String string, String string2) {
        try {
            Class[] classArray = new Class[]{Class.forName(string2)};
            return clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    SpeedBarListener() {
    }
}

