/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.graphics.GPoint;
import acm.program.GraphicsProgram;
import acm.util.ErrorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;

class GProgramListener
implements MouseListener,
MouseMotionListener {
    private GraphicsProgram myProgram;
    private Method mousePressedHook;
    private Method mouseReleasedHook;
    private Method mouseClickedHook;
    private Method mouseMovedHook;
    private Method mouseDraggedHook;
    private boolean clickFlag;

    public GProgramListener(GraphicsProgram graphicsProgram) {
        this.myProgram = graphicsProgram;
        try {
            Class<?> clazz = graphicsProgram.getClass();
            Class[] classArray = new Class[]{Class.forName("acm.graphics.GPoint")};
            try {
                this.mousePressedHook = clazz.getMethod("mousePressed", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                this.mouseReleasedHook = clazz.getMethod("mouseReleased", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                this.mouseClickedHook = clazz.getMethod("mouseClicked", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                this.mouseMovedHook = clazz.getMethod("mouseMoved", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            try {
                this.mouseDraggedHook = clazz.getMethod("mouseDragged", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
    }

    public boolean needsMouseMotionListeners() {
        return this.mouseMovedHook != null || this.mouseDraggedHook != null;
    }

    public void resetClickListener() {
        this.clickFlag = false;
    }

    public boolean clickOccurred() {
        return this.clickFlag;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object[] objectArray;
        if (this.mouseClickedHook != null) {
            objectArray = new Object[]{new GPoint(mouseEvent.getX(), mouseEvent.getY())};
            try {
                this.mouseClickedHook.invoke((Object)this.myProgram, objectArray);
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        }
        objectArray = this;
        synchronized (objectArray) {
            this.clickFlag = true;
            this.notifyAll();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mousePressedHook != null) {
            Object[] objectArray = new Object[]{new GPoint(mouseEvent.getX(), mouseEvent.getY())};
            try {
                this.mousePressedHook.invoke((Object)this.myProgram, objectArray);
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseReleasedHook != null) {
            Object[] objectArray = new Object[]{new GPoint(mouseEvent.getX(), mouseEvent.getY())};
            try {
                this.mouseReleasedHook.invoke((Object)this.myProgram, objectArray);
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.mouseMovedHook != null) {
            Object[] objectArray = new Object[]{new GPoint(mouseEvent.getX(), mouseEvent.getY())};
            try {
                this.mouseMovedHook.invoke((Object)this.myProgram, objectArray);
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseDraggedHook != null) {
            Object[] objectArray = new Object[]{new GPoint(mouseEvent.getX(), mouseEvent.getY())};
            try {
                this.mouseDraggedHook.invoke((Object)this.myProgram, objectArray);
            }
            catch (Exception exception) {
                throw new ErrorException(exception);
            }
        }
    }
}

