/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.AWTDialogModel;
import acm.io.DialogModel;
import acm.io.IOConsole;
import acm.io.IOModel;
import acm.util.CancelledException;
import acm.util.ErrorException;
import acm.util.Platform;
import java.awt.Component;
import java.lang.reflect.Constructor;

public class IODialog
implements IOModel {
    private boolean exceptionOnError;
    private boolean allowCancel;
    private DialogModel model;
    private Component myComponent;
    private IOConsole myConsole;
    private String outputLine;

    public IODialog() {
        this(null);
    }

    public IODialog(Component component) {
        this.myComponent = component;
        this.model = this.createModel();
        this.outputLine = "";
        this.exceptionOnError = false;
        this.allowCancel = false;
    }

    public void print(String string) {
        this.outputLine = String.valueOf(this.outputLine) + string;
    }

    public final void print(boolean bl) {
        this.print(String.valueOf(bl));
    }

    public final void print(char c) {
        this.print(String.valueOf(c));
    }

    public final void print(double d) {
        this.print(String.valueOf(d));
    }

    public final void print(float f) {
        this.print(String.valueOf(f));
    }

    public final void print(int n) {
        this.print(String.valueOf(n));
    }

    public final void print(long l) {
        this.print(String.valueOf(l));
    }

    public final void print(Object object) {
        this.print(String.valueOf(String.valueOf(object)));
    }

    public void println() {
        this.model.popupMessage(this.outputLine);
        this.outputLine = "";
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public final void println(boolean bl) {
        this.println(String.valueOf(bl));
    }

    public final void println(char c) {
        this.println(String.valueOf(c));
    }

    public final void println(double d) {
        this.println(String.valueOf(d));
    }

    public final void println(float f) {
        this.println(String.valueOf(f));
    }

    public final void println(int n) {
        this.println(String.valueOf(n));
    }

    public final void println(long l) {
        this.println(String.valueOf(l));
    }

    public final void println(Object object) {
        this.println(String.valueOf(String.valueOf(object)));
    }

    public void showErrorMessage(String string) {
        this.model.popupErrorMessage(string);
    }

    public final String readLine() {
        return this.readLine(null);
    }

    public String readLine(String string) {
        String string2;
        if (this.myConsole != null && this.myConsole.getInputScript() != null) {
            return this.myConsole.readLine(string);
        }
        string = string == null ? this.outputLine : String.valueOf(this.outputLine) + string;
        this.outputLine = "";
        while ((string2 = this.model.popupLineInputDialog(string, this.allowCancel)) == null) {
            if (!this.allowCancel) continue;
            throw new CancelledException();
        }
        return string2;
    }

    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public final int readInt(int n, int n2) {
        return this.readInt(null, n, n2);
    }

    public final int readInt(String string) {
        return this.readInt(string, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int readInt(String string, int n, int n2) {
        while (true) {
            String string2 = this.readLine(string);
            try {
                int n3 = Integer.parseInt(string2);
                if (n3 < n || n3 > n2) {
                    this.signalError("Value is outside the range [" + n + ":" + n2 + "]");
                }
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                this.signalError("Illegal integer format");
                continue;
            }
            break;
        }
    }

    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public final double readDouble(double d, double d2) {
        return this.readDouble(null, d, d2);
    }

    public final double readDouble(String string) {
        return this.readDouble(string, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public double readDouble(String string, double d, double d2) {
        while (true) {
            String string2 = this.readLine(string);
            try {
                double d3 = Double.valueOf(string2);
                if (d3 < d || d3 > d2) {
                    this.signalError("Value is outside the range [" + d + ":" + d2 + "]");
                }
                return d3;
            }
            catch (NumberFormatException numberFormatException) {
                this.signalError("Illegal numeric format");
                continue;
            }
            break;
        }
    }

    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    public final boolean readBoolean(String string) {
        return this.readBoolean(string, "true", "false");
    }

    public boolean readBoolean(String string, String string2, String string3) {
        Boolean bl;
        if (this.myConsole != null && this.myConsole.getInputScript() != null) {
            return this.myConsole.readBoolean(string, string2, string3);
        }
        string = string == null ? this.outputLine : String.valueOf(this.outputLine) + string;
        this.outputLine = "";
        while ((bl = this.model.popupBooleanInputDialog(string, string2, string3, this.allowCancel)) == null) {
            if (!this.allowCancel) continue;
            throw new CancelledException();
        }
        return bl;
    }

    public void setExceptionOnError(boolean bl) {
        this.exceptionOnError = bl;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public void setAllowCancel(boolean bl) {
        this.allowCancel = bl;
    }

    public boolean getAllowCancel() {
        return this.allowCancel;
    }

    public void setAssociatedConsole(IOConsole iOConsole) {
        this.myConsole = iOConsole;
    }

    public IOConsole getAssociatedConsole() {
        return this.myConsole;
    }

    protected DialogModel createModel() {
        if (Platform.isSwingAvailable()) {
            try {
                Class<?> clazz = Class.forName("acm.io.SwingDialogModel");
                Class[] classArray = new Class[]{Class.forName("java.awt.Component")};
                Object[] objectArray = new Object[]{this.myComponent};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                return (DialogModel)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                return new AWTDialogModel(this.myComponent);
            }
        }
        return new AWTDialogModel(this.myComponent);
    }

    private void signalError(String string) {
        if (this.exceptionOnError) {
            throw new ErrorException(string);
        }
        this.model.popupErrorMessage(string);
    }
}

