/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.ConsoleModel;
import acm.io.ConsoleReader;
import acm.io.ConsoleWriter;
import acm.io.IODialog;
import acm.io.IOModel;
import acm.io.SystemConsole;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.PrintJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class IOConsole
extends Container
implements IOModel {
    public static final IOConsole SYSTEM_CONSOLE = new SystemConsole();
    protected static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final int MINIMUM_CONSOLE_WIDTH = 50;
    protected static final int MINIMUM_CONSOLE_HEIGHT = 40;
    private ConsoleModel consoleModel = this.createConsoleModel();
    private boolean exceptionOnError;
    private BufferedReader reader;
    private PrintWriter writer;
    private File file;
    private Color inputColor;
    private int inputStyle;
    private Color errorColor;
    private int errorStyle;

    public IOConsole() {
        this.consoleModel.setConsole(this);
        this.setBackground(Color.white);
        this.setInputColor(Color.blue);
        this.setInputStyle(1);
        this.setErrorColor(Color.red);
        this.setErrorStyle(1);
        this.setFont(JTFTools.getStandardFont(DEFAULT_FONT));
        this.setLayout(new BorderLayout());
        this.add(this.consoleModel.getConsolePane(), "Center");
        this.reader = new BufferedReader(new ConsoleReader(this.consoleModel));
        this.writer = new PrintWriter(new ConsoleWriter(this.consoleModel));
        this.exceptionOnError = false;
    }

    public void clear() {
        this.consoleModel.clear();
    }

    public void print(String string) {
        this.writer.print(string);
    }

    public final void print(boolean bl) {
        this.print(String.valueOf(bl));
    }

    public final void print(char c) {
        this.print(String.valueOf(c));
    }

    public final void print(double d) {
        this.print(String.valueOf(d));
    }

    public final void print(float f) {
        this.print(String.valueOf(f));
    }

    public final void print(int n) {
        this.print(String.valueOf(n));
    }

    public final void print(long l) {
        this.print(String.valueOf(l));
    }

    public final void print(Object object) {
        this.print(String.valueOf(String.valueOf(object)));
    }

    public void println() {
        this.writer.println();
    }

    public void println(String string) {
        this.writer.println(string);
    }

    public final void println(boolean bl) {
        this.println(String.valueOf(bl));
    }

    public final void println(char c) {
        this.println(String.valueOf(c));
    }

    public final void println(double d) {
        this.println(String.valueOf(d));
    }

    public final void println(float f) {
        this.println(String.valueOf(f));
    }

    public final void println(int n) {
        this.println(String.valueOf(n));
    }

    public final void println(long l) {
        this.println(String.valueOf(l));
    }

    public final void println(Object object) {
        this.println(String.valueOf(String.valueOf(object)));
    }

    public void showErrorMessage(String string) {
        this.consoleModel.print(string, 2);
        this.consoleModel.print("\n", 2);
    }

    public final String readLine() {
        return this.readLine(null);
    }

    public String readLine(String string) {
        if (string != null) {
            this.print(string);
        }
        this.consoleModel.requestFocus();
        try {
            String string2 = this.reader.readLine();
            return string2;
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public final int readInt(int n, int n2) {
        return this.readInt(null, n, n2);
    }

    public final int readInt(String string) {
        return this.readInt(string, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int readInt(String string, int n, int n2) {
        String string2 = null;
        while (true) {
            String string3 = this.readLine(string);
            try {
                int n3 = Integer.parseInt(string3);
                if (n3 >= n && n3 <= n2) {
                    return n3;
                }
                string2 = "Value is outside the range [" + n + ":" + n2 + "]";
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "Illegal numeric format";
            }
            this.showErrorMessage(string2);
            if (string != null) continue;
            string = "Retry: ";
        }
    }

    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public final double readDouble(double d, double d2) {
        return this.readDouble(null, d, d2);
    }

    public final double readDouble(String string) {
        return this.readDouble(string, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public double readDouble(String string, double d, double d2) {
        String string2 = null;
        while (true) {
            String string3 = this.readLine(string);
            try {
                double d3 = Double.valueOf(string3);
                if (d3 >= d && d3 <= d2) {
                    return d3;
                }
                string2 = "Value is outside the range [" + d + ":" + d2 + "]";
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "Illegal numeric format";
            }
            this.showErrorMessage(string2);
            if (string != null) continue;
            string = "Retry: ";
        }
    }

    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    public final boolean readBoolean(String string) {
        return this.readBoolean(string, "true", "false");
    }

    public boolean readBoolean(String string, String string2, String string3) {
        while (true) {
            String string4;
            if ((string4 = this.readLine(string)) == null) {
                throw new ErrorException("End of file encountered");
            }
            if (string4.equalsIgnoreCase(string2)) {
                return true;
            }
            if (string4.equalsIgnoreCase(string3)) {
                return false;
            }
            if (this.exceptionOnError) {
                throw new ErrorException("Illegal boolean format");
            }
            this.showErrorMessage("Illegal boolean format");
            if (string != null) continue;
            string = "Retry: ";
        }
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setExceptionOnError(boolean bl) {
        this.exceptionOnError = bl;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public void setInputStyle(int n) {
        this.inputStyle = n;
        this.consoleModel.setInputStyle(n);
    }

    public int getInputStyle() {
        return this.inputStyle;
    }

    public void setInputColor(Color color) {
        this.inputColor = color;
        this.consoleModel.setInputColor(color);
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setErrorStyle(int n) {
        this.errorStyle = n;
        this.consoleModel.setErrorStyle(n);
    }

    public int getErrorStyle() {
        return this.errorStyle;
    }

    public void setErrorColor(Color color) {
        this.errorColor = color;
        this.consoleModel.setErrorColor(color);
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setBackground(Color color) {
        Component component = this.consoleModel.getTextPane();
        if (component != null) {
            component.setBackground(color);
        }
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        Component component = this.consoleModel.getTextPane();
        if (component != null) {
            component.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setFont(Font font) {
        font = JTFTools.getStandardFont(font);
        Component component = this.consoleModel.getTextPane();
        if (component != null) {
            component.setFont(font);
        }
        super.setFont(font);
    }

    public void setFont(String string) {
        this.setFont(JTFTools.decodeFont(string, this.getFont()));
    }

    public void setInputScript(BufferedReader bufferedReader) {
        this.consoleModel.setInputScript(bufferedReader);
    }

    public BufferedReader getInputScript() {
        return this.consoleModel.getInputScript();
    }

    public void cut() {
        this.consoleModel.cut();
    }

    public void copy() {
        this.consoleModel.copy();
    }

    public void paste() {
        this.consoleModel.paste();
    }

    public void selectAll() {
        this.consoleModel.selectAll();
    }

    public void save() {
        FileWriter fileWriter = null;
        while (fileWriter == null) {
            Object object;
            try {
                if (this.file == null) {
                    Frame frame = JTFTools.getEnclosingFrame(this);
                    if (frame == null) {
                        return;
                    }
                    object = System.getProperty("user.dir");
                    FileDialog fileDialog = new FileDialog(frame, "Save Console As", 1);
                    fileDialog.setDirectory((String)object);
                    ((Component)fileDialog).setVisible(true);
                    String string = fileDialog.getFile();
                    if (string == null) {
                        return;
                    }
                    this.file = new File(fileDialog.getDirectory(), string);
                }
                fileWriter = new FileWriter(this.file);
                this.save(fileWriter);
                ((Writer)fileWriter).close();
                Platform.setFileTypeAndCreator(this.file, "TEXT", "ttxt");
            }
            catch (IOException iOException) {
                object = new IODialog(this);
                ((IODialog)object).showErrorMessage(iOException.getMessage());
            }
        }
    }

    public void saveAs() {
        this.file = null;
        this.save();
    }

    public void save(Writer writer) {
        try {
            writer.write(this.consoleModel.getText());
        }
        catch (IOException iOException) {
            throw new ErrorException(iOException);
        }
    }

    public void printConsole() {
        Frame frame = JTFTools.getEnclosingFrame(this);
        if (frame == null) {
            return;
        }
        PrintJob printJob = this.getToolkit().getPrintJob(frame, "Console", null);
        if (printJob == null) {
            return;
        }
        this.printConsole(printJob);
        printJob.end();
    }

    public void printConsole(PrintJob printJob) {
        this.consoleModel.print(printJob);
    }

    public void script() {
        Frame frame = JTFTools.getEnclosingFrame(this);
        FileDialog fileDialog = new FileDialog(frame, "Input Script", 0);
        fileDialog.setDirectory(System.getProperty("user.dir"));
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null) {
            try {
                FileReader fileReader = new FileReader(new File(new File(string), string2));
                this.setInputScript(new BufferedReader(fileReader));
            }
            catch (IOException iOException) {
                throw new ErrorException(iOException);
            }
        }
    }

    public void requestFocus() {
        this.consoleModel.requestFocus();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 40);
    }

    protected ConsoleModel createConsoleModel() {
        return new ConsoleModel();
    }
}

