/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.gui.TableConstraints;
import acm.util.ErrorException;
import acm.util.OptionTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JScrollBar;

public class TableLayout
implements LayoutManager2 {
    public static final int NONE = 0;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int BOTH = 1;
    public static final int CENTER = 10;
    public static final int LEFT = 11;
    public static final int RIGHT = 12;
    public static final int TOP = 13;
    public static final int BOTTOM = 14;
    public static final int FILL = 1;
    private static final int LAYOUT_CONTAINER_MODE = 0;
    private static final int MINIMUM_LAYOUT_SIZE_MODE = 1;
    private static final int PREFERRED_LAYOUT_SIZE_MODE = 2;
    private static final int MINIMUM_SCROLLBAR_SIZE = 100;
    private Container targetContainer;
    private HashMap constraintTable;
    private HashMap layoutTable;
    private boolean useStrictGridBagModel;
    private boolean layoutInProgress;
    private int nRows;
    private int nColumns;
    private int horizontalAlignment;
    private int verticalAlignment;
    private int defaultFill;
    private int hGap;
    private int vGap;

    public TableLayout() {
        this(0, 0);
    }

    public TableLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public TableLayout(int n, int n2, int n3, int n4) {
        this.nRows = n;
        this.nColumns = n2;
        this.hGap = n3;
        this.vGap = n4;
        this.horizontalAlignment = 10;
        this.verticalAlignment = 10;
        this.defaultFill = 1;
        this.constraintTable = new HashMap();
        this.layoutTable = null;
    }

    public void setColumnCount(int n) {
        this.nColumns = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getColumnCount() {
        return this.nColumns;
    }

    public void setRowCount(int n) {
        this.nRows = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getRowCount() {
        return this.nRows;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setDefaultFill(int n) {
        this.defaultFill = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getDefaultFill() {
        return this.defaultFill;
    }

    public void setHgap(int n) {
        this.hGap = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getHgap() {
        return this.hGap;
    }

    public void setVgap(int n) {
        this.vGap = n;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public int getVgap() {
        return this.vGap;
    }

    public void setStrictGridBagModel(boolean bl) {
        this.useStrictGridBagModel = bl;
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public boolean isStrictGridBagModel() {
        return this.useStrictGridBagModel;
    }

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.constraintTable.put(component, gridBagConstraints.clone());
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public void setConstraints(Component component, String string) {
        this.setConstraints(component, new TableConstraints(string));
    }

    public TableConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
        return gridBagConstraints == null ? null : new TableConstraints(gridBagConstraints);
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void removeLayoutComponent(Component component) {
        this.constraintTable.remove(component);
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        if (container.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        return this.processLayout(container, 2);
    }

    public Dimension minimumLayoutSize(Container container) {
        if (container.getComponentCount() == 0) {
            return new Dimension(0, 0);
        }
        return this.processLayout(container, 1);
    }

    public void layoutContainer(Container container) {
        this.targetContainer = container;
        this.processLayout(container, 0);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            object = new TableConstraints("");
            ((TableConstraints)object).fill = this.defaultFill;
        } else if (object instanceof String) {
            OptionTable optionTable = new OptionTable(((String)object).toLowerCase(), TableConstraints.LEGAL_KEYS);
            object = new TableConstraints(optionTable);
            if (!optionTable.isSpecified("fill")) {
                ((TableConstraints)object).fill = optionTable.isSpecified("anchor") ? 0 : this.defaultFill;
            }
        } else if (!(object instanceof GridBagConstraints)) {
            throw new ErrorException("TableLayout: Illegal constraints");
        }
        this.constraintTable.put(component, object);
        if (this.targetContainer != null) {
            this.targetContainer.invalidate();
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            if (!this.layoutInProgress) {
                this.layoutTable = null;
            }
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = String.valueOf(string) + "[rows=" + this.nRows + ",columns=" + this.nColumns;
        if (this.hGap != 0) {
            string = String.valueOf(string) + ",hgap=" + this.hGap;
        }
        if (this.vGap != 0) {
            string = String.valueOf(string) + ",vgap=" + this.vGap;
        }
        string = String.valueOf(string) + "]";
        return string;
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        return (GridBagConstraints)this.constraintTable.get(component);
    }

    protected TableConstraints lookupConstraints(Component component, Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            if (this.layoutTable == null) {
                this.computeLayoutTable(container);
            }
            TableConstraints tableConstraints = (TableConstraints)this.layoutTable.get(component);
            Object var5_5 = null;
            return tableConstraints;
        }
    }

    private Dimension getMinimumComponentSize(Component component) {
        if (this.isScrollbar(component)) {
            return this.getMinimumScrollbarSize(component);
        }
        return component.getMinimumSize();
    }

    private Dimension getPreferredComponentSize(Component component) {
        if (this.isScrollbar(component)) {
            return this.getMinimumScrollbarSize(component);
        }
        return component.getPreferredSize();
    }

    private boolean isScrollbar(Component component) {
        if (component instanceof Scrollbar || component instanceof JScrollBar) {
            return true;
        }
        try {
            return Class.forName("ScrollbarLike").isInstance(component);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Dimension getMinimumScrollbarSize(Component component) {
        Dimension dimension = component.getMinimumSize();
        try {
            Class<?> clazz = component.getClass();
            Method method = clazz.getMethod("getOrientation", new Class[0]);
            int n = (Integer)method.invoke((Object)component, new Object[0]);
            if (n == 0) {
                dimension.width = Math.max(dimension.width, 100);
            } else {
                dimension.height = Math.max(dimension.height, 100);
            }
        }
        catch (Exception exception) {
            throw new ErrorException(exception);
        }
        return dimension;
    }

    private Dimension processLayout(Container container, int n) {
        Dimension dimension = null;
        Object object = container.getTreeLock();
        synchronized (object) {
            this.layoutInProgress = true;
            if (this.layoutTable == null) {
                this.computeLayoutTable(container);
            }
            int n2 = this.getIntProperty("nRows");
            int n3 = this.getIntProperty("nColumns");
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n3];
            int n4 = container.getComponentCount();
            int n5 = 0;
            while (n5 < n4) {
                Component component = container.getComponent(n5);
                TableConstraints tableConstraints = (TableConstraints)this.layoutTable.get(component);
                int n6 = tableConstraints.gridx;
                int n7 = tableConstraints.gridy;
                int n8 = this.getIntProperty("width" + n6);
                int n9 = this.getIntProperty("height" + n7);
                if (n8 == 0) {
                    n8 = n == 1 || this.useStrictGridBagModel ? this.getMinimumComponentSize((Component)component).width : this.getPreferredComponentSize((Component)component).width;
                    n8 += 2 * tableConstraints.ipadx + tableConstraints.insets.left + tableConstraints.insets.right;
                }
                if (n9 == 0) {
                    n9 = n == 1 || this.useStrictGridBagModel ? this.getMinimumComponentSize((Component)component).height : this.getPreferredComponentSize((Component)component).height;
                    n9 += 2 * tableConstraints.ipady + tableConstraints.insets.top + tableConstraints.insets.bottom;
                }
                nArray2[n6] = Math.max(nArray2[n6], n8);
                nArray[n7] = Math.max(nArray[n7], n9);
                ++n5;
            }
            int n10 = this.hGap;
            int n11 = this.vGap;
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n2];
            double d = 0.0;
            double d2 = 0.0;
            int n12 = 0;
            while (n12 < n3) {
                n10 += nArray2[n12] + this.hGap;
                dArray[n12] = this.getDoubleProperty("weightx" + n12);
                d += dArray[n12];
                ++n12;
            }
            int n13 = 0;
            while (n13 < n2) {
                n11 += nArray[n13] + this.vGap;
                dArray2[n13] = this.getDoubleProperty("weighty" + n13);
                d2 += dArray2[n13];
                ++n13;
            }
            if (n == 0) {
                int n14;
                int n15;
                Dimension dimension2 = container.getSize();
                Insets insets = container.getInsets();
                dimension2.width -= insets.left + insets.right;
                dimension2.height -= insets.top + insets.bottom;
                int n16 = dimension2.width - n10;
                int n17 = dimension2.height - n11;
                int n18 = insets.left;
                int n19 = insets.top;
                if (d == 0.0) {
                    switch (this.horizontalAlignment) {
                        case 11: {
                            n16 = 0;
                            break;
                        }
                        case 10: {
                            n18 += n16 / 2;
                            n16 = 0;
                            break;
                        }
                        case 12: {
                            n18 += n16;
                            n16 = 0;
                            break;
                        }
                        case 1: {
                            d = n3;
                            n15 = 0;
                            while (n15 < n3) {
                                dArray[n15] = 1.0;
                                ++n15;
                            }
                            break;
                        }
                    }
                }
                if (d2 == 0.0) {
                    switch (this.verticalAlignment) {
                        case 13: {
                            n17 = 0;
                            break;
                        }
                        case 10: {
                            n19 += n17 / 2;
                            n17 = 0;
                            break;
                        }
                        case 14: {
                            n19 += n17;
                            n17 = 0;
                            break;
                        }
                        case 1: {
                            d2 = n2;
                            n15 = 0;
                            while (n15 < n2) {
                                dArray2[n15] = 1.0;
                                ++n15;
                            }
                            break;
                        }
                    }
                }
                int[] nArray3 = new int[n3];
                int n20 = this.hGap + n18;
                int n21 = 0;
                while (n21 < n3) {
                    nArray3[n21] = n20;
                    if (n16 > 0) {
                        int n22 = (int)Math.round((double)n16 * dArray[n21] / d);
                        int n23 = n21;
                        nArray2[n23] = nArray2[n23] + n22;
                        n16 -= n22;
                        d -= dArray[n21];
                    }
                    n20 += nArray2[n21] + this.hGap;
                    ++n21;
                }
                int[] nArray4 = new int[n2];
                int n24 = this.vGap + n19;
                int n25 = 0;
                while (n25 < n2) {
                    nArray4[n25] = n24;
                    if (n17 > 0) {
                        n14 = (int)Math.round((double)n17 * dArray2[n25] / d2);
                        int n26 = n25;
                        nArray[n26] = nArray[n26] + n14;
                        n17 -= n14;
                        d2 -= dArray2[n25];
                    }
                    n24 += nArray[n25] + this.vGap;
                    ++n25;
                }
                n14 = 0;
                while (n14 < n4) {
                    Component component = container.getComponent(n14);
                    TableConstraints tableConstraints = (TableConstraints)this.layoutTable.get(component);
                    int n27 = tableConstraints.gridx;
                    int n28 = tableConstraints.gridy;
                    int n29 = nArray3[n27] + tableConstraints.insets.left;
                    int n30 = nArray4[n28] + tableConstraints.insets.top;
                    int n31 = nArray2[n27];
                    int n32 = 1;
                    while (n32 < tableConstraints.gridwidth && n27 + n32 < n3) {
                        n31 += nArray2[n27 + n32] + this.hGap;
                        ++n32;
                    }
                    n31 -= tableConstraints.insets.left + tableConstraints.insets.right;
                    int n33 = nArray[n28];
                    int n34 = 1;
                    while (n34 < tableConstraints.gridheight && n28 + n34 < n2) {
                        n33 += nArray[n28 + n34] + this.vGap;
                        ++n34;
                    }
                    Dimension dimension3 = this.useStrictGridBagModel ? this.getMinimumComponentSize(component) : this.getPreferredComponentSize(component);
                    Rectangle rectangle = this.computeCellBounds(new Rectangle(n29, n30, n31, n33 -= tableConstraints.insets.top + tableConstraints.insets.bottom), dimension3, tableConstraints);
                    component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    ++n14;
                }
            } else {
                dimension = new Dimension(n10, n11);
            }
            this.layoutInProgress = false;
        }
        return dimension;
    }

    /*
     * Unable to fully structure code
     */
    private void computeLayoutTable(Container var1_1) {
        var2_2 = null;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = this.nColumns;
        var6_6 = var1_1.getComponentCount();
        var7_7 = 0;
        this.layoutTable = new HashMap<K, V>();
        var8_8 = 0;
        while (var8_8 < var6_6) {
            var9_9 = var1_1.getComponent(var8_8);
            var10_10 = this.getConstraints(var9_9);
            if (var10_10.gridx != -1) {
                var4_4 = var10_10.gridx;
            }
            if (var10_10.gridy != -1) {
                var3_3 = var10_10.gridy;
            }
            if (this.nRows <= 0 || var3_3 < this.nRows) ** GOTO lbl28
            throw new ErrorException("TableLayout: Too many rows specified");
lbl-1000:
            // 1 sources

            {
                if (var5_5 <= 0 || ++var4_4 < var5_5) continue;
                var11_11 = 0;
                while (var11_11 < var2_2.length) {
                    if (var2_2[var11_11] > 0) {
                        v0 = var11_11;
                        var2_2[v0] = var2_2[v0] - true;
                    }
                    ++var11_11;
                }
                ++var3_3;
                var4_4 = this.getFirstAvailableColumn(var2_2);
lbl28:
                // 3 sources

                ** while (var2_2 != null && var4_4 < var2_2.length && var2_2[var4_4] > 0)
            }
lbl29:
            // 1 sources

            var10_10.gridx = var4_4;
            var10_10.gridy = var3_3;
            var11_11 = var7_7;
            this.setMaxProperty("width" + var4_4, var10_10.width);
            this.setMaxProperty("height" + var3_3, var10_10.height);
            this.setMaxProperty("weightx" + var4_4, var10_10.weightx);
            this.setMaxProperty("weighty" + var3_3, var10_10.weighty);
            var12_12 = 1;
            switch (var10_10.gridwidth) {
                case 0: {
                    var11_11 = 1;
                    if (var5_5 <= 0) break;
                    var12_12 = var5_5 - var4_4;
                    break;
                }
                case -1: {
                    if (var5_5 <= 0) {
                        throw new ErrorException("TableLayout: Illegal to use gridwidth=RELATIVE in first row");
                    }
                    var12_12 = var5_5 - var4_4 - 1;
                    var7_7 = 1;
                    break;
                }
                default: {
                    var12_12 = var10_10.gridwidth;
                    v1 = var11_11 = this.nColumns <= 0 || var4_4 + var10_10.gridwidth < this.nColumns ? 0 : 1;
                }
            }
            if (var12_12 > 1 && var2_2 != null) {
                var13_13 = var4_4;
                while (var13_13 < Math.min(var2_2.length, var4_4 + var12_12)) {
                    if (var2_2[var13_13] != false) {
                        throw new ErrorException("TableLayout: Overlapping cells");
                    }
                    ++var13_13;
                }
            }
            var13_13 = 1;
            switch (var10_10.gridheight) {
                case 0: {
                    var13_13 = 0x7FFFFFFF;
                    break;
                }
                case -1: {
                    throw new ErrorException("TableLayout: Illegal to use gridheight=RELATIVE");
                }
                default: {
                    var13_13 = var10_10.gridheight;
                }
            }
            if (var13_13 > 1) {
                if (var2_2 == null) {
                    var2_2 = new int[var4_4 + var12_12];
                } else if (var2_2.length < var4_4 + var12_12) {
                    var14_15 = var2_2;
                    var2_2 = new int[var4_4 + var12_12];
                    System.arraycopy(var14_15, 0, var2_2, 0, var14_15.length);
                }
                var14_14 = var4_4;
                while (var14_14 < var4_4 + var12_12) {
                    var2_2[var14_14] = var13_13;
                    ++var14_14;
                }
            }
            var10_10.gridwidth = var12_12;
            var10_10.gridheight = var13_13;
            this.layoutTable.put(var9_9, var10_10);
            var4_4 += var12_12;
            while (var11_11 != 0 || var5_5 > 0 && var4_4 >= var5_5) {
                if (var5_5 <= 0) {
                    var5_5 = var4_4;
                }
                if (var2_2 != null) {
                    var14_14 = 0;
                    while (var14_14 < var2_2.length) {
                        if (var2_2[var14_14] > 0) {
                            v2 = var14_14;
                            var2_2[v2] = var2_2[v2] - 1;
                        }
                        ++var14_14;
                    }
                }
                ++var3_3;
                var4_4 = this.getFirstAvailableColumn(var2_2);
                var11_11 = 0;
            }
            ++var8_8;
        }
        if (var5_5 <= 0) {
            var5_5 = var4_4;
        }
        this.setIntProperty("nColumns", var5_5);
        this.setIntProperty("nRows", var3_3 + 1);
    }

    private Rectangle computeCellBounds(Rectangle rectangle, Dimension dimension, TableConstraints tableConstraints) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (tableConstraints.fill == 0 || tableConstraints.fill == 3) {
            n3 = dimension.width;
        }
        if (tableConstraints.fill == 0 || tableConstraints.fill == 2) {
            n4 = dimension.height;
        }
        if (n3 != rectangle.width) {
            switch (tableConstraints.anchor) {
                case 10: 
                case 11: 
                case 15: {
                    n += (rectangle.width - n3) / 2;
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    n += rectangle.width - n3;
                    break;
                }
            }
        }
        if (n4 != rectangle.height) {
            switch (tableConstraints.anchor) {
                case 10: 
                case 13: 
                case 17: {
                    n2 += (rectangle.height - n4) / 2;
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    n2 += rectangle.height - n4;
                    break;
                }
            }
        }
        return new Rectangle(n, n2, n3, n4);
    }

    private void setMaxProperty(String string, int n) {
        this.setIntProperty(string, Math.max(n, this.getIntProperty(string)));
    }

    private void setMaxProperty(String string, double d) {
        this.setDoubleProperty(string, Math.max(d, this.getDoubleProperty(string)));
    }

    private void setIntProperty(String string, int n) {
        this.layoutTable.put(string, new Integer(n));
    }

    private int getIntProperty(String string) {
        Object v = this.layoutTable.get(string);
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    private void setDoubleProperty(String string, double d) {
        this.layoutTable.put(string, new Double(d));
    }

    private double getDoubleProperty(String string) {
        Object v = this.layoutTable.get(string);
        if (v == null) {
            return 0.0;
        }
        return (Double)v;
    }

    private int getFirstAvailableColumn(int[] nArray) {
        if (this.useStrictGridBagModel && nArray != null) {
            int n = nArray.length;
            while (n > 0) {
                if (nArray[n - 1] > 0) {
                    return n;
                }
                --n;
            }
        }
        return 0;
    }
}

