/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.graphics.GScalable;
import acm.util.MediaTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class GImage
extends GObject
implements GResizable,
GScalable {
    private Image myImage;
    private double myWidth;
    private double myHeight;
    private boolean sizeDetermined;

    public GImage(Image image) {
        this(image, 0.0, 0.0);
    }

    public GImage(String string) {
        this(string, 0.0, 0.0);
    }

    public GImage(Image image, double d, double d2) {
        this.setImage(image);
        this.setLocation(d, d2);
    }

    public GImage(String string, double d, double d2) {
        this(MediaTools.loadImage(string), d, d2);
    }

    public void setImage(Image image) {
        this.myImage = MediaTools.loadImage(image);
        this.determineSize();
    }

    public void setImage(String string) {
        this.setImage(MediaTools.loadImage(string));
    }

    public Image getImage() {
        return this.myImage;
    }

    public void paint(Graphics graphics) {
        Component component = this.getComponent();
        if (component == null) {
            component = MediaTools.getImageObserver();
        }
        if (this.myImage != null && component != null) {
            Rectangle rectangle = this.getAWTBounds();
            Color color = this.getObjectColor();
            if (color == null) {
                graphics.drawImage(this.myImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, component);
            } else {
                graphics.drawImage(this.myImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, component);
            }
        }
    }

    public void setSize(double d, double d2) {
        this.myWidth = d;
        this.myHeight = d2;
        this.repaint();
    }

    public final void setSize(GDimension gDimension) {
        this.setSize(gDimension.getWidth(), gDimension.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.myWidth, this.myHeight);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.myWidth = d3;
        this.myHeight = d4;
        this.setLocation(d, d2);
    }

    public final void setBounds(GRectangle gRectangle) {
        this.setBounds(gRectangle.getX(), gRectangle.getY(), gRectangle.getWidth(), gRectangle.getHeight());
    }

    public GRectangle getBounds() {
        this.determineSize();
        return new GRectangle(this.getX(), this.getY(), this.myWidth, this.myHeight);
    }

    public void scale(double d, double d2) {
        this.myWidth *= d;
        this.myHeight *= d2;
        this.repaint();
    }

    public final void scale(double d) {
        this.scale(d, d);
    }

    protected Rectangle getAWTBounds() {
        this.determineSize();
        return new Rectangle(GMath.round(this.getX()), GMath.round(this.getY()), GMath.round(this.myWidth), GMath.round(this.myHeight));
    }

    private void determineSize() {
        if (this.sizeDetermined) {
            return;
        }
        Component component = this.getComponent();
        if (component == null) {
            component = MediaTools.getImageObserver();
        }
        this.myWidth = this.myImage.getWidth(component);
        this.myHeight = this.myImage.getHeight(component);
        this.sizeDetermined = true;
    }
}

