/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvas;
import acm.graphics.GContainer;
import acm.graphics.GMath;
import acm.graphics.GMouseEvent;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GScalable;
import acm.util.ErrorException;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;

public class GCompound
extends GObject
implements GContainer,
GScalable {
    private boolean complete = false;
    private ArrayList contents = new ArrayList();
    private GObject lastObject;
    private GObject dragObject;

    public void add(GObject gObject) {
        if (this.complete) {
            throw new ErrorException("You can't add objects to a GCompound that has been marked as complete.");
        }
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            if (gObject.getParent() != null) {
                gObject.getParent().remove(gObject);
            }
            gObject.setParent(this);
            this.contents.add(gObject);
        }
        this.repaint();
    }

    public final void add(GObject gObject, double d, double d2) {
        this.add(gObject);
        gObject.setLocation(d, d2);
    }

    public final void add(GObject gObject, GPoint gPoint) {
        this.add(gObject, gPoint.getX(), gPoint.getY());
    }

    public void remove(GObject gObject) {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            ((AbstractCollection)this.contents).remove(gObject);
            gObject.setParent(null);
        }
        this.repaint();
    }

    public void removeAll() {
        if (this.complete) {
            throw new ErrorException("You can't remove objects from a GCompound that has been marked as complete.");
        }
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            this.contents.clear();
        }
        this.repaint();
    }

    public int getElementCount() {
        return this.contents.size();
    }

    public GObject getElement(int n) {
        return (GObject)this.contents.get(n);
    }

    public GObject getElementAt(double d, double d2) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.getElementCount() - 1;
            while (n >= 0) {
                GObject gObject = this.getElement(n);
                if (gObject.contains(d, d2)) {
                    GObject gObject2 = gObject;
                    Object var7_7 = null;
                    return gObject2;
                }
                --n;
            }
        }
        return null;
    }

    public final GObject getElementAt(GPoint gPoint) {
        return this.getElementAt(gPoint.getX(), gPoint.getY());
    }

    public Iterator iterator() {
        return this.iterator(0);
    }

    public Iterator iterator(int n) {
        return GCompound.createIterator(this, n);
    }

    public void paint(Graphics graphics) {
        graphics = graphics.create();
        graphics.translate(GMath.round(this.getX()), GMath.round(this.getY()));
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.size();
            int n2 = 0;
            while (n2 < n) {
                ((GObject)this.contents.get(n2)).paintObject(graphics);
                ++n2;
            }
        }
    }

    public void scale(double d, double d2) {
        Component component = this.getComponent();
        boolean bl = false;
        if (component instanceof GCanvas) {
            bl = ((GCanvas)component).getAutoRepaintFlag();
            ((GCanvas)component).setAutoRepaintFlag(false);
        }
        int n = this.getElementCount() - 1;
        while (n >= 0) {
            GObject gObject = this.getElement(n);
            gObject.setLocation(d * gObject.getX(), d2 * gObject.getY());
            if (gObject instanceof GScalable) {
                ((GScalable)((Object)gObject)).scale(d, d2);
            }
            --n;
        }
        if (component instanceof GCanvas) {
            ((GCanvas)component).setAutoRepaintFlag(bl);
        }
        this.repaint();
    }

    public final void scale(double d) {
        this.scale(d, d);
    }

    public GRectangle getBounds() {
        GRectangle gRectangle = new GRectangle();
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.size();
            int n2 = 0;
            while (n2 < n) {
                if (n2 == 0) {
                    gRectangle = new GRectangle(((GObject)this.contents.get(n2)).getBounds());
                } else {
                    gRectangle.add(((GObject)this.contents.get(n2)).getBounds());
                }
                ++n2;
            }
        }
        gRectangle.translate(this.getX(), this.getY());
        return gRectangle;
    }

    public boolean contains(double d, double d2) {
        double d3 = d - this.getX();
        double d4 = d2 - this.getY();
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.size();
            int n2 = 0;
            while (n2 < n) {
                if (((GObject)this.contents.get(n2)).contains(d3, d4)) {
                    boolean bl = true;
                    Object var11_9 = null;
                    return bl;
                }
                ++n2;
            }
        }
        return false;
    }

    public final GPoint getCanvasPoint(GPoint gPoint) {
        return this.getCanvasPoint(gPoint.getX(), gPoint.getY());
    }

    public GPoint getCanvasPoint(double d, double d2) {
        GContainer gContainer = this;
        while (gContainer instanceof GCompound) {
            GCompound gCompound = gContainer;
            d += gCompound.getX();
            d2 += gCompound.getY();
            gContainer = gCompound.getParent();
        }
        return new GPoint(d, d2);
    }

    public final GPoint getLocalPoint(GPoint gPoint) {
        return this.getLocalPoint(gPoint.getX(), gPoint.getY());
    }

    public GPoint getLocalPoint(double d, double d2) {
        GContainer gContainer = this;
        while (gContainer instanceof GCompound) {
            GCompound gCompound = gContainer;
            d -= gCompound.getX();
            d2 -= gCompound.getY();
            gContainer = gCompound.getParent();
        }
        return new GPoint(d, d2);
    }

    public void markAsComplete() {
        this.complete = true;
    }

    protected void sendToFront(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.indexOf(gObject);
            if (n >= 0) {
                this.contents.remove(n);
                this.contents.add(gObject);
            }
        }
        this.repaint();
    }

    protected void sendToBack(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.indexOf(gObject);
            if (n >= 0) {
                this.contents.remove(n);
                this.contents.add(0, gObject);
            }
        }
        this.repaint();
    }

    protected void sendForward(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.indexOf(gObject);
            if (n >= 0) {
                this.contents.remove(n);
                this.contents.add(Math.min(this.contents.size(), n + 1), gObject);
            }
        }
        this.repaint();
    }

    protected void sendBackward(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.indexOf(gObject);
            if (n >= 0) {
                this.contents.remove(n);
                this.contents.add(Math.max(0, n - 1), gObject);
            }
        }
        this.repaint();
    }

    protected void fireMouseListeners(MouseEvent mouseEvent) {
        int n;
        if (super.areMouseListenersEnabled()) {
            super.fireMouseListeners(mouseEvent);
            return;
        }
        GPoint gPoint = new GPoint((double)mouseEvent.getX() - this.getX(), (double)mouseEvent.getY() - this.getY());
        GObject gObject = this.getElementAt(gPoint);
        GMouseEvent gMouseEvent = null;
        if (gObject != this.lastObject) {
            if (this.lastObject != null) {
                gMouseEvent = new GMouseEvent(this.lastObject, 505, mouseEvent);
                this.lastObject.fireMouseListeners(gMouseEvent);
            }
            if (gObject != null) {
                gMouseEvent = new GMouseEvent(gObject, 504, mouseEvent);
                gObject.fireMouseListeners(gMouseEvent);
            }
        }
        this.lastObject = gObject;
        if (this.dragObject != null) {
            gObject = this.dragObject;
        }
        if (gObject != null && (n = mouseEvent.getID()) != 505 && n != 504) {
            if (n == 501) {
                this.dragObject = gObject;
            } else if (n == 502) {
                this.dragObject = null;
            }
            gMouseEvent = new GMouseEvent(gObject, n, mouseEvent);
            gObject.fireMouseListeners(gMouseEvent);
        }
        if (gMouseEvent != null && gMouseEvent.isConsumed()) {
            mouseEvent.consume();
        }
    }

    protected boolean areMouseListenersEnabled() {
        if (super.areMouseListenersEnabled()) {
            return true;
        }
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.size();
            int n2 = 0;
            while (n2 < n) {
                GObject gObject = (GObject)this.contents.get(n2);
                if (gObject.areMouseListenersEnabled()) {
                    boolean bl = true;
                    Object var3_6 = null;
                    return bl;
                }
                ++n2;
            }
        }
        return false;
    }

    protected static Iterator createIterator(GContainer gContainer, int n) {
        try {
            Class<?> clazz = Class.forName("acm.graphics.GIterator");
            Class[] classArray = new Class[]{Class.forName("acm.graphics.GContainer"), Integer.TYPE};
            Object[] objectArray = new Object[]{gContainer, new Integer(n)};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return (Iterator)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new ErrorException("Unable to create an Iterator on this platform.");
        }
    }
}

