/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPoint;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import acm.util.MediaTools;
import acm.util.RandomGenerator;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.event.MouseEvent;

public class Breakout
extends GraphicsProgram {
    private static final int WIDTH = 460;
    private static final int HEIGHT = 610;
    private static final int WIDTH_OF_PADDLE = 58;
    private static final int HEIGHT_OF_PADDLE = 11;
    private static final int PADDLE_OFFSET = 30;
    private static final int BRICK_SEP_H = 5;
    private static final int BRICK_SEP_V = 4;
    private static final int BRICK_HEIGHT = 8;
    private static final int BRICK_Y_BOTTOM_OFFSET = 71;
    private static int BRICKS_IN_ROW = 10;
    private static int BRICK_ROWS = 10;
    private static int BRICK_WIDTH = 460 / BRICKS_IN_ROW - 5;
    private static final int BALL_RADIUS = 10;
    private static final int NTURNS = 3;
    private static final Color[] rowColors = new Color[]{Color.red, Color.red, Color.orange, Color.orange, Color.yellow, Color.yellow, Color.green, Color.green, Color.cyan, Color.cyan};
    private GRect paddle = null;
    private GOval ball = null;
    private double vx;
    private double vy;
    private RandomGenerator rgen = new RandomGenerator();
    private int numBricks = 0;
    private int ballsTried = 0;
    private static AudioClip bounceClip = MediaTools.loadAudioClip("bounce.au");

    public static void main(String[] args) {
        Breakout.fixBricks(args);
        String[] sizeArgs = new String[]{"width=460", "height=610"};
        new Breakout().start(sizeArgs);
    }

    public static void fixBricks(String[] b) {
        if (b == null || b.length != 2) {
            return;
        }
        try {
            int bricksInRow = Integer.valueOf(b[0]);
            int brickRows = Integer.valueOf(b[1]);
            if (bricksInRow <= 0 || brickRows <= 0) {
                return;
            }
            BRICKS_IN_ROW = bricksInRow;
            BRICK_ROWS = brickRows;
            BRICK_WIDTH = 460 / BRICKS_IN_ROW - 5;
        }
        catch (Exception nfe) {
            System.out.println("Unrecognized argument format");
        }
    }

    @Override
    public void run() {
        while (true) {
            this.initialize();
            GLabel g = new GLabel("Click mouse to play");
            this.add(g, 10.0, this.paddle.getY() - 20.0);
            this.waitForClick();
            this.pause(500.0);
            this.remove(g);
            this.play();
        }
    }

    private void initialize() {
        this.placeBricks();
        this.placePaddle();
    }

    private void play() {
        this.ballsTried = 0;
        while (this.ballsTried < 3 && this.numBricks > 0) {
            this.placeBall();
            boolean ballInPlay = true;
            while (this.numBricks > 0 && ballInPlay) {
                ballInPlay = this.moveBall();
                if (!ballInPlay && this.ballsTried < 3) {
                    GLabel g = new GLabel("You lost a ball. Get ready for the next one in 3 seconds.");
                    this.add(g, 10.0, this.paddle.getY() - 20.0);
                    this.pause(3000.0);
                    this.remove(g);
                }
                this.pause(10.0);
            }
        }
        GLabel g = this.ballsTried == 3 ? new GLabel("You lose. Three balls are gone. Click the mouse to play again.") : new GLabel("You win! Congratulations! Click the mouse to play again.");
        this.add(g, 10.0, this.paddle.getY() - 20.0);
        this.waitForClick();
        this.pause(500.0);
        this.removeAll();
    }

    public boolean moveBall() {
        this.ball.move(this.vx, this.vy);
        if (this.vx < 0.0 && this.ball.getX() <= 0.0 || this.vx > 0.0 && this.ball.getX() + 20.0 >= 460.0) {
            this.vx = -this.vx;
        }
        if (this.ball.getY() + 20.0 >= 610.0) {
            this.remove(this.ball);
            ++this.ballsTried;
            return false;
        }
        GObject collider = this.getCollidingObject();
        if (collider == this.paddle && this.vy > 0.0) {
            this.fixBallDirection(collider);
            return true;
        }
        if (collider instanceof Brick) {
            this.fixBallDirection(collider);
            ((Brick)collider).squeak(this);
            this.remove(collider);
            --this.numBricks;
            return true;
        }
        if (this.vy < 0.0 && this.ball.getY() <= 0.0) {
            this.vy = -this.vy;
        }
        return true;
    }

    public GObject getCollidingObject() {
        double y;
        double x = this.ball.getX();
        GObject e = this.getElementAt(x, y = this.ball.getY());
        if (e != null) {
            return e;
        }
        e = this.getElementAt(x + 20.0, y);
        if (e != null) {
            return e;
        }
        e = this.getElementAt(x, y + 20.0);
        if (e != null) {
            return e;
        }
        e = this.getElementAt(x + 20.0, y + 20.0);
        if (e != null) {
            return e;
        }
        return null;
    }

    private void placeBall() {
        this.ball = new GOval(230.0, 305.0, 20.0, 20.0);
        this.ball.setFilled(true);
        this.ball.setFillColor(Color.black);
        this.ball.setColor(Color.black);
        this.add(this.ball);
        this.vx = this.rgen.nextDouble(1.0, 3.0);
        if (!this.rgen.nextBoolean(0.5)) {
            this.vx = -this.vx;
        }
        this.vy = 3.0;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        GPoint p = new GPoint(e.getPoint());
        double p2 = 29.0;
        double x = Math.max(0.0, Math.min(p.getX() - p2, 402.0));
        this.paddle.setLocation(x, this.paddle.getY());
    }

    private void placeBricks() {
        double y = 71.0;
        double x = 2.0;
        for (int r = 0; r != BRICK_ROWS; ++r) {
            double cx = x;
            for (int c = 0; c != BRICKS_IN_ROW; ++c) {
                Brick brick = new Brick(cx, y, BRICK_WIDTH, 8.0);
                brick.setFilled(true);
                brick.setFillColor(rowColors[r % rowColors.length]);
                brick.setColor(rowColors[r % rowColors.length]);
                this.add(brick);
                ++this.numBricks;
                cx = cx + (double)BRICK_WIDTH + 5.0;
            }
            y = y + 8.0 + 4.0;
        }
    }

    private void placePaddle() {
        this.paddle = new GRect(230.0, 569.0, 58.0, 11.0);
        this.paddle.setFilled(true);
        this.paddle.setFillColor(Color.black);
        this.paddle.setColor(Color.black);
        this.add(this.paddle);
        this.addMouseListeners();
    }

    public void fixBallDirection(GObject obj) {
        this.vy = -this.vy;
        double width = obj.getWidth();
        double x = obj.getLocation().getX();
        if (this.vx > 0.0 && this.ball.getX() <= x + width / 4.0) {
            this.vx = -this.vx;
            return;
        }
        if (this.vx < 0.0 && this.ball.getX() >= x + 3.0 * width / 4.0) {
            this.vx = -this.vx;
            return;
        }
    }

    public static String toString(String[] b) {
        if (b == null) {
            return null;
        }
        String res = "[";
        for (int k = 0; k < b.length; ++k) {
            if (k > 0) {
                res = res + ", ";
            }
            res = res + b[k];
        }
        return res + "]";
    }
}

