import java.awt.*;
import java.awt.image.*;
import javax.imageio.*;
import java.io.*;


/** An instance contains 
  (1) an original image (of class ImageArray),
  (2) a possibly altered (by methods in this instance) version of the original image,
  (3) methods to process the image
  */
public class ImageProcessor {
    
    /** DM provides methods for extracting components of an rgb pixel. */
    public static final DirectColorModel DM= (DirectColorModel) ColorModel.getRGBdefault();
    
    /** The following four constants of this class indicate a color.*/
    /** Color gray */
    public static final int GRAY= 0;
    
    /** Color red */
    public static final int RED= 1;
    
    /** Color green */
    public static final int GREEN= 2;
    
    /** Color blue */
    public static final int BLUE= 3;
    
    private ImageArray originalIm; // Original image, to make it easy to restore
    private ImageArray currentIm;  // Altered image.
    
    /** Constructor: an instance for im.
      Precondition: im != null. */
    public ImageProcessor(ImageArray im) {
        originalIm= im;
        currentIm= originalIm.copy();
    }
    
    /** = current image. */
    public ImageArray getCurrentImage() {
        return currentIm;
    }
    
    /** = the original image. */
    public ImageArray getOriginalImage() {
        return originalIm;
    }
    
    /** Invert current image: replace each element with its color complement. */
    public void invert() {
        int len= currentIm.getLength();
        
        // invert all pixels (leave alpha/transparency value alone)
        
        // invariant: pixels 0..p-1 have been complemented.
        for (int p= 0; p < len; p= p+1) {
            int rgb= currentIm.getPixel(p);
            int red= 255 - DM.getRed(rgb);
            int blue= 255 - DM.getBlue(rgb);
            int green= 255 - DM.getGreen(rgb);
            int alpha= DM.getAlpha(rgb);
            currentIm.setPixel(p,
                               (alpha << 24) | (red << 16) | (green << 8) | blue);
        }
    }
    
    /** Transpose current image.  */
    public void transpose() {
        //  Create a new ImageArray ia, using currentIm's row-major order array
        //  and rows and columns, but swap the roles of its numbers
        //  of rows and columns. 
        int rows= currentIm.getRows();         
        int cols= currentIm.getCols();         
        ImageArray ia= new ImageArray(currentIm.getRmoArray(), cols, rows);                  
        
        //Copy each element ImageArray[r,c] to ia[c,r]         
        // invariant: rows 0..r-1 have been copied to ia's columns 0..r-1         
        for (int r= 0; r != rows; r= r+1) {           
            // invariant: elements [r, 0..c-1] have been copied to ia[0..c-1, r]             
            for (int c= 0; c != cols; c= c+1) {             
                ia.setPixel(c, r, currentIm.getPixel(r,c));         
            }  
        }
        
        currentIm= ia;
    }
    
    /** Reflect current image around the horizontal middle. */
    public void hreflect() {
        int rows= currentIm.getRows();
        int cols= currentIm.getCols();
        int h= 0;
        int k= rows-1;
        //invariant: rows 0..h-1 and k+1..rows-1 have been inverted
        while (h < k) {
            // Swap row h with row k
            // invariant: pixels 0..c-1 of rows h and k have been swapped
            for (int c= 0; c != cols; c= c+1) {
                currentIm.swapPixels(h, c, k, c);
            }
            
            h= h+1; k= k-1;
        }
    }
    
    /** Reflect current image around the vertical middle. */
    public void vreflect() {
        
        
        
        
        
        
        
    }
    
    
      /** Change the current image so that every pixel that is not on one of 
      * the four edges of the image is replaced with the average of its  
      * current value and the current values of its eight neighboring pixels. 
      */
    public void fuzzify() {
        /* NOTE: FIRST make a copy of the image.
           THEN transform the copy using the values in the *currentIm*.
           THEN copy the entire transformed copy into the currentIm.
           Thus, the average for each pixel will be the average of values 
           in the "original" currentIm, 
           NOT of values that have already been fuzzified by your method.
         */
        
        
        
        
    }
    
   

    
    /** Put jail bars on the current image, as follows:
        Put 3-pixel-wide red horizontal bars across the top and bottom edge,
        put 4-pixel red vertical bars down the left and right edge, and
        put n evenly-spaced 4-pixel red vertical bars inside, where n is
        ((no of. columns in the picture) - 8) / 50.    */
    public void putInJail() {
      
        
        
    }
    
    
    /** Draw a horizontal 3-pixel-wide bar at row x of the current image
      using the color given by rgb components r, g, and b.
      Precondition: 0 <= x  &&  x+2 < currentIm.getRows() */
    private void drawHBar(int x, int r, int g, int b) {
        int cols= currentIm.getCols();
        
        /* inv: pixels currentIm[x..x+2][0..c-1] are color specified by , g, b */
        for (int c= 0; c < cols; c= c+1) {
            int alpha= DM.getAlpha(currentIm.getPixel(x,c));
            
            // inv: pixels 0..c-1 in rows x..x+(i-1) have had their colors changed
            for (int i= 0; i <= 2; i= i+1) {
            	currentIm.setPixel(x+i, c, (alpha << 24) | (r << 16) | (g << 8) | b);
            }
        }
    }
   
  
    
    /* Filter out color from current image according to parameter c.<br><br>
     Precondition: c is one of the four color constants GRAY,
     RED, GREEN, BLUE of this class.<br><br>
     
     If c is one of RED, GREEN, BLUE, then filter out that color component
     of the image  by setting it to 0 in all pixels. If c is GRAY, then 
     filter all color out  of the image by setting the three color components
     of each pixel to the average of the three.
     
     The alpha component is not changed.
     */
    public void filterOut(int c) {
        
        
        
        
        
        
    }
    

    
    /** Hide message m in this image, using the ascii representation of m's chars.
      Return true if this is possible and false if not.
      If m has more than 999999 characters or the picture doesn't have enough
      pixels, return false without storing the message.
      */
    public boolean hide(String m) {
        
        
        
        
        
        return false;
    }
    

    
    /** Extract and return the message hidden in current image, if any.
      Return null if no message detected. 
      Note: if a message was hidden but the image was subsequently altered,
      this method may not be able to recover the message.  */
    public String reveal() {
        
        
        
        
        return null;
    }
    
    /** Extract and return the message hidden in current image.
      Return null if no message detected. 
       Note: if a message was hidden but the image was subsequently altered,
      this method may not be able to recover the message.
      */
    public String reveal1() {
       // Note: do not  write this method.
       // We'll explain in class some time why this is here.
        
        
        
        
        return null;
    }
    
    
    /** Restore the original image into the current one */
    public void restore() {
        currentIm= originalIm.copy();
    }
    
    /** Provided that file fname does not appear in current directory, store the
      current image in file fname in current directory, as a jpg file.
      Write a message on the console indicating whether or not the write was successful. */
    public void writeImage(String fname) throws java.io.IOException {
        File f= new File(fname);
        if (f.exists()) {
            System.out.println("File " + f.getAbsolutePath() + " exists. It was not overwritten.");
            return;
        }
        
        int r= currentIm.getRows();
        int c= currentIm.getCols();
        int roa[]= currentIm.getRmoArray();
        
        // Create an image from roa. The new Container is needed to get an
        // object that has the appropriate function, createImage, in it; that is all.
        Image image= (new Container()).createImage(new MemoryImageSource(c, r, roa, 0, c));
        
        // Obtain a buffered image and the graphics for it. It has to have the right width and height.
        // The third arg of the call below indicates that input into it will be an integer array of
        // rgb colors
        BufferedImage bimage= 
            new BufferedImage(image.getWidth(null), image.getHeight(null), BufferedImage.TYPE_INT_RGB);
        Graphics g= bimage.createGraphics();
        
        
        // put the image into bimage so that it can be written out and dispose of the graphics.
        g.drawImage(image, 0, 0, null);
        g.dispose();
        
        // Finally, write the image onto the file and give the appropriate message
        ImageIO.write(bimage, "jpg", f);
        System.out.println("Image written to " + f.getAbsolutePath());
    }  
  
    
}
