import acm.graphics.*;
import java.awt.*;
import acm.program.*;

/** An instance maintains a graphics window on the monitor, which can be drawn on
  using pens, turtles, and other things. */
public class A5 extends GraphicsProgram {
    
    // The argument to method start, giving the width and height of the graphics window. */
    private static String[] sizeArgs= { "width=" + 500, "height=" + 500 };
    
    /** Constructor: a new Graphics Program with a window of size (500, 500) */
    public A5() {
        super();
        start(sizeArgs);
    }
    
    /** = a new turtle that is at the Center of the window, faces west,
      is not hidden, and is ready to draw in green. */
    public GTurtle getTurtle() {
        GTurtle t= new GTurtle();
        this.add(t);
        t.setLocation(getWidth()/2, getHeight()/2);
        t.penDown();
        t.setColor(Color.green);
        t.setDirection(180);
        t.showTurtle();
        return t;
    }
    
    /** = a new pen that is at the Center of the window,
      is not hidden, and is ready to draw in black. */
    public GPen getPen() {
        GPen p= new GPen();
        this.add(p);
        p.setLocation(getWidth()/2, getHeight()/2);
        p.setColor(Color.black);
        p.showPen();
        return p;
    }
    
    /** = a representation of t, giving its location, color, and direction */
    public String toString(GTurtle t) {
        // Instructions: Take a look at what t.toString() produces. This new toString
        // function should produce the same thing except that, just before the closing
        // bracket this should appear: , direction=<direction>

        return "";
    }
    
    /** In the middle of the window, draw a green line 100 pixels to the left (west),
      and then a blue line 200 pixels down (sout).
      Do this with a new turtle that moves at speed sp, 0 <= s <= 1, with
      0 being slowest and 1 fastest. */
    public void drawTwoLines(double sp) {
        GTurtle t= getTurtle();
        
        t.setSpeed(sp);
        t.forward(100); // draw a line 100 pixels in the current direction 
        
        t.left(90); // add 90 degrees to the angle
        t.setColor(Color.blue);
        t.forward(200);
    }
    
    /** Draw an equilateral triangle of side length s and color c at turtle t's
      current position. The triangle should be drawn so that if the turtle is facing west,
      the triangle points up and the turtle starts and ends at the east end of the base line.
      UPON COMPLETION, THE FOLLOWING PROPERTIES SHOULD BE THE
      SAME AS WHEN THE METHOD STARTED: turtle position, turtle direction,
      pen color, and whether the pen is up or down.
      Precondition: the pen is down. */
    public void drawTriangle(GTurtle t, double s, Color c) {
        // Hint: each angle in an equilateral triangle is 60 degrees.
        // Note: Do NOT save the turtle position and direction in the beginning
        // and then restore them at the end. Instead, the turtle moves should be
        // such that the turtle ends up where it started and facing in the same
        // direction.
        // Also, 3 lines have to be drawn. Does this suggest a for-loop that
        // processes the range 1..3?
        
        // PUT YOUR CODE HERE AND DELETE THIS COMMENT:
        
       
        
        
        
        
        
        /** When you have completed and tested this procedure, do the following
          instructions in the Interactions pane to learn about round-off error
          caused by using type double instead of the mathematical type real:
          
          a= new A5();
          t= a.getTurtle();
          System.out.println(a.toString(t));
          a.drawTriangle(t, 200, java.awt.Color.red);
          System.out.println(a.toString(t));
          
          You will see that t's location not the same before and after
          drawing the triangle. This is due to "round-off" errors that
          arise because type double uses only approximations to real numbers.
          
          This is OK here, because the pixels in the panel on which
          the drawing takes place are given by integers: the top left one is
          (0, 0),  the one to its right is (0, 1), and so on. The turtle's
          drawing methods round double values to ints before actually drawing.
          
          Add a comment at the top of this file (A5.java) containing a
          cut-and-paste of the results in the Interaction pane of
          typing in the five lines specified in this comment.
          */
    }
    
    /** Use turtle t to draw six red equilateral triangles with side lengths s
      to form a hexagon, starting at the turtle's current position and direction.
      The middle of the hexagon should be the turtle's starting position. 
      Upon completion, the following properties should be the same as when
      the method started: turtle position, turtle direction,
      and whether the pen is up or down.
      Precondition: the pen is down. */
    public void drawHex(GTurtle t, int s) {
        // Note: Do not save any of the turtle's properties and then restore
        //       them at the end. It is not needed. Just use 6 calls on 
        //       procedures drawTriangle (given above) and t.left.
        //       After writing it, test the procedure to make sure that t's final
        //       location and direction are the same as t's initial location and
        //       direction (except for roundoff error).
        //       The procedure is supposed to draw 6 triangles. Does
        //       that suggest a loop that processes the integers in 1..6?
        
        // PUT YOUR CODE HERE AND DELETE THIS LINE:
        
        
        
        
        
    }
    
    /** Remove all objects from the window (using removeAll();). Then
      draw a spiral of n lines using a new turtle that starts in the middle
      of the window and faces east, adding ang degrees to the turtle's direction
      after each line. Use sp for the turtle's speed (0 is slowest, 1 fastest).
      Line 1 is d pixels long; line 2, 2*d pixels, ..., so each line i
      is d*i pixels long. The lines should alternate between blue, green,
      and red, in that order, with the first one being blue.
      */
    public void drawSpiral(double sp, int d, int ang, int n) {
        
       
        
        
    }
    
    /**  Draw a spiral of n lines beginning at turtle t's current position and
      direction, adding ang degrees to the turtle's position after each line.
      Use sp for the turtle's speed (0 is slowest, 1 fastest).
      Line 1 is d pixels long; line 2, 2*d pixels, ..., so each line i
      is d*i pixels long. The lines should alternate between blue, green,
      and red, in that order, with the first one being blue. 
      End with t's color and speed being the same as before the call, but its
      final position and angle will be as it is after the last line drawn.
      Precondition: pen is down.
      */
    private void drawSpiral(GTurtle t, double sp, int d, int ang, int n) {
        // Note: Since n lines have to be drawn, use a for-loop that processes
        //  a range of integers.
        
        
        
        
        
        
        
        
    }
    
    /** Remove all objects from the window (using removeAll();). Then draw
      45 n-sided polygons of side length d using a new turtle that starts in the middle of the
      window, faces WEST, and moves at speed sp (0 <= sp <= 1). The polygons are in alternating
      colors between red and blue. Each polygon starts at the same place, but each one is at
      an angle 8 degrees more than the preceding one. All properties of the turtle are the
      same at the end as they were in the beginning */
    public void multiPolygons(double sp, int n, int d) {
        
        
        
        
        
        
    }
    
    /** Draw 45 n-sided polygons of side length d using turtle t, with the
      turtle moving at speed sp (0 <= sp <= 1). The polygons are in alternating colors
      between red and blue. Each polygon starts at the same place, but
      but each one is at an angle 8 degrees more than the preceding one. All
      properties of the turtle are the same at the end as they
      were in the beginning.
      Precondition: pen is down. */
    private void multiPolygons(GTurtle t, double sp, int n, int d) {
    
        
        
        
        
        
        
        
    }
    
    /** Draw an n-sided polygon using turtle t. Each side is d pixels long.
      The polygon should be drawn with turtle speed sp (0 <= sp <= 1).
      These properties of t should end up the way they were at the beginning:
      position, direction, and pen properties.
      Precondition: pen is down*/
    public void drawPolygon(GTurtle t, double sp, int n, int d) {
        double initialSpeed= t.getSpeed();
        t.setSpeed(sp);
        
        // angle is the angle between 2 adjacent sides
        double angle= ((n-2) * 180.0) / n; 
        for (int j= 0; j < n; j= j+1) {
            t.forward(d);
            t.left(180 - angle);
        }
        
        t.setDirection(t.getDirection()%360);
        t.setSpeed(initialSpeed);
    }
    
    /**  Remove all objects from the window (using removeAll();). Create
      a turtle at the middle of the screen and facing east. Then, draw n
      straight radiating lines of length d at equal angles using
      the turtle, with the turtle moving at speed sp (0 <= sp <= 1). A line drawn at
      angle ang, 0 <= ang < 360, should be drawn with HSV color (ang, 1, 1). */
    public void radiate(double sp, int d, int n) {
       
        
        
        
        
    }
    
    /** Draw n straight radiating lines of length d at equal angles using
      Turtle t with the turtle moving at speed sp (0 <= sp <= 1). A line drawn at
      angle ang, 0 <= ang < 360, should be drawn with HSV color (ang, 1, 1).
      The turtle should end up with its initial color and speed, but
      its final position and angle may be different at the end of drawing.
      Precondition: n >= 2 and pen is down. */
    private void radiate(GTurtle t, double sp, int d, int n){
        /* Notes: 
           1. Drawing n lines should be done with a loop that processes
              a certain range of integers.
           2. You have to keep the direction of the turtle in the range
              0 <= direction < 360; the directions ds and 360 + ds
              are considered to be the same.
           3. Use new HSV(t.getDirection(),1,1) to create an HSV object that
              gives the color represented by turtle t's direction.
           4. For HSV object hsv, call hsv.toRGB() to get a Color object with
              the same color as hsv.
           */
        
        
        
        
        
        
        
        
        
    }
    
    /** Remove all objects from the graphics window and 
      draw a Sierpinksi triangle of depth d with side length s
      with bottom left corner (x, y) and with a new pen.
      Precondition: d >= 0 and sl > 0. */
    public void sierpinski(double x, double y, int d, double s) {
       
        
        
        
        
        
    } 
    
    /** Using pen p, draw a Sierpinksi triangle of depth d with side length s
      and bottom left corner (x, y). 
      Precondition: d >= 0 and s > 0 and pen is down. */
    private void sierpinski(GPen p, double x, double y, int d, double s){ 
       
        
        
        
        
        
        
    }
    
    /** Remove all objects from the window and draw a Sierpinksi carpet of
      depth d with side length s with top-left corner the top of left of the window.
      Use a new pen. Precondition: d >= 0 and s > 0. */
    public void sierpinskicarpet(int d, double s) {
        removeAll();
        GPen p= getPen();
        sierpinskicarpet(p, 0, 0, d, s); 
        
    }
    
    /** Using pen p, draw a Sierpinksi carpet of depth d with side length s and
      top left corner (x, y). 
      Precondition: d >= 0 and s > 0 and pen is down. */
    private void sierpinskicarpet(GPen p, double x, double y, int d, double s){
        p.setLocation(x,y);
        fillSquare(p,s);
        
        if (d==0)
            return;
        
        p.setColor(Color.white);
        p.setLocation(x+s/3, y+s/3);
        fillSquare(p,s/3);
        p.setColor(Color.black);
        
        // Fill in the 8 squares with d-1-level carpets
        // They are  00  01  02
        //           10      12
        //           20  21  22
        
        for (int a=0; a <=2; a++) {
            for (int b=0; b <=2; b++) {
                if (!(a==1 && b ==1)) { 
                    sierpinskicarpet(p, x+a*s/3, y+b*s/3, d-1, s/3);
                }
            }
        }
        
    }
    
    /** Remove all objects from the window and draw a Grisly snowflake of
      depth d with side length s with left point of the base line
      at (s, 2*s).
      Use a new pen. Hide the pen before starting and leave it hidden.
      Precondition: d >= 0 and s > 0. */
    public void grislySnowflake(int d, double s) {
       
        
        
        
        
        
    }

    
    /** Using pen p, draw a Grisly snowflake of depth d with side length s
      and left point of base line at (x, y). 
      Precondition: d >= 0 and s > 0 and pen is down. */
    private void grislySnowflake(GPen p, double x, double y, int d, double s) { 

        
        
        
        
        
        
        
        
        
        
        
    }
    
    /** Remove all objects from the window and draw an draw an H-tree
      of depth d with center (x, y) and size s using a new pen.  
      Precondition: d >= 0 and s >= 0. */
    public void recursiveH(double x, double y, int d, double s) {
        
        
        
        
        
    }
    
    /** draw an H-tree of depth d and size s with center (x, y) using
      pen p.  
      Precondition: d >= 0 and s >= 0 and pen is down. */
    private void recursiveH(GPen p, double x, double y, int d, double s) {
        
        
        
        
        
        
    }
    
    /** Fill the equilateral triangle of side length s with
      left point of its base given by p and triangle pointing up.
      When done, the position of p should be as it was initially. */
    public void fillTriangle(GPen p, double s) {
        double h= s * Math.sqrt(.75);         
        p.startFilledRegion();         
        p.drawLine(s, 0);         
        p.drawLine(-s/2, - h);         
        p.drawLine(-s/2, h);         
        p.endFilledRegion();
    }
    
    /** Draw an H at center (x, y) of size s using pen p. */
    public void drawH(GPen p, double x, double y, double s) {
        // INSTRUCTIONS:  fill this in
        p.setLocation(x-s/2, y);
        p.drawLine(s,0);
        p.setLocation(x-s/2, y-s/2);
        p.drawLine(0,s);
        p.setLocation(x+s/2, y-s/2);
        p.drawLine(0,s);
        
        
    }
    
    /** Using pen p, fill a square with side length s, with top-left corner given
      by p's current position. */
    public void fillSquare(GPen p, double s) {
        p.startFilledRegion();
        p.drawLine(s, 0);
        p.drawLine(0, s);
        p.drawLine(-s, 0);
        p.drawLine(0, -s);
        p.endFilledRegion();
    }
    
    
    /** Fill a hexagon of side length s, with middle (x, y).
      using pen p. */
    public void fillHex(GPen p, double s, double x, double y) {
        p.setLocation(x + s, y);
        double dx= s*GMath.cosDegrees(60);
        double dy= s*GMath.sinDegrees(60);
        p.startFilledRegion();
        p.drawLine(-dx, dy);
        p.drawLine(-s, 0);
        p.drawLine(-dx, -dy);
        p.drawLine(dx, -dy);
        p.drawLine(s, 0);
        p.drawLine(dx, dy);
        p.endFilledRegion();
    }
    
  
}