/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AmbiguousName;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.AnonymousAllocation;
import koala.dynamicjava.tree.AnonymousInnerAllocation;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BooleanTypeName;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.ByteTypeName;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.CharTypeName;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorCall;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.DoubleTypeName;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionStatement;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FloatTypeName;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.IntTypeName;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.LongTypeName;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveTypeName;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.ShortTypeName;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.SimpleFieldAccess;
import koala.dynamicjava.tree.SimpleMethodCall;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.VoidTypeName;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.AbstractVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DisplayVisitor
extends AbstractVisitor<Void> {
    private PrintStream out;
    private String indentation;

    public DisplayVisitor(OutputStream os) {
        this.out = new PrintStream(os);
        this.indentation = "";
    }

    @Override
    public Void visit(PackageDeclaration node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" PackageDeclaration ").append(node.getName()).append(" {").toString());
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ImportDeclaration node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ImportDeclaration ").append(node.getName()).append(node.isPackage() ? ".*" : "").append(" {").toString());
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(EmptyStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" EmptyStatement {").toString());
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ExpressionStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ExpressionStatement {").toString());
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.print(new StringBuffer().append("hasSemicolon:").append(node.getHasSemicolon()).toString());
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(WhileStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" WhileStatement {").toString());
        this.print("condition:");
        this.indent();
        node.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("body:");
        this.indent();
        node.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ForStatement node) {
        Iterator<Node> it;
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ForStatement {").toString());
        this.print("initialization:");
        if (node.getInitialization() != null) {
            this.indent();
            it = node.getInitialization().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
            this.unindent();
        }
        this.print("condition:");
        if (node.getCondition() != null) {
            this.indent();
            node.getCondition().acceptVisitor(this);
            this.unindent();
        }
        this.print("update:");
        if (node.getUpdate() != null) {
            this.indent();
            it = node.getUpdate().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
            this.unindent();
        }
        this.print("body:");
        this.indent();
        node.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(DoStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" DoStatement {").toString());
        this.print("condition:");
        this.indent();
        node.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("body:");
        this.indent();
        node.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(SwitchStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" SwitchStatement {").toString());
        this.print("selector:");
        this.indent();
        node.getSelector().acceptVisitor(this);
        this.unindent();
        this.print("bindings:");
        this.indent();
        Iterator<SwitchBlock> it = node.getBindings().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(SwitchBlock node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" SwitchBlock {").toString());
        this.print("expression:");
        this.indent();
        if (node.getExpression() != null) {
            node.getExpression().acceptVisitor(this);
        } else {
            this.print("default");
        }
        this.unindent();
        this.print("statements:");
        this.indent();
        if (node.getStatements() != null) {
            Iterator<Node> it = node.getStatements().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(LabeledStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" LabeledStatement {").toString());
        this.print("label:");
        this.indent();
        this.print(node.getLabel());
        this.unindent();
        this.print("statement:");
        this.indent();
        node.getStatement().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(BreakStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" BreakStatement {").toString());
        this.print("label:");
        this.indent();
        this.print(node.getLabel());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(TryStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" TryStatement {").toString());
        this.print("tryBlock:");
        this.indent();
        node.getTryBlock().acceptVisitor(this);
        this.unindent();
        this.print("catchStatements:");
        this.indent();
        Iterator<CatchStatement> it = node.getCatchStatements().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("finallyBlock:");
        this.indent();
        if (node.getFinallyBlock() != null) {
            node.getFinallyBlock().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(CatchStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" CatchStatement {").toString());
        this.print("exception:");
        this.indent();
        node.getException().acceptVisitor(this);
        this.unindent();
        this.print("block:");
        this.indent();
        node.getBlock().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ThrowStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ThrowStatement {").toString());
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ReturnStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ReturnStatement {").toString());
        this.print("expression:");
        this.indent();
        if (node.getExpression() != null) {
            node.getExpression().acceptVisitor(this);
        } else {
            this.print("null");
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(SynchronizedStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" SynchronizedStatement {").toString());
        this.print("lock:");
        this.indent();
        node.getLock().acceptVisitor(this);
        this.unindent();
        this.print("body:");
        this.indent();
        node.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ContinueStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ContinueStatement {").toString());
        this.print("label:");
        this.indent();
        this.print(node.getLabel());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(IfThenStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" IfThenStatement {").toString());
        this.print("condition:");
        this.indent();
        node.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("thenStatement:");
        this.indent();
        node.getThenStatement().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(IfThenElseStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" IfThenElseStatement {").toString());
        this.print("condition:");
        this.indent();
        node.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("thenStatement:");
        this.indent();
        node.getThenStatement().acceptVisitor(this);
        this.unindent();
        this.print("elseStatement:");
        this.indent();
        node.getElseStatement().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(Literal node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" Literal (").append(node.getType()).append(") <").append(node.getValue()).append("> {").toString());
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ThisExpression node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ThisExpression {").toString());
        this.print("className:");
        this.indent();
        this.print(node.getClassName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(AmbiguousName node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" AmbiguousName {").toString());
        this.print("representation:");
        this.indent();
        this.print(node.getRepresentation());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ObjectFieldAccess node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ObjectFieldAccess {").toString());
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("fieldName:");
        this.indent();
        this.print(node.getFieldName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(StaticFieldAccess node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" StaticFieldAccess {").toString());
        this.print("fieldType:");
        this.indent();
        node.getFieldType().acceptVisitor(this);
        this.unindent();
        this.print("fieldName:");
        this.indent();
        this.print(node.getFieldName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ArrayAccess node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ArrayAccess {").toString());
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("cellNumber:");
        this.indent();
        node.getCellNumber().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(SimpleFieldAccess node) {
        this.print(new StringBuffer().append(this.indentation).append("l.").append(node.getBeginLine()).append(" SimpleFieldAccess {").toString());
        this.print("fieldName:");
        this.indent();
        this.print(node.getFieldName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(SuperFieldAccess node) {
        this.print(new StringBuffer().append(this.indentation).append("l.").append(node.getBeginLine()).append(" SuperFieldAccess {").toString());
        this.print("fieldName:");
        this.indent();
        this.print(node.getFieldName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ObjectMethodCall node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ObjectMethodCall {").toString());
        this.print("expression:");
        this.indent();
        if (node.getExpression() != null) {
            node.getExpression().acceptVisitor(this);
        } else {
            this.print("null");
        }
        this.unindent();
        this.print("methodName:");
        this.indent();
        this.print(node.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator<Expression> it = node.getArguments().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(SimpleMethodCall node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" SimpleMethodCall {").toString());
        this.print("methodName:");
        this.indent();
        this.print(node.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator<Expression> it = node.getArguments().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(StaticMethodCall node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" StaticMethodCall {").toString());
        this.print("methodType:");
        this.indent();
        node.getMethodType().acceptVisitor(this);
        this.unindent();
        this.print("methodName:");
        this.indent();
        this.print(node.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator<Expression> it = node.getArguments().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ConstructorCall node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ConstructorCall {").toString());
        this.print("expression:");
        this.indent();
        if (node.getExpression() != null) {
            node.getExpression().acceptVisitor(this);
        }
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator<Expression> it = node.getArguments().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("isSuper:");
        this.indent();
        this.print(node.isSuper() ? "true" : "false");
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(SuperMethodCall node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" SuperMethodCall {").toString());
        this.print("methodName:");
        this.indent();
        this.print(node.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator<Expression> it = node.getArguments().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(BooleanTypeName node) {
        this.handlePrimitiveTypeName(node, "boolean");
        return null;
    }

    @Override
    public Void visit(ByteTypeName node) {
        this.handlePrimitiveTypeName(node, "byte");
        return null;
    }

    @Override
    public Void visit(ShortTypeName node) {
        this.handlePrimitiveTypeName(node, "short");
        return null;
    }

    @Override
    public Void visit(CharTypeName node) {
        this.handlePrimitiveTypeName(node, "char");
        return null;
    }

    @Override
    public Void visit(IntTypeName node) {
        this.handlePrimitiveTypeName(node, "int");
        return null;
    }

    @Override
    public Void visit(LongTypeName node) {
        this.handlePrimitiveTypeName(node, "long");
        return null;
    }

    @Override
    public Void visit(FloatTypeName node) {
        this.handlePrimitiveTypeName(node, "float");
        return null;
    }

    @Override
    public Void visit(DoubleTypeName node) {
        this.handlePrimitiveTypeName(node, "double");
        return null;
    }

    @Override
    public Void visit(VoidTypeName node) {
        this.handlePrimitiveTypeName(node, "void");
        return null;
    }

    private void handlePrimitiveTypeName(PrimitiveTypeName node, String name) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" PrimitiveTypeName <").append(name).append(">").toString());
        this.displayProperties(node);
    }

    @Override
    public Void visit(ReferenceTypeName node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ReferenceTypeName {").toString());
        this.print("representation:");
        this.indent();
        this.print(node.getRepresentation());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ArrayTypeName node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ArrayTypeName {").toString());
        if (node.getElementType() != null) {
            this.print("elementType:");
            node.getElementType().acceptVisitor(this);
        }
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(TypeExpression node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" TypeExpression {").toString());
        this.print("type:");
        this.indent();
        node.getType().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(PostIncrement node) {
        this.displayUnary(node);
        return null;
    }

    @Override
    public Void visit(PostDecrement node) {
        this.displayUnary(node);
        return null;
    }

    @Override
    public Void visit(PreIncrement node) {
        this.displayUnary(node);
        return null;
    }

    @Override
    public Void visit(PreDecrement node) {
        this.displayUnary(node);
        return null;
    }

    @Override
    public Void visit(ArrayInitializer node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ArrayInitializer {").toString());
        this.print("cells:");
        this.indent();
        Iterator<Expression> it = node.getCells().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.print("elementType:");
        this.indent();
        node.getElementType().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ArrayAllocation node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ArrayAllocation {").toString());
        this.print("elementType:");
        this.indent();
        node.getElementType().acceptVisitor(this);
        this.unindent();
        this.print("dimension:");
        this.indent();
        this.print(new StringBuffer().append("").append(node.getDimension()).toString());
        this.unindent();
        this.print("sizes:");
        this.indent();
        Iterator<Expression> it = node.getSizes().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.print("initialization:");
        this.indent();
        if (node.getInitialization() != null) {
            node.getInitialization().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(SimpleAllocation node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" SimpleAllocation {").toString());
        this.print("creationType:");
        this.indent();
        node.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator<Expression> it = node.getArguments().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(AnonymousAllocation node) {
        Iterator<Node> it;
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" AnonymousAllocation {").toString());
        this.print("creationType:");
        this.indent();
        node.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            it = node.getArguments().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        it = node.getMembers().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(InnerAllocation node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" InnerAllocation {").toString());
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("className:");
        this.indent();
        this.print(node.getClassName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            Iterator<Expression> it = node.getArguments().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(AnonymousInnerAllocation node) {
        Iterator<Node> it;
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" AnonymousInnerAllocation {").toString());
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("creationType:");
        this.indent();
        this.print(node.getClassName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (node.getArguments() != null) {
            it = node.getArguments().iterator();
            while (it.hasNext()) {
                it.next().acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        it = node.getMembers().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(CastExpression node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" CastExpression {").toString());
        this.print("targetType:");
        this.indent();
        node.getTargetType().acceptVisitor(this);
        this.unindent();
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(NotExpression node) {
        this.displayUnary(node);
        return null;
    }

    @Override
    public Void visit(ComplementExpression node) {
        this.displayUnary(node);
        return null;
    }

    @Override
    public Void visit(PlusExpression node) {
        this.displayUnary(node);
        return null;
    }

    @Override
    public Void visit(MinusExpression node) {
        this.displayUnary(node);
        return null;
    }

    @Override
    public Void visit(MultiplyExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(DivideExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(RemainderExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(AddExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(SubtractExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(ShiftLeftExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(ShiftRightExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(UnsignedShiftRightExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(LessExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(GreaterExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(LessOrEqualExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(GreaterOrEqualExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(InstanceOfExpression node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" InstanceOfExpression {").toString());
        this.print("expression:");
        this.indent();
        node.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("referenceType:");
        this.indent();
        node.getReferenceType().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(EqualExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(NotEqualExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(BitAndExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(ExclusiveOrExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(BitOrExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(AndExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(OrExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(ConditionalExpression node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ConditionalExpression {").toString());
        this.print("conditionExpression:");
        this.indent();
        node.getConditionExpression().acceptVisitor(this);
        this.unindent();
        this.print("ifTrueExpression:");
        this.indent();
        node.getIfTrueExpression().acceptVisitor(this);
        this.unindent();
        this.print("ifFalseExpression:");
        this.indent();
        node.getIfFalseExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(SimpleAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(MultiplyAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(DivideAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(RemainderAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(AddAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(SubtractAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(ShiftLeftAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(ShiftRightAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(UnsignedShiftRightAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(BitAndAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(ExclusiveOrAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(BitOrAssignExpression node) {
        this.displayBinary(node);
        return null;
    }

    @Override
    public Void visit(BlockStatement node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" BlockStatement {").toString());
        this.print("statements:");
        this.indent();
        Iterator<Node> it = node.getStatements().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ClassDeclaration node) {
        Iterator<Node> it;
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ClassDeclaration {").toString());
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("superclass:");
        this.indent();
        node.getSuperclass().acceptVisitor(this);
        this.unindent();
        this.print("interfaces:");
        this.indent();
        if (node.getInterfaces() != null) {
            it = node.getInterfaces().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        it = node.getMembers().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(InterfaceDeclaration node) {
        Iterator<Node> it;
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" InterfaceDeclaration {").toString());
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("interfaces:");
        this.indent();
        if (node.getInterfaces() != null) {
            it = node.getInterfaces().iterator();
            while (it.hasNext()) {
                ((Node)it.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        it = node.getMembers().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ConstructorDeclaration node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ConstructorDeclaration {").toString());
        this.print("accessFlags:");
        this.indent();
        this.print(new StringBuffer().append("").append(node.getAccessFlags()).toString());
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("parameters:");
        this.indent();
        Iterator<Node> it = node.getParameters().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("exceptions:");
        this.indent();
        it = node.getExceptions().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.print("constructorInvocation:");
        this.indent();
        if (node.getConstructorCall() != null) {
            node.getConstructorCall().acceptVisitor(this);
        }
        this.unindent();
        this.print("statements:");
        this.indent();
        it = node.getStatements().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(MethodDeclaration node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" MethodDeclaration {").toString());
        this.print("accessFlags:");
        this.indent();
        this.print(new StringBuffer().append("").append(node.getAccessFlags()).toString());
        this.unindent();
        this.print("returnType:");
        this.indent();
        node.getReturnType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("parameters:");
        this.indent();
        Iterator<Node> it = node.getParameters().iterator();
        while (it.hasNext()) {
            ((Node)it.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("exceptions:");
        this.indent();
        it = node.getExceptions().iterator();
        while (it.hasNext()) {
            it.next().acceptVisitor(this);
        }
        this.unindent();
        this.print("body:");
        this.indent();
        if (node.getBody() != null) {
            node.getBody().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(FormalParameter node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" FormalParameter {").toString());
        if (node.isFinal()) {
            this.print("final");
        }
        this.print("type:");
        this.indent();
        node.getType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(FieldDeclaration node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" FieldDeclaration {").toString());
        this.print("accessFlags:");
        this.indent();
        this.print(new StringBuffer().append("").append(node.getAccessFlags()).toString());
        this.unindent();
        this.print("type:");
        this.indent();
        node.getType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("initializer:");
        this.indent();
        if (node.getInitializer() != null) {
            node.getInitializer().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(VariableDeclaration node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" VariableDeclaration {").toString());
        this.print("isFinal:");
        this.indent();
        this.print(new StringBuffer().append("").append(node.isFinal()).toString());
        this.unindent();
        this.print("type:");
        this.indent();
        node.getType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(node.getName());
        this.unindent();
        this.print("initializer:");
        this.indent();
        if (node.getInitializer() != null) {
            node.getInitializer().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(ClassInitializer node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" ClassInitializer {").toString());
        this.print("block:");
        this.indent();
        node.getBlock().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    @Override
    public Void visit(InstanceInitializer node) {
        this.print(new StringBuffer().append("l.").append(node.getBeginLine()).append(" InstanceInitializer {").toString());
        this.print("block:");
        this.indent();
        node.getBlock().acceptVisitor(this);
        this.unindent();
        this.displayProperties(node);
        this.print("}");
        return null;
    }

    private void displayUnary(UnaryExpression ue) {
        this.print(new StringBuffer().append("l.").append(ue.getBeginLine()).append(" ").append(ue.getClass().getName()).append(" {").toString());
        this.print("expression:");
        this.indent();
        ue.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(ue);
        this.print("}");
    }

    private void displayBinary(BinaryExpression be) {
        this.print(new StringBuffer().append("l.").append(be.getBeginLine()).append(" ").append(be.getClass().getName()).append(" {").toString());
        this.print("leftExpression:");
        this.indent();
        be.getLeftExpression().acceptVisitor(this);
        this.unindent();
        this.print("rightExpression:");
        this.indent();
        be.getRightExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(be);
        this.print("}");
    }

    private void displayProperties(Node node) {
        Iterator it = node.getProperties().iterator();
        if (it.hasNext()) {
            this.print("properties:");
        }
        while (it.hasNext()) {
            this.indent();
            String prop = (String)it.next();
            this.print(new StringBuffer().append(prop).append(": ").append(node.getProperty(prop)).toString());
            this.unindent();
        }
    }

    private void indent() {
        this.indentation = new StringBuffer().append(this.indentation).append("  ").toString();
    }

    private void unindent() {
        this.indentation = this.indentation.substring(0, this.indentation.length() - 2);
    }

    private void print(String s) {
        this.out.println(new StringBuffer().append(this.indentation).append(s).toString());
    }

    @Override
    public Object visit(InstanceInitializer x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ClassInitializer x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(VariableDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(FieldDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(FormalParameter x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(MethodDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ConstructorDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(InterfaceDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ClassDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(BlockStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(BitOrAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ExclusiveOrAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(BitAndAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(UnsignedShiftRightAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ShiftRightAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ShiftLeftAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SubtractAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(AddAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(RemainderAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(DivideAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(MultiplyAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SimpleAssignExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ConditionalExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(OrExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(AndExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(BitOrExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ExclusiveOrExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(BitAndExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(NotEqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(EqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(InstanceOfExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(GreaterOrEqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(LessOrEqualExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(GreaterExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(LessExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(UnsignedShiftRightExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ShiftRightExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ShiftLeftExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SubtractExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(AddExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(RemainderExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(DivideExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(MultiplyExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(MinusExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(PlusExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ComplementExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(NotExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(CastExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(AnonymousInnerAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(InnerAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(AnonymousAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SimpleAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ArrayAllocation x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ArrayInitializer x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(PreDecrement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(PreIncrement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(PostDecrement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(PostIncrement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(TypeExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ArrayTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ReferenceTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(VoidTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(DoubleTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(FloatTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(LongTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(IntTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(CharTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ShortTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ByteTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(BooleanTypeName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SuperMethodCall x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ConstructorCall x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(StaticMethodCall x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SimpleMethodCall x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ObjectMethodCall x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ArrayAccess x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SuperFieldAccess x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(StaticFieldAccess x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ObjectFieldAccess x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SimpleFieldAccess x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(AmbiguousName x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ThisExpression x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(Literal x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(IfThenElseStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(IfThenStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ContinueStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SynchronizedStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ReturnStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ThrowStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(CatchStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(TryStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(BreakStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(LabeledStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SwitchBlock x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(SwitchStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(DoStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ForStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(WhileStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ExpressionStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(EmptyStatement x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(ImportDeclaration x0) {
        return this.visit(x0);
    }

    @Override
    public Object visit(PackageDeclaration x0) {
        return this.visit(x0);
    }
}

