/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.BooleanTypeName;
import koala.dynamicjava.tree.ByteTypeName;
import koala.dynamicjava.tree.CharTypeName;
import koala.dynamicjava.tree.DoubleTypeName;
import koala.dynamicjava.tree.FloatTypeName;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IntTypeName;
import koala.dynamicjava.tree.LongTypeName;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.ShortTypeName;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.VoidTypeName;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeUtilities {
    public static TypeName classToTypeName(Class<?> c) {
        return TreeUtilities.classToTypeName(c, null, 0, 0, 0, 0);
    }

    public static TypeName classToTypeName(Class<?> c, String fn, int bl, int bc, int el, int ec) {
        TypeName result;
        if (c == Integer.TYPE) {
            result = new IntTypeName(fn, bl, bc, el, ec);
        } else if (c == Double.TYPE) {
            result = new DoubleTypeName(fn, bl, bc, el, ec);
        } else if (c == Long.TYPE) {
            result = new LongTypeName(fn, bl, bc, el, ec);
        } else if (c == Float.TYPE) {
            result = new FloatTypeName(fn, bl, bc, el, ec);
        } else if (c == Character.TYPE) {
            result = new CharTypeName(fn, bl, bc, el, ec);
        } else if (c == Byte.TYPE) {
            result = new ByteTypeName(fn, bl, bc, el, ec);
        } else if (c == Short.TYPE) {
            result = new ShortTypeName(fn, bl, bc, el, ec);
        } else if (c == Boolean.TYPE) {
            result = new BooleanTypeName(fn, bl, bc, el, ec);
        } else if (c == Void.TYPE) {
            result = new VoidTypeName(fn, bl, bc, el, ec);
        } else if (c.isArray()) {
            result = new ArrayTypeName(TreeUtilities.classToTypeName(c.getComponentType(), fn, bl, bc, el, ec), 1, false, fn, bl, bc, el, ec);
        } else {
            ArrayList<Identifier> ids = new ArrayList<Identifier>(1);
            ids.add(new Identifier(c.getName()));
            result = new ReferenceTypeName(ids, fn, bl, bc, el, ec);
        }
        return result;
    }

    public static String listToName(List<? extends IdentifierToken> l) {
        String result = "";
        if (l != null) {
            Iterator<? extends IdentifierToken> it = l.iterator();
            if (it.hasNext()) {
                result = new StringBuffer().append(result).append(it.next().image()).toString();
            }
            while (it.hasNext()) {
                result = new StringBuffer().append(result).append(".").append(it.next().image()).toString();
            }
        }
        return result;
    }

    private TreeUtilities() {
    }
}

