/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.SourceInfo;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    public static final String SOURCE_INFO = "sourceInfo";
    private SourceInfo sourceInfo;
    private PropertyChangeSupport propertyChangeSupport;
    private Map<String, Object> properties;

    protected Node(String fn, int bl, int bc, int el, int ec) {
        this(new SourceInfo(fn == null ? new File("") : new File(fn), bl, bc, el, ec));
    }

    protected Node(SourceInfo si) {
        this.sourceInfo = si;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.properties = new HashMap<String, Object>(11);
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(SourceInfo si) {
        this.sourceInfo = si;
        this.firePropertyChange(SOURCE_INFO, this.sourceInfo, this.sourceInfo);
    }

    public void setProperty(String name, Object value) {
        this.firePropertyChange(name, this.properties.put(name, value), value);
    }

    public Object getProperty(String name) {
        if (!this.properties.containsKey(name)) {
            throw new IllegalStateException(new StringBuffer().append("Property '").append(name).append("' is not initialized").toString());
        }
        return this.properties.get(name);
    }

    public Set getProperties() {
        return this.properties.keySet();
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public abstract <T> T acceptVisitor(Visitor<T> var1);

    public String getFilename() {
        return this.sourceInfo.getFile().getName();
    }

    public int getBeginLine() {
        return this.sourceInfo.getStartLine();
    }

    public int getBeginColumn() {
        return this.sourceInfo.getStartColumn();
    }

    public int getEndLine() {
        return this.sourceInfo.getEndLine();
    }

    public int getEndColumn() {
        return this.sourceInfo.getEndColumn();
    }

    public boolean equals(Object n) {
        if (this.getClass() != n.getClass()) {
            return false;
        }
        return this.toString().equals(n.toString());
    }
}

