/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.lang.reflect.Modifier;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.TypeName;
import koala.dynamicjava.tree.visitor.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDeclaration
extends Node {
    public static final String ACCESS_FLAGS = "accessFlags";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String INITIALIZER = "initializer";
    private int accessFlags;
    private TypeName type;
    private String name;
    private Expression initializer;

    public FieldDeclaration(int flags, TypeName type, String name, Expression init) {
        this(flags, type, name, init, null, 0, 0, 0, 0);
    }

    public FieldDeclaration(int flags, TypeName type, String name, Expression init, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.accessFlags = flags;
        this.type = type;
        this.name = name;
        this.initializer = init;
        if (type instanceof ArrayTypeName && this.initializer instanceof ArrayInitializer) {
            ((ArrayInitializer)this.initializer).setElementType(((ArrayTypeName)type).getElementType());
        }
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int f) {
        this.accessFlags = f;
        this.firePropertyChange(ACCESS_FLAGS, this.accessFlags, this.accessFlags);
    }

    public TypeName getType() {
        return this.type;
    }

    public void setType(TypeName t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.type = t;
        this.firePropertyChange(TYPE, this.type, this.type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression e) {
        this.initializer = e;
        this.firePropertyChange(INITIALIZER, this.initializer, this.initializer);
    }

    @Override
    public <T> T acceptVisitor(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this.getClass().getName()).append(": ").append(Modifier.toString(this.getAccessFlags())).append(" ").append(this.getType()).append(" ").append(this.getName()).append(" ").append(this.getInitializer()).append(")").toString();
    }
}

