/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.tree.AmbiguousName;
import koala.dynamicjava.tree.AnonymousAllocation;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayTypeName;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ConstructorCall;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.IntTypeName;
import koala.dynamicjava.tree.IntegerLiteral;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.ReferenceTypeName;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StringLiteral;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.VariableAccess;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDeclaration
extends ClassDeclaration {
    public EnumDeclaration(int flags, String name, List<? extends ReferenceTypeName> impl, EnumBody body) {
        this(flags, name, impl, body, null, 0, 0, 0, 0);
    }

    public EnumDeclaration(int flags, String name, List<? extends ReferenceTypeName> impl, EnumBody body, String fn, int bl, int bc, int el, int ec) {
        super(flags, name, new ReferenceTypeName("java.lang.Enum"), impl, EnumDeclaration.AddValues(name, EnumDeclaration.HandleConstructors(name, EnumDeclaration.makeEnumBodyDeclarationsFromEnumConsts(name, body)), body.getConstants()), fn, bl, bc, el, ec);
    }

    static List<Node> AddValues(String enumTypeName, List<Node> body, List<EnumConstant> consts) {
        List<Node> newbody = body;
        ReferenceTypeName enumType = new ReferenceTypeName(enumTypeName);
        LinkedList<StaticFieldAccess> cells = new LinkedList<StaticFieldAccess>();
        for (EnumConstant c : consts) {
            cells.add(new StaticFieldAccess(enumType, c.getName()));
        }
        ArrayAllocation alloc = new ArrayAllocation(enumType, new ArrayAllocation.TypeDescriptor(Collections.EMPTY_LIST, 1, new ArrayInitializer(cells), 0, 0));
        ReturnStatement valuesBody = new ReturnStatement(alloc);
        newbody.add(new MethodDeclaration(9, new ArrayTypeName(enumType, 1, false), "values", Collections.EMPTY_LIST, Collections.EMPTY_LIST, new BlockStatement(Collections.singletonList(valuesBody))));
        FormalParameter nameParam = new FormalParameter(false, new ReferenceTypeName("java", "lang", "String"), "name");
        LinkedList<Node> valueOfBody = new LinkedList<Node>();
        for (EnumConstant c : consts) {
            String cn = c.getName();
            ObjectMethodCall cond = new ObjectMethodCall(new StringLiteral(new StringBuffer().append("\"").append(cn).append("\"").toString()), "equals", Collections.singletonList(new VariableAccess("name")));
            ReturnStatement ret = new ReturnStatement(new StaticFieldAccess(enumType, cn));
            valueOfBody.add(new IfThenStatement(cond, ret));
        }
        valueOfBody.add(new ThrowStatement(new SimpleAllocation(new ReferenceTypeName("IllegalArgumentException"), Collections.EMPTY_LIST)));
        newbody.add(new MethodDeclaration(9, enumType, "valueOf", Collections.singletonList(nameParam), Collections.EMPTY_LIST, new BlockStatement(valueOfBody)));
        return newbody;
    }

    static List<Node> HandleConstructors(String name, List<Node> body) {
        ListIterator<Node> it = body.listIterator();
        LinkedList<FormalParameter> addToConsDeclaration = new LinkedList<FormalParameter>();
        addToConsDeclaration.add(new FormalParameter(false, new ReferenceTypeName("String"), "$1"));
        addToConsDeclaration.add(new FormalParameter(false, new IntTypeName(), "$2"));
        LinkedList<AmbiguousName> args = new LinkedList<AmbiguousName>();
        args.add(new AmbiguousName("$1"));
        args.add(new AmbiguousName("$2"));
        boolean noConstructor = true;
        while (it.hasNext()) {
            Node current = (Node)it.next();
            if (!(current instanceof ConstructorDeclaration)) continue;
            noConstructor = false;
            List<FormalParameter> consParams = ((ConstructorDeclaration)current).getParameters();
            LinkedList<FormalParameter> newConsParam = new LinkedList<FormalParameter>();
            newConsParam.addAll(addToConsDeclaration);
            newConsParam.addAll(consParams);
            ((ConstructorDeclaration)current).setParameters(newConsParam);
            ((ConstructorDeclaration)current).setConstructorCall(new ConstructorCall(null, args, true));
        }
        if (noConstructor) {
            body.add(new ConstructorDeclaration(2, name, addToConsDeclaration, new LinkedList(), new ConstructorCall(null, args, true), new LinkedList<Node>()));
        }
        return body;
    }

    static List<Node> makeEnumBodyDeclarationsFromEnumConsts(String enumTypeName, EnumBody body) {
        List<EnumConstant> consts = body.getConstants();
        List<Node> decls = body.getDeclarations();
        int accessFlags = 1;
        accessFlags |= 8;
        accessFlags |= 0x10;
        accessFlags |= 0x4000;
        ReferenceTypeName enumType = new ReferenceTypeName(enumTypeName);
        SimpleAllocation allocExpr = null;
        ListIterator<EnumConstant> it = consts.listIterator();
        int i = 0;
        while (it.hasNext()) {
            LinkedList<Expression> args = new LinkedList<Expression>();
            EnumConstant ec = (EnumConstant)it.next();
            args.add(new StringLiteral(new StringBuffer().append("\"").append(ec.getName()).append("\"").toString()));
            args.add(new IntegerLiteral(String.valueOf(i++)));
            if (ec.getArguments() != null) {
                args.addAll(ec.getArguments());
            }
            allocExpr = ec.getClassBody() != null ? new AnonymousAllocation(enumType, args, ec.getClassBody()) : new SimpleAllocation(enumType, args);
            decls.add(new FieldDeclaration(accessFlags, enumType, ec.getName(), allocExpr));
        }
        return decls;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumBody {
        private List<EnumConstant> consts;
        private List<Node> decls;

        public EnumBody(List<EnumConstant> c, List<Node> d) {
            this.consts = c;
            this.decls = d;
        }

        List<EnumConstant> getConstants() {
            return this.consts;
        }

        List<Node> getDeclarations() {
            return this.decls;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumConstant {
        String name;
        List<Expression> args;
        List<Node> classBody;

        public EnumConstant(String _name, List<? extends Expression> _args, List<Node> _classBody) {
            this.name = _name;
            this.args = _args == null ? null : new ArrayList<Expression>(_args);
            this.classBody = _classBody;
        }

        String getName() {
            return this.name;
        }

        List<Expression> getArguments() {
            return this.args;
        }

        List<Node> getClassBody() {
            return this.classBody;
        }
    }
}

