/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import com.rc.retroweaver.runtime.ClassMethods;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuite
implements Test {
    private String fName;
    private Vector<Test> fTests = new Vector(10);
    private static final /* synthetic */ Class class$junit$framework$TestCase;
    private static final /* synthetic */ Class class$java$lang$String;
    private static final /* synthetic */ Class class$junit$framework$Test;

    public static Test createTest(Class<? extends TestCase> theClass, String name) {
        TestCase test;
        Constructor<? extends TestCase> constructor;
        try {
            constructor = TestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e) {
            return TestSuite.warning(new StringBuffer().append("Class ").append(theClass.getName()).append(" has no public constructor TestCase(String name) or TestCase()").toString());
        }
        try {
            if (constructor.getParameterTypes().length == 0) {
                test = constructor.newInstance(new Object[0]);
                if (test instanceof TestCase) {
                    test.setName(name);
                }
            } else {
                test = constructor.newInstance(name);
            }
        }
        catch (InstantiationException e) {
            return TestSuite.warning(new StringBuffer().append("Cannot instantiate test case: ").append(name).append(" (").append(TestSuite.exceptionToString(e)).append(")").toString());
        }
        catch (InvocationTargetException e) {
            return TestSuite.warning(new StringBuffer().append("Exception in constructor: ").append(name).append(" (").append(TestSuite.exceptionToString(e.getTargetException())).append(")").toString());
        }
        catch (IllegalAccessException e) {
            return TestSuite.warning(new StringBuffer().append("Cannot access test case: ").append(name).append(" (").append(TestSuite.exceptionToString(e)).append(")").toString());
        }
        return test;
    }

    public static Constructor<? extends TestCase> getTestConstructor(Class<? extends TestCase> theClass) throws NoSuchMethodException {
        try {
            return theClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = TestSuite.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return theClass.getConstructor(new Class[0]);
        }
    }

    public static Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail(message);
            }
        };
    }

    private static String exceptionToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    public TestSuite() {
    }

    public TestSuite(Class<? extends TestCase> theClass) {
        this.fName = theClass.getName();
        try {
            TestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e) {
            this.addTest(TestSuite.warning(new StringBuffer().append("Class ").append(theClass.getName()).append(" has no public constructor TestCase(String name) or TestCase()").toString()));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(TestSuite.warning(new StringBuffer().append("Class ").append(theClass.getName()).append(" is not public").toString()));
            return;
        }
        Class<? extends TestCase> superClass = theClass;
        ArrayList<String> names = new ArrayList<String>();
        while ((class$junit$framework$Test == null ? TestSuite.class$("junit.framework.Test") : class$junit$framework$Test).isAssignableFrom(superClass)) {
            for (Method each : superClass.getDeclaredMethods()) {
                this.addTestMethod(each, names, theClass);
            }
            superClass = superClass.getSuperclass();
        }
        if (this.fTests.size() == 0) {
            this.addTest(TestSuite.warning(new StringBuffer().append("No tests found in ").append(theClass.getName()).toString()));
        }
    }

    public TestSuite(Class<? extends TestCase> theClass, String name) {
        this(theClass);
        this.setName(name);
    }

    public TestSuite(String name) {
        this.setName(name);
    }

    public TestSuite(Class<?> ... classes) {
        for (Class<?> each : classes) {
            this.addTest(new TestSuite(ClassMethods.asSubclass(each, class$junit$framework$TestCase == null ? TestSuite.class$("junit.framework.TestCase") : class$junit$framework$TestCase)));
        }
    }

    public TestSuite(Class<? extends TestCase>[] classes, String name) {
        this(classes);
        this.setName(name);
    }

    public void addTest(Test test) {
        this.fTests.add(test);
    }

    public void addTestSuite(Class<? extends TestCase> testClass) {
        this.addTest(new TestSuite(testClass));
    }

    @Override
    public int countTestCases() {
        int count = 0;
        for (Test each : this.fTests) {
            count += each.countTestCases();
        }
        return count;
    }

    public String getName() {
        return this.fName;
    }

    @Override
    public void run(TestResult result) {
        for (Test each : this.fTests) {
            if (result.shouldStop()) break;
            this.runTest(each, result);
        }
    }

    public void runTest(Test test, TestResult result) {
        test.run(result);
    }

    public void setName(String name) {
        this.fName = name;
    }

    public Test testAt(int index) {
        return this.fTests.get(index);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration<Test> tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    private void addTestMethod(Method m, List<String> names, Class<? extends TestCase> theClass) {
        String name = m.getName();
        if (names.contains(name)) {
            return;
        }
        if (!this.isPublicTestMethod(m)) {
            if (this.isTestMethod(m)) {
                this.addTest(TestSuite.warning(new StringBuffer().append("Test method isn't public: ").append(m.getName()).toString()));
            }
            return;
        }
        names.add(name);
        this.addTest(TestSuite.createTest(theClass, name));
    }

    private boolean isPublicTestMethod(Method m) {
        return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private boolean isTestMethod(Method m) {
        return m.getParameterTypes().length == 0 && m.getName().startsWith("test") && m.getReturnType().equals(Void.TYPE);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

