/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.DrJavaScrollableDialog;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class Utilities {
    public static volatile boolean TEST_MODE = false;
    public static final String JGOODIES_PACKAGE = "com.jgoodies.looks";

    public static void invokeLater(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        EventQueue.invokeLater(task);
    }

    public static void invokeAndWait(Runnable task) {
        if (EventQueue.isDispatchThread()) {
            task.run();
            return;
        }
        try {
            EventQueue.invokeAndWait(task);
        }
        catch (Exception e) {
            throw new UnexpectedException(e);
        }
    }

    public static void main(String[] args) {
        Utilities.clearEventQueue();
    }

    public static void clearEventQueue() {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
            }
        });
    }

    public static void show(final String msg) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new DrJavaScrollableDialog(null, "Debug Message", "Debug Message from Utilities.show():", msg, false).show();
            }
        });
    }

    public static void showTrace(final Throwable t) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new DrJavaErrorHandler().handle(t);
            }
        });
    }

    public static void showDebug(String msg) {
        Utilities.showMessageBox(msg, "Debug Message");
    }

    public static void showMessageBox(final String msg, final String title) {
        if (TEST_MODE) {
            System.out.println(title + ": " + msg);
        } else {
            Utilities.invokeAndWait(new Runnable(){

                public void run() {
                    new DrJavaScrollableDialog(null, title, "Message:", msg, false).show();
                }
            });
        }
    }

    public static void showStackTrace(final Throwable t) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                new DrJavaScrollableDialog(null, "Stack Trace", "Stack Trace:", StringOps.getStackTrace(t), false).show();
            }
        });
    }

    public static String getClipboardSelection(Component c) {
        Clipboard cb = c.getToolkit().getSystemClipboard();
        if (cb == null) {
            return null;
        }
        Transferable t = cb.getContents(null);
        if (t == null) {
            return null;
        }
        String s = null;
        try {
            int ch;
            Reader r = DataFlavor.stringFlavor.getReaderForText(t);
            StringBuffer sb = new StringBuffer();
            while ((ch = r.read()) != -1) {
                sb.append((char)ch);
            }
            s = sb.toString();
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return s;
    }

    public static AbstractAction createDelegateAction(String newName, final Action delegate) {
        return new AbstractAction(newName){

            public void actionPerformed(ActionEvent ae) {
                delegate.actionPerformed(ae);
            }
        };
    }

    public static boolean isPlasticLaf() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return laf != null && laf.getClass().getName().startsWith(JGOODIES_PACKAGE);
    }

    public static boolean isPlasticLaf(String name) {
        return name != null && name.startsWith(JGOODIES_PACKAGE);
    }
}

