/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.swing;

import com.rc.retroweaver.runtime.Autobox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxJList
extends JList
implements ListSelectionListener {
    static Color listForeground;
    static Color listBackground;
    static Color listSelectionForeground;
    static Color listSelectionBackground;
    HashSet<Integer> selectionCache = new HashSet();

    protected void init(Vector<?> listData, Vector<?> selData) {
        CheckBoxListCellRenderer r = new CheckBoxListCellRenderer();
        if (selData != null) {
            int i = 0;
            for (Object t : listData) {
                boolean sel = false;
                if (selData.contains(t)) {
                    this.selectionCache.add(Autobox.valueOf(i));
                    this.getSelectionModel().addSelectionInterval(i, i);
                    sel = true;
                }
                r.getListCellRendererComponent((JList)this, listData.get(i), i, sel, i == 0);
                ++i;
            }
        }
        this.setCellRenderer(r);
        this.addListSelectionListener(this);
    }

    public CheckBoxJList(Vector<?> listData) {
        super(listData);
        this.init(listData, null);
    }

    public CheckBoxJList(Vector<?> listData, Vector<?> selData) {
        super(listData);
        this.init(listData, selData);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            this.removeListSelectionListener(this);
            HashSet<Integer> newSelections = new HashSet<Integer>();
            int size = this.getModel().getSize();
            for (int i = 0; i < size; ++i) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                newSelections.add(Autobox.valueOf(i));
            }
            for (int index : this.selectionCache) {
                this.getSelectionModel().addSelectionInterval(index, index);
            }
            for (Integer nextInt : newSelections) {
                if (this.selectionCache.contains(nextInt)) {
                    this.getSelectionModel().removeSelectionInterval(nextInt, nextInt);
                    continue;
                }
                this.getSelectionModel().addSelectionInterval(nextInt, nextInt);
            }
            this.selectionCache.clear();
            for (int i = 0; i < size; ++i) {
                if (!this.getSelectionModel().isSelectedIndex(i)) continue;
                this.selectionCache.add(Autobox.valueOf(i));
            }
            this.addListSelectionListener(this);
        }
    }

    static {
        UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
        listForeground = uid.getColor("List.foreground");
        listBackground = uid.getColor("List.background");
        listSelectionForeground = uid.getColor("List.selectionForeground");
        listSelectionBackground = uid.getColor("List.selectionBackground");
    }

    private static class CheckBoxListCellRenderer
    extends JComponent
    implements ListCellRenderer {
        DefaultListCellRenderer defaultComp;
        JCheckBox checkbox;

        public CheckBoxListCellRenderer() {
            this.setLayout(new BorderLayout());
            this.defaultComp = new DefaultListCellRenderer();
            this.checkbox = new JCheckBox();
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.defaultComp, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.defaultComp.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.checkbox.setSelected(isSelected);
            Component[] comps = this.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                comps[i].setForeground(listForeground);
                comps[i].setBackground(listBackground);
            }
            return this;
        }
    }
}

