/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.sexp;

public interface Tokens {

    public static class NumberToken
    extends SExpToken {
        private double _num;

        public NumberToken(double num) {
            super(num % 1.0 == 0.0 ? "" + (int)num : "" + num);
            this._num = num;
        }

        public double getValue() {
            return this._num;
        }
    }

    public static class BooleanToken
    extends SExpToken {
        public static final BooleanToken TRUE = new BooleanToken(true);
        public static final BooleanToken FALSE = new BooleanToken(false);
        private boolean _bool;

        private BooleanToken(boolean bool) {
            super("" + bool);
            this._bool = bool;
        }

        public boolean getValue() {
            return this._bool;
        }
    }

    public static class QuotedTextToken
    extends SExpToken {
        public QuotedTextToken(String txt) {
            super(txt);
        }

        public String getFullText() {
            return "\"" + this._rep + "\"";
        }
    }

    public static class WordToken
    extends SExpToken {
        public WordToken(String word) {
            super(word);
        }
    }

    public static class BackSlashToken
    extends SExpToken {
        public static final BackSlashToken ONLY = new BackSlashToken();

        private BackSlashToken() {
            super("\\");
        }
    }

    public static class RightParenToken
    extends SExpToken {
        public static final RightParenToken ONLY = new RightParenToken();

        private RightParenToken() {
            super(")");
        }
    }

    public static class LeftParenToken
    extends SExpToken {
        public static final LeftParenToken ONLY = new LeftParenToken();

        private LeftParenToken() {
            super("(");
        }
    }

    public static class SExpToken {
        protected String _rep;

        public SExpToken(String rep) {
            this._rep = rep.intern();
        }

        public String getText() {
            return this._rep;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass() == this.getClass() && ((SExpToken)o)._rep == this._rep;
        }

        public int hashCode() {
            return this._rep.hashCode();
        }

        public String toString() {
            return this._rep;
        }
    }
}

