/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util.docnavigation;

import edu.rice.cs.util.docnavigation.GroupNotSelectedException;
import edu.rice.cs.util.docnavigation.IDocumentNavigator;
import edu.rice.cs.util.docnavigation.IDocumentNavigatorAlgo;
import edu.rice.cs.util.docnavigation.INavigationListener;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.INavigatorItemFilter;
import edu.rice.cs.util.docnavigation.NodeData;
import edu.rice.cs.util.docnavigation.NodeDataVisitor;
import edu.rice.cs.util.swing.Utilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JListNavigator<ItemT extends INavigatorItem>
extends JList
implements IDocumentNavigator<ItemT> {
    protected DefaultListModel _model;
    private volatile ItemT _current = null;
    private volatile CustomListCellRenderer _renderer;
    private final ArrayList<INavigationListener<? super ItemT>> navListeners = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$util$docnavigation$JListNavigator;

    public JListNavigator() {
        this.init(new DefaultListModel());
    }

    private void init(DefaultListModel m) {
        this._model = m;
        this.setModel(m);
        this.setSelectionMode(0);
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !JListNavigator.this._model.isEmpty()) {
                    final INavigatorItem newItem = (INavigatorItem)JListNavigator.this.getSelectedValue();
                    if (JListNavigator.access$000(JListNavigator.this) != newItem) {
                        final INavigatorItem oldItem = JListNavigator.access$000(JListNavigator.this);
                        NodeData oldData = new NodeData<ItemT>(){

                            @Override
                            public <Ret> Ret execute(NodeDataVisitor<? super ItemT, Ret> v, Object ... p) {
                                return v.itemCase(oldItem, p);
                            }
                        };
                        NodeData newData = new NodeData<ItemT>(){

                            @Override
                            public <Ret> Ret execute(NodeDataVisitor<? super ItemT, Ret> v, Object ... p) {
                                return v.itemCase(newItem, p);
                            }
                        };
                        Iterator i$ = JListNavigator.access$100(JListNavigator.this).iterator();
                        while (i$.hasNext()) {
                            INavigationListener listener = (INavigationListener)i$.next();
                            if (oldItem != null) {
                                listener.lostSelection(oldData, JListNavigator.this.isNextChangeModelInitiated());
                            }
                            if (newItem == null) continue;
                            listener.gainedSelection(newData, JListNavigator.this.isNextChangeModelInitiated());
                        }
                        JListNavigator.this.setNextChangeModelInitiated(false);
                        JListNavigator.access$002(JListNavigator.this, newItem);
                    }
                }
            }
        });
        this._renderer = new CustomListCellRenderer(null);
        this._renderer.setOpaque(true);
        this.setCellRenderer(this._renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(ItemT doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this._model.addElement(doc);
        }
    }

    @Override
    public void addDocument(ItemT doc, String path) {
        this.addDocument(doc);
    }

    protected ItemT getFromModel(int i) {
        INavigatorItem result = (INavigatorItem)this._model.get(i);
        return (ItemT)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT getNext(ItemT doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            int i = this._model.indexOf(doc);
            if (i == -1) {
                throw new IllegalArgumentException(new StringBuffer().append("No such document ").append(doc.toString()).append(" found in collection of open documents").toString());
            }
            if (i + 1 == this._model.size()) {
                return doc;
            }
            return this.getFromModel(i + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT getPrevious(ItemT doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            int i = this._model.indexOf(doc);
            if (i == -1) {
                throw new IllegalArgumentException(new StringBuffer().append("No such document ").append(doc.toString()).append(" found in collection of open documents").toString());
            }
            if (i == 0) {
                return doc;
            }
            return this.getFromModel(i - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT getFirst() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            return this.getFromModel(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT getLast() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            return this.getFromModel(this._model.size() - 1);
        }
    }

    @Override
    public ItemT getCurrent() {
        return this._current;
    }

    @Override
    public Object getModelLock() {
        return this._model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT removeDocument(ItemT doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            int i = this._model.indexOf(doc);
            if (i == -1) {
                throw new IllegalArgumentException(new StringBuffer().append("Document ").append(doc).append(" not found in Document Navigator").toString());
            }
            ItemT result = this.getFromModel(i);
            this._model.remove(i);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshDocument(ItemT doc, String path) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this.removeDocument(doc);
            this.addDocument(doc);
        }
    }

    @Override
    public void selectDocument(ItemT doc) {
        if (!($assertionsDisabled || Utilities.TEST_MODE || EventQueue.isDispatchThread())) {
            throw new AssertionError();
        }
        if (this._current == doc) {
            return;
        }
        boolean found = this._model.contains(doc);
        if (found) {
            this.setSelectedValue(doc, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(ItemT doc) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            return this._model.contains(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ItemT> getDocuments() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            Enumeration items = this._model.elements();
            ArrayList result = new ArrayList(this._model.size());
            while (items.hasMoreElements()) {
                result.add(items.nextElement());
            }
            return result;
        }
    }

    @Override
    public ArrayList<ItemT> getDocumentsInBin(String binName) {
        return new ArrayList(0);
    }

    @Override
    public int getDocumentCount() {
        return this._model.size();
    }

    @Override
    public boolean isEmpty() {
        return this._model.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNavigationListener(INavigationListener<? super ItemT> listener) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this.navListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNavigationListener(INavigationListener<? super ItemT> listener) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this.navListeners.remove(listener);
        }
    }

    @Override
    public Collection<INavigationListener<? super ItemT>> getNavigatorListeners() {
        return this.navListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            this._model.clear();
        }
    }

    @Override
    public <InType, ReturnType> ReturnType execute(IDocumentNavigatorAlgo<ItemT, InType, ReturnType> algo, InType input) {
        return algo.forList(this, input);
    }

    @Override
    public Container asContainer() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean selectDocumentAt(int x, int y) {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            int idx = this.locationToIndex(new Point(x, y));
            Rectangle rect = this.getCellBounds(idx, idx);
            if (rect.contains(x, y)) {
                this.selectDocument(this.getFromModel(idx));
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean isSelectedAt(int x, int y) {
        return false;
    }

    @Override
    public Component getRenderer() {
        return this._renderer;
    }

    @Override
    public int getSelectionCount() {
        return 1;
    }

    @Override
    public boolean isGroupSelected() {
        return false;
    }

    @Override
    public int getGroupSelectedCount() {
        return 0;
    }

    @Override
    public List<File> getSelectedFolders() {
        return new ArrayList<File>();
    }

    @Override
    public boolean isDocumentSelected() {
        return true;
    }

    @Override
    public int getDocumentSelectedCount() {
        return this.getSelectionCount();
    }

    @Override
    public List<ItemT> getSelectedDocuments() {
        ArrayList<INavigatorItem> l = new ArrayList<INavigatorItem>(1);
        l.add((INavigatorItem)this.getSelectedValue());
        return l;
    }

    @Override
    public boolean isRootSelected() {
        return false;
    }

    @Override
    public boolean isSelectedInGroup(ItemT i) {
        return false;
    }

    @Override
    public void addTopLevelGroup(String name, INavigatorItemFilter<? super ItemT> f) {
    }

    @Override
    public boolean isTopLevelGroupSelected() {
        return false;
    }

    @Override
    public Set<String> getNamesOfSelectedTopLevelGroup() throws GroupNotSelectedException {
        throw new GroupNotSelectedException("A top level group is not selected");
    }

    @Override
    public void requestSelectionUpdate(ItemT doc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        DefaultListModel defaultListModel = this._model;
        synchronized (defaultListModel) {
            return this._model.toString();
        }
    }

    @Override
    public void setNextChangeModelInitiated(boolean b) {
        this.putClientProperty("ModelInitiated", b ? Boolean.TRUE : null);
    }

    @Override
    public boolean isNextChangeModelInitiated() {
        return this.getClientProperty("ModelInitiated") != null;
    }

    static INavigatorItem access$000(JListNavigator x0) {
        return x0._current;
    }

    static ArrayList access$100(JListNavigator x0) {
        return x0.navListeners;
    }

    static INavigatorItem access$002(JListNavigator x0, INavigatorItem x1) {
        x0._current = x1;
        return x0._current;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$util$docnavigation$JListNavigator == null ? (class$edu$rice$cs$util$docnavigation$JListNavigator = JListNavigator.class$("edu.rice.cs.util.docnavigation.JListNavigator")) : class$edu$rice$cs$util$docnavigation$JListNavigator).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private CustomListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            this.setText(((INavigatorItem)value).getName());
            return this;
        }

        CustomListCellRenderer(1 x0) {
            this();
        }
    }
}

