/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import edu.rice.cs.plt.concurrent.CompletionMonitor;
import edu.rice.cs.util.GeneralProcessCreator;
import edu.rice.cs.util.StreamRedirectException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class StreamRedirectThread
extends Thread {
    private Reader in;
    private final Writer out;
    private static final int BUFFER_SIZE = 2048;
    private volatile boolean stop = false;
    private volatile boolean close = true;
    private volatile boolean keepRunning = false;
    private volatile CompletionMonitor cm = new CompletionMonitor();

    public StreamRedirectThread(String name, InputStream in, OutputStream out, boolean close) {
        this(name, in, out, close, false);
    }

    public StreamRedirectThread(String name, InputStream in, OutputStream out, ThreadGroup tg) {
        this(name, in, out, true, tg, false);
    }

    public StreamRedirectThread(String name, InputStream in, OutputStream out, boolean close, ThreadGroup tg) {
        this(name, in, out, close, tg, false);
    }

    public StreamRedirectThread(String name, InputStream in, OutputStream out) {
        this(name, in, out, true, false);
    }

    public StreamRedirectThread(String name, InputStream in, OutputStream out, boolean close, boolean keepRunning) {
        super(name);
        this.keepRunning = keepRunning;
        this.close = close;
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = new BufferedWriter(new OutputStreamWriter(out));
        this.setPriority(9);
    }

    public StreamRedirectThread(String name, InputStream in, OutputStream out, ThreadGroup tg, boolean keepRunning) {
        this(name, in, out, true, tg, keepRunning);
    }

    public StreamRedirectThread(String name, InputStream in, OutputStream out, boolean close, ThreadGroup tg, boolean keepRunning) {
        super(tg, name);
        this.keepRunning = keepRunning;
        this.close = close;
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = new BufferedWriter(new OutputStreamWriter(out));
        this.setPriority(9);
    }

    public void setInputStream(InputStream in) {
        this.in = new BufferedReader(new InputStreamReader(in));
        this.cm.signal();
    }

    public void run() {
        do {
            try {
                int count;
                char[] cbuf = new char[2048];
                while (!this.stop && (count = this.in.read(cbuf, 0, 2048)) >= 0) {
                    try {
                        this.out.write(cbuf, 0, count);
                        this.out.flush();
                    }
                    catch (IOException exc) {
                        GeneralProcessCreator.LOG.log("StreamRedirectThread " + this.getName() + " had IOException while writing: " + exc);
                        throw new StreamRedirectException("An error occurred during stream redirection, while piping data into a process.", exc);
                    }
                }
                GeneralProcessCreator.LOG.log("StreamRedirectThread " + this.getName() + " finished copying");
                this.out.flush();
                if (this.close) {
                    this.in.close();
                }
            }
            catch (IOException exc) {
                GeneralProcessCreator.LOG.log("StreamRedirectThread " + this.getName() + " had IOException: " + exc);
                throw new StreamRedirectException("An error occurred during stream redirection, while piping data out of a process.", exc);
            }
            if (!this.keepRunning) continue;
            while (!this.cm.attemptEnsureSignalled()) {
            }
            this.cm.reset();
        } while (this.keepRunning && !this.close);
        if (this.close) {
            try {
                this.out.close();
            }
            catch (IOException exc) {
                GeneralProcessCreator.LOG.log("StreamRedirectThread " + this.getName() + " had IOException: " + exc);
                throw new StreamRedirectException("An error occurred during stream redirection, while piping data out of a process.", exc);
            }
        }
    }

    public void setStopFlag() {
        this.stop = true;
    }
}

