/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.util;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Enum_;
import edu.rice.cs.plt.lambda.Lambda;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BalancingStreamTokenizer {
    protected Reader _reader;
    public Stack<Integer> _pushed = new Stack();
    protected State _state = new State();
    protected Stack<State> _stateStack = new Stack();
    protected Character _escape = null;
    protected boolean _wasEscape = false;
    protected boolean _isEscape = false;
    public volatile Token _token = Token.NONE;

    public BalancingStreamTokenizer(Reader r) {
        this(r, null);
    }

    public BalancingStreamTokenizer(Reader r, Character escape) {
        this._escape = escape;
        this._reader = r;
    }

    public void defaultWhitespaceSetup() {
        this.wordRange(0, 255);
        this.whitespaceRange(0, 32);
    }

    public void defaultTwoQuoteSetup() {
        this.wordRange(0, 255);
        this.whitespaceRange(0, 32);
        this.addQuotes("\"", "\"");
        this.addQuotes("'", "'");
    }

    public void defaultThreeQuoteSetup() {
        this.wordRange(0, 255);
        this.whitespaceRange(0, 32);
        this.addQuotes("\"", "\"");
        this.addQuotes("'", "'");
        this.addQuotes("`", "`");
    }

    public void defaultTwoQuoteCurlySetup() {
        this.wordRange(0, 255);
        this.whitespaceRange(0, 32);
        this.addQuotes("\"", "\"");
        this.addQuotes("'", "'");
        this.addQuotes("{", "}");
    }

    public void defaultThreeQuoteCurlySetup() {
        this.wordRange(0, 255);
        this.whitespaceRange(0, 32);
        this.addQuotes("\"", "\"");
        this.addQuotes("'", "'");
        this.addQuotes("`", "`");
        this.addQuotes("{", "}");
    }

    public void defaultThreeQuoteDollarCurlySetup() {
        this.wordRange(0, 255);
        this.whitespaceRange(0, 32);
        this.addQuotes("\"", "\"");
        this.addQuotes("'", "'");
        this.addQuotes("`", "`");
        this.addQuotes("${", "}");
    }

    protected int nextToken() throws IOException {
        if (this._pushed.empty()) {
            return this._reader.read();
        }
        return this._pushed.pop();
    }

    protected void pushToken(int token) {
        this._pushed.push(Autobox.valueOf(token));
    }

    public State getState() {
        return new State(this._state);
    }

    public void setState(State state) {
        this._state = state;
    }

    protected void pushState() {
        this._stateStack.push(this._state);
    }

    protected void popState() {
        this.setState(this._stateStack.pop());
    }

    public Token token() {
        return this._token;
    }

    public void wordRange(int lo, int hi) {
        ArrayList<String> kwToRemove = new ArrayList<String>();
        ArrayList<String> qpToRemove = new ArrayList<String>();
        for (int i = lo; i <= hi; ++i) {
            if (this._state.whitespace.contains(Autobox.valueOf(i))) {
                this._state.whitespace.remove(Autobox.valueOf(i));
            }
            for (String s : this._state.keywords) {
                if (s.charAt(0) != i) continue;
                kwToRemove.add(s);
            }
            for (String s : this._state.quotes) {
                if (s.charAt(0) != i) continue;
                qpToRemove.add(s);
            }
        }
        for (String s : kwToRemove) {
            this._state.keywords.remove(s);
        }
        for (String s : qpToRemove) {
            this._state.quotes.remove(s);
            this._state.quoteEnds.remove(this._state.quotePairs.get(s));
            this._state.quotePairs.remove(s);
        }
    }

    public void wordChars(int ... c) {
        ArrayList<String> kwToRemove = new ArrayList<String>();
        ArrayList<String> qpToRemove = new ArrayList<String>();
        for (int i : c) {
            if (this._state.whitespace.contains(Autobox.valueOf(i))) {
                this._state.whitespace.remove(Autobox.valueOf(i));
            }
            for (String s : this._state.keywords) {
                if (s.charAt(0) != i) continue;
                kwToRemove.add(s);
            }
            for (String s : this._state.quotes) {
                if (s.charAt(0) != i) continue;
                qpToRemove.add(s);
            }
        }
        for (String s : kwToRemove) {
            this._state.keywords.remove(s);
        }
        for (String s : qpToRemove) {
            this._state.quotes.remove(s);
            this._state.quoteEnds.remove(this._state.quotePairs.get(s));
            this._state.quotePairs.remove(s);
        }
    }

    public void whitespaceRange(int lo, int hi) {
        ArrayList<String> kwToRemove = new ArrayList<String>();
        ArrayList<String> qpToRemove = new ArrayList<String>();
        for (int i = lo; i <= hi; ++i) {
            if (this._escape != null && i == this._escape.charValue()) continue;
            this._state.whitespace.add(Autobox.valueOf(i));
            for (String s : this._state.keywords) {
                if (s.charAt(0) != i) continue;
                kwToRemove.add(s);
            }
            for (String s : this._state.quotes) {
                if (s.charAt(0) != i) continue;
                qpToRemove.add(s);
            }
        }
        for (String s : kwToRemove) {
            this._state.keywords.remove(s);
        }
        for (String s : qpToRemove) {
            this._state.quotes.remove(s);
            this._state.quoteEnds.remove(this._state.quotePairs.get(s));
            this._state.quotePairs.remove(s);
        }
    }

    public void whitespace(int ... c) {
        ArrayList<String> kwToRemove = new ArrayList<String>();
        ArrayList<String> qpToRemove = new ArrayList<String>();
        for (int i : c) {
            if (this._escape != null && i == this._escape.charValue()) continue;
            this._state.whitespace.add(Autobox.valueOf(i));
            for (String s : this._state.keywords) {
                if (s.charAt(0) != i) continue;
                kwToRemove.add(s);
            }
            for (String s : this._state.quotes) {
                if (s.charAt(0) != i) continue;
                qpToRemove.add(s);
            }
        }
        for (String s : kwToRemove) {
            this._state.keywords.remove(s);
        }
        for (String s : qpToRemove) {
            this._state.quotes.remove(s);
            this._state.quoteEnds.remove(this._state.quotePairs.get(s));
            this._state.quotePairs.remove(s);
        }
    }

    public void addQuotes(String begin, String end) {
        begin = this.escape(begin);
        end = this.escape(end);
        for (int c : this._state.whitespace) {
            if (begin.charAt(0) != c) continue;
            throw new QuoteStartsWithWhitespaceException(new StringBuffer().append("Cannot add quote pair '").append(begin).append("'-'").append(end).append("' because the first character of the beginning has ").append("already been marked as whitespace").toString());
        }
        for (String s : this._state.quotes) {
            if (!s.equals(end)) continue;
            throw new QuoteStartsWithWhitespaceException(new StringBuffer().append("Cannot add quote pair '").append(begin).append("'-'").append(end).append("' because the end is already used as beginning of another quote pair").toString());
        }
        String b = null;
        Iterator<String> qit = this._state.quotes.iterator();
        while (qit.hasNext() && !(b = qit.next()).equals(begin)) {
        }
        if (b != null && qit.hasNext()) {
            this._state.quotes.remove(b);
            this._state.quoteEnds.remove(this._state.quotePairs.get(b));
            this._state.quotePairs.remove(b);
        }
        this._state.quotes.add(begin);
        this._state.quoteEnds.add(end);
        this._state.quotePairs.put(begin, end);
        ArrayList<String> kwToRemove = new ArrayList<String>();
        for (String s : this._state.keywords) {
            if (!s.startsWith(begin)) continue;
            kwToRemove.add(s);
        }
        for (String s : kwToRemove) {
            this._state.keywords.remove(s);
        }
    }

    public void addKeyword(String kw) {
        kw = this.escape(kw);
        for (int c : this._state.whitespace) {
            if (kw.charAt(0) != c) continue;
            throw new KeywordStartsWithWhitespaceException(new StringBuffer().append("Cannot add keyword '").append(kw).append("' because the first character of the beginning has ").append("already been marked as whitespace").toString());
        }
        for (String s : this._state.quotes) {
            if (!s.startsWith(kw)) continue;
            throw new KeywordStartsWithQuoteException(new StringBuffer().append("Cannot add keyword '").append(kw).append("' because it has the same beginning as the quote pair '").append(s).append("'-'").append(this._state.quotePairs.get(s)).append("'").toString());
        }
        this._state.keywords.add(kw);
    }

    public String getNextToken() throws IOException {
        StringBuffer buf = new StringBuffer();
        int c = this.nextToken();
        while (c != -1) {
            String temp;
            boolean bl = this._isEscape = this._escape != null && (char)c == this._escape.charValue();
            if (this._state.whitespace.contains(Autobox.valueOf(c))) {
                if (this._wasEscape) {
                    buf.append(String.valueOf((char)c));
                    this._wasEscape = false;
                } else if (buf.length() > 0) {
                    this._token = Token.NORMAL;
                    return buf.toString();
                }
                c = this.nextToken();
                continue;
            }
            if (!this._wasEscape && (temp = this.findMatch(c, this._state.quotes, new Lambda<String, String>(){

                @Override
                public String value(String in) {
                    for (int i = in.length() - 1; i > 0; --i) {
                        BalancingStreamTokenizer.this.pushToken(in.charAt(i));
                    }
                    return null;
                }

                @Override
                public Object value(Object x0) {
                    return this.value((String)x0);
                }
            })) != null) {
                String s;
                if (buf.length() > 0) {
                    for (int i = temp.length() - 1; i >= 0; --i) {
                        this.pushToken(temp.charAt(i));
                    }
                    this._token = Token.NORMAL;
                    return buf.toString();
                }
                String begin = temp;
                Stack<String> quoteStack = new Stack<String>();
                quoteStack.add(begin);
                StringBuffer quoteBuf = new StringBuffer(this.unescape(begin));
                this.pushState();
                this._state = new State();
                this._state.whitespace.clear();
                this._state.keywords.clear();
                this._state.keywords.addAll(this._stateStack.peek().quotes);
                this._state.keywords.addAll(this._stateStack.peek().quoteEnds);
                this._state.quotes.clear();
                this._state.quoteEnds.clear();
                this._state.quotePairs.clear();
                while (quoteStack.size() > 0 && (s = this.getNextToken()) != null) {
                    if (this._stateStack.peek().quoteEnds.contains(s)) {
                        String top = (String)quoteStack.peek();
                        if (this._stateStack.peek().quotePairs.get(top).equals(s)) {
                            quoteBuf.append(this.unescape(s));
                            quoteStack.pop();
                            continue;
                        }
                        if (this._stateStack.peek().quotes.contains(s)) {
                            quoteBuf.append(this.unescape(s));
                            quoteStack.add(s);
                            continue;
                        }
                        quoteBuf.append(s);
                        break;
                    }
                    if (this._stateStack.peek().quotes.contains(s)) {
                        quoteBuf.append(this.unescape(s));
                        quoteStack.add(s);
                        continue;
                    }
                    quoteBuf.append(s);
                }
                this.popState();
                this._token = Token.QUOTED;
                return quoteBuf.toString();
            }
            if (!this._wasEscape && (temp = this.findMatch(c, this._state.keywords, new Lambda<String, String>(){

                @Override
                public String value(String in) {
                    for (int i = in.length() - 1; i > 0; --i) {
                        BalancingStreamTokenizer.this.pushToken(in.charAt(i));
                    }
                    return null;
                }

                @Override
                public Object value(Object x0) {
                    return this.value((String)x0);
                }
            })) != null) {
                if (buf.length() > 0) {
                    for (int i = temp.length() - 1; i >= 0; --i) {
                        this.pushToken(temp.charAt(i));
                    }
                    this._token = Token.NORMAL;
                    return buf.toString();
                }
                this._token = Token.KEYWORD;
                return this.unescape(temp);
            }
            if (this._isEscape) {
                if (this._wasEscape) {
                    buf.append(String.valueOf(this._escape));
                    this._wasEscape = false;
                    this._isEscape = false;
                } else {
                    int cnext = this.nextToken();
                    if (cnext != this._escape.charValue() && !this._state.whitespace.contains(Autobox.valueOf(cnext))) {
                        int i;
                        String temp2 = this.findMatch(cnext, this._state.quotes, new Lambda<String, String>(){

                            @Override
                            public String value(String in) {
                                for (int i = in.length() - 1; i > 0; --i) {
                                    BalancingStreamTokenizer.this.pushToken(in.charAt(i));
                                }
                                return null;
                            }

                            @Override
                            public Object value(Object x0) {
                                return this.value((String)x0);
                            }
                        });
                        if (temp2 != null) {
                            for (i = temp2.length() - 1; i > 0; --i) {
                                this.pushToken(temp2.charAt(i));
                            }
                        } else {
                            temp2 = this.findMatch(cnext, this._state.keywords, new Lambda<String, String>(){

                                @Override
                                public String value(String in) {
                                    for (int i = in.length() - 1; i > 0; --i) {
                                        BalancingStreamTokenizer.this.pushToken(in.charAt(i));
                                    }
                                    return null;
                                }

                                @Override
                                public Object value(Object x0) {
                                    return this.value((String)x0);
                                }
                            });
                            if (temp2 != null) {
                                for (i = temp2.length() - 1; i > 0; --i) {
                                    this.pushToken(temp2.charAt(i));
                                }
                            } else {
                                buf.append(String.valueOf(this._escape));
                                this._wasEscape = false;
                                this._isEscape = false;
                            }
                        }
                    }
                    this.pushToken(cnext);
                }
            } else {
                buf.append(String.valueOf((char)c));
            }
            this._wasEscape = this._isEscape;
            c = this.nextToken();
        }
        if (this._wasEscape) {
            buf.append(String.valueOf(this._escape));
        }
        if (buf.length() > 0) {
            this._token = Token.NORMAL;
            return buf.toString();
        }
        this._token = Token.END;
        return null;
    }

    public static TreeSet<String> prefixSet(Set<String> set, String prefix) {
        TreeSet<String> out = new TreeSet<String>();
        for (String s : set) {
            if (!s.startsWith(prefix)) continue;
            out.add(s);
        }
        return out;
    }

    protected String findMatch(int c, TreeSet<String> choices, Lambda<String, String> notFoundLambda) throws IOException {
        StringBuffer buf = new StringBuffer(String.valueOf((char)c));
        TreeSet<String> prefixSet = BalancingStreamTokenizer.prefixSet(choices, buf.toString());
        while (prefixSet.size() > 1 && (c = this.nextToken()) != -1) {
            buf.append(String.valueOf((char)c));
            prefixSet = BalancingStreamTokenizer.prefixSet(choices, buf.toString());
        }
        if (c != -1 && prefixSet.size() == 1 && choices.contains(prefixSet.first())) {
            String match = (String)prefixSet.first();
            while (c != -1 && buf.length() < match.length() && (c = this.nextToken()) != -1) {
                buf.append(String.valueOf((char)c));
            }
            if (buf.toString().equals(match)) {
                return buf.toString();
            }
        }
        return notFoundLambda.value(buf.toString());
    }

    protected String escape(String s) {
        if (this._escape == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (i == 0) {
                sb.append(s.charAt(0));
                continue;
            }
            if (s.charAt(i) == this._escape.charValue()) {
                sb.append(this._escape);
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    protected String unescape(String s) {
        if (this._escape == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (i == 0) {
                sb.append(s.charAt(0));
                continue;
            }
            if (s.charAt(i) == this._escape.charValue() && i + 1 < s.length() && s.charAt(i + 1) == this._escape.charValue()) {
                ++i;
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static class KeywordStartsWithQuoteException
    extends SetupException {
        public KeywordStartsWithQuoteException(String s) {
            super(s);
        }
    }

    public static class KeywordStartsWithWhitespaceException
    extends StartsWithWhitespaceException {
        public KeywordStartsWithWhitespaceException(String s) {
            super(s);
        }
    }

    public static class QuoteStartsWithWhitespaceException
    extends StartsWithWhitespaceException {
        public QuoteStartsWithWhitespaceException(String s) {
            super(s);
        }
    }

    public static class StartsWithWhitespaceException
    extends SetupException {
        public StartsWithWhitespaceException(String s) {
            super(s);
        }
    }

    public static class SetupException
    extends RuntimeException {
        public SetupException(String s) {
            super(s);
        }
    }

    /*
     * Signature claims super is java.lang.Enum<edu.rice.cs.util.BalancingStreamTokenizer$Token>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Token
    extends Enum_ {
        public static final /* enum */ Token NONE = new Token("NONE", 0);
        public static final /* enum */ Token NORMAL = new Token("NORMAL", 1);
        public static final /* enum */ Token QUOTED = new Token("QUOTED", 2);
        public static final /* enum */ Token KEYWORD = new Token("KEYWORD", 3);
        public static final /* enum */ Token END = new Token("END", 4);
        private static final /* synthetic */ Token[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$edu$rice$cs$util$BalancingStreamTokenizer$Token;

        public static Token[] values() {
            return (Token[])$VALUES.clone();
        }

        public static Token valueOf(String name) {
            return (Token)Enum_.valueOf(class$edu$rice$cs$util$BalancingStreamTokenizer$Token == null ? (class$edu$rice$cs$util$BalancingStreamTokenizer$Token = Token.class$("edu.rice.cs.util.BalancingStreamTokenizer$Token")) : class$edu$rice$cs$util$BalancingStreamTokenizer$Token, name);
        }

        private Token(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new Token[]{NONE, NORMAL, QUOTED, KEYWORD, END};
            Enum_.setEnumValues(Token.values(), class$edu$rice$cs$util$BalancingStreamTokenizer$Token == null ? (class$edu$rice$cs$util$BalancingStreamTokenizer$Token = Token.class$("edu.rice.cs.util.BalancingStreamTokenizer$Token")) : class$edu$rice$cs$util$BalancingStreamTokenizer$Token);
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    public static class State {
        public HashMap<String, String> quotePairs = new HashMap();
        public TreeSet<String> quotes = new TreeSet();
        public TreeSet<String> quoteEnds = new TreeSet();
        public TreeSet<String> keywords = new TreeSet();
        public HashSet<Integer> whitespace = new HashSet();

        public State() {
        }

        public State(State o) {
            this.quotePairs = new HashMap<String, String>(o.quotePairs);
            this.keywords = new TreeSet<String>((SortedSet<String>)o.keywords);
            this.quotes = new TreeSet<String>((SortedSet<String>)o.quotes);
            this.quoteEnds = new TreeSet<String>((SortedSet<String>)o.quoteEnds);
            this.whitespace = new HashSet<Integer>(o.whitespace);
        }
    }
}

