/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.text;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Enum_;
import edu.rice.cs.plt.collect.IndexedOneToOneRelation;
import edu.rice.cs.plt.collect.OneToOneRelation;
import edu.rice.cs.plt.iter.AbstractIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LazyThunk;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.recur.RecurUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextUtil {
    public static final String NEWLINE = System.getProperty("line.separator", "\n");
    private static final Thunk<OneToOneRelation<Character, String>> XML_ENTITIES = LazyThunk.make(new Thunk<OneToOneRelation<Character, String>>(){

        @Override
        public OneToOneRelation<Character, String> value() {
            IndexedOneToOneRelation<Character, String> result = new IndexedOneToOneRelation<Character, String>();
            result.add(Autobox.valueOf('\"'), "quot");
            result.add(Autobox.valueOf('&'), "amp");
            result.add(Autobox.valueOf('\''), "apos");
            result.add(Autobox.valueOf('<'), "lt");
            result.add(Autobox.valueOf('>'), "gt");
            return result;
        }

        @Override
        public Object value() {
            return this.value();
        }
    });
    private static final Thunk<OneToOneRelation<Character, String>> HTML_ENTITIES = LazyThunk.make(new Thunk<OneToOneRelation<Character, String>>(){

        @Override
        public OneToOneRelation<Character, String> value() {
            IndexedOneToOneRelation<Character, String> result = new IndexedOneToOneRelation<Character, String>();
            result.add(Autobox.valueOf('\''), "#39");
            result.add(Autobox.valueOf('\"'), "quot");
            result.add(Autobox.valueOf('&'), "amp");
            result.add(Autobox.valueOf('<'), "lt");
            result.add(Autobox.valueOf('>'), "gt");
            result.add(Autobox.valueOf('\u00a0'), "nbsp");
            result.add(Autobox.valueOf('\u00a1'), "iexcl");
            result.add(Autobox.valueOf('\u00a2'), "cent");
            result.add(Autobox.valueOf('\u00a3'), "pound");
            result.add(Autobox.valueOf('\u00a4'), "curren");
            result.add(Autobox.valueOf('\u00a5'), "yen");
            result.add(Autobox.valueOf('\u00a6'), "brvbar");
            result.add(Autobox.valueOf('\u00a7'), "sect");
            result.add(Autobox.valueOf('\u00a8'), "uml");
            result.add(Autobox.valueOf('\u00a9'), "copy");
            result.add(Autobox.valueOf('\u00aa'), "ordf");
            result.add(Autobox.valueOf('\u00ab'), "laquo");
            result.add(Autobox.valueOf('\u00ac'), "not");
            result.add(Autobox.valueOf('\u00ad'), "shy");
            result.add(Autobox.valueOf('\u00ae'), "reg");
            result.add(Autobox.valueOf('\u00af'), "macr");
            result.add(Autobox.valueOf('\u00b0'), "deg");
            result.add(Autobox.valueOf('\u00b1'), "plusmn");
            result.add(Autobox.valueOf('\u00b2'), "sup2");
            result.add(Autobox.valueOf('\u00b3'), "sup3");
            result.add(Autobox.valueOf('\u00b4'), "acute");
            result.add(Autobox.valueOf('\u00b5'), "micro");
            result.add(Autobox.valueOf('\u00b6'), "para");
            result.add(Autobox.valueOf('\u00b7'), "middot");
            result.add(Autobox.valueOf('\u00b8'), "cedil");
            result.add(Autobox.valueOf('\u00b9'), "sup1");
            result.add(Autobox.valueOf('\u00ba'), "ordm");
            result.add(Autobox.valueOf('\u00bb'), "raquo");
            result.add(Autobox.valueOf('\u00bc'), "frac14");
            result.add(Autobox.valueOf('\u00bd'), "frac12");
            result.add(Autobox.valueOf('\u00be'), "frac34");
            result.add(Autobox.valueOf('\u00bf'), "iquest");
            result.add(Autobox.valueOf('\u00c0'), "Agrave");
            result.add(Autobox.valueOf('\u00c1'), "Aacute");
            result.add(Autobox.valueOf('\u00c2'), "Acirc");
            result.add(Autobox.valueOf('\u00c3'), "Atilde");
            result.add(Autobox.valueOf('\u00c4'), "Auml");
            result.add(Autobox.valueOf('\u00c5'), "Aring");
            result.add(Autobox.valueOf('\u00c6'), "AElig");
            result.add(Autobox.valueOf('\u00c7'), "Ccedil");
            result.add(Autobox.valueOf('\u00c8'), "Egrave");
            result.add(Autobox.valueOf('\u00c9'), "Eacute");
            result.add(Autobox.valueOf('\u00ca'), "Ecirc");
            result.add(Autobox.valueOf('\u00cb'), "Euml");
            result.add(Autobox.valueOf('\u00cc'), "Igrave");
            result.add(Autobox.valueOf('\u00cd'), "Iacute");
            result.add(Autobox.valueOf('\u00ce'), "Icirc");
            result.add(Autobox.valueOf('\u00cf'), "Iuml");
            result.add(Autobox.valueOf('\u00d0'), "ETH");
            result.add(Autobox.valueOf('\u00d1'), "Ntilde");
            result.add(Autobox.valueOf('\u00d2'), "Ograve");
            result.add(Autobox.valueOf('\u00d3'), "Oacute");
            result.add(Autobox.valueOf('\u00d4'), "Ocirc");
            result.add(Autobox.valueOf('\u00d5'), "Otilde");
            result.add(Autobox.valueOf('\u00d6'), "Ouml");
            result.add(Autobox.valueOf('\u00d7'), "times");
            result.add(Autobox.valueOf('\u00d8'), "Oslash");
            result.add(Autobox.valueOf('\u00d9'), "Ugrave");
            result.add(Autobox.valueOf('\u00da'), "Uacute");
            result.add(Autobox.valueOf('\u00db'), "Ucirc");
            result.add(Autobox.valueOf('\u00dc'), "Uuml");
            result.add(Autobox.valueOf('\u00dd'), "Yacute");
            result.add(Autobox.valueOf('\u00de'), "THORN");
            result.add(Autobox.valueOf('\u00df'), "szlig");
            result.add(Autobox.valueOf('\u00e0'), "agrave");
            result.add(Autobox.valueOf('\u00e1'), "aacute");
            result.add(Autobox.valueOf('\u00e2'), "acirc");
            result.add(Autobox.valueOf('\u00e3'), "atilde");
            result.add(Autobox.valueOf('\u00e4'), "auml");
            result.add(Autobox.valueOf('\u00e5'), "aring");
            result.add(Autobox.valueOf('\u00e6'), "aelig");
            result.add(Autobox.valueOf('\u00e7'), "ccedil");
            result.add(Autobox.valueOf('\u00e8'), "egrave");
            result.add(Autobox.valueOf('\u00e9'), "eacute");
            result.add(Autobox.valueOf('\u00ea'), "ecirc");
            result.add(Autobox.valueOf('\u00eb'), "euml");
            result.add(Autobox.valueOf('\u00ec'), "igrave");
            result.add(Autobox.valueOf('\u00ed'), "iacute");
            result.add(Autobox.valueOf('\u00ee'), "icirc");
            result.add(Autobox.valueOf('\u00ef'), "iuml");
            result.add(Autobox.valueOf('\u00f0'), "eth");
            result.add(Autobox.valueOf('\u00f1'), "ntilde");
            result.add(Autobox.valueOf('\u00f2'), "ograve");
            result.add(Autobox.valueOf('\u00f3'), "oacute");
            result.add(Autobox.valueOf('\u00f4'), "ocirc");
            result.add(Autobox.valueOf('\u00f5'), "otilde");
            result.add(Autobox.valueOf('\u00f6'), "ouml");
            result.add(Autobox.valueOf('\u00f7'), "divide");
            result.add(Autobox.valueOf('\u00f8'), "oslash");
            result.add(Autobox.valueOf('\u00f9'), "ugrave");
            result.add(Autobox.valueOf('\u00fa'), "uacute");
            result.add(Autobox.valueOf('\u00fb'), "ucirc");
            result.add(Autobox.valueOf('\u00fc'), "uuml");
            result.add(Autobox.valueOf('\u00fd'), "yacute");
            result.add(Autobox.valueOf('\u00fe'), "thorn");
            result.add(Autobox.valueOf('\u00ff'), "yuml");
            result.add(Autobox.valueOf('\u0152'), "OElig");
            result.add(Autobox.valueOf('\u0153'), "oelig");
            result.add(Autobox.valueOf('\u0160'), "Scaron");
            result.add(Autobox.valueOf('\u0161'), "scaron");
            result.add(Autobox.valueOf('\u0178'), "Yuml");
            result.add(Autobox.valueOf('\u0192'), "fnof");
            result.add(Autobox.valueOf('\u02c6'), "circ");
            result.add(Autobox.valueOf('\u02dc'), "tilde");
            result.add(Autobox.valueOf('\u0391'), "Alpha");
            result.add(Autobox.valueOf('\u0392'), "Beta");
            result.add(Autobox.valueOf('\u0393'), "Gamma");
            result.add(Autobox.valueOf('\u0394'), "Delta");
            result.add(Autobox.valueOf('\u0395'), "Epsilon");
            result.add(Autobox.valueOf('\u0396'), "Zeta");
            result.add(Autobox.valueOf('\u0397'), "Eta");
            result.add(Autobox.valueOf('\u0398'), "Theta");
            result.add(Autobox.valueOf('\u0399'), "Iota");
            result.add(Autobox.valueOf('\u039a'), "Kappa");
            result.add(Autobox.valueOf('\u039b'), "Lambda");
            result.add(Autobox.valueOf('\u039c'), "Mu");
            result.add(Autobox.valueOf('\u039d'), "Nu");
            result.add(Autobox.valueOf('\u039e'), "Xi");
            result.add(Autobox.valueOf('\u039f'), "Omicron");
            result.add(Autobox.valueOf('\u03a0'), "Pi");
            result.add(Autobox.valueOf('\u03a1'), "Rho");
            result.add(Autobox.valueOf('\u03a3'), "Sigma");
            result.add(Autobox.valueOf('\u03a4'), "Tau");
            result.add(Autobox.valueOf('\u03a5'), "Upsilon");
            result.add(Autobox.valueOf('\u03a6'), "Phi");
            result.add(Autobox.valueOf('\u03a7'), "Chi");
            result.add(Autobox.valueOf('\u03a8'), "Psi");
            result.add(Autobox.valueOf('\u03a9'), "Omega");
            result.add(Autobox.valueOf('\u03b1'), "alpha");
            result.add(Autobox.valueOf('\u03b2'), "beta");
            result.add(Autobox.valueOf('\u03b3'), "gamma");
            result.add(Autobox.valueOf('\u03b4'), "delta");
            result.add(Autobox.valueOf('\u03b5'), "epsilon");
            result.add(Autobox.valueOf('\u03b6'), "zeta");
            result.add(Autobox.valueOf('\u03b7'), "eta");
            result.add(Autobox.valueOf('\u03b8'), "theta");
            result.add(Autobox.valueOf('\u03b9'), "iota");
            result.add(Autobox.valueOf('\u03ba'), "kappa");
            result.add(Autobox.valueOf('\u03bb'), "lambda");
            result.add(Autobox.valueOf('\u03bc'), "mu");
            result.add(Autobox.valueOf('\u03bd'), "nu");
            result.add(Autobox.valueOf('\u03be'), "xi");
            result.add(Autobox.valueOf('\u03bf'), "omicron");
            result.add(Autobox.valueOf('\u03c0'), "pi");
            result.add(Autobox.valueOf('\u03c1'), "rho");
            result.add(Autobox.valueOf('\u03c2'), "sigmaf");
            result.add(Autobox.valueOf('\u03c3'), "sigma");
            result.add(Autobox.valueOf('\u03c4'), "tau");
            result.add(Autobox.valueOf('\u03c5'), "upsilon");
            result.add(Autobox.valueOf('\u03c6'), "phi");
            result.add(Autobox.valueOf('\u03c7'), "chi");
            result.add(Autobox.valueOf('\u03c8'), "psi");
            result.add(Autobox.valueOf('\u03c9'), "omega");
            result.add(Autobox.valueOf('\u03d1'), "thetasym");
            result.add(Autobox.valueOf('\u03d2'), "upsih");
            result.add(Autobox.valueOf('\u03d6'), "piv");
            result.add(Autobox.valueOf('\u2002'), "ensp");
            result.add(Autobox.valueOf('\u2003'), "emsp");
            result.add(Autobox.valueOf('\u2009'), "thinsp");
            result.add(Autobox.valueOf('\u200c'), "zwnj");
            result.add(Autobox.valueOf('\u200d'), "zwj");
            result.add(Autobox.valueOf('\u200e'), "lrm");
            result.add(Autobox.valueOf('\u200f'), "rlm");
            result.add(Autobox.valueOf('\u2013'), "ndash");
            result.add(Autobox.valueOf('\u2014'), "mdash");
            result.add(Autobox.valueOf('\u2018'), "lsquo");
            result.add(Autobox.valueOf('\u2019'), "rsquo");
            result.add(Autobox.valueOf('\u201a'), "sbquo");
            result.add(Autobox.valueOf('\u201c'), "ldquo");
            result.add(Autobox.valueOf('\u201d'), "rdquo");
            result.add(Autobox.valueOf('\u201e'), "bdquo");
            result.add(Autobox.valueOf('\u2020'), "dagger");
            result.add(Autobox.valueOf('\u2021'), "Dagger");
            result.add(Autobox.valueOf('\u2022'), "bull");
            result.add(Autobox.valueOf('\u2026'), "hellip");
            result.add(Autobox.valueOf('\u2030'), "permil");
            result.add(Autobox.valueOf('\u2032'), "prime");
            result.add(Autobox.valueOf('\u2033'), "Prime");
            result.add(Autobox.valueOf('\u2039'), "lsaquo");
            result.add(Autobox.valueOf('\u203a'), "rsaquo");
            result.add(Autobox.valueOf('\u203e'), "oline");
            result.add(Autobox.valueOf('\u2044'), "frasl");
            result.add(Autobox.valueOf('\u20ac'), "euro");
            result.add(Autobox.valueOf('\u2111'), "image");
            result.add(Autobox.valueOf('\u2118'), "weierp");
            result.add(Autobox.valueOf('\u211c'), "real");
            result.add(Autobox.valueOf('\u2122'), "trade");
            result.add(Autobox.valueOf('\u2135'), "alefsym");
            result.add(Autobox.valueOf('\u2190'), "larr");
            result.add(Autobox.valueOf('\u2191'), "uarr");
            result.add(Autobox.valueOf('\u2192'), "rarr");
            result.add(Autobox.valueOf('\u2193'), "darr");
            result.add(Autobox.valueOf('\u2194'), "harr");
            result.add(Autobox.valueOf('\u21b5'), "crarr");
            result.add(Autobox.valueOf('\u21d0'), "lArr");
            result.add(Autobox.valueOf('\u21d1'), "uArr");
            result.add(Autobox.valueOf('\u21d2'), "rArr");
            result.add(Autobox.valueOf('\u21d3'), "dArr");
            result.add(Autobox.valueOf('\u21d4'), "hArr");
            result.add(Autobox.valueOf('\u2200'), "forall");
            result.add(Autobox.valueOf('\u2202'), "part");
            result.add(Autobox.valueOf('\u2203'), "exist");
            result.add(Autobox.valueOf('\u2205'), "empty");
            result.add(Autobox.valueOf('\u2207'), "nabla");
            result.add(Autobox.valueOf('\u2208'), "isin");
            result.add(Autobox.valueOf('\u2209'), "notin");
            result.add(Autobox.valueOf('\u220b'), "ni");
            result.add(Autobox.valueOf('\u220f'), "prod");
            result.add(Autobox.valueOf('\u2211'), "sum");
            result.add(Autobox.valueOf('\u2212'), "minus");
            result.add(Autobox.valueOf('\u2217'), "lowast");
            result.add(Autobox.valueOf('\u221a'), "radic");
            result.add(Autobox.valueOf('\u221d'), "prop");
            result.add(Autobox.valueOf('\u221e'), "infin");
            result.add(Autobox.valueOf('\u2220'), "ang");
            result.add(Autobox.valueOf('\u2227'), "and");
            result.add(Autobox.valueOf('\u2228'), "or");
            result.add(Autobox.valueOf('\u2229'), "cap");
            result.add(Autobox.valueOf('\u222a'), "cup");
            result.add(Autobox.valueOf('\u222b'), "int");
            result.add(Autobox.valueOf('\u2234'), "there4");
            result.add(Autobox.valueOf('\u223c'), "sim");
            result.add(Autobox.valueOf('\u2245'), "cong");
            result.add(Autobox.valueOf('\u2248'), "asymp");
            result.add(Autobox.valueOf('\u2260'), "ne");
            result.add(Autobox.valueOf('\u2261'), "equiv");
            result.add(Autobox.valueOf('\u2264'), "le");
            result.add(Autobox.valueOf('\u2265'), "ge");
            result.add(Autobox.valueOf('\u2282'), "sub");
            result.add(Autobox.valueOf('\u2283'), "sup");
            result.add(Autobox.valueOf('\u2284'), "nsub");
            result.add(Autobox.valueOf('\u2286'), "sube");
            result.add(Autobox.valueOf('\u2287'), "supe");
            result.add(Autobox.valueOf('\u2295'), "oplus");
            result.add(Autobox.valueOf('\u2297'), "otimes");
            result.add(Autobox.valueOf('\u22a5'), "perp");
            result.add(Autobox.valueOf('\u22c5'), "sdot");
            result.add(Autobox.valueOf('\u2308'), "lceil");
            result.add(Autobox.valueOf('\u2309'), "rceil");
            result.add(Autobox.valueOf('\u230a'), "lfloor");
            result.add(Autobox.valueOf('\u230b'), "rfloor");
            result.add(Autobox.valueOf('\u2329'), "lang");
            result.add(Autobox.valueOf('\u232a'), "rang");
            result.add(Autobox.valueOf('\u25ca'), "loz");
            result.add(Autobox.valueOf('\u2660'), "spades");
            result.add(Autobox.valueOf('\u2663'), "clubs");
            result.add(Autobox.valueOf('\u2665'), "hearts");
            result.add(Autobox.valueOf('\u2666'), "diams");
            return result;
        }

        @Override
        public Object value() {
            return this.value();
        }
    });

    private TextUtil() {
    }

    public static String toString(Object o) {
        return RecurUtil.safeToString(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SizedIterable<String> getLines(String s) {
        AbstractIterable result = IterUtil.empty();
        BufferedReader r = new BufferedReader(new StringReader(s));
        try {
            String line = r.readLine();
            while (line != null) {
                result = IterUtil.compose(result, line);
                line = r.readLine();
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {}
        }
        return result;
    }

    public static String repeat(String s, int copies) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < copies; ++i) {
            result.append(s);
        }
        return result.toString();
    }

    public static String repeat(char c, int copies) {
        char[] result = new char[copies];
        Arrays.fill(result, c);
        return String.valueOf(result);
    }

    public static String padLeft(String s, char c, int length) {
        StringBuffer result = new StringBuffer();
        int delta = length - s.length();
        for (int i = 0; i < delta; ++i) {
            result.append(c);
        }
        result.append(s);
        return result.toString();
    }

    public static String padRight(String s, char c, int length) {
        StringBuffer result = new StringBuffer();
        result.append(s);
        int delta = length - s.length();
        for (int i = 0; i < delta; ++i) {
            result.append(c);
        }
        return result.toString();
    }

    public static boolean contains(String s, int character) {
        return s.indexOf(character) >= 0;
    }

    public static boolean contains(String s, String piece) {
        return s.indexOf(piece) >= 0;
    }

    public static boolean containsAny(String s, int ... characters) {
        for (int c : characters) {
            if (!TextUtil.contains(s, c)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String s, String ... pieces) {
        for (String piece : pieces) {
            if (!TextUtil.contains(s, piece)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(String s, int ... characters) {
        for (int c : characters) {
            if (TextUtil.contains(s, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(String s, String ... pieces) {
        for (String piece : pieces) {
            if (TextUtil.contains(s, piece)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(String s, String piece) {
        return s.toLowerCase().indexOf(piece.toLowerCase()) >= 0;
    }

    public static boolean containsAnyIgnoreCase(String s, String ... pieces) {
        for (String piece : pieces) {
            if (!TextUtil.contains(s, piece)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllIgnoreCase(String s, String ... pieces) {
        for (String piece : pieces) {
            if (TextUtil.contains(s, piece)) continue;
            return false;
        }
        return true;
    }

    public static int indexOfFirst(String s, int ... characters) {
        int result = -1;
        for (int c : characters) {
            int index = s.indexOf(c);
            if (index < 0 || result >= 0 && index >= result) continue;
            result = index;
        }
        return result;
    }

    public static int indexOfFirst(String s, String ... pieces) {
        int result = -1;
        for (String piece : pieces) {
            int index = s.indexOf(piece);
            if (index < 0 || result >= 0 && index >= result) continue;
            result = index;
        }
        return result;
    }

    public static String prefix(String s, int delim) {
        int index = s.indexOf(delim);
        return index == -1 ? s : s.substring(0, index);
    }

    public static String removePrefix(String s, int delim) {
        int index = s.indexOf(delim);
        return index == -1 ? s : s.substring(index + 1);
    }

    public static String suffix(String s, int delim) {
        int index = s.lastIndexOf(delim);
        return index == -1 ? s : s.substring(index + 1);
    }

    public static String removeSuffix(String s, int delim) {
        int index = s.lastIndexOf(delim);
        return index == -1 ? s : s.substring(0, index);
    }

    public static String toHexString(byte[] bs) {
        return TextUtil.toHexString(bs, 0, bs.length);
    }

    public static String toHexString(byte[] bs, int offset, int length) {
        StringBuffer result = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            if (i > offset) {
                result.append(' ');
            }
            byte b = bs[i];
            result.append(Character.forDigit((b & 0xF0) >> 4, 16));
            result.append(Character.forDigit(b & 0xF, 16));
        }
        return result.toString();
    }

    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static String unicodeEscape(String s) {
        return new UnicodeTranslator(){

            protected void handleStandardChar(char c, boolean backslashed) {
                if (c > '\u007f') {
                    if (backslashed) {
                        this._result.append("\\u005c");
                    }
                    this._result.append("\\u");
                    this._result.append(TextUtil.padLeft(Integer.toHexString(c), '0', 4));
                    this._changed = true;
                } else {
                    if (backslashed) {
                        this._result.append('\\');
                    }
                    this._result.append(c);
                }
            }

            protected void handlePartialEscape(String escape) {
                this._result.append("\\u005cu");
                this._result.append(escape);
                this._changed = true;
            }

            protected void handleCompleteEscape(String escape) {
                this._result.append("\\uu");
                this._result.append(escape);
                this._changed = true;
            }
        }.value(s);
    }

    public static String unicodeUnescapeOnce(String s) {
        return new UnicodeTranslator(){

            protected void handleStandardChar(char c, boolean backslashed) {
                if (backslashed) {
                    this._result.append('\\');
                }
                this._result.append(c);
            }

            protected void handlePartialEscape(String escape) {
                throw new IllegalArgumentException("Expected a hexadecimal digit after '\\u" + escape + "'");
            }

            protected void handleCompleteEscape(String escape) {
                if (escape.charAt(0) == 'u') {
                    this._result.append('\\');
                    this._result.append(escape);
                } else {
                    this._result.append((char)Integer.parseInt(escape, 16));
                }
                this._changed = true;
            }
        }.value(s);
    }

    public static String unicodeUnescape(String s) {
        return new UnicodeTranslator(){

            protected void handleStandardChar(char c, boolean backslashed) {
                if (backslashed) {
                    this._result.append('\\');
                }
                this._result.append(c);
            }

            protected void handlePartialEscape(String escape) {
                throw new IllegalArgumentException("Expected a hexadecimal digit after '\\u" + escape + "'");
            }

            protected void handleCompleteEscape(String escape) {
                int firstDigit = escape.lastIndexOf(117) + 1;
                this._result.append((char)Integer.parseInt(escape.substring(firstDigit), 16));
                this._changed = true;
            }
        }.value(s);
    }

    public static String javaEscape(String s) {
        return new StringTranslator(){

            protected void processChar(char c) {
                switch (c) {
                    case '\b': {
                        this._result.append("\\b");
                        this._changed = true;
                        break;
                    }
                    case '\t': {
                        this._result.append("\\t");
                        this._changed = true;
                        break;
                    }
                    case '\n': {
                        this._result.append("\\n");
                        this._changed = true;
                        break;
                    }
                    case '\f': {
                        this._result.append("\\f");
                        this._changed = true;
                        break;
                    }
                    case '\r': {
                        this._result.append("\\r");
                        this._changed = true;
                        break;
                    }
                    case '\"': {
                        this._result.append("\\\"");
                        this._changed = true;
                        break;
                    }
                    case '\'': {
                        this._result.append("\\'");
                        this._changed = true;
                        break;
                    }
                    case '\\': {
                        this._result.append("\\\\");
                        this._changed = true;
                        break;
                    }
                    default: {
                        if (c < ' ' || c == '\u007f') {
                            this._result.append('\\');
                            this._result.append(TextUtil.padLeft(Integer.toOctalString(c), '0', 3));
                            this._changed = true;
                            break;
                        }
                        this._result.append(c);
                    }
                }
            }

            protected void finish() {
            }
        }.value(s);
    }

    public static String javaUnescape(String s) {
        return new StringTranslator(){
            private JState _state = JState.START;
            private final StringBuffer _buffer = new StringBuffer();

            private void reset(char c) {
                this._result.append((char)Integer.parseInt(this._buffer.toString(), 8));
                this._buffer.delete(0, this._buffer.length());
                this._state = JState.START;
                if (c == '\\') {
                    this._state = JState.BACKSLASH;
                    this._changed = true;
                } else {
                    this._result.append(c);
                }
            }

            protected void processChar(char c) {
                block0 : switch (11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$JState[this._state.ordinal()]) {
                    case 1: {
                        if (c == '\\') {
                            this._state = JState.BACKSLASH;
                            this._changed = true;
                            break;
                        }
                        this._result.append(c);
                        break;
                    }
                    case 2: {
                        switch (c) {
                            case 'b': {
                                this._result.append('\b');
                                this._state = JState.START;
                                break block0;
                            }
                            case 't': {
                                this._result.append('\t');
                                this._state = JState.START;
                                break block0;
                            }
                            case 'n': {
                                this._result.append('\n');
                                this._state = JState.START;
                                break block0;
                            }
                            case 'f': {
                                this._result.append('\f');
                                this._state = JState.START;
                                break block0;
                            }
                            case 'r': {
                                this._result.append('\r');
                                this._state = JState.START;
                                break block0;
                            }
                            case '\"': {
                                this._result.append('\"');
                                this._state = JState.START;
                                break block0;
                            }
                            case '\'': {
                                this._result.append('\'');
                                this._state = JState.START;
                                break block0;
                            }
                            case '\\': {
                                this._result.append('\\');
                                this._state = JState.START;
                                break block0;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': {
                                this._buffer.append(c);
                                this._state = JState.DIG1;
                                break block0;
                            }
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': {
                                this._buffer.append(c);
                                this._state = JState.DIG2;
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("'" + c + "' after '\\'");
                    }
                    case 3: {
                        if (TextUtil.isOctalDigit(c)) {
                            this._buffer.append(c);
                            this._state = JState.DIG2;
                            break;
                        }
                        this.reset(c);
                        break;
                    }
                    case 4: {
                        if (TextUtil.isOctalDigit(c)) {
                            this._buffer.append(c);
                            this._state = JState.DIG3;
                            break;
                        }
                        this.reset(c);
                        break;
                    }
                    case 5: {
                        this.reset(c);
                    }
                }
            }

            protected void finish() {
                switch (11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$JState[this._state.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        throw new IllegalArgumentException("Nothing after after '\\'");
                    }
                    default: {
                        this._result.append((char)Integer.parseInt(this._buffer.toString(), 8));
                    }
                }
            }
        }.value(s);
    }

    public static String regexEscape(String s) {
        return new StringTranslator(){

            protected void processChar(char c) {
                switch (c) {
                    case '\t': {
                        this._result.append("\\t");
                        this._changed = true;
                        break;
                    }
                    case '\n': {
                        this._result.append("\\n");
                        this._changed = true;
                        break;
                    }
                    case '\r': {
                        this._result.append("\\r");
                        this._changed = true;
                        break;
                    }
                    case '\f': {
                        this._result.append("\\f");
                        this._changed = true;
                        break;
                    }
                    case '\u0007': {
                        this._result.append("\\a");
                        this._changed = true;
                        break;
                    }
                    case '\u001b': {
                        this._result.append("\\e");
                        this._changed = true;
                        break;
                    }
                    default: {
                        if (c < ' ' || c == '\u007f') {
                            this._result.append("\\x");
                            this._result.append(TextUtil.padLeft(Integer.toHexString(c), '0', 2));
                            this._changed = true;
                            break;
                        }
                        if (c > ' ' && c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z' && c < '\u007f') {
                            this._result.append('\\');
                            this._result.append(c);
                            this._changed = true;
                            break;
                        }
                        this._result.append(c);
                    }
                }
            }

            protected void finish() {
            }
        }.value(s);
    }

    public static String sgmlEscape(String s, final Map<Character, String> entities, final boolean convertToAscii) {
        return new StringTranslator(){

            protected void processChar(char c) {
                String entity = (String)entities.get(Autobox.valueOf(c));
                if (entity != null) {
                    this._result.append('&');
                    this._result.append(entity);
                    this._result.append(';');
                    this._changed = true;
                } else if (convertToAscii && c > '\u007f') {
                    this._result.append("&#");
                    this._result.append((int)c);
                    this._result.append(';');
                    this._changed = true;
                } else {
                    this._result.append(c);
                }
            }

            protected void finish() {
            }
        }.value(s);
    }

    public static String sgmlUnescape(String s, final Map<String, Character> entities) {
        return new StringTranslator(){
            private SGMLState _state = SGMLState.START;
            private final StringBuffer _buffer = new StringBuffer();

            private void reset() {
                this._buffer.delete(0, this._buffer.length());
                this._state = SGMLState.START;
            }

            protected void processChar(char c) {
                switch (11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$SGMLState[this._state.ordinal()]) {
                    case 1: {
                        if (c == '&') {
                            this._state = SGMLState.AMP;
                            this._changed = true;
                            break;
                        }
                        this._result.append(c);
                        break;
                    }
                    case 2: {
                        if (c == '#') {
                            this._state = SGMLState.NUM;
                            break;
                        }
                        if (c == ';') {
                            throw new IllegalArgumentException("Missing entity name");
                        }
                        this._state = SGMLState.NAME;
                        this._buffer.append(c);
                        break;
                    }
                    case 3: {
                        if (c == ';') {
                            Character namedChar = (Character)entities.get(this._buffer.toString());
                            if (namedChar == null) {
                                throw new IllegalArgumentException("Unrecognized entity name: '" + this._buffer.toString() + "'");
                            }
                            this._result.append(namedChar.charValue());
                            this.reset();
                            break;
                        }
                        this._buffer.append(c);
                        break;
                    }
                    case 4: {
                        if (c == 'x') {
                            this._state = SGMLState.HEX_DIGITS;
                            break;
                        }
                        if (TextUtil.isDecimalDigit(c)) {
                            this._state = SGMLState.DEC_DIGITS;
                            this._buffer.append(c);
                            break;
                        }
                        throw new IllegalArgumentException("Expected decimal digit: '" + c + "'");
                    }
                    case 5: {
                        if (c == ';') {
                            if (this._buffer.length() == 0) {
                                throw new IllegalArgumentException("Expected hexadecimal digit: ';'");
                            }
                            this._result.append((char)Integer.parseInt(this._buffer.toString(), 16));
                            this.reset();
                            break;
                        }
                        if (TextUtil.isHexDigit(c)) {
                            this._buffer.append(c);
                            break;
                        }
                        throw new IllegalArgumentException("Expected hexadecimal digit: '" + c + "'");
                    }
                    case 6: {
                        if (c == ';') {
                            this._result.append((char)Integer.parseInt(this._buffer.toString()));
                            this.reset();
                            break;
                        }
                        if (TextUtil.isDecimalDigit(c)) {
                            this._buffer.append(c);
                            break;
                        }
                        throw new IllegalArgumentException("Expected decimal digit: '" + c + "'");
                    }
                }
            }

            protected void finish() {
                if (this._state != SGMLState.START) {
                    throw new IllegalArgumentException("Unfinished entity");
                }
            }
        }.value(s);
    }

    public static String xmlEscape(String s) {
        return TextUtil.sgmlEscape(s, XML_ENTITIES.value().functionMap(), true);
    }

    public static String xmlEscape(String s, boolean convertToAscii) {
        return TextUtil.sgmlEscape(s, XML_ENTITIES.value().functionMap(), convertToAscii);
    }

    public static String xmlUnescape(String s) {
        return TextUtil.sgmlUnescape(s, XML_ENTITIES.value().injectionMap());
    }

    public static String htmlEscape(String s) {
        return TextUtil.sgmlEscape(s, HTML_ENTITIES.value().functionMap(), true);
    }

    public static String htmlUnescape(String s) {
        return TextUtil.sgmlUnescape(s, HTML_ENTITIES.value().injectionMap());
    }

    static class 11 {
        static final /* synthetic */ int[] $SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State;
        static final /* synthetic */ int[] $SwitchMap$edu$rice$cs$plt$text$TextUtil$JState;
        static final /* synthetic */ int[] $SwitchMap$edu$rice$cs$plt$text$TextUtil$SGMLState;

        static {
            $SwitchMap$edu$rice$cs$plt$text$TextUtil$SGMLState = new int[SGMLState.values().length];
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$SGMLState[SGMLState.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$SGMLState[SGMLState.AMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$SGMLState[SGMLState.NAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$SGMLState[SGMLState.NUM.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$SGMLState[SGMLState.HEX_DIGITS.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$SGMLState[SGMLState.DEC_DIGITS.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            $SwitchMap$edu$rice$cs$plt$text$TextUtil$JState = new int[JState.values().length];
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$JState[JState.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$JState[JState.BACKSLASH.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$JState[JState.DIG1.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$JState[JState.DIG2.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$JState[JState.DIG3.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            $SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State = new int[UnicodeTranslator.State.values().length];
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State[UnicodeTranslator.State.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State[UnicodeTranslator.State.BACKSLASH.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State[UnicodeTranslator.State.U.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State[UnicodeTranslator.State.DIG1.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State[UnicodeTranslator.State.DIG2.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State[UnicodeTranslator.State.DIG3.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * Signature claims super is java.lang.Enum<edu.rice.cs.plt.text.TextUtil$SGMLState>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SGMLState
    extends Enum_ {
        public static final /* enum */ SGMLState START = new SGMLState("START", 0);
        public static final /* enum */ SGMLState AMP = new SGMLState("AMP", 1);
        public static final /* enum */ SGMLState NAME = new SGMLState("NAME", 2);
        public static final /* enum */ SGMLState NUM = new SGMLState("NUM", 3);
        public static final /* enum */ SGMLState HEX_DIGITS = new SGMLState("HEX_DIGITS", 4);
        public static final /* enum */ SGMLState DEC_DIGITS = new SGMLState("DEC_DIGITS", 5);
        private static final /* synthetic */ SGMLState[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$edu$rice$cs$plt$text$TextUtil$SGMLState;

        public static SGMLState[] values() {
            return (SGMLState[])$VALUES.clone();
        }

        public static SGMLState valueOf(String name) {
            return (SGMLState)Enum_.valueOf(class$edu$rice$cs$plt$text$TextUtil$SGMLState == null ? (class$edu$rice$cs$plt$text$TextUtil$SGMLState = SGMLState.class$("edu.rice.cs.plt.text.TextUtil$SGMLState")) : class$edu$rice$cs$plt$text$TextUtil$SGMLState, name);
        }

        private SGMLState(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new SGMLState[]{START, AMP, NAME, NUM, HEX_DIGITS, DEC_DIGITS};
            Enum_.setEnumValues(SGMLState.values(), class$edu$rice$cs$plt$text$TextUtil$SGMLState == null ? (class$edu$rice$cs$plt$text$TextUtil$SGMLState = SGMLState.class$("edu.rice.cs.plt.text.TextUtil$SGMLState")) : class$edu$rice$cs$plt$text$TextUtil$SGMLState);
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    /*
     * Signature claims super is java.lang.Enum<edu.rice.cs.plt.text.TextUtil$JState>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JState
    extends Enum_ {
        public static final /* enum */ JState START = new JState("START", 0);
        public static final /* enum */ JState BACKSLASH = new JState("BACKSLASH", 1);
        public static final /* enum */ JState DIG1 = new JState("DIG1", 2);
        public static final /* enum */ JState DIG2 = new JState("DIG2", 3);
        public static final /* enum */ JState DIG3 = new JState("DIG3", 4);
        private static final /* synthetic */ JState[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$edu$rice$cs$plt$text$TextUtil$JState;

        public static JState[] values() {
            return (JState[])$VALUES.clone();
        }

        public static JState valueOf(String name) {
            return (JState)Enum_.valueOf(class$edu$rice$cs$plt$text$TextUtil$JState == null ? (class$edu$rice$cs$plt$text$TextUtil$JState = JState.class$("edu.rice.cs.plt.text.TextUtil$JState")) : class$edu$rice$cs$plt$text$TextUtil$JState, name);
        }

        private JState(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new JState[]{START, BACKSLASH, DIG1, DIG2, DIG3};
            Enum_.setEnumValues(JState.values(), class$edu$rice$cs$plt$text$TextUtil$JState == null ? (class$edu$rice$cs$plt$text$TextUtil$JState = JState.class$("edu.rice.cs.plt.text.TextUtil$JState")) : class$edu$rice$cs$plt$text$TextUtil$JState);
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }

    private static abstract class UnicodeTranslator
    extends StringTranslator {
        private State _state = State.START;
        private StringBuffer _buffer = new StringBuffer();

        UnicodeTranslator() {
        }

        protected abstract void handleStandardChar(char var1, boolean var2);

        protected abstract void handlePartialEscape(String var1);

        protected abstract void handleCompleteEscape(String var1);

        private void reset(char c) {
            this.handlePartialEscape(this._buffer.toString());
            this._buffer.delete(0, this._buffer.length());
            this._state = State.START;
            if (c == '\\') {
                this._state = State.BACKSLASH;
            } else {
                this.handleStandardChar(c, false);
            }
        }

        protected final void processChar(char c) {
            switch (11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State[this._state.ordinal()]) {
                case 1: {
                    if (c == '\\') {
                        this._state = State.BACKSLASH;
                        break;
                    }
                    this.handleStandardChar(c, false);
                    break;
                }
                case 2: {
                    if (c == 'u') {
                        this._state = State.U;
                        break;
                    }
                    this.handleStandardChar(c, true);
                    this._state = State.START;
                    break;
                }
                case 3: {
                    if (TextUtil.isHexDigit(c)) {
                        this._buffer.append(c);
                        this._state = State.DIG1;
                        break;
                    }
                    if (c == 'u') break;
                    this.reset(c);
                    break;
                }
                case 4: {
                    if (TextUtil.isHexDigit(c)) {
                        this._buffer.append(c);
                        this._state = State.DIG2;
                        break;
                    }
                    this.reset(c);
                    break;
                }
                case 5: {
                    if (TextUtil.isHexDigit(c)) {
                        this._buffer.append(c);
                        this._state = State.DIG3;
                        break;
                    }
                    this.reset(c);
                    break;
                }
                case 6: {
                    if (TextUtil.isHexDigit(c)) {
                        this._buffer.append(c);
                        this.handleCompleteEscape(this._buffer.toString());
                        this._buffer.delete(0, this._buffer.length());
                        this._state = State.START;
                        break;
                    }
                    this.reset(c);
                }
            }
        }

        protected final void finish() {
            switch (11.$SwitchMap$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State[this._state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.handleStandardChar('\\', false);
                    break;
                }
                default: {
                    this.handlePartialEscape(this._buffer.toString());
                }
            }
        }

        /*
         * Signature claims super is java.lang.Enum<edu.rice.cs.plt.text.TextUtil$UnicodeTranslator$State>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class State
        extends Enum_ {
            public static final /* enum */ State START = new State("START", 0);
            public static final /* enum */ State BACKSLASH = new State("BACKSLASH", 1);
            public static final /* enum */ State U = new State("U", 2);
            public static final /* enum */ State DIG1 = new State("DIG1", 3);
            public static final /* enum */ State DIG2 = new State("DIG2", 4);
            public static final /* enum */ State DIG3 = new State("DIG3", 5);
            private static final /* synthetic */ State[] $VALUES;
            private static final /* synthetic */ long serialVersionUID = 0L;
            private static final /* synthetic */ Class class$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String name) {
                return (State)Enum_.valueOf(class$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State == null ? (class$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State = State.class$("edu.rice.cs.plt.text.TextUtil$UnicodeTranslator$State")) : class$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State, name);
            }

            private State(String string, int n) {
                super(string, n);
            }

            static {
                $VALUES = new State[]{START, BACKSLASH, U, DIG1, DIG2, DIG3};
                Enum_.setEnumValues(State.values(), class$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State == null ? (class$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State = State.class$("edu.rice.cs.plt.text.TextUtil$UnicodeTranslator$State")) : class$edu$rice$cs$plt$text$TextUtil$UnicodeTranslator$State);
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class StringTranslator
    implements Lambda<String, String> {
        protected final StringBuffer _result = new StringBuffer();
        protected boolean _changed = false;

        StringTranslator() {
        }

        @Override
        public final String value(String s) {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                this.processChar(s.charAt(i));
            }
            this.finish();
            return this._changed ? this._result.toString() : s;
        }

        protected abstract void processChar(char var1);

        protected abstract void finish();

        @Override
        public Object value(Object x0) {
            return this.value((String)x0);
        }
    }
}

