/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.reflect;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.reflect.ReflectUtil;
import java.net.URL;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowingClassLoader
extends ClassLoader {
    private final Iterable<? extends String> _prefixes;
    private final boolean _blackList;
    private final boolean _filterBootClasses;

    public static ShadowingClassLoader blackList(ClassLoader parent, String ... excludePrefixes) {
        return new ShadowingClassLoader(parent, true, (Iterable_)((Object)IterUtil.asIterable(excludePrefixes)), false);
    }

    public static ShadowingClassLoader whiteList(ClassLoader parent, String ... includePrefixes) {
        return new ShadowingClassLoader(parent, false, (Iterable_)((Object)IterUtil.asIterable(includePrefixes)), false);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public ShadowingClassLoader(ClassLoader parent, boolean blackList, Iterable_ prefixes, boolean filterBootClasses) {
        super(parent);
        this._blackList = blackList;
        this._prefixes = prefixes;
        this._filterBootClasses = filterBootClasses;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if ((this._filterBootClasses || !this.isBootClass(name)) && this.matchesPrefixes(name) == this._blackList) {
            throw new ClassNotFoundException(new StringBuffer().append(name).append(" is being shadowed").toString());
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        if ((this._filterBootClasses || !this.isBootResource(name)) && this.matchesPrefixes(name.replace('/', '.')) == this._blackList) {
            return null;
        }
        return super.getResource(name);
    }

    private boolean isBootClass(String name) {
        try {
            ReflectUtil.BOOT_CLASS_LOADER.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isBootResource(String name) {
        return ReflectUtil.BOOT_CLASS_LOADER.getResource(name) != null;
    }

    private boolean matchesPrefixes(String name) {
        Iterator i$ = IterableMethods.iterator(this._prefixes);
        while (i$.hasNext()) {
            String p = (String)i$.next();
            if (!name.startsWith(p) || !name.equals(p) && !name.startsWith(new StringBuffer().append(p).append(".").toString()) && !name.startsWith(new StringBuffer().append(p).append("$").toString())) continue;
            return true;
        }
        return false;
    }
}

