/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.recur;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.Enum_;
import edu.rice.cs.plt.collect.TotalMap;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.Lambda2;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate2;
import edu.rice.cs.plt.recur.RecursionStack;
import edu.rice.cs.plt.recur.RecursionStack2;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.text.TextUtil;
import java.util.Arrays;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RecurUtil {
    private static final TotalMap<Thread, RecursionStack<Object>> TO_STRING_STACKS;
    private static final TotalMap<Thread, RecursionStack2<Object, Object>> EQUALS_STACKS;
    private static final TotalMap<Thread, RecursionStack<Object>> HASH_CODE_STACKS;
    private static final Lambda<ArrayStringMode, Lambda<Object, String>> TO_STRING_GENERATOR;
    private static final Lambda<ArrayStringMode, Lambda<Object, String>> DEFAULT_INF_STRING_GENERATOR;
    private static final Lambda2<Object, Object, Boolean> EQUALS;
    private static final Lambda<Object, Integer> HASH_CODE;
    private static final Lambda<Object, Integer> DEFAULT_INF_HASH_CODE;

    private RecurUtil() {
    }

    public static String safeToString(Object obj) {
        return RecurUtil.safeToString(obj, DEFAULT_INF_STRING_GENERATOR.value(ArrayStringMode.DEEP_BRACED), 1, ArrayStringMode.DEEP_BRACED);
    }

    public static String safeToString(Object obj, String infiniteString) {
        return RecurUtil.safeToString(obj, infiniteString, 1, ArrayStringMode.DEEP_BRACED);
    }

    public static <T> String safeToString(T obj, Lambda<? super T, String> infiniteString) {
        return RecurUtil.safeToString(obj, infiniteString, 1, ArrayStringMode.DEEP_BRACED);
    }

    public static String safeToString(Object obj, ArrayStringMode arrayMode) {
        return RecurUtil.safeToString(obj, DEFAULT_INF_STRING_GENERATOR.value(arrayMode), 1, arrayMode);
    }

    public static String safeToString(Object obj, String infiniteString, ArrayStringMode arrayMode) {
        return RecurUtil.safeToString(obj, LambdaUtil.valueLambda(infiniteString), 1, arrayMode);
    }

    public static <T> String safeToString(T obj, Lambda<? super T, String> infiniteString, ArrayStringMode arrayMode) {
        return RecurUtil.safeToString(obj, infiniteString, 1, arrayMode);
    }

    public static String safeToString(Object obj, int depth) {
        return RecurUtil.safeToString(obj, DEFAULT_INF_STRING_GENERATOR.value(ArrayStringMode.DEEP_BRACED), depth, ArrayStringMode.DEEP_BRACED);
    }

    public static String safeToString(Object obj, String infiniteString, int depth) {
        return RecurUtil.safeToString(obj, infiniteString, depth, ArrayStringMode.DEEP_BRACED);
    }

    public static <T> String safeToString(T obj, Lambda<? super T, String> infiniteString, int depth) {
        return RecurUtil.safeToString(obj, infiniteString, depth, ArrayStringMode.DEEP_BRACED);
    }

    public static String safeToString(Object obj, int depth, ArrayStringMode arrayMode) {
        return RecurUtil.safeToString(obj, DEFAULT_INF_STRING_GENERATOR.value(arrayMode), depth, arrayMode);
    }

    public static String safeToString(Object obj, String infiniteString, int depth, ArrayStringMode arrayMode) {
        return RecurUtil.safeToString(obj, LambdaUtil.valueLambda(infiniteString), depth, arrayMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String safeToString(T obj, Lambda<? super T, String> infiniteString, int depth, ArrayStringMode arrayMode) {
        RecursionStack<Object> stack;
        if (obj == null) {
            return "null";
        }
        Thread t = Thread.currentThread();
        TotalMap<Thread, RecursionStack<Object>> totalMap = TO_STRING_STACKS;
        synchronized (totalMap) {
            stack = TO_STRING_STACKS.get(t);
        }
        String result = stack.apply(TO_STRING_GENERATOR.value(arrayMode), infiniteString, obj);
        if (stack.isEmpty()) {
            TotalMap<Thread, RecursionStack<Object>> totalMap2 = TO_STRING_STACKS;
            synchronized (totalMap2) {
                TO_STRING_STACKS.revert(t);
            }
        }
        return result;
    }

    public static String arrayToString(Object array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(Object array, ArrayStringMode stringMode) {
        if (array instanceof Object[]) {
            return RecurUtil.arrayToString((Object[])array, stringMode);
        }
        if (array instanceof int[]) {
            return RecurUtil.arrayToString((int[])array, stringMode);
        }
        if (array instanceof char[]) {
            return RecurUtil.arrayToString((char[])array, stringMode);
        }
        if (array instanceof byte[]) {
            return RecurUtil.arrayToString((byte[])array, stringMode);
        }
        if (array instanceof double[]) {
            return RecurUtil.arrayToString((double[])array, stringMode);
        }
        if (array instanceof boolean[]) {
            return RecurUtil.arrayToString((boolean[])array, stringMode);
        }
        if (array instanceof short[]) {
            return RecurUtil.arrayToString((short[])array, stringMode);
        }
        if (array instanceof long[]) {
            return RecurUtil.arrayToString((long[])array, stringMode);
        }
        if (array instanceof float[]) {
            return RecurUtil.arrayToString((float[])array, stringMode);
        }
        throw new IllegalArgumentException("Non-array argument");
    }

    public static String arrayToString(Object[] array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(Object[] array, ArrayStringMode stringMode) {
        switch (stringMode) {
            case CLASS_NAME: {
                return array.toString();
            }
            case TYPE_AND_SIZE: {
                return new StringBuffer().append(ReflectUtil.simpleName(array.getClass().getComponentType())).append("[").append(array.length).append("]").toString();
            }
        }
        StringBuffer result = new StringBuffer();
        result.append(stringMode.prefix());
        boolean first = true;
        for (Object elt : array) {
            if (first) {
                first = false;
            } else {
                result.append(stringMode.delimiter());
            }
            result.append(RecurUtil.safeToString(elt, stringMode.nestedMode()));
        }
        result.append(stringMode.suffix());
        return result.toString();
    }

    public static String arrayToString(boolean[] array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(boolean[] array, ArrayStringMode stringMode) {
        switch (stringMode) {
            case CLASS_NAME: {
                return array.toString();
            }
            case TYPE_AND_SIZE: {
                return new StringBuffer().append("boolean[").append(array.length).append("]").toString();
            }
        }
        StringBuffer result = new StringBuffer();
        result.append(stringMode.prefix());
        boolean first = true;
        for (boolean elt : array) {
            if (first) {
                first = false;
            } else {
                result.append(stringMode.delimiter());
            }
            result.append(elt);
        }
        result.append(stringMode.suffix());
        return result.toString();
    }

    public static String arrayToString(char[] array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(char[] array, ArrayStringMode stringMode) {
        switch (stringMode) {
            case CLASS_NAME: {
                return array.toString();
            }
            case TYPE_AND_SIZE: {
                return new StringBuffer().append("char[").append(array.length).append("]").toString();
            }
        }
        StringBuffer result = new StringBuffer();
        result.append(stringMode.prefix());
        boolean first = true;
        for (char elt : array) {
            if (first) {
                first = false;
            } else {
                result.append(stringMode.delimiter());
            }
            result.append(elt);
        }
        result.append(stringMode.suffix());
        return result.toString();
    }

    public static String arrayToString(byte[] array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(byte[] array, ArrayStringMode stringMode) {
        switch (stringMode) {
            case CLASS_NAME: {
                return array.toString();
            }
            case TYPE_AND_SIZE: {
                return new StringBuffer().append("byte[").append(array.length).append("]").toString();
            }
        }
        StringBuffer result = new StringBuffer();
        result.append(stringMode.prefix());
        boolean first = true;
        for (byte elt : array) {
            if (first) {
                first = false;
            } else {
                result.append(stringMode.delimiter());
            }
            result.append(elt);
        }
        result.append(stringMode.suffix());
        return result.toString();
    }

    public static String arrayToString(short[] array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(short[] array, ArrayStringMode stringMode) {
        switch (stringMode) {
            case CLASS_NAME: {
                return array.toString();
            }
            case TYPE_AND_SIZE: {
                return new StringBuffer().append("short[").append(array.length).append("]").toString();
            }
        }
        StringBuffer result = new StringBuffer();
        result.append(stringMode.prefix());
        boolean first = true;
        for (short elt : array) {
            if (first) {
                first = false;
            } else {
                result.append(stringMode.delimiter());
            }
            result.append(elt);
        }
        result.append(stringMode.suffix());
        return result.toString();
    }

    public static String arrayToString(int[] array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(int[] array, ArrayStringMode stringMode) {
        switch (stringMode) {
            case CLASS_NAME: {
                return array.toString();
            }
            case TYPE_AND_SIZE: {
                return new StringBuffer().append("int[").append(array.length).append("]").toString();
            }
        }
        StringBuffer result = new StringBuffer();
        result.append(stringMode.prefix());
        boolean first = true;
        for (int elt : array) {
            if (first) {
                first = false;
            } else {
                result.append(stringMode.delimiter());
            }
            result.append(elt);
        }
        result.append(stringMode.suffix());
        return result.toString();
    }

    public static String arrayToString(long[] array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(long[] array, ArrayStringMode stringMode) {
        switch (stringMode) {
            case CLASS_NAME: {
                return array.toString();
            }
            case TYPE_AND_SIZE: {
                return new StringBuffer().append("long[").append(array.length).append("]").toString();
            }
        }
        StringBuffer result = new StringBuffer();
        result.append(stringMode.prefix());
        boolean first = true;
        for (long elt : array) {
            if (first) {
                first = false;
            } else {
                result.append(stringMode.delimiter());
            }
            result.append(elt);
        }
        result.append(stringMode.suffix());
        return result.toString();
    }

    public static String arrayToString(float[] array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(float[] array, ArrayStringMode stringMode) {
        switch (stringMode) {
            case CLASS_NAME: {
                return array.toString();
            }
            case TYPE_AND_SIZE: {
                return new StringBuffer().append("float[").append(array.length).append("]").toString();
            }
        }
        StringBuffer result = new StringBuffer();
        result.append(stringMode.prefix());
        boolean first = true;
        for (float elt : array) {
            if (first) {
                first = false;
            } else {
                result.append(stringMode.delimiter());
            }
            result.append(elt);
        }
        result.append(stringMode.suffix());
        return result.toString();
    }

    public static String arrayToString(double[] array) {
        return RecurUtil.arrayToString(array, ArrayStringMode.DEEP_BRACED);
    }

    public static String arrayToString(double[] array, ArrayStringMode stringMode) {
        switch (stringMode) {
            case CLASS_NAME: {
                return array.toString();
            }
            case TYPE_AND_SIZE: {
                return new StringBuffer().append("double[").append(array.length).append("]").toString();
            }
        }
        StringBuffer result = new StringBuffer();
        result.append(stringMode.prefix());
        boolean first = true;
        for (double elt : array) {
            if (first) {
                first = false;
            } else {
                result.append(stringMode.delimiter());
            }
            result.append(elt);
        }
        result.append(stringMode.suffix());
        return result.toString();
    }

    public static boolean safeEquals(Object obj1, Object obj2) {
        return RecurUtil.safeEquals(obj1, obj2, LambdaUtil.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T1, T2> boolean safeEquals(T1 obj1, T2 obj2, Predicate2<? super T1, ? super T2> infiniteEquals) {
        RecursionStack2<Object, Object> stack;
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        Thread t = Thread.currentThread();
        TotalMap<Thread, RecursionStack2<Object, Object>> totalMap = EQUALS_STACKS;
        synchronized (totalMap) {
            stack = EQUALS_STACKS.get(t);
        }
        boolean result = stack.apply(EQUALS, LambdaUtil.asLambda(infiniteEquals), obj1, obj2);
        if (stack.isEmpty()) {
            TotalMap<Thread, RecursionStack2<Object, Object>> totalMap2 = EQUALS_STACKS;
            synchronized (totalMap2) {
                EQUALS_STACKS.revert(t);
            }
        }
        return result;
    }

    public static boolean arrayEquals(Object a1, Object a2) {
        if (!a1.getClass().isArray() || !a2.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array argument");
        }
        if (a1 instanceof Object[] && a2 instanceof Object[]) {
            return RecurUtil.arrayEquals((Object[])a1, (Object[])a2);
        }
        if (!a1.getClass().equals(a2.getClass())) {
            return false;
        }
        if (a1 instanceof int[]) {
            return Arrays.equals((int[])a1, (int[])a2);
        }
        if (a1 instanceof char[]) {
            return Arrays.equals((char[])a1, (char[])a2);
        }
        if (a1 instanceof byte[]) {
            return Arrays.equals((byte[])a1, (byte[])a2);
        }
        if (a1 instanceof double[]) {
            return Arrays.equals((double[])a1, (double[])a2);
        }
        if (a1 instanceof boolean[]) {
            return Arrays.equals((boolean[])a1, (boolean[])a2);
        }
        if (a1 instanceof short[]) {
            return Arrays.equals((short[])a1, (short[])a2);
        }
        if (a1 instanceof long[]) {
            return Arrays.equals((long[])a1, (long[])a2);
        }
        if (a1 instanceof float[]) {
            return Arrays.equals((float[])a1, (float[])a2);
        }
        throw new IllegalArgumentException("Unrecognized array type");
    }

    public static boolean arrayEquals(Object[] a1, Object[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (RecurUtil.safeEquals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public static int safeHashCode(Object obj) {
        return RecurUtil.safeHashCode(obj, DEFAULT_INF_HASH_CODE);
    }

    public static int safeHashCode(Object obj, int infiniteHashCode) {
        return RecurUtil.safeHashCode(obj, LambdaUtil.valueLambda(Autobox.valueOf(infiniteHashCode)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int safeHashCode(T obj, Lambda<? super T, Integer> infiniteHashCode) {
        RecursionStack<Object> stack;
        if (obj == null) {
            return 0;
        }
        Thread t = Thread.currentThread();
        TotalMap<Thread, RecursionStack<Object>> totalMap = HASH_CODE_STACKS;
        synchronized (totalMap) {
            stack = HASH_CODE_STACKS.get(t);
        }
        int result = stack.apply(HASH_CODE, infiniteHashCode, obj);
        if (stack.isEmpty()) {
            TotalMap<Thread, RecursionStack<Object>> totalMap2 = HASH_CODE_STACKS;
            synchronized (totalMap2) {
                HASH_CODE_STACKS.revert(t);
            }
        }
        return result;
    }

    public static int arrayHashCode(Object array) {
        if (array instanceof Object[]) {
            return RecurUtil.arrayHashCode((Object[])array);
        }
        if (array instanceof int[]) {
            return RecurUtil.arrayHashCode((int[])array);
        }
        if (array instanceof char[]) {
            return RecurUtil.arrayHashCode((char[])array);
        }
        if (array instanceof byte[]) {
            return RecurUtil.arrayHashCode((byte[])array);
        }
        if (array instanceof double[]) {
            return RecurUtil.arrayHashCode((double[])array);
        }
        if (array instanceof boolean[]) {
            return RecurUtil.arrayHashCode((boolean[])array);
        }
        if (array instanceof short[]) {
            return RecurUtil.arrayHashCode((short[])array);
        }
        if (array instanceof long[]) {
            return RecurUtil.arrayHashCode((long[])array);
        }
        if (array instanceof float[]) {
            return RecurUtil.arrayHashCode((float[])array);
        }
        throw new IllegalArgumentException("Non-array argument");
    }

    public static int arrayHashCode(Object[] array) {
        int result = 1;
        for (Object elt : array) {
            result = result * 31 + RecurUtil.safeHashCode(elt);
        }
        return result;
    }

    public static int arrayHashCode(boolean[] array) {
        int result = 1;
        for (boolean elt : array) {
            result = result * 31 + Autobox.valueOf(elt).hashCode();
        }
        return result;
    }

    public static int arrayHashCode(char[] array) {
        int result = 1;
        for (char elt : array) {
            result = result * 31 + Autobox.valueOf(elt).hashCode();
        }
        return result;
    }

    public static int arrayHashCode(byte[] array) {
        int result = 1;
        for (byte elt : array) {
            result = result * 31 + Autobox.valueOf(elt).hashCode();
        }
        return result;
    }

    public static int arrayHashCode(short[] array) {
        int result = 1;
        for (short elt : array) {
            result = result * 31 + Autobox.valueOf(elt).hashCode();
        }
        return result;
    }

    public static int arrayHashCode(int[] array) {
        int result = 1;
        for (int elt : array) {
            result = result * 31 + Autobox.valueOf(elt).hashCode();
        }
        return result;
    }

    public static int arrayHashCode(long[] array) {
        int result = 1;
        for (long elt : array) {
            result = result * 31 + Autobox.valueOf(elt).hashCode();
        }
        return result;
    }

    public static int arrayHashCode(float[] array) {
        int result = 1;
        for (float elt : array) {
            result = result * 31 + Autobox.valueOf(elt).hashCode();
        }
        return result;
    }

    public static int arrayHashCode(double[] array) {
        int result = 1;
        for (double elt : array) {
            result = result * 31 + Autobox.valueOf(elt).hashCode();
        }
        return result;
    }

    static {
        Lambda<Thread, RecursionStack<Object>> makeNew = new Lambda<Thread, RecursionStack<Object>>(){

            @Override
            public RecursionStack<Object> value(Thread t) {
                return new RecursionStack<Object>();
            }

            @Override
            public Object value(Object x0) {
                return this.value((Thread)x0);
            }
        };
        Lambda<Thread, RecursionStack2<Object, Object>> makeNew2 = new Lambda<Thread, RecursionStack2<Object, Object>>(){

            @Override
            public RecursionStack2<Object, Object> value(Thread t) {
                return new RecursionStack2<Object, Object>();
            }

            @Override
            public Object value(Object x0) {
                return this.value((Thread)x0);
            }
        };
        TO_STRING_STACKS = new TotalMap<Thread, RecursionStack<Object>>(makeNew, true);
        EQUALS_STACKS = new TotalMap<Thread, RecursionStack2<Object, Object>>(makeNew2, true);
        HASH_CODE_STACKS = new TotalMap<Thread, RecursionStack<Object>>(makeNew, true);
        TO_STRING_GENERATOR = LambdaUtil.curry(new Lambda2<ArrayStringMode, Object, String>(){

            @Override
            public String value(ArrayStringMode mode, Object obj) {
                if (obj.getClass().isArray()) {
                    return RecurUtil.arrayToString(obj, mode);
                }
                return obj.toString();
            }

            @Override
            public Object value(Object x0, Object x1) {
                return this.value((ArrayStringMode)x0, x1);
            }
        });
        DEFAULT_INF_STRING_GENERATOR = LambdaUtil.curry(new Lambda2<ArrayStringMode, Object, String>(){

            @Override
            public String value(ArrayStringMode mode, Object obj) {
                if (obj.getClass().isArray()) {
                    return new StringBuffer().append(mode.prefix()).append("...").append(mode.suffix()).toString();
                }
                return new StringBuffer().append(ReflectUtil.simpleName(obj.getClass())).append("...").toString();
            }

            @Override
            public Object value(Object x0, Object x1) {
                return this.value((ArrayStringMode)x0, x1);
            }
        });
        EQUALS = new Lambda2<Object, Object, Boolean>(){

            @Override
            public Boolean value(Object obj1, Object obj2) {
                if (obj1.getClass().isArray()) {
                    if (obj2.getClass().isArray()) {
                        return Autobox.valueOf(RecurUtil.arrayEquals(obj1, obj2));
                    }
                    return Autobox.valueOf(false);
                }
                if (obj2.getClass().isArray()) {
                    return Autobox.valueOf(false);
                }
                return Autobox.valueOf(obj1.equals(obj2));
            }

            @Override
            public Object value(Object x0, Object x1) {
                return this.value(x0, x1);
            }
        };
        HASH_CODE = new Lambda<Object, Integer>(){

            @Override
            public Integer value(Object obj) {
                if (obj.getClass().isArray()) {
                    return Autobox.valueOf(RecurUtil.arrayHashCode(obj));
                }
                return Autobox.valueOf(obj.hashCode());
            }

            @Override
            public Object value(Object x0) {
                return this.value(x0);
            }
        };
        DEFAULT_INF_HASH_CODE = LambdaUtil.valueLambda(Autobox.valueOf(-1288714095));
    }

    /*
     * Signature claims super is java.lang.Enum<edu.rice.cs.plt.recur.RecurUtil$ArrayStringMode>, not com.rc.retroweaver.runtime.Enum_ - discarding signature.
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ArrayStringMode
    extends Enum_ {
        public static final /* enum */ ArrayStringMode CLASS_NAME = new ArrayStringMode("CLASS_NAME", 0){

            protected String prefix() {
                throw new IllegalArgumentException();
            }

            protected String delimiter() {
                throw new IllegalArgumentException();
            }

            protected String suffix() {
                throw new IllegalArgumentException();
            }

            protected ArrayStringMode nestedMode() {
                throw new IllegalArgumentException();
            }
        };
        public static final /* enum */ ArrayStringMode TYPE_AND_SIZE = new ArrayStringMode("TYPE_AND_SIZE", 1){

            protected String prefix() {
                throw new IllegalArgumentException();
            }

            protected String delimiter() {
                throw new IllegalArgumentException();
            }

            protected String suffix() {
                throw new IllegalArgumentException();
            }

            protected ArrayStringMode nestedMode() {
                throw new IllegalArgumentException();
            }
        };
        public static final /* enum */ ArrayStringMode SHALLOW_BRACKETED = new ArrayStringMode("SHALLOW_BRACKETED", 2){

            protected String prefix() {
                return "[";
            }

            protected String delimiter() {
                return ", ";
            }

            protected String suffix() {
                return "]";
            }

            protected ArrayStringMode nestedMode() {
                return CLASS_NAME;
            }
        };
        public static final /* enum */ ArrayStringMode DEEP_BRACKETED = new ArrayStringMode("DEEP_BRACKETED", 3){

            protected String prefix() {
                return "[";
            }

            protected String delimiter() {
                return ", ";
            }

            protected String suffix() {
                return "]";
            }

            protected ArrayStringMode nestedMode() {
                return DEEP_BRACKETED;
            }
        };
        public static final /* enum */ ArrayStringMode SHALLOW_BRACED = new ArrayStringMode("SHALLOW_BRACED", 4){

            protected String prefix() {
                return "{ ";
            }

            protected String delimiter() {
                return ", ";
            }

            protected String suffix() {
                return " }";
            }

            protected ArrayStringMode nestedMode() {
                return TYPE_AND_SIZE;
            }
        };
        public static final /* enum */ ArrayStringMode DEEP_BRACED = new ArrayStringMode("DEEP_BRACED", 5){

            protected String prefix() {
                return "{ ";
            }

            protected String delimiter() {
                return ", ";
            }

            protected String suffix() {
                return " }";
            }

            protected ArrayStringMode nestedMode() {
                return DEEP_BRACED;
            }
        };
        public static final /* enum */ ArrayStringMode DEEP_MULTILINE = new ArrayStringMode("DEEP_MULTILINE", 6){

            protected String prefix() {
                return "";
            }

            protected String delimiter() {
                return TextUtil.NEWLINE;
            }

            protected String suffix() {
                return "";
            }

            protected ArrayStringMode nestedMode() {
                return DEEP_BRACED;
            }
        };
        public static final /* enum */ ArrayStringMode SHALLOW_MULTILINE = new ArrayStringMode("SHALLOW_MULTILINE", 7){

            protected String prefix() {
                return "";
            }

            protected String delimiter() {
                return TextUtil.NEWLINE;
            }

            protected String suffix() {
                return "";
            }

            protected ArrayStringMode nestedMode() {
                return SHALLOW_BRACED;
            }
        };
        private static final /* synthetic */ ArrayStringMode[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$edu$rice$cs$plt$recur$RecurUtil$ArrayStringMode;

        public static ArrayStringMode[] values() {
            return (ArrayStringMode[])$VALUES.clone();
        }

        public static ArrayStringMode valueOf(String name) {
            return (ArrayStringMode)Enum_.valueOf(class$edu$rice$cs$plt$recur$RecurUtil$ArrayStringMode == null ? (class$edu$rice$cs$plt$recur$RecurUtil$ArrayStringMode = ArrayStringMode.class$("edu.rice.cs.plt.recur.RecurUtil$ArrayStringMode")) : class$edu$rice$cs$plt$recur$RecurUtil$ArrayStringMode, name);
        }

        private ArrayStringMode(String string, int n) {
            super(string, n);
        }

        protected abstract String prefix();

        protected abstract String delimiter();

        protected abstract String suffix();

        protected abstract ArrayStringMode nestedMode();

        ArrayStringMode(String x0, int x1, 1 x2) {
            this(x0, x1);
        }

        static {
            $VALUES = new ArrayStringMode[]{CLASS_NAME, TYPE_AND_SIZE, SHALLOW_BRACKETED, DEEP_BRACKETED, SHALLOW_BRACED, DEEP_BRACED, DEEP_MULTILINE, SHALLOW_MULTILINE};
            Enum_.setEnumValues(ArrayStringMode.values(), class$edu$rice$cs$plt$recur$RecurUtil$ArrayStringMode == null ? (class$edu$rice$cs$plt$recur$RecurUtil$ArrayStringMode = ArrayStringMode.class$("edu.rice.cs.plt.recur.RecurUtil$ArrayStringMode")) : class$edu$rice$cs$plt$recur$RecurUtil$ArrayStringMode);
        }

        static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                try {
                    noClassDefFoundError.initCause(classNotFoundException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw noClassDefFoundError;
            }
            return clazz;
        }
    }
}

